/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Rectangle;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;

public final class DockDivider {
    private float _fScale;
    private DockLayoutInfo _liBefore;
    private DockLayoutInfo _liAfter;
    private Rectangle _rect;
    private int _nMaxUp;
    private int _nMaxDn;

    DockDivider(DockLayoutInfo liBefore, DockLayoutInfo liAfter, Rectangle rect, int nMaxUp, int nMaxDn, float fScale) {
        this._liBefore = liBefore;
        this._liAfter = liAfter;
        this._rect = rect;
        this._nMaxUp = nMaxUp;
        this._nMaxDn = nMaxDn;
        this._fScale = fScale;
    }

    public Rectangle getRectangle() {
        return this._rect;
    }

    public int adjustForMax(int nPos) {
        if (nPos < this._nMaxUp) {
            nPos = this._nMaxUp;
        } else if (nPos > this._nMaxDn) {
            nPos = this._nMaxDn;
        }
        return nPos;
    }

    public void moveBy(int nDelta, boolean bHorz) {
        int nScaledDelta = (int)((float)nDelta / this._fScale);
        int nOrientation = bHorz ? 0 : 2;
        this._liBefore.moveBy(nScaledDelta, nOrientation + 1);
        this._liAfter.moveBy(-nScaledDelta, nOrientation);
    }

    int referenceType(Object ref) {
        if (this._liBefore.isReferring(ref)) {
            return 2;
        }
        if (this._liAfter.isReferring(ref)) {
            return 1;
        }
        return 0;
    }

    public DockLayoutInfo getBefore() {
        return this._liBefore;
    }

    public DockLayoutInfo getAfter() {
        return this._liAfter;
    }
}

