/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import oracle.ideimpl.controls.dockLayout.AbstractDockLayoutInfoNode;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;

final class DockLayoutInfoHorzNode
extends AbstractDockLayoutInfoNode {
    private static final int MIN_WINDOW_WIDTH = 50;

    DockLayoutInfoHorzNode() {
        super(0);
    }

    public Dimension getSize(int nType) {
        Dimension d = new Dimension(0, 0);
        int n = this.getNodeCount();
        int nGap = 0;
        int i = 0;
        while (i < n) {
            DockLayoutInfo li = this.getNode(i);
            if (li.isVisible()) {
                Dimension dSub = li.getSize(nType);
                d.width += dSub.width + nGap;
                d.height = Math.max(d.height, dSub.height);
                nGap = 4;
            }
            ++i;
        }
        return d;
    }

    public void getDividers(ArrayList horzDividers, ArrayList vertDividers) {
        horzDividers.addAll(this.getDividers());
        int n = this.getNodeCount();
        int i = 0;
        while (i < n) {
            DockLayoutInfo li = this.getNode(i);
            li.getDividers(horzDividers, vertDividers);
            ++i;
        }
    }

    public void layoutContainer(Rectangle rect) {
        int n = this.getNodeCount();
        if (n != 0) {
            DockInsertionPoint dip;
            this.removeDividers();
            this.removeInserts();
            int nTotalMin = 0;
            int nTotalPref = 0;
            int nVisible = 0;
            int[] anMin = new int[n];
            int[] anPref = new int[n];
            int i = 0;
            while (i < n) {
                DockLayoutInfo li = this.getNode(i);
                if (li.isVisible()) {
                    anMin[i] = li.getSize((int)0).width;
                    int sz = li.getSize((int)2).width;
                    anPref[i] = sz < 50 ? 50 : sz;
                    nTotalMin += anMin[i];
                    nTotalPref += anPref[i];
                    ++nVisible;
                }
                ++i;
            }
            int nSource = nTotalPref - nTotalMin;
            int nTarget = rect.width - (nTotalMin + (nVisible - 1) * 4);
            float fScale = (float)nTarget / (float)nSource;
            int nIPFeedback = rect.width / (nVisible + 1);
            Rectangle r = new Rectangle(rect.x, rect.y, 0, rect.height);
            DockLayoutInfo lastLi = null;
            int nLastDividerLimit = 0;
            int xFeedback = r.x;
            int i2 = 0;
            while (i2 < n) {
                DockLayoutInfo li = this.getNode(i2);
                if (li.isVisible()) {
                    int nNewSize = (int)((float)(anPref[i2] - anMin[i2]) * fScale);
                    r.width = --nVisible > 0 ? anMin[i2] + nNewSize : rect.width - r.x;
                    if (lastLi != null) {
                        dip = new DockInsertionPoint(lastLi, 1, new Point(r.x, r.y + r.height / 2), new Rectangle(xFeedback, r.y, nIPFeedback, r.height));
                        this.addInsert(dip);
                        Rectangle rDiv = new Rectangle(r.x - 4, r.y, 4, r.height);
                        int nMaxUp = nLastDividerLimit;
                        int nMaxDn = r.x + r.width - anMin[i2];
                        this.addDivider(new DockDivider(lastLi, li, rDiv, nMaxUp, nMaxDn, fScale));
                    } else {
                        dip = new DockInsertionPoint(li, 0, new Point(r.x, r.y + r.height / 2), new Rectangle(xFeedback, r.y, nIPFeedback, r.height));
                        this.addInsert(dip);
                    }
                    li.layoutContainer(r);
                    if (li instanceof DockLayoutInfoLeaf) {
                        dip = new DockInsertionPoint(li, 2, new Point(r.x + r.width / 2, r.y), new Rectangle(r.x, r.y, r.width, r.height / 2));
                        this.addInsert(dip);
                        dip = new DockInsertionPoint(li, 3, new Point(r.x + r.width / 2, r.y + r.height), new Rectangle(r.x, r.y + r.height / 2, r.width, r.height - r.height / 2));
                        this.addInsert(dip);
                    }
                    nLastDividerLimit = r.x + anMin[i2];
                    xFeedback += nIPFeedback;
                    r.x += r.width + 4;
                    lastLi = li;
                }
                ++i2;
            }
            if (lastLi != null) {
                dip = new DockInsertionPoint(lastLi, 1, new Point(rect.width, r.y + r.height / 2), new Rectangle(xFeedback, r.y, rect.width - xFeedback, r.height));
                this.addInsert(dip);
            }
        }
    }
}

