/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutPersistence;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;

public final class DockLayoutInfoLeaf
implements DockLayoutInfo,
TreeNode {
    private Dimension _dimPref;
    private JComponent _component;
    private DockInsertionPoint _insert;

    public DockLayoutInfoLeaf(JComponent c, Dimension dimPref) {
        this._component = c;
        this._dimPref = dimPref;
    }

    public boolean saveLayout(DockLayoutPersistence p, String strMyName) {
        boolean ret = false;
        String strCompName = strMyName + ".component";
        if (p.saveComponent(this._component, strCompName)) {
            p.setProperty(strMyName + ".ItemCount", null);
            p.setProperty(strMyName + ".width", "" + this._dimPref.width);
            p.setProperty(strMyName + ".height", "" + this._dimPref.height);
            ret = true;
        }
        return ret;
    }

    public static DockLayoutInfoLeaf loadLayout(DockLayoutPersistence p, String strMyName) {
        DockLayoutInfoLeaf li = null;
        String strCompName = strMyName + ".component";
        JComponent newComp = p.loadComponent(strCompName);
        if (newComp != null) {
            String sWidth = p.getProperty(strMyName + ".width", "100");
            String sHeight = p.getProperty(strMyName + ".height", "100");
            int nWidth = Integer.parseInt(sWidth);
            int nHeight = Integer.parseInt(sHeight);
            li = new DockLayoutInfoLeaf(newComp, new Dimension(nWidth, nHeight));
        }
        return li;
    }

    public boolean saveLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess parent) {
        boolean ret = false;
        DefaultStructuredPropertyAccess leafBox = new DefaultStructuredPropertyAccess("leafBox");
        if (layoutPersistence.saveComponent((StructuredPropertyAccess)leafBox, this._component)) {
            leafBox.setProperty("width", Integer.toString(this._dimPref.width));
            leafBox.setProperty("height", Integer.toString(this._dimPref.height));
            parent.appendChild((StructuredPropertyAccess)leafBox);
            ret = true;
        }
        return ret;
    }

    public static DockLayoutInfoLeaf loadLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess leafBox) {
        DockLayoutInfoLeaf li = null;
        JComponent newComp = layoutPersistence.loadComponent(leafBox);
        if (newComp != null) {
            int width = Integer.parseInt(leafBox.getProperty("width", "100"));
            int height = Integer.parseInt(leafBox.getProperty("height", "100"));
            li = new DockLayoutInfoLeaf(newComp, new Dimension(width, height));
        }
        return li;
    }

    public boolean isReferring(Object ref) {
        return ref == this || ref == this._component;
    }

    public int getNodeCount() {
        return 1;
    }

    public DockLayoutInfo getNode(int nPos) {
        return null;
    }

    public boolean isVisible() {
        return this._component.isVisible();
    }

    public Dimension getSize(int nType) {
        Dimension d;
        switch (nType) {
            case 0: {
                d = this._component.getMinimumSize();
                break;
            }
            case 1: {
                if (this.isVisible()) {
                    d = this._component.getSize();
                    break;
                }
                d = new Dimension(0, 0);
                break;
            }
            case 2: {
                d = this._dimPref;
                break;
            }
            case 3: {
                d = this._component.getMaximumSize();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return d;
    }

    public Dimension getPrefSize() {
        return this.getSize(2);
    }

    public void getDividers(ArrayList horzDividers, ArrayList vertDividers) {
    }

    public DockDivider getDivider(JComponent ref, int nOrient) {
        return null;
    }

    public DockLayoutInfoLeaf getLayoutInfo(JComponent c) {
        if (this._component == c) {
            return this;
        }
        return null;
    }

    public void getInsertionPoints(ArrayList inserts) {
        if (this._insert != null) {
            inserts.add(this._insert);
        }
    }

    public void invalidateLayout(Container target) {
        this._insert = null;
    }

    public void layoutContainer(Rectangle rect) {
        Point ptC = new Point(rect.x + rect.width / 2, rect.y + rect.height / 2);
        Dimension dC = new Dimension(rect.width / 3, rect.height / 3);
        Rectangle rC = new Rectangle(ptC.x - dC.width, ptC.y - dC.height, dC.width * 2, dC.height * 2);
        this._insert = new DockInsertionPoint(this, 4, ptC, rC);
        this._component.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public int moveBy(int nDelta, int nOrient) {
        int nRet = 0;
        Dimension dMin = this.getSize(0);
        if (DockLayoutUtil.isHorz(nOrient)) {
            int nNewPref = this._dimPref.width + nDelta;
            if (nNewPref < dMin.width) {
                nNewPref = dMin.width;
            }
            nRet = nNewPref - this._dimPref.width;
            this._dimPref.width = nNewPref;
        } else {
            int nNewPref = this._dimPref.height + nDelta;
            if (nNewPref < dMin.height) {
                nNewPref = dMin.height;
            }
            nRet = nNewPref - this._dimPref.height;
            this._dimPref.height = nNewPref;
        }
        this._component.invalidate();
        return nRet;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public TreeNode getChildAt(int childIndex) {
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getChildCount() {
        return 0;
    }

    public TreeNode getParent() {
        throw new UnsupportedOperationException();
    }

    public int getIndex(TreeNode node) {
        return -1;
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }
}

