/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import oracle.ideimpl.controls.dockLayout.AbstractDockLayoutInfoNode;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;

final class DockLayoutInfoVertNode
extends AbstractDockLayoutInfoNode {
    private static final int MIN_WINDOW_HEIGHT = 50;

    DockLayoutInfoVertNode() {
        super(2);
    }

    public Dimension getSize(int nType) {
        Dimension d = new Dimension(0, 0);
        int n = this.getNodeCount();
        int nGap = 0;
        int i = 0;
        while (i < n) {
            DockLayoutInfo li = this.getNode(i);
            if (li.isVisible()) {
                Dimension dSub = li.getSize(nType);
                d.height += dSub.height + nGap;
                d.width = Math.max(d.width, dSub.width);
                nGap = 4;
            }
            ++i;
        }
        return d;
    }

    public void getDividers(ArrayList horzDividers, ArrayList vertDividers) {
        vertDividers.addAll(this.getDividers());
        int n = this.getNodeCount();
        int i = 0;
        while (i < n) {
            DockLayoutInfo li = this.getNode(i);
            li.getDividers(horzDividers, vertDividers);
            ++i;
        }
    }

    public void layoutContainer(Rectangle rect) {
        DockInsertionPoint dip;
        int n = this.getNodeCount();
        if (n == 0) {
            return;
        }
        this.removeDividers();
        this.removeInserts();
        int nTotalMin = 0;
        int nTotalPref = 0;
        int nVisible = 0;
        int[] anMin = new int[n];
        int[] anPref = new int[n];
        int i = 0;
        while (i < n) {
            DockLayoutInfo li = this.getNode(i);
            if (li.isVisible()) {
                anMin[i] = li.getSize((int)0).height;
                int sz = li.getSize((int)2).height;
                anPref[i] = sz < 50 ? 50 : sz;
                nTotalMin += anMin[i];
                nTotalPref += anPref[i];
                ++nVisible;
            }
            ++i;
        }
        int nSource = nTotalPref - nTotalMin;
        int nTarget = rect.height - (nTotalMin + (nVisible - 1) * 4);
        float fScale = (float)nTarget / (float)nSource;
        int nIPFeedback = rect.height / (nVisible + 1);
        Rectangle r = new Rectangle(rect.x, rect.y, rect.width, 0);
        DockLayoutInfo lastLi = null;
        int nLastDividerLimit = 0;
        int yFeedback = r.y;
        int i2 = 0;
        while (i2 < n) {
            DockLayoutInfo li = this.getNode(i2);
            if (li.isVisible()) {
                int nNewSize = (int)((float)(anPref[i2] - anMin[i2]) * fScale);
                r.height = --nVisible > 0 ? anMin[i2] + nNewSize : rect.height - r.y;
                if (lastLi != null) {
                    dip = new DockInsertionPoint(lastLi, 3, new Point(r.x + r.width / 2, r.y), new Rectangle(r.x, yFeedback, r.width, nIPFeedback));
                    this.addInsert(dip);
                    Rectangle rDiv = new Rectangle(r.x, r.y - 4, r.width, 4);
                    int nMaxUp = nLastDividerLimit;
                    int nMaxDn = r.y + r.height - anMin[i2];
                    this.addDivider(new DockDivider(lastLi, li, rDiv, nMaxUp, nMaxDn, fScale));
                } else {
                    dip = new DockInsertionPoint(li, 2, new Point(r.x + r.width / 2, r.y), new Rectangle(r.x, yFeedback, r.width, nIPFeedback));
                    this.addInsert(dip);
                }
                li.layoutContainer(r);
                if (li instanceof DockLayoutInfoLeaf) {
                    dip = new DockInsertionPoint(li, 0, new Point(r.x, r.y + r.height / 2), new Rectangle(r.x, r.y, r.width / 2, r.height));
                    this.addInsert(dip);
                    dip = new DockInsertionPoint(li, 1, new Point(r.x + r.width, r.y + r.height / 2), new Rectangle(r.x + r.width / 2, r.y, r.width - r.width / 2, r.height));
                    this.addInsert(dip);
                }
                nLastDividerLimit = r.y + anMin[i2];
                yFeedback += nIPFeedback;
                r.y += r.height + 4;
                lastLi = li;
            }
            ++i2;
        }
        if (lastLi != null) {
            dip = new DockInsertionPoint(lastLi, 3, new Point(r.x + r.width / 2, rect.height), new Rectangle(r.x, yFeedback, r.width, rect.height - yFeedback));
            this.addInsert(dip);
        }
    }
}

