/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;

public class DockLayoutPanel
extends JPanel
implements MouseInputListener {
    protected DockLayout _layout;
    protected DockDivider _draggedDivider;
    protected boolean _draggedIsHorz;
    protected Point _draggedPtStart;
    protected Point _draggedPtLast;
    private boolean _paintingDividers;

    private void $init$() {
        this._draggedPtStart = new Point();
        this._draggedPtLast = new Point();
        this._paintingDividers = true;
    }

    public DockLayoutPanel() {
        super(new DockLayout());
        this.$init$();
        this._layout = (DockLayout)this.getLayout();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setPaintingDividers(false);
        this.setOpaque(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockInsertionPoint getDockInsertionAt(Point pt) {
        DockInsertionPoint dipRet = null;
        Rectangle rMe = this.getBounds();
        if (rMe.contains(pt)) {
            ArrayList v;
            double nMinDist = 2.147483647E9;
            Object object = this.getTreeLock();
            synchronized (object) {
                v = this._layout.getInsertionPoints(this);
            }
            int n = v.size();
            if (n != 0) {
                int i = 0;
                while (i < n) {
                    DockInsertionPoint dip = (DockInsertionPoint)v.get(i);
                    Point ptAnchor = dip.getAnchor();
                    double nDist = pt.distance(ptAnchor);
                    if (nDist < nMinDist) {
                        nMinDist = nDist;
                        dipRet = dip;
                    }
                    ++i;
                }
            }
            if (dipRet != null) {
                dipRet.setContainer(this);
            }
        }
        return dipRet;
    }

    public DockLayoutInfoLeaf getLayoutInfo(JComponent c) {
        return this._layout.getLayoutInfo(c);
    }

    public void saveLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess parent) {
        this._layout.saveLayout(layoutPersistence, parent);
    }

    public void loadLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess parent) {
        this._layout.loadLayout((Container)this, layoutPersistence, parent);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isPaintingDividers()) {
            this.paintDivider(g, this._layout.getHorzDividers(this), false);
            this.paintDivider(g, this._layout.getVertDividers(this), true);
        }
    }

    private boolean isPaintingDividers() {
        return this._paintingDividers;
    }

    public void setPaintingDividers(boolean paintingDividers) {
        this._paintingDividers = paintingDividers;
    }

    private void paintDivider(Graphics g, Rectangle r, boolean bHorz) {
        if (g.hitClip(r.x, r.y, r.width, r.height) && this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    protected void paintDivider(Graphics g, ArrayList v, boolean bHorz) {
        int n = v.size();
        int i = 0;
        while (i < n) {
            DockDivider dd = (DockDivider)v.get(i);
            this.paintDivider(g, dd.getRectangle(), bHorz);
            ++i;
        }
    }

    private boolean isDraggingDivider() {
        return this._draggedDivider != null;
    }

    private static DockDivider findDivider(ArrayList v, Point pt) {
        int n = v.size();
        int i = 0;
        while (i < n) {
            DockDivider dd = (DockDivider)v.get(i);
            if (dd.getRectangle().contains(pt)) {
                return dd;
            }
            ++i;
        }
        return null;
    }

    private void setCursor(Point pt) {
        DockDivider dd = DockLayoutPanel.findDivider(this._layout.getHorzDividers(this), pt);
        if (dd != null) {
            this.setCursor(Cursor.getPredefinedCursor(11));
            return;
        }
        dd = DockLayoutPanel.findDivider(this._layout.getVertDividers(this), pt);
        if (dd != null) {
            this.setCursor(Cursor.getPredefinedCursor(9));
            return;
        }
        this.setCursor((Cursor)null);
    }

    private void renderDividerDrag() {
        int y2;
        int y1;
        int x2;
        int x1;
        Rectangle r = this._draggedDivider.getRectangle();
        if (this._draggedIsHorz) {
            x2 = x1 = this._draggedPtLast.x + r.width / 2;
            y1 = r.y;
            y2 = r.y + r.height;
        } else {
            x1 = r.x;
            x2 = r.x + r.width;
            y2 = y1 = this._draggedPtLast.y + r.height / 2;
        }
        Graphics g = this.getGraphics();
        g.setXORMode(this.getBackground());
        g.drawLine(x1, y1, x2, y2);
    }

    protected void whenDividerMoving() {
    }

    protected void whenDividerMoved() {
        int nDelta = this._draggedIsHorz ? this._draggedPtLast.x - this._draggedPtStart.x : this._draggedPtLast.y - this._draggedPtStart.y;
        this._draggedDivider.moveBy(nDelta, this._draggedIsHorz);
        this._draggedDivider = null;
        this.revalidate();
        this.setCursor((Cursor)null);
    }

    public void mouseMoved(MouseEvent e) {
        this.setCursor(e.getPoint());
    }

    public void mouseExited(MouseEvent e) {
        this.setCursor((Cursor)null);
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isDraggingDivider()) {
            this._draggedPtStart.setLocation(e.getPoint());
            this._draggedDivider = DockLayoutPanel.findDivider(this._layout.getHorzDividers(this), this._draggedPtStart);
            if (this._draggedDivider != null) {
                this._draggedIsHorz = true;
            } else {
                this._draggedDivider = DockLayoutPanel.findDivider(this._layout.getVertDividers(this), this._draggedPtStart);
                this._draggedIsHorz = false;
            }
        }
        if (this.isDraggingDivider()) {
            this._draggedPtLast.setLocation(this._draggedPtStart);
            this.renderDividerDrag();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isDraggingDivider()) {
            this.renderDividerDrag();
            this._draggedPtLast.setLocation(e.getPoint());
            this.whenDividerMoving();
            this.renderDividerDrag();
            this.setCursor(this._draggedIsHorz ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9));
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isDraggingDivider()) {
            this.renderDividerDrag();
            this.whenDividerMoved();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && !e.isPopupTrigger()) {
            int orientation;
            Point point = e.getPoint();
            DockDivider divider = DockLayoutPanel.findDivider(this._layout.getHorzDividers(this), point);
            if (divider != null) {
                orientation = 0;
            } else {
                divider = DockLayoutPanel.findDivider(this._layout.getVertDividers(this), point);
                orientation = 1;
            }
            if (divider != null) {
                this.whenDividerDoubleClicked(divider, orientation);
            }
        }
    }

    protected void whenDividerDoubleClicked(DockDivider divider, int orientation) {
    }
}

