/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import oracle.ide.docking.Dockable;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockPanelHost;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.VisibilityLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDockPanelHost
implements DockPanelHost {
    @Override
    public boolean getDockablePath(DockablePath path, DockableCriteria criteria) {
        DockPanel dockPanel = this.getDockPanel();
        switch (criteria.getSearchFor()) {
            case 4: {
                if (dockPanel != criteria.getCriteria()) break;
                path.setDockPanel(dockPanel);
                return true;
            }
        }
        if (dockPanel.getDockablePath(path, criteria)) {
            path.setDockPanel(dockPanel);
            return true;
        }
        return false;
    }

    @Override
    public DockInsertionPoint getClosestDockInsertionPoint(Point pt, Dimension moveBy, TitledPanel excludeTitledPanel) {
        DockPanel dockPanel = this.getDockPanel();
        return dockPanel.getClosestDockInsertionPoint(pt, moveBy, excludeTitledPanel);
    }

    @Override
    public void getDockablePaths(List<DockablePath> dockablePaths) {
        DockPanel dockPanel = this.getDockPanel();
        int sizeBefore = dockablePaths.size();
        dockPanel.getDockablePaths(dockablePaths);
        int i = sizeBefore;
        while (i < dockablePaths.size()) {
            DockablePath dockablePath = dockablePaths.get(i);
            dockablePath.setDockPanelHost(this);
            ++i;
        }
    }

    @Override
    public void setDockableVisible(DockablePath dockablePath, boolean bVisible, int flags) {
        DockPanel dockPanel = dockablePath.getDockPanel();
        dockPanel.setDockableVisible(dockablePath, bVisible, flags);
    }

    @Override
    public boolean activateDockable(DockablePath dockablePath) {
        DockPanel dockPanel = dockablePath.getDockPanel();
        return dockPanel.activateDockable(dockablePath);
    }

    @Override
    public boolean getActiveDockablePath(DockablePath dockablePath) {
        DockPanel dockPanel = this.getDockPanel();
        if (dockPanel.getActiveDockablePath(dockablePath)) {
            dockablePath.setDockPanel(dockPanel);
            return true;
        }
        return false;
    }

    @Override
    public void loadVisibilityLayout(VisibilityLayout currentVisibilityLayout, boolean isStartup, int flags) {
        DockPanel dockPanel = this.getDockPanel();
        dockPanel.loadVisibilityLayout(currentVisibilityLayout, isStartup, flags);
    }

    @Override
    public void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        this.getDockPanel().saveVisibilityLayout(visibilityLayout);
    }

    @Override
    public void dumpAllDockables() {
        DockPanel dockPanel = this.getDockPanel();
        int titledPanelCount = dockPanel.getTitledPanelCount();
        int titledPanelPos = 0;
        while (titledPanelPos < titledPanelCount) {
            TitledPanel titledPanel = dockPanel.getTitledPanel(titledPanelPos);
            int clientCount = titledPanel.getClientCount();
            int clientPos = 0;
            while (clientPos < clientCount) {
                Dockable dockable = titledPanel.getClient(clientPos);
                System.out.println(dockable.getClass().getName() + " -> " + dockable.getUniqueName());
                ++clientPos;
            }
            ++titledPanelPos;
        }
    }

    public void dock(TitledPanel tp, DockLayoutConstraint dlc) {
        this.getDockPanel().dock(tp, dlc);
    }

    AbstractDockPanelHost() {
    }
}

