/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Toolkit;
import javax.swing.JComponent;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.docking.Dockable;
import oracle.ideimpl.controls.TabbedHeader;
import oracle.ideimpl.docking.AutoExpandEventListener;
import oracle.ideimpl.docking.AutoExpandListener;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.docking.shutter.ShutterTab;

public final class AutoExpander {
    private final AutoExpandEventListener autoExpandEventListener;

    private void $init$() {
        this.autoExpandEventListener = new AutoExpandEventListener();
    }

    private AutoExpander() {
        this.$init$();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.autoExpandEventListener, 48);
    }

    public void attachListenerToDockableAndTab(TitledPanel titledPanel, TabbedHeader tabbedHeader, Dockable dockable) {
        CustomTab tabs = this.customTabFrom(tabbedHeader);
        if (tabs == null) {
            return;
        }
        ShutterTab shutterTab = new ShutterTab(this.titledPanelFor(dockable), true);
        AutoExpandListener autoExpandListener = new AutoExpandListener(shutterTab, titledPanel, new TitledPanelHolder(dockable), tabs, dockable);
        shutterTab.setShutterTabListener(autoExpandListener);
        this.autoExpandEventListener.addDelegate(autoExpandListener);
        this.checkIfDockableOfSameTypeIsAutoExtended(dockable);
    }

    public void autoExpand(Dockable dockable) {
        if (dockable == null || !dockable.isAutoExpandableEnabled()) {
            return;
        }
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        if (shutterPanel.isShowing()) {
            return;
        }
        AutoExpandListener autoExpandListener = this.autoExpandEventListener.delegateFrom(dockable);
        if (autoExpandListener == null) {
            return;
        }
        autoExpandListener.showShutterTab();
    }

    private void checkIfDockableOfSameTypeIsAutoExtended(Dockable newDockable) {
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        if (!shutterPanel.isShowing()) {
            return;
        }
        TitledPanelHolder holder = shutterPanel.getHolder();
        if (holder == null) {
            return;
        }
        Dockable autoExtendedDockable = holder.getDockable();
        if (autoExtendedDockable == null) {
            return;
        }
        if (!newDockable.getClass().equals(autoExtendedDockable.getClass())) {
            return;
        }
        AutoExpandListener autoExpandListener = this.autoExpandEventListener.delegateFrom(autoExtendedDockable);
        if (autoExpandListener == null) {
            return;
        }
        autoExpandListener.hideShutterTab();
    }

    public void hideAutoExpanded(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        if (!shutterPanel.isShowing()) {
            return;
        }
        AutoExpandListener autoExpandListener = this.autoExpandEventListener.delegateFrom(dockable);
        if (autoExpandListener == null) {
            return;
        }
        if (dockable == this.dockableFromShutterPanel()) {
            autoExpandListener.hideShutterTab();
        }
    }

    private Dockable dockableFromShutterPanel() {
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        TitledPanelHolder holder = shutterPanel.getHolder();
        if (holder == null) {
            return null;
        }
        return holder.getDockable();
    }

    private TitledPanel titledPanelFor(Dockable dockable) {
        TitledPanel newTitledPanel = new TitledPanel();
        JComponent dockableGUI = dockable.getHostedComponent();
        newTitledPanel.add(dockableGUI);
        return newTitledPanel;
    }

    public void removeListener(Dockable dockable) {
        AutoExpandListener autoExpandListener = this.autoExpandEventListener.delegateFrom(dockable);
        if (autoExpandListener == null) {
            return;
        }
        autoExpandListener.dispose();
        this.autoExpandEventListener.removeDelegate(autoExpandListener);
    }

    public boolean hasListenerAttached(Dockable dockable) {
        return this.autoExpandEventListener.delegateFrom(dockable) != null;
    }

    private CustomTab customTabFrom(TabbedHeader tabbedHeader) {
        if (tabbedHeader == null) {
            return null;
        }
        return tabbedHeader.getCustomTab();
    }

    public static AutoExpander instance() {
        return AutoExpanderHolder.ra$instance();
    }

    AutoExpander(1 var1_1) {
        this();
    }

    private static class AutoExpanderHolder {
        private static AutoExpander instance = new AutoExpander(null);

        private AutoExpanderHolder() {
        }

        static AutoExpander ra$instance() {
            return instance;
        }
    }

    public final class 1 {
    }
}

