/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.controls.Divider;
import oracle.ideimpl.docking.controls.DividerEvent;
import oracle.ideimpl.docking.controls.DividerListener;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterMargin;

public final class DividerControlledPanel
extends JPanel
implements SwingConstants {
    private static final int DIVIDER_SIZE = 4;
    private static final int MIN_SHOW = 10;
    private String _strOrientation;
    private ShutterMargin _margin;
    private DockPanel _dockPanel;
    private Divider _divider;
    private Dimension _dimRestore;
    private boolean _bResizable;

    private void $init$() {
        this._bResizable = false;
    }

    public DividerControlledPanel(DockPanel dockPanel, String strBorderLayoutOrient) {
        this.$init$();
        this.setOpaque(false);
        this._dockPanel = dockPanel;
        this._strOrientation = DividerControlledPanel.getReverseOrientation(strBorderLayoutOrient);
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this._margin = ShutterManager.getInstance().createShutterMargin(strBorderLayoutOrient);
        this._divider = new Divider(DividerControlledPanel.getIntOrientation(strBorderLayoutOrient), 4);
        this._divider.setOpaque(false);
        this.add((Component)dockPanel, "Center");
        this.add((Component)this._divider, this._strOrientation);
        this.add((Component)this._margin, strBorderLayoutOrient);
        this._divider.addDividerListener(new 1());
        this._divider.setVisible(false);
    }

    public DockPanel getDockPanel() {
        return this._dockPanel;
    }

    public ShutterMargin getShutterMargin() {
        return this._margin;
    }

    public void setRestoredSize(Dimension dRestore) {
        this._dimRestore = new Dimension(dRestore);
    }

    public Dimension getRestoredSize() {
        return this._dimRestore;
    }

    public void setResizable(boolean bResizable) {
        if (this._bResizable != bResizable) {
            this._divider.setVisible(bResizable);
            Container parent = this.getParent();
            if (parent != null) {
                parent.doLayout();
            }
            this._bResizable = bResizable;
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = this._bResizable ? new Dimension(this._dimRestore) : this.getShutterMargin().getPreferredSize();
        return d;
    }

    String getOrientation() {
        return this._strOrientation;
    }

    private static String getReverseOrientation(String strBorderLayoutOrient) {
        String reverseOrientation = strBorderLayoutOrient == "West" ? "East" : (strBorderLayoutOrient == "North" ? "South" : (strBorderLayoutOrient == "East" ? "West" : "North"));
        return reverseOrientation;
    }

    void moveBy(int nDelta) {
        Dimension dMin = this._dockPanel.getMinimumSize();
        if (this._strOrientation.equalsIgnoreCase("West")) {
            this._dimRestore.width = Math.max(this._dimRestore.width - nDelta, dMin.width + 4 + 10);
        } else if (this._strOrientation.equalsIgnoreCase("East")) {
            this._dimRestore.width = Math.max(this._dimRestore.width + nDelta, dMin.width + 4 + 10);
        } else if (this._strOrientation.equalsIgnoreCase("North")) {
            this._dimRestore.height = Math.max(this._dimRestore.height - nDelta, dMin.height + 4 + 10);
        } else if (this._strOrientation.equalsIgnoreCase("South")) {
            this._dimRestore.height = Math.max(this._dimRestore.height + nDelta, dMin.height + 4 + 10);
        }
        Container parent = this.getParent();
        if (parent != null) {
            parent.invalidate();
            parent.validate();
        }
    }

    private static int getIntOrientation(String strOrientation) {
        if (strOrientation.equalsIgnoreCase("West") || strOrientation.equalsIgnoreCase("East")) {
            return 1;
        }
        return 0;
    }

    final class 1
    implements DividerListener {
        public void dividerMoved(DividerEvent e) {
            DividerControlledPanel.this.moveBy(e.getDelta());
        }
    }
}

