/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.VisibilityLayout;
import oracle.ideimpl.docking.shutter.ShutterMargin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DockPanel
extends DockLayoutPanel {
    public void dock(TitledPanel tp, DockLayoutConstraint dlc) {
        DockStationImpl.transfer(tp, this, dlc);
    }

    @Override
    public void remove(int index) {
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (shutterMargin != null) {
            TitledPanel titledPanel = (TitledPanel)this.getComponent(index);
            shutterMargin.removeShutter(titledPanel);
        }
        super.remove(index);
    }

    @Override
    public void removeAll() {
        ShutterMargin shutterMargin = this.getShutterMargin();
        if (shutterMargin != null) {
            shutterMargin.removeAll();
        }
        super.removeAll();
    }

    public static boolean canDock(JComponent comp, DockLayoutConstraint dlc) {
        DockLayoutInfo li;
        Object ref = dlc.getReference();
        return !(ref instanceof DockLayoutInfo ? (li = (DockLayoutInfo)ref).isReferring(comp) : comp == ref);
    }

    public int getTitledPanelCount() {
        return this.getComponentCount();
    }

    public TitledPanel getTitledPanel(int n) {
        return (TitledPanel)this.getComponent(n);
    }

    public int indexOfTitledPanel(TitledPanel tp) {
        int n = this.getComponentCount();
        int i = n - 1;
        while (i >= 0) {
            if (tp == this.getComponent(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public TitledPanel[] getAllTitledPanels() {
        int n = this.getComponentCount();
        TitledPanel[] ret = new TitledPanel[n];
        int i = n - 1;
        while (i >= 0) {
            ret[i] = (TitledPanel)this.getComponent(i);
            --i;
        }
        return ret;
    }

    @Override
    protected void whenDividerMoving() {
        if (this._draggedIsHorz) {
            this._draggedPtLast.x = this._draggedDivider.adjustForMax(this._draggedPtLast.x);
        } else {
            this._draggedPtLast.y = this._draggedDivider.adjustForMax(this._draggedPtLast.y);
        }
    }

    public void loadVisibilityLayout(VisibilityLayout newVisibilityLayout, boolean isStartup, int flags) {
        int titledPanelCount = this.getTitledPanelCount();
        int i = 0;
        while (i < titledPanelCount) {
            TitledPanel titledPanel = this.getTitledPanel(i);
            titledPanel.loadVisibilityLayout(newVisibilityLayout, isStartup, flags);
            ++i;
        }
    }

    void saveVisibilityLayout(VisibilityLayout visibilityLayout) {
        int titledPanelCount = this.getTitledPanelCount();
        int titledPanelPos = 0;
        while (titledPanelPos < titledPanelCount) {
            TitledPanel titledPanel = this.getTitledPanel(titledPanelPos);
            titledPanel.saveVisibilityLayout(visibilityLayout);
            ++titledPanelPos;
        }
    }

    public boolean getDockablePath(DockablePath path, DockableCriteria criteria) {
        switch (criteria.getSearchFor()) {
            case 1: {
                TitledPanel titledPanel = (TitledPanel)criteria.getCriteria();
                int index = this.indexOfTitledPanel(titledPanel);
                if (index == -1) break;
                path.setTitledPanel(titledPanel);
                return true;
            }
            default: {
                int titledPanelCount = this.getTitledPanelCount();
                int i = 0;
                while (i < titledPanelCount) {
                    TitledPanel titledPanel = this.getTitledPanel(i);
                    if (titledPanel.getDockablePath(path, criteria)) {
                        path.setTitledPanel(titledPanel);
                        return true;
                    }
                    ++i;
                }
                break block0;
            }
        }
        return false;
    }

    public DockInsertionPoint getClosestDockInsertionPoint(Point ptRef, Dimension moveBy, TitledPanel excludeTitledPanel) {
        DockInsertionPoint bestDip = null;
        if (this.isShowing()) {
            double bestDist = Double.MAX_VALUE;
            Point ptScreen = this.getLocationOnScreen();
            DockLayout dl = (DockLayout)this.getLayout();
            ArrayList al = dl.getInsertionPoints(this);
            int n = al.size();
            int j = 0;
            while (j < n) {
                DockLayoutConstraint constraint;
                double dist;
                DockInsertionPoint dip = (DockInsertionPoint)al.get(j);
                Point anchor = dip.getAnchor();
                Point absoluteAnchor = new Point(anchor.x + ptScreen.x, anchor.y + ptScreen.y);
                if ((moveBy.width < 0 && absoluteAnchor.x < ptRef.x || moveBy.width > 0 && absoluteAnchor.x > ptRef.x || moveBy.height < 0 && absoluteAnchor.y < ptRef.y || moveBy.height > 0 && absoluteAnchor.y > ptRef.y) && (dist = ptRef.distance(absoluteAnchor)) < bestDist && DockPanel.canDock(excludeTitledPanel, constraint = dip.createConstraint())) {
                    bestDip = dip;
                    bestDist = dist;
                    bestDip.setContainer(this);
                }
                ++j;
            }
        }
        return bestDip;
    }

    public void getDockablePaths(List<DockablePath> dockablePaths) {
        int titledPanelCount = this.getTitledPanelCount();
        int i = 0;
        while (i < titledPanelCount) {
            TitledPanel titledPanel = this.getTitledPanel(i);
            int from = dockablePaths.size();
            titledPanel.getDockablePaths(dockablePaths);
            int to = dockablePaths.size();
            int j = from;
            while (j < to) {
                DockablePath dockablePath = dockablePaths.get(j);
                dockablePath.setDockPanel(this);
                ++j;
            }
            ++i;
        }
    }

    public void setDockableVisible(DockablePath dockablePath, boolean bVisible, int flags) {
        TitledPanel titledPanel = dockablePath.getTitledPanel();
        titledPanel.setDockableVisible(dockablePath, bVisible, flags);
    }

    public boolean activateDockable(DockablePath dockablePath) {
        TitledPanel titledPanel = dockablePath.getTitledPanel();
        return titledPanel.activateDockable(dockablePath, 0);
    }

    public boolean getActiveDockablePath(DockablePath dockablePath) {
        int titledPanelCount = this.getTitledPanelCount();
        int i = 0;
        while (i < titledPanelCount) {
            TitledPanel titledPanel = this.getTitledPanel(i);
            if (titledPanel.getActiveDockablePath(dockablePath)) {
                dockablePath.setTitledPanel(titledPanel);
                return true;
            }
            ++i;
        }
        return false;
    }

    DividerControlledPanel getDividerControlledPanel() {
        Container parent = this.getParent();
        return parent instanceof DividerControlledPanel ? (DividerControlledPanel)parent : null;
    }

    ShutterMargin getShutterMargin() {
        DividerControlledPanel dividerControlledPanel = this.getDividerControlledPanel();
        if (dividerControlledPanel != null) {
            return dividerControlledPanel.getShutterMargin();
        }
        return null;
    }
}

