/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.List;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableHolder;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DockableHolderImpl
implements DockableHolder {
    public final boolean getDockablePath(DockablePath path, DockableCriteria criteria) {
        switch (criteria.getSearchFor()) {
            case 3: {
                if (!criteria.getCriteria().equals(this)) break;
                path.setParentHolder(this);
                return true;
            }
            case 2: {
                Dockable dockable = this.getDockable();
                if (!criteria.getCriteria().equals(dockable)) break;
                path.setParentHolder(this);
                return true;
            }
        }
        Dockable dockable = this.getDockable();
        if (dockable instanceof DrawerDockableWindow) {
            DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable;
            List containedHolders = drawerDockableWindow.getContainedHolders();
            int i = 0;
            while (i < containedHolders.size()) {
                DockableHolderImpl contained = (DockableHolderImpl)((DockableHolder)containedHolders.get(i));
                if (contained.getDockablePath(path, criteria)) {
                    path.setParentHolder(this);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void getDockablePaths(List<DockablePath> dockablePaths) {
        int from = dockablePaths.size();
        DockablePath path = new DockablePath();
        dockablePaths.add(path);
        Dockable dockable = this.getDockable();
        if (dockable instanceof DrawerDockableWindow) {
            DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)dockable;
            List containedHolders = drawerDockableWindow.getContainedHolders();
            for (DockableHolderImpl subHolder : containedHolders) {
                subHolder.getDockablePaths(dockablePaths);
            }
        }
        int to = dockablePaths.size();
        int i = from;
        while (i < to) {
            DockablePath dockablePath = dockablePaths.get(i);
            dockablePath.setParentHolder(this);
            ++i;
        }
    }

    abstract void undock(DockablePath var1, int var2);

    public abstract void disposeComponent();
}

