/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.List;
import javax.swing.Icon;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.window.WindowSelector;

final class DockableSelector
extends WindowSelector {
    private static final DockableSelector INSTANCE;
    private List _dockableList;
    private List _editorList;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DockableSelector() {
    }

    public static DockableSelector getInstance() {
        return INSTANCE;
    }

    void selectNext(List dockableList) {
        this.initialize(dockableList);
        this.selectNextItem();
    }

    void selectPrevious(List dockableList) {
        this.initialize(dockableList);
        this.selectPreviousItem();
    }

    public int sizeOfDisplayables() {
        return EditorManager.getEditorManager().getAllEditors().size() + DockStationImpl.getInstance().getVisibleDockablePaths().size();
    }

    static {
        $assertionsDisabled = DockableSelector.class.desiredAssertionStatus() ^ true;
        INSTANCE = new DockableSelector();
    }

    protected Displayable[] getDisplayables() {
        if (!$assertionsDisabled && this._dockableList == null) {
            throw new AssertionError();
        }
        Displayable[] displayables = new Displayable[this._dockableList.size() + this._editorList.size()];
        int index = 0;
        for (DockablePath dockablePath : this._dockableList) {
            Dockable dockable = dockablePath.getDockable();
            1 displayable = new 1(this, dockable);
            displayables[index++] = displayable;
        }
        for (Editor editor : this._editorList) {
            displayables[index++] = editor.getContext().getNode();
        }
        return displayables;
    }

    protected void activateSelectedWindow() {
        if (this._dockableList != null) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex < this._dockableList.size()) {
                DockablePath dockablePath = (DockablePath)this._dockableList.get(selectedIndex);
                Dockable dockable = dockablePath.getDockable();
                DockStationImpl.getInstance().activateDockable(dockable);
            } else {
                Editor selectedEditor = (Editor)this._editorList.get(selectedIndex -= this._dockableList.size());
                EditorInfo selectedEditorInfo = this.findEditorInfo(selectedEditor.getContext().getNode().getShortLabel());
                EditorManager.getEditorManager().activateEditor(selectedEditorInfo);
                EditorManager.getEditorManager().getCurrentEditor().getGUI().requestFocusInWindow();
            }
            this.dispose();
        }
    }

    private EditorInfo findEditorInfo(String shortLabel) {
        List editorInfos = EditorManager.getEditorManager().getEditorsInfo();
        for (EditorInfo info : editorInfos) {
            if (!info._getShortLabel().equals(shortLabel)) continue;
            return info;
        }
        return null;
    }

    protected void dispose() {
        super.dispose();
        this._dockableList = null;
        this._editorList = null;
    }

    private void initialize(List dockableList) {
        if (this._dockableList == null) {
            if (!($assertionsDisabled || dockableList != null && dockableList.size() > 0)) {
                throw new AssertionError();
            }
            this._dockableList = dockableList;
            this._editorList = EditorManager.getEditorManager().getAllEditors();
        }
    }

    final class 1
    extends DefaultDisplayable {
        private final /* synthetic */ Dockable v$dockable;
        final /* synthetic */ DockableSelector this$0;

        public String getShortLabel() {
            return this.v$dockable.getTitleName();
        }

        public Icon getIcon() {
            return this.v$dockable.getTabIcon();
        }

        public 1(DockableSelector dockableSelector, Dockable dockable) {
            this.v$dockable = dockable;
            this.this$0 = dockableSelector;
        }
    }
}

