/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.RotatingIcon;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DrawerElement;
import oracle.ide.resource.IdeIcons;
import oracle.ide.view.TitledContainer;
import oracle.ideimpl.docking.DrawerPanelImpl;

class DrawerElementImpl
extends DrawerElement
implements TitledContainer {
    private Component _component;
    private double _ratio;
    private double _expansionRatio;
    private final Listeners _listeners;
    private final JLabel _title;
    private final Toolbar _buttons;
    private boolean _active;

    private void $init$() {
        this._ratio = 1.0;
        this._expansionRatio = 0.0;
        this._listeners = new Listeners(null);
    }

    public DrawerElementImpl(String label, Component component) {
        super((LayoutManager)new GridBagLayout());
        this.$init$();
        JLabel handle = new JLabel(IdeIcons.getIcon((int)11));
        handle.setRequestFocusEnabled(false);
        this._listeners.add(handle);
        RotatingIcon rotatingIcon = new RotatingIcon(IdeIcons.getIcon((int)15));
        this._title = new JLabel(label, (Icon)rotatingIcon, 10);
        this._title.setRequestFocusEnabled(false);
        this._listeners.add(this._title);
        this._buttons = new Toolbar();
        this._buttons.setOpaque(false);
        this._buttons.setBorderPainted(false);
        Insets insets = new Insets(2, 2, 2, 2);
        this.add(handle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0));
        this.add(this._title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
        this.add((Component)this._buttons, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setComponent(component);
        Color background = UIManager.getColor("TextField.background");
        this.setBackground(background);
    }

    public String getLabel() {
        return this._title.getText();
    }

    private DrawerPanelImpl getDrawerComponent() {
        return (DrawerPanelImpl)((Object)this.getParent());
    }

    public Component getComponent() {
        return this._component;
    }

    public void setComponent(Component component) {
        if (this._component != null) {
            this.remove(this._component);
        }
        this._component = component;
        if (this._component != null) {
            this.add(this._component, new GridBagConstraints(0, 1, 99, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        }
    }

    protected void addButton(JComponent button) {
        button.setRequestFocusEnabled(false);
        this._buttons.add((Component)button);
    }

    public void removeButton(Component button) {
        this._buttons.remove(button);
    }

    int getTitlebarHeight() {
        Dimension preferredSize = this.getPreferredSize();
        int ret = preferredSize.height;
        Component component = this.getComponent();
        if (component != null && component.isVisible()) {
            Dimension compPrefSize = component.getPreferredSize();
            ret -= compPrefSize.height;
        }
        return ret;
    }

    double getRealRatio() {
        return this._ratio;
    }

    public double getRatio() {
        return this._ratio * this._expansionRatio;
    }

    public void setRatio(double ratio) {
        this._ratio = ratio;
    }

    public double getExpansionRatio() {
        return this._expansionRatio;
    }

    public void setExpansionRatio(double expansionRatio) {
        this._expansionRatio = expansionRatio;
        RotatingIcon rotatingIcon = (RotatingIcon)this._title.getIcon();
        rotatingIcon.setRotation(Math.PI * expansionRatio / 2.0);
    }

    public void setExpanded(boolean expanded) {
        this.setExpansionRatio(expanded ? 1 : 0);
    }

    public boolean isExpanded() {
        return this._expansionRatio > 0.0;
    }

    protected void paintComponent(Graphics gAWT) {
        Color c2;
        Color c1;
        super.paintComponent(gAWT);
        Graphics2D g = (Graphics2D)gAWT;
        if (this._active) {
            c1 = IdeUIManager.getActiveTitleGradientLightColor();
            c2 = IdeUIManager.getActiveTitleGradientDarkColor();
        } else {
            c1 = IdeUIManager.getInactiveTitleGradientLightColor();
            c2 = IdeUIManager.getInactiveTitleGradientDarkColor();
        }
        Insets insets = this.getInsets();
        int height = this._component.getHeight() > 0 ? this._component.getY() - insets.top : this.getHeight() - insets.top - insets.bottom;
        int width = this.getWidth() - (insets.left + insets.right);
        GradientPaint paint = new GradientPaint(insets.left, insets.top, c1, insets.left, height - 1, c2);
        g.setPaint(paint);
        g.fillRect(insets.left, insets.top, width, height);
    }

    private void whenClickExpand(MouseEvent e) {
        DrawerPanelImpl DockableDrawerPanel = this.getDrawerComponent();
        if (e.isControlDown() && !this.isExpanded()) {
            DockableDrawerPanel.toggle(Collections.singletonList((DrawerElement)this), null, true);
        } else {
            DockableDrawerPanel.toggleVisibility(this);
        }
    }

    private void whenClickTitle(MouseEvent e) {
        this.whenClickExpand(e);
    }

    private void whenMinimize() {
        DrawerPanelImpl drawerPanel = this.getDrawerComponent();
        drawerPanel.minimize(this, true);
    }

    private void whenMaximize() {
        DrawerPanelImpl drawerPanel = this.getDrawerComponent();
        drawerPanel.whenMaximize(this);
    }

    public void setMinimizable(boolean minimizable) {
    }

    public void containerActivated(boolean isActive) {
        this._active = isActive;
        int height = this.getHeight() - this._component.getHeight();
        int width = this.getWidth();
        this.repaint(500L, 0, 0, width, height);
    }

    boolean isActive() {
        return this._active;
    }

    static void mav$whenMinimize(DrawerElementImpl drawerElementImpl) {
        drawerElementImpl.whenMinimize();
    }

    static void mav$whenMaximize(DrawerElementImpl drawerElementImpl) {
        drawerElementImpl.whenMaximize();
    }

    static DrawerPanelImpl mav$getDrawerComponent(DrawerElementImpl drawerElementImpl) {
        return drawerElementImpl.getDrawerComponent();
    }

    static JLabel ra$_title(DrawerElementImpl drawerElementImpl) {
        return drawerElementImpl._title;
    }

    static void mav$whenClickTitle(DrawerElementImpl drawerElementImpl, MouseEvent mouseEvent) {
        drawerElementImpl.whenClickTitle(mouseEvent);
    }

    private final class Listeners
    implements MouseListener,
    MouseMotionListener,
    ActionListener {
        public void add(Component component) {
            component.addMouseListener(this);
            component.addMouseMotionListener(this);
        }

        public void mouseClicked(MouseEvent e) {
            Object source = e.getSource();
            if (DrawerElementImpl.ra$_title(DrawerElementImpl.this) == source) {
                DrawerElementImpl.mav$whenClickTitle(DrawerElementImpl.this, e);
            }
        }

        public void mousePressed(MouseEvent e) {
            DrawerPanelImpl drawerPanel = DrawerElementImpl.mav$getDrawerComponent(DrawerElementImpl.this);
            drawerPanel.mousePressed(DrawerElementImpl.this, e);
        }

        public void mouseReleased(MouseEvent e) {
            DrawerPanelImpl drawerPanel = DrawerElementImpl.mav$getDrawerComponent(DrawerElementImpl.this);
            drawerPanel.mouseReleased(DrawerElementImpl.this, e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            DrawerPanelImpl drawerPanel = DrawerElementImpl.mav$getDrawerComponent(DrawerElementImpl.this);
            drawerPanel.mouseDragged(DrawerElementImpl.this, e);
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if ("Minimize".equals(actionCommand)) {
                DrawerElementImpl.mav$whenMinimize(DrawerElementImpl.this);
            } else if ("Maximize".equals(actionCommand)) {
                DrawerElementImpl.mav$whenMaximize(DrawerElementImpl.this);
            }
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

