/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.List;
import javax.swing.JComponent;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerEntry;
import oracle.ide.docking.DrawerModel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableHolderImpl;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.DrawerElementImpl;
import oracle.ideimpl.docking.DrawerModelImpl;

public final class DrawerEntryImpl
extends DockableHolderImpl
implements DrawerEntry {
    private DrawerDockableWindow _drawerDockableWindow;
    protected DockableWindow _dockable;
    private DrawerElementImpl _drawerElement;
    private DrawerModel.State _state;

    private void $init$() {
        this._state = DrawerModel.State.VISIBLE;
    }

    DrawerEntryImpl(DrawerDockableWindow drawerDockableWindow, DockableWindow dockable) {
        this.$init$();
        this._drawerDockableWindow = drawerDockableWindow;
        this._dockable = dockable;
    }

    public DrawerElementImpl getComponent() {
        return this._drawerElement;
    }

    public DrawerElementImpl getOrCreateComponent() {
        if (this._drawerElement == null) {
            DockableWindow dockable = this.getDockable();
            String title = dockable.getTabName();
            JComponent hostedComponent = dockable.getHostedComponent();
            if (hostedComponent == null) {
                throw new IllegalStateException(dockable.getClass().getName() + " (" + title + ")\n" + "Dockable.getHostedComponent() cannot be null");
            }
            this._drawerElement = new DrawerElementImpl(title, hostedComponent);
        }
        return this._drawerElement;
    }

    public void disposeComponent() {
        this._drawerElement = null;
    }

    public void detach() {
        DrawerModelImpl model = (DrawerModelImpl)this._drawerDockableWindow.getModel();
        model.remove(this._dockable);
    }

    void setClientVisible(boolean visible, int flags) {
        if (visible) {
            this._drawerDockableWindow.show(this._dockable);
        } else {
            this._drawerDockableWindow.hide(this._dockable);
        }
    }

    public DrawerModel.State getState() {
        return this._state;
    }

    public void setState(DrawerModel.State state) {
        this._state = state;
    }

    public DockableWindow getDockable() {
        return this._dockable;
    }

    void undock(DockablePath path, int flags) {
        List<DockableHolderImpl> dockableHolders = path.getDockableHolders();
        DockableHolderImpl masterHolder = dockableHolders.get(dockableHolders.size() - 2);
        DrawerDockableWindow drawerDockableWindow = (DrawerDockableWindow)masterHolder.getDockable();
        DrawerModelImpl model = (DrawerModelImpl)drawerDockableWindow.getModel();
        model.remove(this._dockable);
        DockableEvent event = new DockableEvent((Dockable)this._dockable, 1, flags);
        DockStationImpl.getInstance().fireDockableEvent(event);
        this.disposeComponent();
    }

    int getDockableStatus() {
        int status;
        switch (1.$sm$oracle$ide$docking$DrawerModel$State[this._state.ordinal()]) {
            case 1: {
                status = 12;
                break;
            }
            case 2: {
                status = 40;
                break;
            }
            default: {
                status = 0;
                break;
            }
        }
        if (this._drawerElement != null && this._drawerElement.isActive()) {
            status |= 0x10;
        }
        return status;
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$ide$docking$DrawerModel$State;

        static {
            int[] nArray = new int[DrawerModel.State.values().length];
            $sm$oracle$ide$docking$DrawerModel$State = nArray;
            try {
                nArray[DrawerModel.State.MINIMIZED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$docking$DrawerModel$State[DrawerModel.State.VISIBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$docking$DrawerModel$State[DrawerModel.State.DETACHED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$ide$docking$DrawerModel$State[DrawerModel.State.HIDDEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

