/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Animator;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableDragContext;
import oracle.ide.docking.DockableDragSource;
import oracle.ide.docking.DockableDropTarget;
import oracle.ide.docking.DockableWindow;
import oracle.ide.docking.DrawerDockableWindow;
import oracle.ide.docking.DrawerElement;
import oracle.ide.docking.DrawerEntry;
import oracle.ide.docking.DrawerModel;
import oracle.ide.docking.DrawerPanel;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DrawerElementImpl;
import oracle.ideimpl.docking.DrawerEntryImpl;
import oracle.ideimpl.docking.DrawerModelImpl;
import oracle.ideimpl.docking.MinimizedTray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrawerPanelImpl
extends DrawerPanel
implements DockableDropTarget {
    private static final int COLLAPSE_SMALL_DRAWERS_THRESHOLD = 20;
    private static boolean _actionsCreated;
    private final DrawerDockableWindow _drawerDockableWindow;
    private final JComponent _bottomComponent;
    private ArrayList<Double> _drawerRatios;
    private int _dropFeedbackPos;
    private Listeners _listeners;
    private DockableDragContext _dockableDragContext;
    private Point _relativeStartPoint;
    private static final int FEEDBACK_HEIGHT = 100;

    private void $init$() {
        this._dropFeedbackPos = -1;
        this._listeners = new Listeners(null);
    }

    public DrawerPanelImpl(DrawerDockableWindow drawerDockableWindow) {
        this.$init$();
        DrawerPanelImpl.createActions();
        this._drawerDockableWindow = drawerDockableWindow;
        this._bottomComponent = new JLabel(IdeIcons.getIcon((int)6));
        this._bottomComponent.setRequestFocusEnabled(false);
        this._bottomComponent.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this._bottomComponent.addMouseListener(new 1());
        this.add(this._bottomComponent);
        2 prevPanelAction = new 2();
        3 nextPanelAction = new 3();
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(117, 1), prevPanelAction);
        inputMap.put(KeyStroke.getKeyStroke(117, 0), nextPanelAction);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(prevPanelAction, prevPanelAction);
        actionMap.put(nextPanelAction, nextPanelAction);
        this.setBackground(Color.WHITE);
        DrawerModelImpl model = this.getModel();
        Listener listener = new Listener(null);
        model.addListDataListener(listener);
        if (model.size() > 0) {
            ListDataEvent addAllEvent = new ListDataEvent((Object)model, 1, 0, model.size() - 1);
            listener.intervalAdded(addAllEvent);
        }
    }

    private void addDrawerElement(DrawerEntryImpl drawerEntry, int index) {
        DrawerElementImpl drawerElement = drawerEntry.getOrCreateComponent();
        DockableWindow dockable = drawerEntry.getDockable();
        MenuToolButton menuToolButton = new MenuToolButton((ToggleAction)IdeAction.newLocalAction((int)DrawerDockableWindow.DROP_DOWN_ACTION_ID, (View)dockable));
        menuToolButton.setBorder(BorderFactory.createEmptyBorder());
        menuToolButton.addPopupItem((ToggleAction)IdeAction.newLocalAction((int)DrawerDockableWindow.RESTORE_ACTION_ID, (View)dockable));
        menuToolButton.addPopupItem((ToggleAction)IdeAction.newLocalAction((int)DrawerDockableWindow.MOVE_ACTION_ID, (View)dockable));
        menuToolButton.addPopupItem((ToggleAction)IdeAction.newLocalAction((int)DrawerDockableWindow.SIZE_ACTION_ID, (View)dockable));
        menuToolButton.addPopupItem((ToggleAction)IdeAction.newLocalAction((int)DrawerDockableWindow.FLOAT_ACTION_ID, (View)dockable));
        menuToolButton.addPopupItem((ToggleAction)IdeAction.newLocalAction((int)DrawerDockableWindow.MINIMIZE_ACTION_ID, (View)dockable));
        menuToolButton.addPopupItem((ToggleAction)IdeAction.newLocalAction((int)DrawerDockableWindow.MAXIMIZE_ACTION_ID, (View)dockable));
        menuToolButton.setOpaque(false);
        menuToolButton.setBorderPainted(false);
        drawerElement.addButton((JComponent)menuToolButton);
        Ide.getMainWindow().registerView((View)dockable);
        if (DrawerModel.State.VISIBLE.equals((Object)drawerEntry.getState())) {
            this.addDrawer(index, drawerElement);
            DockStationImpl.getInstance().addToCache((Dockable)dockable);
        }
    }

    private void removeDrawerElement(DrawerEntryImpl drawerEntry) {
        DockableWindow dockableWindow = drawerEntry.getDockable();
        DockStationImpl.getInstance().removeFromCache((Dockable)dockableWindow);
        Ide.getMainWindow().unregisterView((View)dockableWindow);
        DrawerElementImpl drawerElement = drawerEntry.getComponent();
        if (drawerElement != null) {
            this.removeDrawer(drawerElement);
        }
    }

    public void dumpDrawerSizes() {
        System.out.println("======================================");
        List<DrawerElementImpl> drawers = this.getDrawers();
        for (DrawerElementImpl drawerElement : drawers) {
            System.out.println(drawerElement.getLabel() + ":" + drawerElement.getRealRatio() + "/" + drawerElement.getRatio());
        }
    }

    public void addDrawer(int pos, DrawerElement drawerElement) {
        this.add((Component)drawerElement);
        this.whenVisibleDrawerCountChanges();
        List<DrawerElementImpl> drawers = this.getDrawers();
        if (drawers.size() == 1) {
            DrawerElementImpl drawerElementImpl = (DrawerElementImpl)drawerElement;
            drawerElementImpl.setExpanded(true);
        }
    }

    public void removeDrawer(DrawerElement drawerElement) {
        this.remove((Component)drawerElement);
        this.whenVisibleDrawerCountChanges();
    }

    protected final void addDropFeedback(int position) {
        this._dropFeedbackPos = position;
        this.invalidate();
        this.validate();
    }

    protected final void removeDropFeedback() {
        this.addDropFeedback(-1);
    }

    public List<DrawerElementImpl> getDrawers() {
        DrawerModelImpl model = this.getModel();
        List<DrawerEntryImpl> entries = model.getEntries();
        ArrayList<DrawerElementImpl> drawerElements = new ArrayList<DrawerElementImpl>();
        for (DrawerEntryImpl entry : entries) {
            if (entry.getState() != DrawerModel.State.VISIBLE) continue;
            DrawerElementImpl drawerElement = (DrawerElementImpl)entry.getOrCreateComponent();
            drawerElements.add(drawerElement);
        }
        return drawerElements;
    }

    public void doLayout() {
        int allocatableHeight;
        Insets insets = this.getInsets();
        int width = this.getWidth();
        int availableWidth = width - (insets.left + insets.right);
        int height = this.getHeight();
        Dimension bottomPrefSize = this._bottomComponent.getPreferredSize();
        int bottomPrefHeight = bottomPrefSize.height;
        int bottomPrefWidth = bottomPrefSize.width;
        this._bottomComponent.setBounds(width - insets.right - bottomPrefWidth, height - insets.bottom - bottomPrefHeight, bottomPrefWidth, bottomPrefHeight);
        List<DrawerElementImpl> drawers = this.getDrawers();
        int titlebarHeights = 0;
        double totalRatio = 0.0;
        int expandedCount = 0;
        for (DrawerElementImpl drawerElement : drawers) {
            if (drawerElement.isExpanded()) {
                double ratio = drawerElement.getRatio();
                totalRatio += ratio;
                ++expandedCount;
            }
            int titlebarHeight = drawerElement.getTitlebarHeight();
            titlebarHeights += titlebarHeight;
        }
        int availableHeight = height - (insets.top + bottomPrefHeight + insets.bottom);
        int remainingHeight = allocatableHeight = availableHeight - titlebarHeights;
        if (this._dropFeedbackPos >= 0) {
            remainingHeight -= 100;
        }
        int expandedLeft = expandedCount;
        double y = insets.top;
        boolean isAnimating = false;
        int drawerCount = drawers.size();
        double[] newRatios = new double[drawerCount];
        int i = 0;
        while (i < drawerCount) {
            DrawerElementImpl drawerElement = drawers.get(i);
            if (i == this._dropFeedbackPos) {
                y += (double)100;
            }
            double newRatio = 1.0;
            int drawerHeight = drawerElement.getTitlebarHeight();
            if (drawerElement.isExpanded()) {
                if (--expandedLeft != 0) {
                    double ratio = drawerElement.getRatio();
                    if (totalRatio > 0.0) {
                        int componentHeight = (int)Math.round((double)remainingHeight * ratio / totalRatio);
                        drawerHeight += componentHeight;
                        remainingHeight -= componentHeight;
                        totalRatio -= ratio;
                        if (allocatableHeight > 0) {
                            newRatio = (double)componentHeight / (double)allocatableHeight;
                        }
                    }
                } else {
                    newRatio = (double)remainingHeight / (double)allocatableHeight;
                    drawerHeight += remainingHeight;
                }
                if (drawerElement.getExpansionRatio() != 1.0) {
                    isAnimating = true;
                }
            }
            drawerElement.setBounds(insets.left, (int)Math.ceil(y), availableWidth, drawerHeight);
            y += (double)drawerHeight;
            newRatios[i] = newRatio;
            ++i;
        }
        if (!isAnimating) {
            int i2 = 0;
            while (i2 < drawerCount) {
                double newRatio = newRatios[i2];
                DrawerElementImpl drawerElement = drawers.get(i2);
                drawerElement.setRatio(newRatio);
                ++i2;
            }
        }
    }

    public void expand(DrawerElementImpl drawerElement) {
        this.toggle(Collections.singletonList(drawerElement), null, true);
    }

    void toggleVisibility(DrawerElementImpl drawerElement) {
        switch (2) {
            case 1: {
                this.toggleVisibility_multipleOpen(drawerElement);
                break;
            }
            case 2: {
                this.toggleVisibility_closeOneAtATime(drawerElement);
                break;
            }
            case 3: {
                this.toggleVisibility_keepOne(drawerElement);
                break;
            }
        }
    }

    private void toggleVisibility_multipleOpen(DrawerElementImpl drawerElement) {
        List<DrawerElementImpl> singleton = Collections.singletonList(drawerElement);
        if (drawerElement.isExpanded()) {
            this.toggle(null, singleton, true);
        } else {
            this.toggle(singleton, null, true);
        }
    }

    private void toggleVisibility_closeOneAtATime(DrawerElementImpl drawerElement) {
        if (drawerElement.isExpanded()) {
            List<DrawerElementImpl> expandedDrawers = this.getDrawers(true);
            if (expandedDrawers.size() > 1) {
                this.toggle(null, Collections.singletonList(drawerElement), true);
            }
        } else {
            List<DrawerElementImpl> expand = Collections.singletonList(drawerElement);
            List<DrawerElementImpl> collapse = this.getDrawers(true);
            this.toggle(expand, collapse, true);
        }
    }

    private void toggleVisibility_keepOne(DrawerElementImpl drawerElement) {
        if (drawerElement.isExpanded()) {
            List<DrawerElementImpl> expanded = this.getDrawers(true);
            expanded.remove((Object)drawerElement);
            if (!expanded.isEmpty()) {
                this.toggle(null, expanded, true);
            }
        } else {
            List<DrawerElementImpl> collapse = this.getDrawers(true);
            this.toggle(Collections.singletonList(drawerElement), collapse, true);
        }
    }

    public void toggle(List<? extends DrawerElement> expand, List<? extends DrawerElement> collapse, boolean animate) {
        KeyboardFocusManager focusManager;
        Component focusOwner;
        DrawerElementImpl oldFocused = null;
        DrawerElementImpl newFocused = null;
        if (expand != null && !expand.isEmpty() && collapse != null && !collapse.isEmpty() && (focusOwner = (focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getFocusOwner()) != null && SwingUtilities.isDescendingFrom(focusOwner, (Component)((Object)this))) {
            int i = 0;
            while (newFocused == null && i < collapse.size()) {
                DrawerElementImpl drawerElement = (DrawerElementImpl)collapse.get(i);
                if (SwingUtilities.isDescendingFrom(focusOwner, (Component)((Object)drawerElement))) {
                    oldFocused = drawerElement;
                    newFocused = (DrawerElementImpl)expand.get(0);
                }
                ++i;
            }
        }
        if (animate) {
            if (this.isShowing()) {
                DrawerElementImpl oldFocused2 = oldFocused;
                DrawerElementImpl newFocused2 = newFocused;
                4 propertyChangeListener = new 4(this, expand, collapse, newFocused2, oldFocused2);
                Animator.animate((int)30, (long)400L, (int)10, (double)0.6, (double)0.14, (PropertyChangeListener)propertyChangeListener);
            }
        } else {
            if (expand != null) {
                for (DrawerElement drawerElement : expand) {
                    DrawerElementImpl element = (DrawerElementImpl)drawerElement;
                    element.setExpansionRatio(1.0);
                }
            }
            if (collapse != null) {
                for (DrawerElement drawerElement : collapse) {
                    DrawerElementImpl element = (DrawerElementImpl)drawerElement;
                    element.setExpansionRatio(0.0);
                }
            }
            this.invalidate();
            this.validate();
        }
    }

    protected final void insideDrag(DrawerElementImpl drawer1, DrawerElementImpl drawer2, int delta, DrawerElementImpl drawerElement) {
        int height = this.getHeight();
        Insets insets = this.getInsets();
        List<DrawerElementImpl> drawers = this.getDrawers();
        int titlebarHeights = 0;
        for (DrawerElementImpl element : drawers) {
            int titlebarHeight = element.getTitlebarHeight();
            titlebarHeights += titlebarHeight;
        }
        int availableHeight = height - (insets.top + insets.bottom);
        double allocatableHeight = availableHeight - titlebarHeights;
        double newRatio1 = this.calcNewRatio(allocatableHeight, drawer1, delta);
        double newRatio2 = this.calcNewRatio(allocatableHeight, drawer2, -delta);
        if (newRatio1 * allocatableHeight < 1.0) {
            double smallRatio = drawer1.getRatio();
            newRatio2 += smallRatio;
            drawer1.setExpanded(false);
            int pos = drawers.indexOf((Object)drawer1);
            Double ratio = this._drawerRatios.get(pos);
            if (ratio > 0.0) {
                drawer1.setRatio(ratio);
            }
        }
        if (newRatio2 * allocatableHeight < 1.0) {
            double smallRatio = drawer2.getRatio();
            newRatio1 += smallRatio;
            int pos = drawers.indexOf((Object)drawer2);
            Double ratio = this._drawerRatios.get(pos);
            drawer2.setExpanded(false);
            if (ratio > 0.0) {
                drawer2.setRatio(ratio);
            }
        }
        if (newRatio1 * allocatableHeight >= 1.0 && newRatio2 * allocatableHeight >= 1.0) {
            drawer1.setRatio(newRatio1);
            drawer1.setExpanded(true);
            drawer2.setRatio(newRatio2);
            drawer2.setExpanded(true);
        }
        this.invalidate();
        this.validate();
    }

    private double calcNewRatio(double allocatableHeight, DrawerElementImpl drawerElement, int delta) {
        double ret = drawerElement.getRatio() + (double)delta / allocatableHeight;
        return ret;
    }

    void mousePressed(DrawerElementImpl drawerElement, MouseEvent e) {
        List<DrawerElementImpl> drawers = this.getDrawers();
        int drawerCount = drawers.size();
        this._drawerRatios = new ArrayList(drawerCount);
        int i = 0;
        while (i < drawerCount) {
            DrawerElementImpl drawerElement_i = drawers.get(i);
            double ratio = drawerElement_i.getRatio();
            this._drawerRatios.add(ratio);
            ++i;
        }
        this.whenMousePressed(drawerElement, e);
    }

    void mouseDragged(DrawerElementImpl drawerElement, MouseEvent e) {
        this.whenMouseDragged(drawerElement, e);
    }

    void mouseReleased(DrawerElementImpl drawerElement, MouseEvent e) {
        this.whenMouseReleased(drawerElement, e);
        this.closeSmallDrawers();
        this._drawerRatios = null;
    }

    private void closeSmallDrawers() {
        ArrayList<DrawerElementImpl> collapse = new ArrayList<DrawerElementImpl>();
        List<DrawerElementImpl> drawers = this.getDrawers(true);
        for (DrawerElementImpl drawerElement : drawers) {
            int titlebarHeight = drawerElement.getTitlebarHeight();
            int height = drawerElement.getHeight();
            int componentHeight = height - titlebarHeight;
            if (componentHeight >= 20) continue;
            collapse.add(drawerElement);
        }
        if (!collapse.isEmpty()) {
            this.toggle(null, collapse, true);
        }
    }

    public void minimize(DrawerElement drawerElement, boolean animate) {
        DrawerElementImpl expandDrawerElement = null;
        if (drawerElement.isExpanded()) {
            List<DrawerElementImpl> drawers;
            int thisPos = (drawers = this.getDrawers()).indexOf(drawerElement);
            expandDrawerElement = drawers.get(thisPos > 0 ? thisPos - 1 : thisPos);
        }
        if (animate) {
            Rectangle sourceBounds = drawerElement.getBounds();
            Rectangle destBounds = this._bottomComponent.getBounds();
            5 propertyChangeListener = new 5(this, drawerElement, sourceBounds, destBounds);
            Animator.animate((int)30, (long)600L, (int)10, (double)0.6, (double)0.14, (PropertyChangeListener)propertyChangeListener);
        }
        this.remove((Component)drawerElement);
        if (expandDrawerElement != null) {
            this.expand(expandDrawerElement);
        }
        this.whenVisibleDrawerCountChanges();
        this.invalidate();
        this.revalidate();
    }

    private void whenVisibleDrawerCountChanges() {
        List<DrawerElementImpl> drawers = this.getDrawers();
        boolean minimizable = drawers.size() > 1;
        for (DrawerElementImpl drawerElement : drawers) {
            drawerElement.setMinimizable(minimizable);
        }
    }

    private void whenTrayClicked() {
        DrawerModelImpl model = this.getModel();
        List<DrawerEntryImpl> entries = model.getEntries();
        MinimizedTray minimizedTray = new MinimizedTray(this);
        for (DrawerEntryImpl entry : entries) {
            if (DrawerModel.State.MINIMIZED != entry.getState()) continue;
            minimizedTray.addEntry(entry);
        }
        if (!minimizedTray.isEmpty()) {
            minimizedTray.expand((Component)((Object)this));
        }
    }

    public void restore(DrawerEntry entry, boolean animate) {
        DrawerElement drawerElement = entry.getOrCreateComponent();
        this.add((Component)drawerElement);
        entry.setState(DrawerModel.State.VISIBLE);
        drawerElement.setExpanded(false);
        this.validate();
        List<DrawerElementImpl> collapse = this.getDrawers(true);
        this.toggle(Collections.singletonList(drawerElement), collapse, animate);
        this.whenVisibleDrawerCountChanges();
    }

    public void show(DrawerEntry entry) {
        DrawerElementImpl drawerElement = (DrawerElementImpl)entry.getOrCreateComponent();
        this.add((Component)((Object)drawerElement));
        entry.setState(DrawerModel.State.VISIBLE);
        this.whenVisibleDrawerCountChanges();
        this.invalidate();
        this.revalidate();
    }

    public void hide(DrawerEntry entry) {
        block6: {
            DrawerElementImpl expandDrawerElement = null;
            DrawerElementImpl hiddenDrawerElement = (DrawerElementImpl)entry.getComponent();
            if (hiddenDrawerElement == null) break block6;
            List<DrawerElementImpl> expandedDrawers = this.getDrawers(true);
            expandedDrawers.remove((Object)hiddenDrawerElement);
            if (expandedDrawers.isEmpty()) {
                List<DrawerElementImpl> drawers = this.getDrawers();
                int index = drawers.indexOf((Object)hiddenDrawerElement);
                int i = index - 1;
                while (expandDrawerElement == null && i >= 0) {
                    DrawerElementImpl element = drawers.get(i);
                    if (element.isVisible()) {
                        expandDrawerElement = element;
                    }
                    --i;
                }
                int i2 = index + 1;
                while (i2 < drawers.size()) {
                    DrawerElementImpl element = drawers.get(i2);
                    if (element.isVisible()) {
                        expandDrawerElement = element;
                    }
                    ++i2;
                }
            }
            this.remove((Component)((Object)hiddenDrawerElement));
            entry.setState(DrawerModel.State.HIDDEN);
            if (expandDrawerElement != null) {
                this.expand(expandDrawerElement);
            }
            this.whenVisibleDrawerCountChanges();
            this.invalidate();
            this.revalidate();
        }
    }

    public void whenMaximize(DrawerElementImpl drawerElement) {
        List<DrawerElementImpl> collapse = this.getDrawers(true);
        collapse.remove((Object)drawerElement);
        List<DrawerElementImpl> expand = drawerElement.isExpanded() ? null : Collections.singletonList(drawerElement);
        this.toggle(expand, collapse, true);
    }

    private List<DrawerElementImpl> getDrawers(Boolean expanded) {
        ArrayList<DrawerElementImpl> ret = new ArrayList<DrawerElementImpl>();
        List<DrawerElementImpl> drawers = this.getDrawers();
        for (DrawerElementImpl drawerElement : drawers) {
            if (expanded != null && drawerElement.isExpanded() != expanded.booleanValue()) continue;
            ret.add(drawerElement);
        }
        return ret;
    }

    private DrawerElementImpl getFocusedDrawerPos() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        for (DrawerElementImpl drawerElement : this.getDrawers()) {
            if (!SwingUtilities.isDescendingFrom(focusOwner, (Component)((Object)drawerElement))) continue;
            return drawerElement;
        }
        return null;
    }

    private void whenPrevPanel() {
        this.whenNextPrevPanel(-1);
    }

    private void whenNextPanel() {
        this.whenNextPrevPanel(1);
    }

    private void whenNextPrevPanel(int direction) {
        DrawerElementImpl focusedDrawerElement = this.getFocusedDrawerPos();
        if (focusedDrawerElement != null) {
            List<DrawerElementImpl> drawers = this.getDrawers();
            int focusedDrawerPos = drawers.indexOf((Object)focusedDrawerElement);
            int activateDrawerPos = (focusedDrawerPos + direction + drawers.size()) % drawers.size();
            DrawerElementImpl activateDrawerElement = drawers.get(activateDrawerPos);
            List<DrawerElementImpl> expandedDrawers = this.getDrawers(true);
            expandedDrawers.remove((Object)activateDrawerElement);
            this.toggle(Collections.singletonList(activateDrawerElement), expandedDrawers, true);
            activateDrawerElement.getComponent().requestFocus();
        }
    }

    private Dockable getDockable(DrawerElementImpl drawerElement) {
        return this._drawerDockableWindow.getDockable((DrawerElement)drawerElement);
    }

    protected void whenMousePressed(DrawerElementImpl drawerElement, MouseEvent e) {
        this._relativeStartPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), (Component)((Object)drawerElement));
    }

    protected void whenMouseDragged(DrawerElementImpl drawerElement, MouseEvent e) {
        if (this._relativeStartPoint != null) {
            Point ptScreen = e.getPoint();
            SwingUtilities.convertPointToScreen(ptScreen, e.getComponent());
            if (this._dockableDragContext == null) {
                DockStation dockStation = DockStation.getDockStation();
                this._dockableDragContext = dockStation.createDockableDragContext((DockableDragSource)this._listeners);
                Dockable dockable = this.getDockable(drawerElement);
                Dockable[] dockables = new Dockable[]{dockable};
                this._dockableDragContext.setDockables(dockables);
                this._dockableDragContext.setStartPoint(ptScreen);
                Dimension drawerSize = drawerElement.getSize();
                this._dockableDragContext.setPreferredSizes(drawerSize, drawerSize);
            }
            this._dockableDragContext.mouseMoved(ptScreen, e.getModifiers());
        }
    }

    protected void whenMouseReleased(DrawerElementImpl drawerElement, MouseEvent e) {
        if (this._dockableDragContext != null) {
            Point ptScreen = e.getPoint();
            SwingUtilities.convertPointToScreen(ptScreen, e.getComponent());
            this._dockableDragContext.endDrag(ptScreen, e.getModifiers());
            this._dockableDragContext = null;
        }
    }

    private void whenDragCanceled() {
        this._relativeStartPoint = null;
        this._dockableDragContext = null;
    }

    public boolean dragEnter(DockableDragContext dockableDragContext, Point ptScreen) {
        return this.dragOver(dockableDragContext, ptScreen);
    }

    public boolean dragOver(DockableDragContext dockableDragContext, Point ptScreen) {
        return this.dragOrAccept(dockableDragContext, ptScreen, false);
    }

    public void dragExit(DockableDragContext dockableDragContext) {
        this.removeDropFeedback();
    }

    public void acceptDrop(DockableDragContext dockableDragContext, Point ptScreen) {
        this.dragOrAccept(dockableDragContext, ptScreen, true);
    }

    private boolean dragOrAccept(DockableDragContext dockableDragContext, Point ptScreen, boolean accept) {
        boolean ret = false;
        Dockable[] dockables = dockableDragContext.getDockables();
        if (dockables[0] instanceof DockableWindow) {
            DockableWindow draggedDockable = (DockableWindow)dockables[0];
            DrawerModelImpl model = this.getModel();
            int index = model.indexOf((Dockable)draggedDockable);
            if (index != -1) {
                DrawerEntryImpl entry = model.getEntry(index);
                DrawerElementImpl draggedDrawerElement = entry.getOrCreateComponent();
                if (this.isDropReorder(ptScreen, draggedDrawerElement)) {
                    this.removeDropFeedback();
                    Dimension drawerSize = draggedDrawerElement.getSize();
                    this._dockableDragContext.setPreferredSizes(drawerSize, drawerSize);
                    ret = true;
                } else {
                    int dropInsertPosition = this.getDropInsertPosition(ptScreen);
                    if (dropInsertPosition >= 0) {
                        List<DrawerElementImpl> drawers = this.getDrawers();
                        int sourcePos = drawers.indexOf((Object)draggedDrawerElement);
                        int visibleDistance = this.getVisibleDistance(sourcePos, dropInsertPosition);
                        if (visibleDistance > 0) {
                            if (this.isDraggedOverFeedback(dropInsertPosition)) {
                                if (accept) {
                                    this.dragAccept(entry, dropInsertPosition);
                                }
                            } else if (accept) {
                                this.dragAccept(entry, dropInsertPosition);
                            } else {
                                this.addDropFeedback(dropInsertPosition);
                            }
                        } else {
                            this.removeDropFeedback();
                        }
                        ret = true;
                    }
                }
            }
        }
        return ret;
    }

    private boolean isDraggedOverFeedback(int dropInsertPosition) {
        System.out.println("DockableDrawerPanel.isDraggedOverFeedback : " + dropInsertPosition + " == " + this._dropFeedbackPos);
        return dropInsertPosition == this._dropFeedbackPos;
    }

    private int getVisibleDistance(int from, int to) {
        int ret = from > to ? from - to : to - from - 1;
        return ret;
    }

    private void dragAccept(DrawerEntryImpl entry, int dropInsertPosition) {
        DrawerModelImpl model = this.getModel();
        model.move(entry, dropInsertPosition);
    }

    private DrawerModelImpl getModel() {
        return (DrawerModelImpl)this._drawerDockableWindow.getModel();
    }

    private boolean isDropReorder(Point ptScreen, DrawerElementImpl drawerElement) {
        boolean ret = false;
        if (this.containsScreenPoint(ptScreen)) {
            Point pt = new Point(ptScreen);
            SwingUtilities.convertPointFromScreen(pt, (Component)((Object)drawerElement));
            List<DrawerElementImpl> drawers = this.getDrawers();
            int pos = drawers.indexOf((Object)drawerElement);
            DrawerElementImpl previous = null;
            DrawerElementImpl next = null;
            int delta = pt.y - this._relativeStartPoint.y;
            if (delta < 0) {
                int i = pos - 1;
                while (previous == null && i >= 0) {
                    DrawerElementImpl drawerElement_i = drawers.get(i);
                    if (drawerElement_i.isExpanded()) {
                        previous = drawerElement_i;
                    }
                    --i;
                }
                next = drawerElement;
            } else {
                if (pos > 0) {
                    previous = drawers.get(pos - 1);
                }
                int modelSize = drawers.size();
                int i = pos;
                while (next == null && i < modelSize) {
                    DrawerElementImpl drawerElement_i = drawers.get(i);
                    if (drawerElement_i.isExpanded()) {
                        next = drawerElement_i;
                    }
                    ++i;
                }
            }
            if (previous != null && next != null) {
                this.insideDrag(previous, next, delta, drawerElement);
                ret = true;
            }
        }
        return ret;
    }

    private boolean containsScreenPoint(Point ptScreen) {
        Point pt = new Point(ptScreen);
        SwingUtilities.convertPointFromScreen(pt, (Component)((Object)this));
        return this.contains(pt);
    }

    private int getDropInsertPosition(Point ptScreen) {
        List<DrawerElementImpl> drawers = this.getDrawers();
        Rectangle bounds = new Rectangle();
        Point pt = new Point(ptScreen);
        SwingUtilities.convertPointFromScreen(pt, (Component)((Object)this));
        int i = 0;
        while (i < drawers.size()) {
            DrawerElementImpl element = drawers.get(i);
            element.getBounds(bounds);
            if (bounds.contains(pt)) {
                Component component = element.getComponent();
                if (component != null) {
                    if (pt.y < bounds.y + bounds.height / 2) {
                        return i;
                    }
                    return i + 1;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void saveLayout(StructuredPropertyAccess layout) {
        List<DrawerElementImpl> drawerElements = this.getDrawers();
        for (DrawerElementImpl drawerElement : drawerElements) {
            double ratio = drawerElement.getRatio();
            boolean expanded = drawerElement.isExpanded();
            DefaultStructuredPropertyAccess propertyAccess = new DefaultStructuredPropertyAccess("Drawer");
            propertyAccess.setProperty("Ratio", Double.toString(ratio));
            if (expanded) {
                propertyAccess.setBooleanProperty("Expanded", true);
            }
            layout.appendChild((StructuredPropertyAccess)propertyAccess);
        }
    }

    protected void loadLayout(StructuredPropertyAccess layout) {
        List<DrawerElementImpl> drawers = this.getDrawers();
        Iterator childNodes = layout.getChildNodes("Drawer");
        int i = 0;
        while (i < drawers.size() && childNodes.hasNext()) {
            DrawerElementImpl drawerElement = drawers.get(i);
            StructuredPropertyAccess propertyAccess = (StructuredPropertyAccess)childNodes.next();
            String property = propertyAccess.getProperty("Ratio", "0");
            double ratio = Double.parseDouble(property);
            boolean expanded = propertyAccess.getBooleanProperty("Expanded", false);
            drawerElement.setRatio(ratio);
            drawerElement.setExpanded(expanded);
            ++i;
        }
    }

    private static void createActions() {
        if (!_actionsCreated) {
            IdeAction.get((int)DrawerDockableWindow.DROP_DOWN_ACTION_ID, null, (String)"Menu", null, null, (ArrayResourceBundle)IdeIcons.getInstance(), (int)28, null, (boolean)true);
            IdeAction.get((int)DrawerDockableWindow.RESTORE_ACTION_ID, null, (String)"Restore", null, null, null, null, (boolean)true);
            IdeAction.get((int)DrawerDockableWindow.MOVE_ACTION_ID, null, (String)"Move", null, null, null, null, (boolean)true);
            IdeAction.get((int)DrawerDockableWindow.SIZE_ACTION_ID, null, (String)"Size", null, null, null, null, (boolean)true);
            IdeAction.get((int)DrawerDockableWindow.FLOAT_ACTION_ID, null, (String)"Float", null, null, null, null, (boolean)true);
            IdeAction.get((int)DrawerDockableWindow.MINIMIZE_ACTION_ID, null, (String)"Minimize", null, null, null, null, (boolean)true);
            IdeAction.get((int)DrawerDockableWindow.MAXIMIZE_ACTION_ID, null, (String)"Maximize", null, null, null, null, (boolean)true);
            _actionsCreated = true;
        }
    }

    static void mav$whenDragCanceled(DrawerPanelImpl drawerPanelImpl) {
        drawerPanelImpl.whenDragCanceled();
    }

    static DrawerModelImpl mav$getModel(DrawerPanelImpl drawerPanelImpl) {
        return drawerPanelImpl.getModel();
    }

    static void mav$removeDrawerElement(DrawerPanelImpl drawerPanelImpl, DrawerEntryImpl drawerEntryImpl) {
        drawerPanelImpl.removeDrawerElement(drawerEntryImpl);
    }

    static void mav$addDrawerElement(DrawerPanelImpl drawerPanelImpl, DrawerEntryImpl drawerEntryImpl, int n) {
        drawerPanelImpl.addDrawerElement(drawerEntryImpl, n);
    }

    static void mav$whenTrayClicked(DrawerPanelImpl drawerPanelImpl) {
        drawerPanelImpl.whenTrayClicked();
    }

    static void mav$whenPrevPanel(DrawerPanelImpl drawerPanelImpl) {
        drawerPanelImpl.whenPrevPanel();
    }

    static void mav$whenNextPanel(DrawerPanelImpl drawerPanelImpl) {
        drawerPanelImpl.whenNextPanel();
    }

    final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            DrawerPanelImpl.mav$whenTrayClicked(DrawerPanelImpl.this);
        }
    }

    final class 2
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            DrawerPanelImpl.mav$whenPrevPanel(DrawerPanelImpl.this);
        }
    }

    final class 3
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            DrawerPanelImpl.mav$whenNextPanel(DrawerPanelImpl.this);
        }
    }

    final class 4
    implements PropertyChangeListener {
        private final /* synthetic */ List v$expand;
        private final /* synthetic */ List v$collapse;
        private final /* synthetic */ DrawerElementImpl v$newFocused2;
        private final /* synthetic */ DrawerElementImpl v$oldFocused2;
        final /* synthetic */ DrawerPanelImpl this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            double expansionRatio = (Double)evt.getNewValue();
            if (this.v$expand != null) {
                for (DrawerElement drawerElement : this.v$expand) {
                    DrawerElementImpl element = (DrawerElementImpl)drawerElement;
                    element.setExpansionRatio(expansionRatio);
                }
            }
            if (this.v$collapse != null) {
                for (DrawerElement drawerElement : this.v$collapse) {
                    DrawerElementImpl element = (DrawerElementImpl)drawerElement;
                    element.setExpansionRatio(1.0 - expansionRatio);
                }
            }
            this.this$0.invalidate();
            this.this$0.validate();
            if (this.v$newFocused2 != null) {
                this.v$oldFocused2.containerActivated(false);
                this.v$newFocused2.containerActivated(true);
                Component firstComponent = this.v$newFocused2.getComponent();
                JComponent focusable = GraphicsUtils.getFocusableComponentOrChild((Component)firstComponent, (boolean)true);
                focusable.requestFocus();
            }
            Graphics g = this.this$0.getGraphics();
            this.this$0.paint(g);
            g.dispose();
        }

        public 4(DrawerPanelImpl drawerPanelImpl, List list, List list2, DrawerElementImpl drawerElementImpl, DrawerElementImpl drawerElementImpl2) {
            this.v$oldFocused2 = drawerElementImpl2;
            this.v$newFocused2 = drawerElementImpl;
            this.v$collapse = list2;
            this.v$expand = list;
            this.this$0 = drawerPanelImpl;
        }
    }

    final class 5
    implements PropertyChangeListener {
        private final /* synthetic */ DrawerElement v$drawerElement;
        private final /* synthetic */ Rectangle v$sourceBounds;
        private final /* synthetic */ Rectangle v$destBounds;
        final /* synthetic */ DrawerPanelImpl this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            double r = (Double)evt.getNewValue();
            this.v$drawerElement.setBounds((int)((double)this.v$sourceBounds.x + (double)(this.v$destBounds.x - this.v$sourceBounds.x) * r), (int)((double)this.v$sourceBounds.y + (double)(this.v$destBounds.y - this.v$sourceBounds.y) * r), (int)((double)this.v$sourceBounds.width + (double)(this.v$destBounds.width - this.v$sourceBounds.width) * r), (int)((double)this.v$sourceBounds.height + (double)(this.v$destBounds.height - this.v$sourceBounds.height) * r));
            Graphics g = this.this$0.getGraphics();
            this.this$0.paint(g);
            g.dispose();
        }

        public 5(DrawerPanelImpl drawerPanelImpl, DrawerElement drawerElement, Rectangle rectangle, Rectangle rectangle2) {
            this.v$destBounds = rectangle2;
            this.v$sourceBounds = rectangle;
            this.v$drawerElement = drawerElement;
            this.this$0 = drawerPanelImpl;
        }
    }

    private class Listeners
    implements DockableDragSource {
        public void canceled() {
            DrawerPanelImpl.mav$whenDragCanceled(DrawerPanelImpl.this);
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Listener
    implements ListDataListener {
        public void intervalAdded(ListDataEvent e) {
            int index0 = e.getIndex0();
            int index1 = e.getIndex1();
            DrawerModelImpl model = DrawerPanelImpl.mav$getModel(DrawerPanelImpl.this);
            int i = 0;
            while (i <= index1 - index0) {
                DrawerEntryImpl entry = model.getEntry(index0 + i);
                DrawerPanelImpl.mav$addDrawerElement(DrawerPanelImpl.this, entry, index0 + i);
                ++i;
            }
        }

        public void intervalRemoved(ListDataEvent e) {
            int index0 = e.getIndex0();
            int index1 = e.getIndex1();
            DrawerModelImpl model = DrawerPanelImpl.mav$getModel(DrawerPanelImpl.this);
            int i = 0;
            while (i <= index1 - index0) {
                DrawerEntryImpl entry = model.getEntry(index0 + i);
                DrawerPanelImpl.mav$removeDrawerElement(DrawerPanelImpl.this, entry);
                ++i;
            }
        }

        public void contentsChanged(ListDataEvent e) {
            throw new IllegalStateException();
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

