/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputListener;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.FloatingToolWindow;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.JDK;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;
import oracle.ideimpl.docking.AbstractDockPanelHost;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.FloatDockUI;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.controls.Handlebar;
import oracle.javatools.icons.OracleIcons;

final class FloatDockWindow
extends AbstractDockPanelHost
implements FloatingToolWindow,
SwingConstants,
MouseInputListener,
ActionListener,
ContainerListener,
ComponentListener {
    static final String PANEL_NAME = "panel";
    private static final int BORDER_WEST = 1;
    private static final int BORDER_EAST = 2;
    private static final int BORDER_NORTH = 4;
    private static final int BORDER_SOUTH = 8;
    private static final int CORNER_SIZE = 15;
    private static final boolean REALTIME_RESIZE = true;
    private static final String KEY_X = "x";
    private static final String KEY_Y = "y";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_HEIGHT = "height";
    private DockPanel _dockPanel;
    private Handlebar _title;
    private SmallSquareButton _buttonClose;
    private FloatDockUI _ui;
    private JFrame _frame;
    private boolean _bDragging;
    private Point _ptLastDrag;
    private int _nOrient;
    private Point _ptDraggedFrom;
    private Point _ptMovedFrom;

    public FloatDockWindow(JFrame frame) {
        this.$init$();
        this._frame = frame;
        this.createHost();
    }

    public void createWindowUI() {
        boolean floatOnTop = this.isFloatOnTop();
        this._ui = floatOnTop ? new FloatDockDialogUI(this._frame) : new FloatDockDialogUI();
        this._ui.getContentPane().setLayout(new BorderLayout());
        this.createTitle();
        this.createBorder();
        InputMap imIde = Ide.getIdeInputMap();
        InputMap imMe = this._ui.getRootPane().getInputMap(1);
        imMe.setParent(imIde);
        ActionMap amIde = Ide.getIdeActionMap();
        ActionMap amMe = this._ui.getRootPane().getActionMap();
        amMe.setParent(amIde);
        this.attachHost();
    }

    private void createHost() {
        DockPanel dockPanel;
        Assert.println((this._dockPanel != null ? 1 : 0) != 0, (String)"Host was already created");
        this._dockPanel = dockPanel = new DockPanel();
    }

    private void attachHost() {
        DockPanel dockPanel = this.getDockPanel();
        DockStationImpl dockStation = DockStationImpl.getInstance();
        dockStation.registerDockPanelHost(this);
        ActiveViewHandlerImpl activeViewHandler = dockStation.getActiveViewHandler();
        activeViewHandler.addControllerProvider(dockPanel, dockStation);
        this._ui.getContentPane().add((Component)dockPanel, "Center");
        dockPanel.addContainerListener(this);
        int titledPanelCount = dockPanel.getTitledPanelCount();
        int titledPanelPos = 0;
        while (titledPanelPos < titledPanelCount) {
            TitledPanel titledPanel = dockPanel.getTitledPanel(titledPanelPos);
            titledPanel.addComponentListener(this);
            ++titledPanelPos;
        }
        this.visibleCountChanges();
    }

    private void createBorder() {
        Color background = UIManager.getColor("Panel.background");
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES), BorderFactory.createLineBorder(background, 3));
        JRootPane rootPane = this._ui.getRootPane();
        rootPane.setBorder(border);
        rootPane.addMouseListener(this);
        rootPane.addMouseMotionListener(this);
    }

    private void createTitle() {
        this._title = new Handlebar();
        this._title.setOrientation(0);
        this._buttonClose = new SmallSquareButton(OracleIcons.getIcon((String)"extras/small_close.gif"), IdeArb.getString((int)292));
        this._title.addButton(this._buttonClose, 0);
        this._title.addMouseListener(this);
        this._title.addMouseMotionListener(this);
        this._buttonClose.addActionListener((ActionListener)this);
        this._ui.getContentPane().add((Component)((Object)this._title), "North");
    }

    public Window getGUI() {
        return (Window)((Object)this._ui);
    }

    public void adjustClientSize(Dimension d, boolean bContainerToClient) {
        Insets insets = this._ui.getRootPane().getInsets();
        insets.top += this._title.getSize().height;
        d.width = d.width + (insets.left + insets.right) * (bContainerToClient ? -1 : 1);
        d.height = d.height + (insets.top + insets.bottom) * (bContainerToClient ? -1 : 1);
    }

    public DockPanel getDockPanel() {
        return this._dockPanel;
    }

    public DockInsertionPoint getDockInsertionAt(Point pt) {
        DockInsertionPoint dip = null;
        if (this.isVisible()) {
            DockPanel dp = this.getDockPanel();
            Point ptLocal = new Point(pt);
            SwingUtilities.convertPointFromScreen(ptLocal, dp);
            dip = dp.getDockInsertionAt(ptLocal);
        }
        return dip;
    }

    private void closeHost() {
        this._ui.asWindow().dispose();
        DockStationImpl dockStation = DockStationImpl.getInstance();
        dockStation.unregisterDockPanelHost(this);
        dockStation.getActiveViewHandler().removeControllerProvider(this._dockPanel);
    }

    public StructuredPropertyAccess saveLayout(XMLDockLayoutPersistence layoutPersistence) {
        DefaultStructuredPropertyAccess panelNode = new DefaultStructuredPropertyAccess(PANEL_NAME);
        Point pt = new Point();
        this.getLocation(pt);
        Dimension d = new Dimension();
        this.getSize(d);
        panelNode.setProperty("position", "float");
        panelNode.setProperty(KEY_X, Integer.toString(pt.x));
        panelNode.setProperty(KEY_Y, Integer.toString(pt.y));
        panelNode.setProperty(KEY_WIDTH, Integer.toString(d.width));
        panelNode.setProperty(KEY_HEIGHT, Integer.toString(d.height));
        panelNode.setProperty("visible", Boolean.toString(this.isVisible()));
        DockPanel dockPanel = this.getDockPanel();
        dockPanel.saveLayout(layoutPersistence, (StructuredPropertyAccess)panelNode);
        return panelNode;
    }

    private static int getAttribute(StructuredPropertyAccess parent, String key, int defaultValue) {
        String property = parent.getProperty(key, null);
        int ret = property == null ? defaultValue : Integer.parseInt(property);
        return ret;
    }

    public void loadLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess parent) {
        DockPanel dockPanel = this.getDockPanel();
        dockPanel.loadLayout(layoutPersistence, parent);
        this.createWindowUI();
        int x = FloatDockWindow.getAttribute(parent, KEY_X, 0);
        int y = FloatDockWindow.getAttribute(parent, KEY_Y, 0);
        int width = FloatDockWindow.getAttribute(parent, KEY_WIDTH, 100);
        int height = FloatDockWindow.getAttribute(parent, KEY_HEIGHT, 100);
        this.setBounds(x, y, width, height);
    }

    private boolean isFloatOnTop() {
        DockPanel dockPanel = this.getDockPanel();
        TitledPanel[] allTitledPanels = dockPanel.getAllTitledPanels();
        boolean floatOnTop = true;
        int i = 0;
        while (floatOnTop && i < allTitledPanels.length) {
            TitledPanel titledPanel = allTitledPanels[i];
            int clientCount = titledPanel.getClientCount();
            int clientPos = 0;
            while (floatOnTop && clientPos < clientCount) {
                TitledPanelHolder holder = titledPanel.getHolder(clientPos);
                floatOnTop = holder.isFloatOnTop();
                ++clientPos;
            }
            ++i;
        }
        return floatOnTop;
    }

    private Handlebar getHandlebar() {
        return this._title;
    }

    private void whenClose() {
        DockStationImpl ds = DockStationImpl.getInstance();
        ds.addDockableEventContext(20);
        try {
            DockPanel dp = this.getDockPanel();
            TitledPanel[] allTP = dp.getAllTitledPanels();
            int n = allTP.length;
            int i = 0;
            while (i < n) {
                TitledPanel tp = allTP[i];
                if (-1 != dp.indexOfTitledPanel(tp)) {
                    tp.closePanel(20);
                }
                ++i;
            }
        }
        finally {
            ds.removeDockableEventContext(20);
        }
        this.hide();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._buttonClose) {
            this.whenClose();
        }
    }

    private boolean isVisible() {
        return this._ui.asWindow().isVisible();
    }

    private void hide() {
        this._ui.asWindow().setVisible(false);
    }

    public Dimension getSize(Dimension rv) {
        return this._ui.asWindow().getSize(rv);
    }

    public void setSize(int x, int y) {
        this._ui.asWindow().setSize(x, y);
    }

    public Point getLocation(Point rv) {
        return this._ui.asWindow().getLocation(rv);
    }

    private void setLocation(int x, int y) {
        this._ui.asWindow().setLocation(x, y);
    }

    public Rectangle getBounds() {
        return this._ui.asWindow().getBounds();
    }

    public void setBounds(int x, int y, int width, int height) {
        this._ui.asWindow().setBounds(x, y, width, height);
    }

    public void validate() {
        this._ui.asWindow().validate();
    }

    public void componentAdded(ContainerEvent e) {
        Component titledPanel = e.getChild();
        titledPanel.addComponentListener(this);
        this.visibleCountChanges();
    }

    public void componentRemoved(ContainerEvent e) {
        Component titledPanel = e.getChild();
        titledPanel.removeComponentListener(this);
        this.visibleCountChanges();
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
        this.visibleCountChanges();
    }

    public void componentHidden(ComponentEvent e) {
        this.visibleCountChanges();
    }

    private void visibleCountChanges() {
        DockPanel dockPanel = this.getDockPanel();
        int titledPanelCount = dockPanel.getTitledPanelCount();
        if (titledPanelCount == 0) {
            this.closeHost();
        } else {
            int visibleCount = 0;
            int i = 0;
            while (i < titledPanelCount) {
                TitledPanel titledPanel = dockPanel.getTitledPanel(i);
                if (titledPanel.getVisibleCount() > 0) {
                    ++visibleCount;
                }
                ++i;
            }
            DockStationImpl dockStation = DockStationImpl.getInstance();
            switch (visibleCount) {
                case 0: {
                    dockStation.setFloatVisible(this, false);
                    break;
                }
                case 1: {
                    this.setMultiHost(false);
                    dockStation.setFloatVisible(this, true);
                    break;
                }
                default: {
                    this.setMultiHost(true);
                    dockStation.setFloatVisible(this, true);
                    break;
                }
            }
        }
    }

    private void setMultiHost(boolean bMulti) {
        this.getHandlebar().setVisible(bMulti);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getSource() != this._title) {
            this.borderMouseDragged(e);
        } else {
            this.titleMouseDragged(e);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (e.getSource() != this._title) {
            this.borderMouseExited();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (e.getSource() != this._title) {
            this.borderMouseMoved(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() != this._title) {
            this.borderMousePressed(e);
        } else {
            this.titleMousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getSource() != this._title) {
            this.borderMouseReleased();
        }
    }

    private int getPositionOnBorder(Point pt) {
        JRootPane rp = this._ui.getRootPane();
        Dimension dim = rp.getSize();
        Insets ins = rp.getInsets();
        int nxRet = 0;
        if (pt.x < ins.left) {
            nxRet |= 1;
        } else if (pt.x > dim.width - ins.right) {
            nxRet |= 2;
        }
        if (nxRet != 0) {
            if (pt.y < 15) {
                nxRet |= 4;
            } else if (pt.y > dim.height - 15) {
                nxRet |= 8;
            }
        }
        int nyRet = 0;
        if (pt.y < ins.top) {
            nyRet |= 4;
        } else if (pt.y > dim.height - ins.bottom) {
            nyRet |= 8;
        }
        if (nyRet != 0) {
            if (pt.x < 15) {
                nyRet |= 1;
            } else if (pt.x > dim.width - 15) {
                nyRet |= 2;
            }
        }
        return nxRet | nyRet;
    }

    private static int borderToCursor(int nOrient) {
        switch (nOrient) {
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 4: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 5: {
                return 6;
            }
            case 9: {
                return 4;
            }
            case 6: {
                return 7;
            }
            case 10: {
                return 5;
            }
        }
        return 0;
    }

    private void $init$() {
        this._ptLastDrag = new Point();
    }

    private void setDragLastPosition(int nxInComponent, int nyInComponent) {
        this._ptLastDrag.setLocation(nxInComponent, nyInComponent);
        SwingUtilities.convertPointToScreen(this._ptLastDrag, this._ui.asWindow());
    }

    private void setDragLastPosition(Point ptInComponent) {
        this.setDragLastPosition(ptInComponent.x, ptInComponent.y);
    }

    private Point getDragOffset(Point pt) {
        pt = new Point(pt);
        SwingUtilities.convertPointToScreen(pt, this._ui.asWindow());
        pt.x -= this._ptLastDrag.x;
        pt.y -= this._ptLastDrag.y;
        return pt;
    }

    private void borderMouseMoved(MouseEvent e) {
        Point pt = e.getPoint();
        int n = this.getPositionOnBorder(pt);
        Cursor cursor = Cursor.getPredefinedCursor(FloatDockWindow.borderToCursor(n));
        this._ui.getRootPane().setCursor(cursor);
    }

    private void borderMouseExited() {
        Cursor cursor = Cursor.getPredefinedCursor(0);
        this._ui.getRootPane().setCursor(cursor);
    }

    private void borderMousePressed(MouseEvent e) {
        Point pt = e.getPoint();
        int n = this.getPositionOnBorder(pt);
        if (n != 0) {
            this.setDragLastPosition(pt);
            this._nOrient = n;
            this._bDragging = true;
        }
    }

    private void borderMouseDragged(MouseEvent e) {
        if (this._bDragging) {
            Point ptNew = e.getPoint();
            Point ptDiff = this.getDragOffset(ptNew);
            Dimension dMin = this._ui.asWindow().getMinimumSize();
            Rectangle r = this.getBounds();
            if ((this._nOrient & 2) != 0) {
                int nNewSize = r.width + ptDiff.x;
                if (nNewSize < dMin.width) {
                    nNewSize = dMin.width;
                }
                r.width = nNewSize;
            }
            if ((this._nOrient & 1) != 0) {
                int nNewSize = r.width - ptDiff.x;
                if (nNewSize < dMin.width) {
                    nNewSize = dMin.width;
                    ptDiff.x = r.width - nNewSize;
                }
                r.width = nNewSize;
                r.x += ptDiff.x;
            }
            if ((this._nOrient & 8) != 0) {
                int nNewSize = r.height + ptDiff.y;
                if (nNewSize < dMin.height) {
                    nNewSize = dMin.height;
                }
                r.height = nNewSize;
            }
            if ((this._nOrient & 4) != 0) {
                int nNewSize = r.height - ptDiff.y;
                if (nNewSize < dMin.height) {
                    nNewSize = dMin.height;
                    ptDiff.y = r.height - nNewSize;
                }
                r.height = nNewSize;
                r.y += ptDiff.y;
            }
            this.setDragLastPosition(ptNew);
            this.setBounds(r.x, r.y, r.width, r.height);
            this.validate();
        }
    }

    private void borderMouseReleased() {
        if (this._bDragging) {
            this._bDragging = false;
        }
    }

    private void titleMousePressed(MouseEvent e) {
        this._ptDraggedFrom = new Point(e.getPoint());
        SwingUtilities.convertPointToScreen(this._ptDraggedFrom, this._ui.asWindow());
        this._ptMovedFrom = new Point();
        this.getLocation(this._ptMovedFrom);
    }

    private void titleMouseDragged(MouseEvent e) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        EventQueue eq = tk.getSystemEventQueue();
        if (eq.peekEvent(e.getID()) == null && !e.isConsumed()) {
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, this._ui.asWindow());
            this.setLocation(this._ptMovedFrom.x + (pt.x - this._ptDraggedFrom.x), this._ptMovedFrom.y + (pt.y - this._ptDraggedFrom.y));
        }
    }

    static Handlebar mav$getHandlebar(FloatDockWindow floatDockWindow) {
        return floatDockWindow.getHandlebar();
    }

    private class FloatDockDialogUI
    extends JDialog
    implements FloatDockUI {
        private boolean _bIsVisible;
        private Dimension _dimSaved;

        public FloatDockDialogUI() {
            this.$init$();
            this.setUndecorated(true);
        }

        public FloatDockDialogUI(Frame owner) {
            super(owner);
            this.$init$();
            this.setUndecorated(true);
        }

        public FloatDockWindow getFloatDockWindow() {
            return FloatDockWindow.this;
        }

        public Window asWindow() {
            return this;
        }

        public boolean isFocusable() {
            return false;
        }

        private void $init$() {
            this._bIsVisible = false;
            this._dimSaved = new Dimension(0, 0);
        }

        public boolean isVisible() {
            if (JDK.HAS_BUG_4390137) {
                return this._bIsVisible;
            }
            return super.isVisible();
        }

        public void setSize(Dimension size) {
            if (JDK.HAS_BUG_4390137) {
                this._dimSaved.setSize(size);
                super.setSize(size);
            } else {
                super.setSize(size);
            }
        }

        public void setVisible(boolean bVisible) {
            if (JDK.HAS_BUG_4390137) {
                if (bVisible != this._bIsVisible) {
                    if (bVisible) {
                        this.setSize(this._dimSaved);
                        if (!this.isVisible()) {
                            super.setVisible(true);
                        }
                    } else {
                        this._dimSaved.setSize(this.getSize());
                        super.setSize(0, 0);
                    }
                    this._bIsVisible = bVisible;
                }
            } else {
                super.setVisible(bVisible);
            }
        }

        public Dimension getMinimumSize() {
            Dimension dPanel = FloatDockWindow.this.getDockPanel().getMinimumSize();
            Dimension dTitle = FloatDockWindow.mav$getHandlebar(FloatDockWindow.this).getMinimumSize();
            dPanel.height += dTitle.height;
            return dPanel;
        }

        public Dimension getPreferredSize() {
            return this.getLayout().preferredLayoutSize(this);
        }

        public void dispose() {
            if (!Ide.isQuitting()) {
                DockStationImpl.getInstance().unregisterDockPanelHost(FloatDockWindow.this);
            }
            super.dispose();
        }

        public void show() {
            DockPanel jc;
            super.show();
            Component c = this.getFocusOwner();
            if ((c == this || c == null) && (jc = FloatDockWindow.this.getDockPanel()) != null) {
                jc.transferFocus();
            }
        }
    }
}

