/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import oracle.ide.Ide;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableHolder;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.docking.AbstractTitledPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.window.MaximizedWindowInfo;
import oracle.ideimpl.window.WindowingConstants;

final class MaximizedTitledPanel
extends AbstractTitledPanel
implements MaximizedWindowInfo,
TitleChangeListener {
    private TitledPanel _titledPanel;
    private TitledPanelHolder _holder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MaximizedTitledPanel(TitledPanel titledPanel, TitledPanelHolder holder) {
        this._titledPanel = titledPanel;
        this._holder = holder;
        this.createTitle();
        this.createUIMap();
        this.attachHolder();
        this.setBorder(WindowingConstants.FLAT_COMPOUND_BORDER);
    }

    protected TitledPanelHolder getSelectedHolder() {
        return this._holder;
    }

    private void attachHolder() {
        this.add((Component)((Object)this._handlebar), "North");
        Dockable dockable = this._holder.getDockable();
        dockable.addTitleChangeListener((TitleChangeListener)this);
        DockStationImpl dockStation = DockStationImpl.getInstance();
        DockableEvent event = new DockableEvent(dockable, 0, 4);
        dockStation.fireDockableEvent(event);
        JComponent component = this._holder.getOrCreateComponent();
        component.setVisible(true);
        this.add((Component)component, "Center");
        this.adjustTitle(dockable);
        this.adjustButtons(dockable);
    }

    private void detachHolder() {
        Dockable dockable = this._holder.getDockable();
        dockable.removeTitleChangeListener((TitleChangeListener)this);
    }

    protected JPopupMenu getTitleContextMenu() {
        TitledPanelHolder holder = this.getSelectedHolder();
        return this.createSystemMenu(holder);
    }

    static {
        $assertionsDisabled = MaximizedTitledPanel.class.desiredAssertionStatus() ^ true;
    }

    protected void whenSystemMenuClose(TitledPanelHolder selectedHolder) {
        if (!$assertionsDisabled && selectedHolder != this.getSelectedHolder()) {
            throw new AssertionError();
        }
        this.whenClose(20);
    }

    protected void whenMinimize(int flags) {
    }

    protected void whenMaximize(int flags) {
    }

    protected void whenRestore(int flags, DockableHolder selectedHolder) {
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        mainWindow.restore();
    }

    protected void whenClose(int flags) {
        TitledPanelHolder selectedHolder = this.getSelectedHolder();
        DockStationImpl dockStation = DockStationImpl.getInstance();
        dockStation.addDockableEventContext(flags);
        try {
            this.whenRestore(flags, selectedHolder);
            dockStation.close(selectedHolder.getDockable());
            IdeUtil.tryToRestoreFocus(null);
        }
        finally {
            dockStation.removeDockableEventContext(flags);
        }
    }

    protected void systemMenuSizeDocked() {
    }

    protected void whenSystemMenuFloat(DockableHolder selectedHolder) {
        this.whenRestore(4, selectedHolder);
        DockStationImpl.getInstance().floatPanel(this._titledPanel, new Point(10, 10));
    }

    protected boolean isMinimized() {
        return false;
    }

    protected boolean isMinimizable() {
        return false;
    }

    protected boolean isMaximized() {
        return true;
    }

    protected boolean isMaximizable() {
        return true;
    }

    protected boolean isFloating() {
        return false;
    }

    protected boolean canMove() {
        return false;
    }

    protected boolean canSize() {
        return false;
    }

    public int getClientCount() {
        return 1;
    }

    public Dockable getClient(int i) {
        return this._holder.getDockable();
    }

    public boolean isClientAccessible(Dockable dockable) {
        return dockable == this._holder.getDockable();
    }

    public JComponent getMaximizeComponent() {
        return this;
    }

    public void maximize() {
        this._titledPanel.maximizeHolder(this._holder);
    }

    public void restore() {
        this.detachHolder();
        this._titledPanel.restoreHolder(this._holder);
    }

    public int getWindowType() {
        return 1;
    }

    public void titleChange(TitleChangeEvent e) {
        Dockable dockable = this._holder.getDockable();
        String titleName = dockable.getTitleName();
        Icon icon = dockable.getTabIcon();
        this._handlebar.setTitle(titleName);
        this._handlebar.setIcon(icon);
    }
}

