/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import oracle.ide.controls.Animator;
import oracle.ide.docking.DockableWindow;
import oracle.ideimpl.docking.DrawerEntryImpl;
import oracle.ideimpl.docking.DrawerPanelImpl;
import oracle.javatools.util.Pair;

class MinimizedTray
extends JPanel {
    private Listeners _listeners;
    private DrawerPanelImpl _drawerPanel;
    private JScrollPane _scrollPane;
    private JList _list;

    private void $init$() {
        this._listeners = new Listeners(null);
    }

    public MinimizedTray(DrawerPanelImpl drawerPanel) {
        super(new BorderLayout());
        this.$init$();
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.add((Component)new Handle(0), "North");
        this._drawerPanel = drawerPanel;
        DefaultListModel dataModel = new DefaultListModel();
        this._list = new JList(dataModel);
        this._list.addMouseListener(this._listeners);
        this._list.addKeyListener(this._listeners);
        this._scrollPane = new JScrollPane(this._list);
        this._scrollPane.setBorder(null);
        JLabel label = new JLabel("Minimized");
        label.setBackground(Color.GRAY);
        label.setBorder(null);
        label.setAlignmentX(0.5f);
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, insets, 0, 0));
        panel.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        this.add((Component)panel, "Center");
    }

    public void addEntry(DrawerEntryImpl entry) {
        DefaultListModel dataModel = (DefaultListModel)this._list.getModel();
        DockableWindow dockable = entry.getDockable();
        String label = dockable.getTabName();
        Pair pair = new Pair((Object)label, (Object)entry);
        dataModel.addElement(pair);
    }

    private void whenRestore() {
        Pair pair = (Pair)this._list.getSelectedValue();
        if (pair != null) {
            DrawerEntryImpl entry = (DrawerEntryImpl)pair.second;
            DefaultListModel model = (DefaultListModel)this._list.getModel();
            model.removeElement(pair);
            this._drawerPanel.restore(entry, false);
        }
        if (this.isEmpty()) {
            this.collapse();
        }
    }

    public boolean isEmpty() {
        return this._list.getModel().getSize() == 0;
    }

    public final void expand(Component parent) {
        this._scrollPane.setVerticalScrollBarPolicy(21);
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer(parent);
        JLayeredPane layeredPane = rootPaneContainer.getLayeredPane();
        layeredPane.add((Component)this, JLayeredPane.MODAL_LAYER);
        Dimension preferredSize = this.getPreferredSize();
        int parentHeight = parent.getHeight();
        int parentWidth = parent.getWidth();
        int preferredHeight = Math.min(preferredSize.height, parentHeight / 3);
        Point pt = SwingUtilities.convertPoint(parent, 0, parentHeight, layeredPane);
        Rectangle rcFrom = new Rectangle(pt.x, pt.y, parentWidth, 0);
        Rectangle rcTo = new Rectangle(pt.x, pt.y - preferredHeight, parentWidth, preferredHeight);
        AnimationListener animationListener = new AnimationListener(this, rcFrom, rcTo);
        Animator.animate((int)30, (long)500L, (PropertyChangeListener)animationListener);
        this.requestFocus();
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener("permanentFocusOwner", this._listeners);
        layeredPane.addComponentListener(this._listeners);
        this._scrollPane.setVerticalScrollBarPolicy(20);
    }

    public void collapse() {
        JLayeredPane layeredPane = (JLayeredPane)this.getParent();
        layeredPane.removeComponentListener(this._listeners);
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.removePropertyChangeListener("permanentFocusOwner", this._listeners);
        Rectangle rcFrom = this.getBounds();
        Rectangle rcTo = new Rectangle(rcFrom.x, rcFrom.y + rcFrom.height, rcFrom.width, 0);
        Animator.animate((int)30, (long)500L, (PropertyChangeListener)new AnimationListener(layeredPane, rcFrom, rcTo));
        layeredPane.remove(this);
        layeredPane.repaint();
    }

    private RootPaneContainer getRootPaneContainer(Component parent) {
        return (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, parent));
    }

    static void mav$whenRestore(MinimizedTray minimizedTray) {
        minimizedTray.whenRestore();
    }

    static JList ra$_list(MinimizedTray minimizedTray) {
        return minimizedTray._list;
    }

    private class AnimationListener
    implements PropertyChangeListener {
        private JComponent _layeredPane;
        private Rectangle _rcFrom;
        private Rectangle _rcTo;

        public AnimationListener(JComponent component, Rectangle rcFrom, Rectangle rcTo) {
            this._layeredPane = component;
            this._rcFrom = rcFrom;
            this._rcTo = rcTo;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            double v = (Double)evt.getNewValue();
            Rectangle rc = Animator.getRectangle((double)v, (Rectangle)this._rcFrom, (Rectangle)this._rcTo);
            MinimizedTray.this.setBounds(rc);
            Graphics g = this._layeredPane.getGraphics();
            this._layeredPane.paintAll(g);
            g.dispose();
        }
    }

    private static class Handle
    extends JPanel {
        private int _orientation;

        public Handle(int orientation) {
            this._orientation = orientation;
            int cursorType = orientation == 0 ? 8 : 10;
            this.setCursor(Cursor.getPredefinedCursor(cursorType));
            this.setPreferredSize(new Dimension(10, 10));
            this.setBorder(BorderFactory.createBevelBorder(0));
        }

        protected void paintComponent(Graphics g) {
            Color background = this.getBackground();
            g.setColor(background);
            Insets insets = this.getInsets();
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom;
            g.fillRect(insets.left, insets.top, width, height);
            g.setColor(Color.GRAY);
            if (this._orientation == 0) {
                int d = height - 2;
                int i = -10;
                while (i <= 10) {
                    g.drawOval(insets.left + (width - d) / 2 + i, insets.top + (height - d) / 2, d, d);
                    i += 10;
                }
            } else {
                int d = width - 2;
                int i = -10;
                while (i <= 10) {
                    g.fillOval(insets.left + (width - d) / 2, insets.top + (height - d) / 2 + i, d, d);
                    i += 10;
                }
            }
        }
    }

    private class Listeners
    implements PropertyChangeListener,
    ComponentListener,
    MouseListener,
    KeyListener {
        public void propertyChange(PropertyChangeEvent evt) {
            KeyboardFocusManager focusManager;
            Component permanentFocusOwner;
            String propertyName = evt.getPropertyName();
            if ("permanentFocusOwner".equals(propertyName) && (permanentFocusOwner = (focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager()).getPermanentFocusOwner()) != null && !SwingUtilities.isDescendingFrom(permanentFocusOwner, MinimizedTray.this)) {
                MinimizedTray.this.collapse();
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            Container parent = MinimizedTray.this.getParent();
            MinimizedTray.this.setBounds(MinimizedTray.this.getX(), parent.getHeight() - MinimizedTray.this.getHeight(), parent.getWidth(), MinimizedTray.this.getHeight());
            MinimizedTray.this.revalidate();
        }

        public void componentShown(ComponentEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            MinimizedTray.mav$whenRestore(MinimizedTray.this);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            int index;
            if (e.getButton() != 1 && (index = MinimizedTray.ra$_list(MinimizedTray.this).locationToIndex(e.getPoint())) >= 0) {
                MinimizedTray.ra$_list(MinimizedTray.this).setSelectedIndex(index);
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
            if ('\n' == e.getKeyChar()) {
                MinimizedTray.mav$whenRestore(MinimizedTray.this);
            }
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

