/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JWindow;
import oracle.ide.docking.Dockable;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.MoveDock;
import oracle.ideimpl.docking.MoveFloat;
import oracle.ideimpl.docking.SizeDock;
import oracle.ideimpl.docking.SizeFloat;
import oracle.ideimpl.docking.TitledPanel;

abstract class MoveFeedback
extends JWindow
implements KeyEventDispatcher {
    private static final Dimension DEFAULT_SIZE = new Dimension(100, 30);
    private static final int STEP_SMALL = 1;
    private static final int STEP_NORMAL = 10;
    private static final int STEP_LARGE = 50;
    private JButton _lbl;
    protected Component _cOver;

    protected abstract void moveBy(int var1, int var2);

    protected void commit() {
    }

    protected void rollback() {
    }

    public MoveFeedback(Component cOver) {
        this._cOver = cOver;
        this._lbl = new JButton();
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this._lbl, "Center");
        this.setSize(DEFAULT_SIZE);
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addKeyEventDispatcher(this);
        this.setVisible(true);
        this.requestFocus();
        this.adjustPosition();
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            int nStep = 0;
            switch (e.getModifiers()) {
                case 1: {
                    nStep = 1;
                    break;
                }
                case 0: {
                    nStep = 10;
                    break;
                }
                case 2: {
                    nStep = 50;
                    break;
                }
            }
            if (nStep != 0) {
                boolean bMoved = false;
                switch (e.getKeyCode()) {
                    case 37: {
                        this.moveBy(-nStep, 0);
                        bMoved = true;
                        break;
                    }
                    case 39: {
                        this.moveBy(nStep, 0);
                        bMoved = true;
                        break;
                    }
                    case 38: {
                        this.moveBy(0, -nStep);
                        bMoved = true;
                        break;
                    }
                    case 40: {
                        this.moveBy(0, nStep);
                        bMoved = true;
                        break;
                    }
                    case 10: {
                        this.commit();
                        this.byebye();
                        break;
                    }
                    case 27: {
                        this.rollback();
                        this.byebye();
                        break;
                    }
                }
                if (bMoved) {
                    this.adjustPosition();
                }
            }
        }
        return true;
    }

    private final void byebye() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        this.setVisible(false);
        this.dispose();
    }

    protected void adjustPosition() {
        GraphicsUtils.centerWindowOnComponent((Window)this, (Component)this._cOver);
    }

    protected final void setText(Point pt) {
        this._lbl.setText(pt.x + " x " + pt.y);
    }

    protected final void setText(Dimension d) {
        this._lbl.setText(d.width + " x " + d.height);
    }

    private static int limit(int min, int x, int max) {
        return x < min ? min : (x > max ? max : x);
    }

    protected static void limit(Point pt, int nxMax, int nyMax) {
        pt.x = MoveFeedback.limit(0, pt.x, nxMax);
        pt.y = MoveFeedback.limit(0, pt.y, nyMax);
    }

    protected static void limit(Dimension d, int nxMin, int nxMax, int nyMin, int nyMax) {
        d.width = MoveFeedback.limit(nxMin, d.width, nxMax);
        d.height = MoveFeedback.limit(nyMin, d.height, nyMax);
    }

    protected static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    static MoveFeedback createMoveFloat(Window w) {
        return new MoveFloat(w);
    }

    static MoveFeedback createSizeFloat(Window w) {
        return new SizeFloat(w);
    }

    static MoveFeedback createSizeDock(DockPanel dp, TitledPanel tp) {
        return new SizeDock(dp, tp);
    }

    static MoveFeedback createMoveDock(Dockable dockable, JComponent c) {
        return new MoveDock(dockable, c);
    }
}

