/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.controls.PentaLayout;
import oracle.ide.util.BitField;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.IdeImplArb;

public class PentaLayoutConfigPanel
extends JPanel {
    private PentaLayout _pentaLayout;
    private JButton _butNorthTakesWest;
    private JButton _butWestTakesNorth;
    private JButton _butNorthTakesEast;
    private JButton _butEastTakesNorth;
    private JButton _butSouthTakesWest;
    private JButton _butWestTakesSouth;
    private JButton _butSouthTakesEast;
    private JButton _butEastTakesSouth;
    private JPanel _nortCenter;
    private JPanel _southCenter;
    private JPanel _westCenter;
    private JPanel _eastCenter;
    private ArrayList _buttonControlers;

    private void $init$() {
        this._buttonControlers = new ArrayList(4);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setBounds(100, 100, 500, 500);
        PentaLayoutConfigPanel contentPane = new PentaLayoutConfigPanel(0);
        frame.setContentPane(contentPane);
        frame.addWindowListener(new 1(contentPane));
        frame.setVisible(true);
    }

    public PentaLayoutConfigPanel(byte initialStyle) {
        super(new BorderLayout());
        this.$init$();
        this._pentaLayout = new PentaLayout(initialStyle, 0, 0);
        JLabel windowLayoutLabel = new JLabel();
        this.add((Component)windowLayoutLabel, "North");
        this._butNorthTakesWest = this.createButton(IdeImplArb.getIcon(16));
        this._butWestTakesNorth = this.createButton(IdeImplArb.getIcon(18));
        String windowLayoutString = IdeImplArb.getString(81);
        ResourceUtils.resLabel((JLabel)windowLayoutLabel, (Component)this._butNorthTakesWest, (String)windowLayoutString);
        ButtonControler buttonControler = new ButtonControler(this._butNorthTakesWest, this._butWestTakesNorth, 8, windowLayoutLabel);
        this._buttonControlers.add(buttonControler);
        this._butNorthTakesEast = this.createButton(IdeImplArb.getIcon(73));
        this._butEastTakesNorth = this.createButton(IdeImplArb.getIcon(19));
        buttonControler = new ButtonControler(this._butNorthTakesEast, this._butEastTakesNorth, 4, null);
        this._buttonControlers.add(buttonControler);
        this._butSouthTakesWest = this.createButton(IdeImplArb.getIcon(71));
        this._butWestTakesSouth = this.createButton(IdeImplArb.getIcon(10));
        buttonControler = new ButtonControler(this._butSouthTakesWest, this._butWestTakesSouth, 2, null);
        this._buttonControlers.add(buttonControler);
        this._butSouthTakesEast = this.createButton(IdeImplArb.getIcon(42));
        this._butEastTakesSouth = this.createButton(IdeImplArb.getIcon(12));
        buttonControler = new ButtonControler(this._butSouthTakesEast, this._butEastTakesSouth, 1, null);
        this._buttonControlers.add(buttonControler);
        JPanel pentaLayoutPanel = new JPanel();
        pentaLayoutPanel.setLayout((LayoutManager)this._pentaLayout);
        JPanel panel = this.createBorderPanel();
        panel.add((Component)this._butWestTakesNorth, "West");
        panel.add((Component)this._butEastTakesNorth, "East");
        this._nortCenter = this.createCenterPanel();
        panel.add((Component)this._nortCenter, "Center");
        pentaLayoutPanel.add((Component)panel, PentaLayout.NORTH);
        JPanel panel2 = this.createBorderPanel();
        panel2.add((Component)this._butWestTakesSouth, "West");
        panel2.add((Component)this._butEastTakesSouth, "East");
        this._southCenter = this.createCenterPanel();
        panel2.add((Component)this._southCenter, "Center");
        pentaLayoutPanel.add((Component)panel2, PentaLayout.SOUTH);
        JPanel panel3 = this.createBorderPanel();
        panel3.add((Component)this._butNorthTakesWest, "North");
        panel3.add((Component)this._butSouthTakesWest, "South");
        this._westCenter = this.createCenterPanel();
        panel3.add((Component)this._westCenter, "Center");
        pentaLayoutPanel.add((Component)panel3, PentaLayout.WEST);
        JPanel panel4 = this.createBorderPanel();
        panel4.add((Component)this._butNorthTakesEast, "North");
        panel4.add((Component)this._butSouthTakesEast, "South");
        this._eastCenter = this.createCenterPanel();
        panel4.add((Component)this._eastCenter, "Center");
        pentaLayoutPanel.add((Component)panel4, PentaLayout.EAST);
        JPanel editorPanel = new JPanel();
        pentaLayoutPanel.add((Component)editorPanel, PentaLayout.CENTER);
        editorPanel.setBackground(null);
        pentaLayoutPanel.setBackground(Color.WHITE);
        this.add((Component)pentaLayoutPanel, "Center");
    }

    public void doLayout() {
        Dimension prefSizes = new Dimension();
        this.getSize(prefSizes);
        prefSizes.width /= 6;
        prefSizes.height /= 6;
        this._butNorthTakesWest.setPreferredSize(prefSizes);
        this._butWestTakesNorth.setPreferredSize(prefSizes);
        this._butNorthTakesEast.setPreferredSize(prefSizes);
        this._butEastTakesNorth.setPreferredSize(prefSizes);
        this._butSouthTakesWest.setPreferredSize(prefSizes);
        this._butWestTakesSouth.setPreferredSize(prefSizes);
        this._butSouthTakesEast.setPreferredSize(prefSizes);
        this._butEastTakesSouth.setPreferredSize(prefSizes);
        this._nortCenter.setPreferredSize(prefSizes);
        this._southCenter.setPreferredSize(prefSizes);
        this._westCenter.setPreferredSize(prefSizes);
        this._eastCenter.setPreferredSize(prefSizes);
        super.doLayout();
    }

    private JPanel createBorderPanel() {
        JPanel panel = new JPanel(new 2());
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        panel.setBackground(null);
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel centerPanel = new JPanel();
        centerPanel.setBackground(null);
        return centerPanel;
    }

    private JButton createButton(Icon icon) {
        JButton ret = new JButton(icon);
        ret.setOpaque(false);
        ret.setContentAreaFilled(false);
        ret.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        return ret;
    }

    public byte getStyle() {
        return this._pentaLayout.getStyle();
    }

    public void setStyle(byte style) {
        this._pentaLayout.setStyle(style);
        int i = 0;
        while (i < this._buttonControlers.size()) {
            ButtonControler buttonControler = (ButtonControler)this._buttonControlers.get(i);
            ButtonControler.mav$updateButtons(buttonControler);
            ++i;
        }
    }

    class ButtonControler
    implements ActionListener {
        private JButton _button1;
        private JButton _button2;
        private int _myByte;
        private JLabel _label;

        public ButtonControler(JButton button1, JButton button2, byte myByte, JLabel label) {
            this._button1 = button1;
            this._button2 = button2;
            this._myByte = myByte;
            this._label = label;
            this._button1.addActionListener(this);
            this._button2.addActionListener(this);
            this.updateButtons();
        }

        public void actionPerformed(ActionEvent e) {
            byte style = PentaLayoutConfigPanel.this.getStyle();
            byte newStyle = (byte)(style ^ this._myByte);
            PentaLayoutConfigPanel.this.setStyle(newStyle);
            this.updateButtons();
        }

        private void updateButtons() {
            byte style = PentaLayoutConfigPanel.this.getStyle();
            boolean isMyByteSet = BitField.isSet((int)style, (int)this._myByte);
            if (isMyByteSet) {
                this.swapButtons(this._button1, this._button2);
            } else {
                this.swapButtons(this._button2, this._button1);
            }
        }

        private void swapButtons(JButton hideButton, JButton showButton) {
            boolean restoreFocus = hideButton.hasFocus();
            if (restoreFocus) {
                FocusManager.getCurrentManager().clearGlobalFocusOwner();
            }
            hideButton.setVisible(false);
            showButton.setVisible(true);
            if (this._label != null) {
                this._label.setLabelFor(showButton);
            }
            if (restoreFocus) {
                SwingUtilities.invokeLater(new 1(this, showButton));
            }
        }

        static void mav$updateButtons(ButtonControler buttonControler) {
            buttonControler.updateButtons();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ JButton v$showButton;
            final /* synthetic */ ButtonControler this$0;

            public void run() {
                this.v$showButton.requestFocus();
            }

            public 1(ButtonControler buttonControler, JButton jButton) {
                this.v$showButton = jButton;
                this.this$0 = buttonControler;
            }
        }
    }

    static final class 1
    extends WindowAdapter {
        private final /* synthetic */ PentaLayoutConfigPanel v$contentPane;

        public void windowClosing(WindowEvent e) {
            byte style = this.v$contentPane.getStyle();
            System.out.println("Result:" + style + " = " + Integer.toBinaryString(style));
            System.exit(0);
        }

        public 1(PentaLayoutConfigPanel pentaLayoutConfigPanel) {
            this.v$contentPane = pentaLayoutConfigPanel;
        }
    }

    final class 2
    extends BorderLayout {
        public void layoutContainer(Container target) {
            super.layoutContainer(target);
        }
    }
}

