/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Container;
import java.awt.Dimension;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.MoveFeedback;
import oracle.ideimpl.docking.TitledPanel;

final class SizeDock
extends MoveFeedback {
    private DockPanel _dp;
    private DockDivider _horzDd;
    private DockDivider _vertDd;
    private DividerControlledPanel _dcp;
    private DockLayoutInfo _dli;

    SizeDock(DockPanel dp, TitledPanel tp) {
        super(tp);
        Container c;
        this._dp = dp;
        dp.validate();
        DockLayout dl = (DockLayout)dp.getLayout();
        this._horzDd = dl.getDivider(tp, 0);
        this._vertDd = dl.getDivider(tp, 2);
        if ((this._horzDd == null || this._vertDd == null) && (c = dp.getParent()) instanceof DividerControlledPanel) {
            this._dcp = (DividerControlledPanel)c;
        }
        this._dli = dp.getLayoutInfo(tp);
        this.setText();
    }

    private void setText() {
        Dimension dReal = this._dli.getSize(1);
        this.setText(dReal);
    }

    protected void moveBy(int x, int y) {
        if (x != 0) {
            String s;
            if (this._horzDd != null) {
                this._horzDd.moveBy(x, true);
            } else if (this._dcp != null && ((s = this._dcp.getOrientation()).equals("East") || s.equals("West"))) {
                this._dcp.moveBy(x);
            }
        }
        if (y != 0) {
            String s;
            if (this._vertDd != null) {
                this._vertDd.moveBy(y, false);
            } else if (this._dcp != null && ((s = this._dcp.getOrientation()).equals("North") || s.equals("South"))) {
                this._dcp.moveBy(y);
            }
        }
        this._dp.validate();
        this.setText();
    }
}

