/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.docking.Dockable;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.docking.DockableHolderImpl;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.TitledPanel;

public final class TitledPanelHolder
extends DockableHolderImpl {
    protected Dockable _dockable;
    protected JComponent _component;
    private boolean _minimized;
    private Boolean _floatOnTop;

    private void $init$() {
        this._minimized = false;
    }

    public TitledPanelHolder(Dockable dockable) {
        this.$init$();
        this._dockable = dockable;
    }

    public Dockable getDockable() {
        return this._dockable;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public JComponent getOrCreateComponent() {
        if (this._component == null) {
            JComponent mainComponent;
            String componentName;
            Dockable dockable = this.getDockable();
            JComponent component = dockable.getHostedComponent();
            if (component != null && (componentName = component.getName()) == null) {
                String titleName = dockable.getTitleName();
                component.setName(titleName);
            }
            if ((mainComponent = GraphicsUtils.focusComponentOrChild((Component)component, (boolean)true)) != null && mainComponent.getName() == null) {
                String mainComponentName = this._dockable.getUniqueName() + "_MAIN";
                mainComponent.setName(mainComponentName);
            }
            this._component = component;
        }
        return this._component;
    }

    public void disposeComponent() {
        this._component = null;
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public void setMinimized(boolean minimized) {
        this._minimized = minimized;
    }

    public Boolean getFloatOnTop() {
        return this._floatOnTop;
    }

    public boolean isFloatOnTop() {
        boolean ret;
        if (this._floatOnTop != null) {
            ret = this._floatOnTop;
        } else {
            EnvironOptions environOptions = Ide.getEnvironOptions();
            ret = environOptions.isFloatOnTop();
        }
        return ret;
    }

    public void setFloatOnTop(Boolean floatOnTop) {
        this._floatOnTop = floatOnTop;
    }

    void undock(DockablePath path, int flags) {
        TitledPanel titledPanel = path.getTitledPanel();
        int index = path.getPagePos();
        titledPanel.removeClientAt(index, flags);
    }
}

