/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import oracle.ideimpl.docking.VisibleComponentEvent;
import oracle.ideimpl.docking.VisibleComponentListener;

final class VisibleComponentAgent
implements ComponentListener,
ContainerListener {
    private ArrayList _listeners;

    private void $init$() {
        this._listeners = new ArrayList();
    }

    public void attachTo(Container c) {
        c.addContainerListener(this);
    }

    public void addVisibleComponentListener(VisibleComponentListener vcl) {
        if (!this._listeners.contains(this._listeners)) {
            this._listeners.add(vcl);
        }
    }

    public void componentShown(ComponentEvent e) {
        Component c = e.getComponent();
        this.whenComponentChanges(c.getParent(), c);
    }

    public void componentHidden(ComponentEvent e) {
        Component c = e.getComponent();
        this.whenComponentChanges(c.getParent(), c);
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentAdded(ContainerEvent e) {
        Container cn = e.getContainer();
        Component cm = e.getChild();
        this.whenComponentChanges(cn, cm);
        cm.addComponentListener(this);
    }

    public void componentRemoved(ContainerEvent e) {
        Container cn = e.getContainer();
        Component cm = e.getChild();
        cm.removeComponentListener(this);
        this.whenComponentChanges(cn, cm);
    }

    private void whenComponentChanges(Container cn, Component cm) {
        int n = cn.getComponentCount();
        int nVisibleCount = 0;
        int i = 0;
        while (i < n) {
            Component cChild = cn.getComponent(i);
            if (cChild.isVisible()) {
                ++nVisibleCount;
            }
            ++i;
        }
        VisibleComponentEvent vce = new VisibleComponentEvent(cn, cm, nVisibleCount);
        n = this._listeners.size();
        int i2 = 0;
        while (i2 < n) {
            VisibleComponentListener vcl = (VisibleComponentListener)this._listeners.get(i2);
            vcl.visibleCountChanges(vce);
            ++i2;
        }
    }

    VisibleComponentAgent() {
        this.$init$();
    }
}

