/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.docking.shutter.ShutterTab;

public final class ShutterMargin
extends JPanel
implements LayoutManager2,
DockableListener {
    private static final int GAP = 4;
    private String _orientation;

    ShutterMargin(String orientation) {
        this._orientation = orientation;
        Border border = BorderFactory.createEmptyBorder(this._orientation == "South" ? 1 : 0, this._orientation == "East" ? 1 : 0, this._orientation == "North" ? 1 : 0, this._orientation == "West" ? 1 : 0);
        this.setBorder(border);
        this.setLayout(this);
        this.setOpaque(false);
        DockStationImpl.getInstance().addDockableListener(this, null);
    }

    public boolean hasShutter(TitledPanel titledPanel) {
        return this.getShutter(titledPanel) != null;
    }

    public boolean addShutter(TitledPanel titledPanel, boolean showEffects) {
        if (titledPanel.getVisibleCount() <= 0) {
            return false;
        }
        ShutterTab tab = this.getShutter(titledPanel);
        if (tab == null) {
            tab = new ShutterTab(titledPanel);
            this.add((Component)tab, this.getInsertionPoint(titledPanel));
            if (showEffects) {
                ShutterMargin.showMove(titledPanel, tab);
            }
        }
        this.refreshShutter(titledPanel);
        return true;
    }

    public void removeShutter(TitledPanel titledPanel) {
        int pos = this.getShutterPos(titledPanel);
        if (pos >= 0) {
            this.remove(pos);
        }
    }

    public void refreshShutter(TitledPanel titledPanel) {
        ShutterTab tab = this.getShutter(titledPanel);
        if (tab != null) {
            tab.refresh();
        }
    }

    String getOrientation() {
        return this._orientation;
    }

    private ShutterTab getShutter(TitledPanel titledPanel) {
        int i = this.getShutterPos(titledPanel);
        return i >= 0 ? this.getShutter(i) : null;
    }

    private ShutterTab getShutter(Dockable dockable) {
        int i = this.getShutterPos(dockable);
        return i >= 0 ? this.getShutter(i) : null;
    }

    private ShutterTab getShutter(int pos) {
        return (ShutterTab)this.getComponent(pos);
    }

    private int getShutterPos(TitledPanel titledPanel) {
        int n = this.getShutterCount();
        int i = 0;
        while (i < n) {
            ShutterTab tab = this.getShutter(i);
            if (tab.getTitledPanel() == titledPanel) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getShutterPos(Dockable dockable) {
        int n = this.getShutterCount();
        int i = 0;
        while (i < n) {
            ShutterTab tab = this.getShutter(i);
            if (tab.isClient(dockable)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getShutterCount() {
        return this.getComponentCount();
    }

    /*
     * Unable to fully structure code
     */
    private int getInsertionPoint(TitledPanel panel) {
        titledPanels = this.getDockPanel().getAllTitledPanels();
        titledCount = titledPanels.length;
        marginCount = this.getShutterCount();
        titledPos = 0;
        marginPos = 0;
        while (marginPos < marginCount) {
            block3: {
                tab = this.getShutter(marginPos);
                if (!(tab instanceof ShutterTab)) break block3;
                compoundTab = tab;
                tabPanel = compoundTab.getTitledPanel();
                if (panel != tabPanel) ** GOTO lbl18
                return -1;
lbl-1000:
                // 1 sources

                {
                    titledPanel = titledPanels[titledPos];
                    if (titledPanel == panel) {
                        return marginPos;
                    }
                    if (titledPanel == tabPanel) break;
                    ++titledPos;
lbl18:
                    // 2 sources

                    ** while (titledPos < titledCount)
                }
            }
            ++marginPos;
        }
        return marginPos;
    }

    private DockPanel getDockPanel() {
        DividerControlledPanel dividerControlledPanel = (DividerControlledPanel)this.getParent();
        return dividerControlledPanel.getDockPanel();
    }

    private static void showMove(JComponent fromWindow, JComponent toWindow) {
        Graphics2D g;
        int steps = 5;
        Component glassPane = fromWindow.getRootPane().getGlassPane();
        if (glassPane != null && (g = (Graphics2D)glassPane.getGraphics()) != null) {
            Rectangle fromBounds = fromWindow.getBounds();
            Rectangle toBounds = toWindow.getBounds();
            Rectangle from = SwingUtilities.convertRectangle(fromWindow.getParent(), fromBounds, glassPane);
            Rectangle target = SwingUtilities.convertRectangle(toWindow.getParent(), toBounds, glassPane);
            g.setXORMode(Color.GRAY);
            int distance_x = target.x - from.x;
            int distance_y = target.y - from.y;
            int diffSize_x = target.width - from.width;
            int diffSize_y = target.height - from.height;
            Rectangle lastPos = new Rectangle(0, 0, 0, 0);
            int i = 1;
            while (i <= 5) {
                g.drawRect(lastPos.x, lastPos.y, lastPos.width, lastPos.height);
                lastPos.x = from.x + distance_x * i / 5;
                lastPos.y = from.y + distance_y * i / 5;
                lastPos.width = from.width + diffSize_x * i / 5;
                lastPos.height = from.height + diffSize_y * i / 5;
                g.drawRect(lastPos.x, lastPos.y, lastPos.width, lastPos.height);
                try {
                    Thread.sleep(7 + i * 7);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                ++i;
            }
            g.drawRect(lastPos.x, lastPos.y, lastPos.width, lastPos.height);
        }
    }

    public void dockableHidden(DockableEvent e) {
        this.dockableShown(e, false);
    }

    public void dockableShown(DockableEvent e) {
        this.dockableShown(e, true);
    }

    private void dockableShown(DockableEvent e, boolean shown) {
        Dockable dockable = e.getSource();
        ShutterTab shutterTab = this.getShutter(dockable);
        if (shutterTab != null) {
            shutterTab.getModel().setSelected(shown);
        }
    }

    public void raiseFloatPanel(TitledPanelHolder holder, int flags) {
        ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
        if (!shutterPanel.isClientAccessible(holder)) {
            ShutterTab tab = this.getShutter(holder.getDockable());
            if (tab != null) {
                tab.setSelectedHolder(holder);
            }
            DockStationImpl dockStation = DockStationImpl.getInstance();
            DockPanel dockPanel = this.getDockPanel();
            int orientation = dockStation.getPanelOrientation(dockPanel);
            shutterPanel.showPanel(holder, orientation, flags);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    public void layoutContainer(Container parent) {
        int n = this.getComponentCount();
        if (n != 0) {
            Insets insets = this.getInsets();
            int insWidth = insets.left + insets.right;
            int insHeight = insets.top + insets.bottom;
            int width = this.getWidth() - insWidth;
            int height = this.getHeight() - insHeight;
            if (this._orientation == "West" || this._orientation == "East") {
                int pos = insets.top;
                int i = 0;
                while (i < n) {
                    Component component = this.getComponent(i);
                    Dimension preferredSize = component.getPreferredSize();
                    component.setBounds(insets.left, pos, width, preferredSize.height);
                    pos += preferredSize.height + 4;
                    ++i;
                }
            } else {
                int pos = insets.left;
                int i = 0;
                while (i < n) {
                    Component component = this.getComponent(i);
                    Dimension preferredSize = component.getPreferredSize();
                    component.setBounds(pos, insets.top, preferredSize.width, height);
                    pos += preferredSize.width + 4;
                    ++i;
                }
            }
        }
        this.repaint();
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension dim;
        if (this.getComponentCount() != 0) {
            Dimension minimumSize = new Dimension(this.getComponent(0).getPreferredSize());
            if (this._orientation == "West" || this._orientation == "East") {
                minimumSize.height = 0;
            } else {
                minimumSize.width = 0;
            }
            dim = minimumSize;
            Insets insets = this.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
        } else {
            dim = new Dimension(0, 0);
        }
        return dim;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public void removeLayoutComponent(Component comp) {
    }

    public void addLayoutComponent(Component comp, Object constraints) {
    }

    public void invalidateLayout(Container target) {
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

