/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controls.DragComponentEvent;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableHolder;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideimpl.controls.OneLineBorder;
import oracle.ideimpl.controls.dockLayout.DockLayoutUtil;
import oracle.ideimpl.docking.AbstractTitledPanel;
import oracle.ideimpl.docking.DividerControlledPanel;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockableCriteria;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.docking.TitledPanel;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.controls.Divider;
import oracle.ideimpl.docking.controls.DividerEvent;
import oracle.ideimpl.docking.controls.DividerListener;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanelDragListener;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.window.WindowingConstants;
import oracle.javatools.ui.border.ShadowBorder;

public final class ShutterPanel
extends AbstractTitledPanel
implements ComponentListener,
DividerListener,
TitleChangeListener {
    private static final boolean SHUTTER_PANEL_ANIMATION = Boolean.getBoolean("jdev.docking.shutter_animation");
    private static final int MIN_SIZE = 30;
    private View _lastActiveView;
    private TitledPanelHolder _holder;
    private Divider _divider;
    private OneLineBorder _dividerBorder;
    private ShutterPanelDragListener _tabDragListener;
    private boolean _allowDetachPanel;
    private DesktopBackgroundMouseListener _desktopBackgroundMouseListener;
    private int[] _sizes;
    private Dimension minimumSize;
    private boolean resizedByUser;
    private int _orientation;
    private static final String TITLED_PANEL_CARD = "titledPanel";
    private static final String CAPTURE_PANEL_CARD = "capturePanel";
    private final CardLayout _cardLayout;
    private final JPanel _titledPanel;
    private final CapturePanel _capturePanel;
    private TitledPanel dockedTitledPanel;

    private void $init$() {
        this._allowDetachPanel = true;
        this._sizes = new int[]{180, 180, 180, 180};
        this._orientation = -1;
        this._cardLayout = new CardLayout();
        this._titledPanel = new JPanel(new BorderLayout());
        this._capturePanel = new CapturePanel();
    }

    public boolean isResizedByUser() {
        return this.resizedByUser;
    }

    ShutterPanel() {
        this.$init$();
        this.init();
    }

    protected TitledPanelHolder getSelectedHolder() {
        return this.getHolder();
    }

    void setFloatingSize(int orientation, int size) {
        this._sizes[orientation] = size;
    }

    int getFloatingSize(int orientation) {
        return this._sizes[orientation];
    }

    int getFloatingSize() {
        return this.getFloatingSize(this.getOrientation());
    }

    int getOrientation() {
        return this._orientation;
    }

    private Dockable getDockable() {
        return this.getHolder().getDockable();
    }

    private void init() {
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), (Border)new ShadowBorder(10, 3, 3, 10, 0.5)), WindowingConstants.FLAT_COMPOUND_BORDER);
        this.setBorder(border);
        this.setOpaque(false);
        this.enableEvents(16);
        this.setLayout(this._cardLayout);
        this.add((Component)this._titledPanel, TITLED_PANEL_CARD);
        this.add((Component)this._capturePanel, CAPTURE_PANEL_CARD);
        this.setVisible(false);
        this.createTitle();
        this.createUIMap();
        this._dividerBorder = new OneLineBorder(4, IdeConstants.COLOR_IDE_LINES);
        this._divider = new Divider(0, 4);
        this._divider.setOpaque(false);
        this._divider.setBorder(this._dividerBorder);
        this._divider.addDividerListener(this);
        this._titledPanel.add((Component)this._divider, "East");
        this.setFocusCycleRoot(true);
    }

    protected void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        Color background = this.getBackground();
        g.setColor(background);
        g.fillRect(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.top - insets.bottom);
    }

    public void setBorder(Border border) {
        super.setBorder(border);
    }

    protected void createTitle() {
        super.createTitle();
        this.setActive(true);
    }

    public void setVisible(boolean aFlag) {
        if (this.isVisible() != aFlag) {
            super.setVisible(aFlag);
            Container parent = this.getParent();
            if (parent != null) {
                EditorManagerImpl editorManager = (EditorManagerImpl)EditorManager.getEditorManager();
                JComponent desktopBackground = editorManager.getDesktopBackground();
                if (aFlag) {
                    this._desktopBackgroundMouseListener = new DesktopBackgroundMouseListener();
                    desktopBackground.addMouseListener(this._desktopBackgroundMouseListener);
                } else {
                    desktopBackground.removeMouseListener(this._desktopBackgroundMouseListener);
                    this._desktopBackgroundMouseListener = null;
                }
            }
        }
    }

    private void whenDesktopBackgroundMouseClicked() {
        this.detachPanel();
        IdeUtil.tryToRestoreFocus(null);
    }

    void showPanel(TitledPanelHolder holder, int orientation, int flags) {
        this.showPanel(holder, orientation, flags, true, false, null);
    }

    void showPanel(TitledPanelHolder holder, int orientation, int flags, boolean fireDockableShownEvent, boolean forAutoExpansion, TitledPanel dockedTitledPanel) {
        boolean isSameOrient;
        TitledPanelHolder previousHolder;
        this.resizedByUser = false;
        this.minimumSize = null;
        this.dockedTitledPanel = dockedTitledPanel;
        if (dockedTitledPanel != null) {
            this.minimumSize = dockedTitledPanel.getSize();
        }
        boolean isReplace = (previousHolder = this.getHolder()) != null;
        boolean bl = isSameOrient = orientation == this._orientation;
        if (isReplace) {
            this.listenFocus(false);
            this._titledPanel.remove(previousHolder.getComponent());
            DockStationImpl dockStation = DockStationImpl.getInstance();
            DockableEvent event = new DockableEvent(this.getDockable(), 1, flags);
            dockStation.fireDockableEvent(event);
        } else {
            this._lastActiveView = Ide.getMainWindow().getLastActiveView();
        }
        this.setOrientation(orientation);
        this.setHolder(holder);
        ShutterMargin margin = ShutterPanel.getShutterMargin(orientation);
        margin.addComponentListener(this);
        Dockable newDockable = this.getDockable();
        if (fireDockableShownEvent) {
            JComponent gui = newDockable.getHostedComponent();
            if (gui != null) {
                gui.setVisible(true);
            }
            DockStationImpl dockStation = DockStationImpl.getInstance();
            DockableEvent event = new DockableEvent(newDockable, 0, flags);
            dockStation.fireDockableEvent(event);
        }
        JComponent component = holder.getOrCreateComponent();
        this._titledPanel.add((Component)component, "Center");
        this.adjustTitle(newDockable);
        this.adjustButtons(newDockable);
        this._buttonPin.setVisible(forAutoExpansion ^ true);
        if (SHUTTER_PANEL_ANIMATION) {
            PanelAnimator.raisePanel(this);
        } else {
            if (forAutoExpansion) {
                this.adaptSize(dockedTitledPanel, newDockable);
            } else {
                this.adaptSize();
            }
            this.setVisible(true);
        }
        SwingUtilities.invokeLater(new 1(this, component, fireDockableShownEvent, newDockable));
        if (isReplace && isSameOrient) {
            component.repaint();
        }
        this.listenFocus(true);
    }

    public TitledPanelHolder getHolder() {
        return this._holder;
    }

    private void setHolder(TitledPanelHolder dockableHolder) {
        if (this.getHolder() != null) {
            Dockable dockable = this.getHolder().getDockable();
            dockable.removeTitleChangeListener((TitleChangeListener)this);
        }
        this._holder = dockableHolder;
        if (this.getHolder() != null) {
            Dockable dockable = this.getHolder().getDockable();
            dockable.addTitleChangeListener((TitleChangeListener)this);
        }
    }

    private void listenFocus(boolean bListen) {
        this._allowDetachPanel = bListen;
    }

    void hidePanel(int flags) {
        this.hidePanel(flags, true);
    }

    void hidePanel(int flags, boolean fireDockableHiddenEvent) {
        TitledPanelHolder holder = this.getHolder();
        if (holder != null) {
            Dockable detachedDockable = holder.getDockable();
            this.detachDockable(flags);
            this.getParent().validate();
            if (fireDockableHiddenEvent) {
                DockStationImpl dockStation = DockStationImpl.getInstance();
                dockStation.fireDockableEvent(new DockableEvent(detachedDockable, 1, flags));
            }
        }
    }

    private void detachDockable(int flags) {
        this.listenFocus(false);
        if (SHUTTER_PANEL_ANIMATION && flags == 0) {
            PanelAnimator.hidePanel(this);
        } else {
            this.setVisible(false);
            if (SHUTTER_PANEL_ANIMATION) {
                PanelAnimator.cancel();
            }
        }
        JComponent c = this.getHolder().getComponent();
        if (c != null) {
            this._titledPanel.remove(c);
        }
        this.setHolder(null);
        ShutterMargin margin = ShutterPanel.getShutterMargin(this._orientation);
        margin.removeComponentListener(this);
        if (this._lastActiveView != null) {
            GraphicsUtils.focusComponentOrChild((Component)this._lastActiveView.getGUI(), (boolean)true);
            this._lastActiveView = null;
        }
    }

    private static ShutterMargin getShutterMargin(int nOrient) {
        DockStationImpl dockStation = DockStationImpl.getInstance();
        DividerControlledPanel dividerControlledPanel = dockStation.getDividerControlledPanel(nOrient);
        ShutterMargin shutterMargin = dividerControlledPanel.getShutterMargin();
        return shutterMargin;
    }

    private void setOrientation(int orientation) {
        if (this._orientation != orientation) {
            int dividerBorderSides;
            String dividerPos;
            int dividerOrient;
            String handleBarPos;
            int handleBarOrient;
            this._orientation = orientation;
            switch (orientation) {
                case 0: {
                    handleBarOrient = 0;
                    handleBarPos = "North";
                    dividerOrient = 1;
                    dividerPos = "East";
                    dividerBorderSides = 4;
                    break;
                }
                case 1: {
                    handleBarOrient = 0;
                    handleBarPos = "North";
                    dividerOrient = 1;
                    dividerPos = "West";
                    dividerBorderSides = 8;
                    break;
                }
                case 2: {
                    handleBarOrient = 1;
                    handleBarPos = "West";
                    dividerOrient = 0;
                    dividerPos = "South";
                    dividerBorderSides = 1;
                    break;
                }
                default: {
                    handleBarOrient = 1;
                    handleBarPos = "West";
                    dividerOrient = 0;
                    dividerPos = "North";
                    dividerBorderSides = 2;
                    break;
                }
            }
            this._titledPanel.add((Component)((Object)this._handlebar), handleBarPos);
            this._handlebar.setOrientation(handleBarOrient);
            OneLineBorder border = (OneLineBorder)this._handlebar.getBorder();
            int sides = handleBarOrient == 1 ? 8 : 2;
            border.setSides(sides);
            this._titledPanel.add((Component)this._divider, dividerPos);
            this._divider.setOrientation(dividerOrient);
            this._dividerBorder.setSides(dividerBorderSides);
        }
    }

    private void adaptSize() {
        this.adaptSize(null, null);
    }

    private void adaptSize(TitledPanel dockedTitledPanel, Dockable dockable) {
        int mySize = this._sizes[this._orientation];
        ShutterMargin shutterMargin = ShutterPanel.getShutterMargin(this._orientation);
        Rectangle marginBounds = shutterMargin.getBounds();
        Rectangle myBounds = SwingUtilities.convertRectangle(shutterMargin.getParent(), marginBounds, this.getParent());
        switch (this._orientation) {
            case 0: {
                if (dockable != null) {
                    mySize = this.rightWidth(mySize, dockedTitledPanel, dockable);
                }
                this.setBounds(myBounds.x + myBounds.width, myBounds.y, mySize, myBounds.height);
                break;
            }
            case 1: {
                if (dockable != null) {
                    mySize = this.rightWidth(mySize, dockedTitledPanel, dockable);
                }
                this.setBounds(myBounds.x - mySize, myBounds.y, mySize, myBounds.height);
                break;
            }
            case 2: {
                if (dockable != null) {
                    mySize = this.rightHeight(mySize, dockedTitledPanel, dockable);
                }
                this.setBounds(myBounds.x, myBounds.y + myBounds.height, myBounds.width, mySize);
                break;
            }
            case 3: {
                if (dockable != null) {
                    mySize = this.rightHeight(mySize, dockedTitledPanel, dockable);
                }
                this.setBounds(myBounds.x, myBounds.y - mySize, myBounds.width, mySize);
                break;
            }
        }
        this.validate();
    }

    private int rightWidth(int current, TitledPanel dockedTitledPanel, Dockable dockable) {
        int dockedTitledPanelWidth = dockedTitledPanel.getSize().width;
        Dimension forAutoExpansion = this.autoExpandSizeFromDockable(dockedTitledPanel, dockable);
        if (forAutoExpansion != null) {
            return Math.max(forAutoExpansion.width, dockedTitledPanelWidth);
        }
        return Math.max(current, dockedTitledPanelWidth);
    }

    private int rightHeight(int current, TitledPanel dockedTitledPanel, Dockable dockable) {
        int dockedTitledPanelHeight = dockedTitledPanel.getSize().height;
        Dimension forAutoExpansion = this.autoExpandSizeFromDockable(dockedTitledPanel, dockable);
        if (forAutoExpansion != null) {
            return Math.max(forAutoExpansion.height, dockedTitledPanelHeight);
        }
        return Math.max(current, dockedTitledPanelHeight);
    }

    private Dimension autoExpandSizeFromDockable(TitledPanel dockedTitledPanel, Dockable dockable) {
        Dimension forAutoExpansion = dockable.getAutoExpansionPreferredSize(this._orientation);
        if (forAutoExpansion != null) {
            return forAutoExpansion;
        }
        return dockable.getAutoExpansionSize(this._orientation, (JPanel)dockedTitledPanel);
    }

    protected boolean isMinimized() {
        return true;
    }

    protected boolean isMinimizable() {
        return true;
    }

    protected boolean isMaximized() {
        return false;
    }

    protected boolean isMaximizable() {
        return false;
    }

    protected boolean isFloating() {
        return false;
    }

    protected boolean canMove() {
        return false;
    }

    protected boolean canSize() {
        return false;
    }

    protected JPopupMenu getTitleContextMenu() {
        TitledPanelHolder holder = this.getHolder();
        return this.createSystemMenu(holder);
    }

    protected void whenMinimize(int flags) {
    }

    protected void whenMaximize(int flags) {
    }

    protected void whenRestore(int flags, DockableHolder selectedHolder) {
        DockablePath path;
        DockStationImpl dockStation = DockStationImpl.getInstance();
        if (dockStation.getDockablePath(path = new DockablePath(), new DockableCriteria(selectedHolder))) {
            TitledPanel titledPanel = path.getTitledPanel();
            this._lastActiveView = null;
            this.hidePanel(flags);
            titledPanel.restore(flags);
        }
    }

    protected void whenSystemMenuClose(TitledPanelHolder selectedHolder) {
        this.whenClose(20, selectedHolder);
    }

    protected void whenClose(int flags) {
        this.whenClose(flags, this.getHolder());
    }

    private void whenClose(int flags, TitledPanelHolder holder) {
        DockStationImpl dockStation = DockStationImpl.getInstance();
        dockStation.addDockableEventContext(flags);
        try {
            DockablePath path = new DockablePath();
            if (dockStation.getDockablePath(path, new DockableCriteria(holder))) {
                this.close(flags, holder, path.getTitledPanel());
            } else if (this.dockedTitledPanel != null) {
                this.close(flags, holder, this.dockedTitledPanel);
            }
        }
        finally {
            dockStation.removeDockableEventContext(flags);
        }
    }

    private void close(int flags, TitledPanelHolder holder, TitledPanel titledPanel) {
        this.hidePanel(0);
        titledPanel.closeClient(holder, flags);
        holder.disposeComponent();
        IdeUtil.tryToRestoreFocus(null);
    }

    protected void titleMousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showTitleContextMenu(e);
        } else {
            AbstractTitledPanel._ptStart.setLocation(e.getPoint());
        }
    }

    protected void titleMouseDragged(MouseEvent e) {
        JComponent c = this.getHolder().getComponent();
        if (!AbstractTitledPanel._bDraging && SwingUtilities.isLeftMouseButton(e) && AbstractTitledPanel._ptStart.distanceSq(e.getPoint()) >= (double)AbstractTitledPanel.DRAGSTART) {
            AbstractTitledPanel._bDraging = true;
            this.listenFocus(false);
            this._tabDragListener = new ShutterPanelDragListener(this.getHolder());
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, c);
            this._tabDragListener.start(new DragComponentEvent((Component)c, pt, 1, e.getModifiers()));
        }
        if (AbstractTitledPanel._bDraging) {
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, c);
            this._tabDragListener.move(new DragComponentEvent((Component)c, pt, 2, e.getModifiers()));
        }
    }

    protected void titleMouseReleased(MouseEvent e) {
        if (AbstractTitledPanel._bDraging) {
            Point pt = e.getPoint();
            JComponent jcClientComponent = this.getHolder().getComponent();
            SwingUtilities.convertPointToScreen(pt, jcClientComponent);
            this._tabDragListener.end(new DragComponentEvent((Component)jcClientComponent, pt, 3, e.getModifiers()));
            AbstractTitledPanel._bDraging = false;
            this._tabDragListener = null;
            if (this.getHolder() != null) {
                this.listenFocus(true);
            }
        } else if (e.isPopupTrigger()) {
            this.showTitleContextMenu(e);
        }
    }

    protected void systemMenuSizeDocked() {
    }

    protected void whenSystemMenuFloat(DockableHolder selectedHolder) {
        this.whenRestore(4, selectedHolder);
        DockStationImpl dockStation = DockStationImpl.getInstance();
        DockablePath path = new DockablePath();
        if (dockStation.getDockablePath(path, new DockableCriteria(selectedHolder))) {
            TitledPanel titledPanel = path.getTitledPanel();
            dockStation.floatPanel(titledPanel, new Point(10, 10));
        }
    }

    public void componentResized(ComponentEvent e) {
        this.adaptSize();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void containerActivated(boolean isActive) {
        super.containerActivated(isActive);
        if (!isActive && this._allowDetachPanel) {
            this.detachPanel();
        }
    }

    private void detachPanel() {
        DockStationImpl dockStation = DockStationImpl.getInstance();
        dockStation.addDockableEventContext(4);
        try {
            this.hidePanel(4);
        }
        finally {
            dockStation.removeDockableEventContext(4);
        }
    }

    public int getClientCount() {
        return this.getHolder() == null ? 0 : 1;
    }

    public Dockable getClient(int i) {
        return this.getHolder().getDockable();
    }

    public boolean isClientAccessible(Dockable dockable) {
        return this.getHolder() != null && this.getHolder().getDockable() == dockable;
    }

    public boolean isClientAccessible(DockableHolder holder) {
        return this.getHolder() != null && this.getHolder() == holder;
    }

    public void dividerMoved(DividerEvent e) {
        int maxLimit;
        int minLimit = 30;
        int delta = e.getDelta();
        Container parent = this.getParent();
        boolean horizontal = DockLayoutUtil.isHorz(this._orientation);
        if (horizontal) {
            ShutterMargin westMargin = ShutterPanel.getShutterMargin(0);
            Rectangle westBounds = SwingUtilities.convertRectangle(westMargin.getParent(), westMargin.getBounds(), parent);
            int west = westBounds.x + westBounds.width;
            ShutterMargin eastMargin = ShutterPanel.getShutterMargin(1);
            Point eastOrigin = SwingUtilities.convertPoint(eastMargin.getParent(), eastMargin.getLocation(), parent);
            maxLimit = eastOrigin.x - west - 30;
        } else {
            ShutterMargin northMargin = ShutterPanel.getShutterMargin(2);
            Rectangle northBounds = SwingUtilities.convertRectangle(northMargin.getParent(), northMargin.getBounds(), parent);
            int north = northBounds.y + northBounds.height;
            ShutterMargin southMargin = ShutterPanel.getShutterMargin(3);
            Point southOrigin = SwingUtilities.convertPoint(southMargin.getParent(), southMargin.getLocation(), parent);
            maxLimit = southOrigin.y - north - 30;
        }
        if (!DockLayoutUtil.isBefore(this._orientation)) {
            delta = -delta;
        }
        int min = Math.max(this._sizes[this._orientation] + delta, 30);
        if (this.minimumSize != null) {
            min = horizontal ? Math.max(min, this.minimumSize.width) : Math.max(min, this.minimumSize.height);
        }
        this._sizes[this._orientation] = Math.min(min, maxLimit);
        this.resizedByUser = true;
        this.adaptSize();
    }

    public void titleChange(TitleChangeEvent e) {
        Dockable dockable = this.getHolder().getDockable();
        this.adjustTitle(dockable);
    }

    void capture() {
        this.setVisible(true);
        this.adaptSize();
        this._cardLayout.show(this, TITLED_PANEL_CARD);
        this._capturePanel.capture(this._titledPanel, this.getOrientation());
        this._cardLayout.show(this, CAPTURE_PANEL_CARD);
    }

    void uncapture() {
        this._cardLayout.show(this, TITLED_PANEL_CARD);
        this._capturePanel.uncapture();
    }

    int getCaptureOrientation() {
        return this._capturePanel.getOrientation();
    }

    void setActive(boolean isActive) {
        this._handlebar.setActive(isActive);
    }

    static void mav$whenDesktopBackgroundMouseClicked(ShutterPanel shutterPanel) {
        shutterPanel.whenDesktopBackgroundMouseClicked();
    }

    static void mav$adaptSize(ShutterPanel shutterPanel) {
        shutterPanel.adaptSize();
    }

    class DesktopBackgroundMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            ShutterPanel.mav$whenDesktopBackgroundMouseClicked(ShutterPanel.this);
        }

        DesktopBackgroundMouseListener() {
        }
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ JComponent v$component;
        private final /* synthetic */ boolean v$fireDockableShownEvent;
        private final /* synthetic */ Dockable v$newDockable;
        final /* synthetic */ ShutterPanel this$0;

        public void run() {
            GraphicsUtils.focusComponentOrChild((Component)this.v$component, (boolean)true);
            if (!this.v$fireDockableShownEvent) {
                this.v$newDockable.afterAutoExpanding();
                return;
            }
        }

        public 1(ShutterPanel shutterPanel, JComponent jComponent, boolean bl, Dockable dockable) {
            this.v$newDockable = dockable;
            this.v$fireDockableShownEvent = bl;
            this.v$component = jComponent;
            this.this$0 = shutterPanel;
        }
    }

    private static final class PanelAnimator
    implements ActionListener {
        private static final PanelAnimator INSTANCE = new PanelAnimator();
        private static final int ANIMATE_DELAY_MSEC = 240;
        private static final int ANIMATE_RAISE_STEP_MSEC = 16;
        private static final int ANIMATE_RAISE_STEP_PIXELS = 6;
        private static final int ANIMATE_HIDE_STEP_MSEC = 16;
        private static final int ANIMATE_HIDE_STEP_PIXELS = 8;
        private static final Object RAISE_ACTION = "raise";
        private static final Object HIDE_ACTION = "hide";
        private Timer _timer;
        private long _curTime;
        private ShutterPanel _panel;
        private boolean _isRaising;

        private PanelAnimator() {
        }

        static void raisePanel(ShutterPanel panel) {
            INSTANCE.start(panel, RAISE_ACTION);
        }

        static void hidePanel(ShutterPanel panel) {
            INSTANCE.start(panel, HIDE_ACTION);
        }

        static void cancel() {
            INSTANCE.done();
        }

        public final void actionPerformed(ActionEvent e) {
            int mySize = this._panel.getFloatingSize();
            long when = e.getWhen();
            long elapsed = when - this._curTime;
            int pixels = this._isRaising ? 6 : 8;
            int delta = (int)(elapsed * (long)pixels / (long)this._timer.getDelay());
            this.adjustPanelSize(this._isRaising ? delta : -delta);
            this._panel.validate();
            this._curTime = when;
            int newSize = this.getPanelSize();
            if (this._isRaising ? newSize >= mySize : newSize <= 0) {
                this._panel.setVisible(this._isRaising);
                this.done();
            }
        }

        private void start(ShutterPanel panel, Object action) {
            boolean isRaising;
            boolean bl = isRaising = action == RAISE_ACTION;
            if (this._timer != null) {
                if (!isRaising && !this._isRaising) {
                    return;
                }
                this._timer.stop();
                this._timer = null;
                int oldSize = this.getPanelSize();
                int captureOrientation = this._panel.getCaptureOrientation();
                this._panel = panel;
                this._panel.setActive(isRaising);
                this._panel.capture();
                if (this._panel.getOrientation() == captureOrientation) {
                    this.adjustPanelSize(-panel.getFloatingSize() + oldSize);
                } else {
                    this.adjustPanelSize(isRaising ? -panel.getFloatingSize() : 0);
                }
            } else {
                if (isRaising && panel.isVisible() && panel.getOrientation() == panel.getCaptureOrientation()) {
                    ShutterPanel.mav$adaptSize(panel);
                    return;
                }
                this._panel = panel;
                this._panel.setActive(isRaising);
                this._panel.capture();
                if (isRaising) {
                    this.adjustPanelSize(-this._panel.getFloatingSize());
                }
            }
            this._isRaising = isRaising;
            this._curTime = System.currentTimeMillis();
            this._timer = new Timer(this._isRaising ? 16 : 16, this);
            this._timer.setInitialDelay(240);
            this._timer.start();
        }

        private void done() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
            if (this._panel != null) {
                this._panel.uncapture();
                this._panel = null;
            }
            this._curTime = 0L;
            this._isRaising = false;
        }

        private int getPanelSize() {
            switch (this._panel.getOrientation()) {
                case 0: 
                case 1: {
                    return this._panel.getWidth();
                }
                case 2: 
                case 3: {
                    return this._panel.getHeight();
                }
            }
            return 0;
        }

        private void adjustPanelSize(int delta) {
            int x = this._panel.getX();
            int y = this._panel.getY();
            int width = this._panel.getWidth();
            int height = this._panel.getHeight();
            int mySize = this._panel.getFloatingSize();
            int newWidth = Math.min(Math.max(width + delta, 0), mySize);
            int newHeight = Math.min(Math.max(height + delta, 0), mySize);
            switch (this._panel.getOrientation()) {
                case 0: {
                    this._panel.setBounds(x, y, newWidth, height);
                    break;
                }
                case 1: {
                    this._panel.setBounds(Math.max(x + width - mySize, x - delta), y, newWidth, height);
                    break;
                }
                case 2: {
                    this._panel.setBounds(x, y, width, newHeight);
                    break;
                }
                case 3: {
                    this._panel.setBounds(x, Math.max(y + height - mySize, y - delta), width, newHeight);
                    break;
                }
            }
        }
    }

    private static final class CapturePanel
    extends JPanel {
        BufferedImage _image;
        int _orientation;
        boolean _isTrailing;

        CapturePanel() {
            super(null);
        }

        void capture(Component c, int orientation) {
            this._image = this.captureComponentImage(c);
            this._orientation = orientation;
            if (this._image != null) {
                this._isTrailing = this._orientation == 0 || this._orientation == 2;
            }
        }

        void uncapture() {
            this._image = null;
            this._isTrailing = false;
        }

        int getOrientation() {
            return this._orientation;
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this._image != null) {
                int x = this._isTrailing ? this.getWidth() - this._image.getWidth() : 0;
                int y = this._isTrailing ? this.getHeight() - this._image.getHeight() : 0;
                g.drawImage(this._image, x, y, null);
            }
        }

        private BufferedImage captureComponentImage(Component c) {
            int width = c.getWidth();
            int height = c.getHeight();
            if (width == 0 || height == 0) {
                return null;
            }
            BufferedImage image = new BufferedImage(width, height, 2);
            Graphics2D g2 = image.createGraphics();
            c.paintAll(g2);
            g2.dispose();
            return image;
        }
    }
}

