/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.IdeConstants;
import oracle.ideimpl.controls.dockLayout.DockInsertionPoint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.editor.Desktop;

final class DesktopDropZone
extends JPanel
implements DropTargetListener {
    private static final boolean DEBUG_DROP_POINTS = false;
    private static final int DEBUG_DROP_POINT_SIZE = 25;
    private final DockLayoutPanel _dockLayoutPanel;
    private DockInsertionPoint _insertionPoint;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DesktopDropZone(DockLayoutPanel dockLayoutPanel) {
        this._dockLayoutPanel = dockLayoutPanel;
        this.setBounds(this._dockLayoutPanel.getBounds());
        this.setOpaque(false);
        new DropTarget(this, this);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._insertionPoint != null) {
            this.paintDragUnderFeedback(g);
        }
    }

    static {
        $assertionsDisabled = DesktopDropZone.class.desiredAssertionStatus() ^ true;
    }

    protected void paintDragUnderFeedback(Graphics g) {
        if (!$assertionsDisabled && this._insertionPoint == null) {
            throw new AssertionError();
        }
        Color oldColor = g.getColor();
        Rectangle r = SwingUtilities.convertRectangle(this._dockLayoutPanel, this._insertionPoint.getFeedback(), this);
        g.setColor(IdeConstants.DRAG_FEEDBACK_BACKGROUND);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(IdeConstants.DRAG_FEEDBACK_OUTLINE);
        g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
        g.setColor(oldColor);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        this.setFeedbackPoint(dtde.getLocation());
    }

    public void dragExit(DropTargetEvent dte) {
        this.setFeedbackPoint(null);
    }

    public void drop(DropTargetDropEvent dtde) {
        Desktop desktop = (Desktop)this.getParent();
        desktop.dropTab(dtde);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    private void setFeedbackPoint(Point pt) {
        DockInsertionPoint dip = this.getInsertionPoint(pt);
        if (dip != this._insertionPoint) {
            this._insertionPoint = dip;
            this.repaint();
        }
    }

    private DockInsertionPoint getInsertionPoint(Point pt) {
        if (pt != null) {
            Point feedback = SwingUtilities.convertPoint(this, pt, this._dockLayoutPanel);
            return this._dockLayoutPanel.getDockInsertionAt(feedback);
        }
        return null;
    }
}

