/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;
import oracle.ide.util.Assert;

final class EditorAddinRegistry {
    private final Map _registry;
    private final ArrayList _dynamicRegistry;
    private final HashMap _registeredAddins;
    private final HashSet _registeredEditors;
    private final Set _registeredClasses;

    private void $init$() {
        this._registry = new HashMap();
        this._dynamicRegistry = new ArrayList();
        this._registeredAddins = new HashMap();
        this._registeredEditors = new HashSet();
        this._registeredClasses = new HashSet();
    }

    void unregister(EditorAddin editorAddin) {
        Set keySet = this._registry.keySet();
        ArrayList keys = new ArrayList(keySet);
        int i = 0;
        while (i < keys.size()) {
            Object key = keys.get(i);
            List list = (List)this._registry.get(key);
            int j = list.size() - 1;
            while (j >= 0) {
                EditorAddin registeredAddin = (EditorAddin)list.get(j);
                if (editorAddin.equals((Object)registeredAddin)) {
                    list.remove(j);
                }
                --j;
            }
            if (list.isEmpty()) {
                this._registry.remove(key);
            }
            ++i;
        }
        this.removeFromRegistry(editorAddin);
    }

    void extend(EditorAddin editorAddin, Class[] types) {
        boolean isDefault = editorAddin.isDefault();
        int i = 0;
        while (i < types.length) {
            ArrayList<EditorAddin> list = (ArrayList<EditorAddin>)this._registry.get(types[i]);
            if (list == null) {
                list = new ArrayList<EditorAddin>(5);
                list.add(editorAddin);
                this._registry.put(types[i], list);
                this._registeredClasses.add(types[i]);
            } else if (!list.contains(editorAddin)) {
                if (isDefault) {
                    list.add(0, editorAddin);
                } else {
                    list.add(editorAddin);
                }
            }
            ++i;
        }
        this.addToRegistry(editorAddin);
    }

    void registerDynamic(EditorAddin editorAddin) {
        this._dynamicRegistry.add(editorAddin);
        this.addToRegistry(editorAddin);
    }

    void unregisterDynamic(EditorAddin editorAddin) {
        this._dynamicRegistry.remove(editorAddin);
        this.removeFromRegistry(editorAddin);
    }

    List getStaticAddins(Class elementClass) {
        return this.getAddinsImpl(elementClass, null);
    }

    Set getStaticElementTypes() {
        return Collections.unmodifiableSet(this._registeredClasses);
    }

    List getAddins(Element element) {
        Assert.startTiming((String)(this.getClass().getName() + ".getAddins"), null, (boolean)false);
        List addins = this.getAddinsImpl(element.getClass(), element);
        Assert.endTiming((String)(this.getClass().getName() + ".getAddins"), (String)("Building the list of addins for " + element.getShortLabel()), (String)"  ", (boolean)false);
        return addins;
    }

    private List getAddinsImpl(Class elementClass, Element element) {
        HashMap<EditorAddin, Float> addins = new HashMap<EditorAddin, Float>();
        List staticAddins = this.getStaticAddinsImpl(elementClass);
        int i = 0;
        while (i < staticAddins.size()) {
            EditorAddin editorAddin = (EditorAddin)staticAddins.get(i);
            addins.put(editorAddin, new Float(0.5 - (double)i * 0.01));
            ++i;
        }
        int i2 = 0;
        while (element != null && i2 < this._dynamicRegistry.size()) {
            EditorAddin editorAddin = (EditorAddin)this._dynamicRegistry.get(i2);
            if (!addins.containsKey(editorAddin)) {
                Assert.startTiming((String)this.getClass().getName(), null, (boolean)false);
                float editorWeight = editorAddin.getEditorWeight(element);
                Assert.endTiming((String)this.getClass().getName(), (String)(editorAddin.getClass().getName() + ".getEditorWeight()"), (String)"    ", (boolean)false, (long)5);
                if (!Float.isNaN(editorWeight)) {
                    addins.put(editorAddin, new Float(editorWeight));
                }
            }
            ++i2;
        }
        ArrayList addinList = new ArrayList(addins.keySet());
        Collections.sort(addinList, new 1(this, addins));
        return addinList;
    }

    boolean hasAddins(Element element) {
        boolean ret = false;
        if (this.hasStaticAddins(element)) {
            ret = true;
        } else {
            int i = 0;
            while (i < this._dynamicRegistry.size()) {
                EditorAddin editorAddin = (EditorAddin)this._dynamicRegistry.get(i);
                float editorWeight = editorAddin.getEditorWeight(element);
                if (!Float.isNaN(editorWeight)) {
                    ret = true;
                    break;
                }
                ++i;
            }
        }
        return ret;
    }

    private boolean hasStaticAddins(Element element) {
        boolean ret = false;
        Class<?> cls = element.getClass();
        List list = (List)this._registry.get(cls);
        if (list != null) {
            ret = true;
        } else {
            Class<?> superCls = cls.getSuperclass();
            while (superCls != null) {
                list = (List)this._registry.get(superCls);
                if (list != null && list.size() != 0) {
                    ret = true;
                    break;
                }
                superCls = superCls.getSuperclass();
            }
        }
        return ret;
    }

    private List getStaticAddinsImpl(Class cls) {
        List list = (List)this._registry.get(cls);
        if (list == null) {
            Class superCls = cls.getSuperclass();
            while (superCls != null) {
                list = (List)this._registry.get(superCls);
                if (list != null && list.size() != 0) {
                    this._registry.put(cls, list);
                    break;
                }
                superCls = superCls.getSuperclass();
            }
        }
        return list != null ? list : Collections.EMPTY_LIST;
    }

    Class getRegisteredElementType(Class cls) {
        if (this._registry.containsKey(cls)) {
            return cls;
        }
        Class superCls = cls.getSuperclass();
        while (superCls != null) {
            if (this._registry.containsKey(superCls)) {
                return superCls;
            }
            superCls = superCls.getSuperclass();
        }
        return null;
    }

    void dumpRegisteredEditors() {
        HashMap allNodeTypes = new HashMap();
        System.out.println("-------------------- Registered editors");
        for (Class nodeClass : this._registry.keySet()) {
            System.out.println(nodeClass.getName());
            List lst = (List)this._registry.get(nodeClass);
            int i = 0;
            while (i < lst.size()) {
                EditorAddin editorAddin = (EditorAddin)lst.get(i);
                Class editorClass = editorAddin.getEditorClass();
                System.out.println("    " + editorAddin.getMenuSpecification().label + " = " + editorClass.getName());
                ++i;
            }
            this.buildNodeTree(nodeClass, allNodeTypes);
        }
        System.out.println("-------------------- Node hierarchy");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)allNodeTypes.get(Object.class);
        this.recDumpTree(root, "");
    }

    private DefaultMutableTreeNode buildNodeTree(Class cls, HashMap allNodeTypes) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodeTypes.get(cls);
        if (node == null) {
            node = new DefaultMutableTreeNode(cls);
            if (cls != Object.class) {
                Class superclass = cls.getSuperclass();
                DefaultMutableTreeNode parentNode = this.buildNodeTree(superclass, allNodeTypes);
                parentNode.add(node);
            }
            allNodeTypes.put(cls, node);
        }
        return node;
    }

    private void recDumpTree(DefaultMutableTreeNode parent, String level) {
        Class cls = (Class)parent.getUserObject();
        System.out.println(level + cls.getName());
        int childCount = parent.getChildCount();
        int i = 0;
        while (i < childCount) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            this.recDumpTree(child, level + "  ");
            ++i;
        }
    }

    private void addToRegistry(EditorAddin editorAddin) {
        Class editorAddinClass = editorAddin.getClass();
        String editorAddinClassName = editorAddinClass.getName();
        this._registeredAddins.put(editorAddinClassName, editorAddin);
        Class editorClass = editorAddin.getEditorClass();
        this._registeredEditors.add(editorClass);
    }

    private void removeFromRegistry(EditorAddin editorAddin) {
        Class editorAddinClass = editorAddin.getClass();
        String editorAddinClassName = editorAddinClass.getName();
        this._registeredAddins.remove(editorAddinClassName);
        Class editorClass = editorAddin.getEditorClass();
        this._registeredEditors.remove(editorClass);
    }

    EditorAddin getRegisteredEditorAddin(String editorAddinClassName) {
        return (EditorAddin)this._registeredAddins.get(editorAddinClassName);
    }

    boolean isEditorRegistered(Class editorClass) {
        boolean ret = this._registeredEditors.contains(editorClass);
        return ret;
    }

    EditorAddin getEditorAddin(Class editorClass) {
        if (this.isEditorRegistered(editorClass)) {
            Iterator i;
            Set set = this._registeredAddins.keySet();
            Iterator iterator = i = set != null ? set.iterator() : null;
            if (i != null) {
                while (i.hasNext()) {
                    Object key = i.next();
                    EditorAddin addin = (EditorAddin)this._registeredAddins.get(key);
                    if (addin == null || addin.getEditorClass() != editorClass) continue;
                    return addin;
                }
            }
        }
        return null;
    }

    EditorAddinRegistry() {
        this.$init$();
    }

    final class 1
    implements Comparator {
        private final /* synthetic */ HashMap v$addins;
        final /* synthetic */ EditorAddinRegistry this$0;

        public int compare(Object o1, Object o2) {
            Float value1 = (Float)this.v$addins.get(o1);
            Float value2 = (Float)this.v$addins.get(o2);
            return Float.compare(value2.floatValue(), value1.floatValue());
        }

        public 1(EditorAddinRegistry editorAddinRegistry, HashMap hashMap) {
            this.v$addins = hashMap;
            this.this$0 = editorAddinRegistry;
        }
    }
}

