/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.Enumeration;
import java.util.Iterator;
import oracle.ide.util.BitField;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditorIterator
implements Iterator,
Enumeration {
    private static final int ITERATE_TABGROUP = 1;
    public static final int ITERATE_DOCUMENT = 3;
    private static final int ITERATE_PANE_STATE = 7;
    public static final int ITERATE_EDITOR = 15;
    private final int _type;
    private final EditorPathImpl _path;

    public EditorIterator(int type) {
        this._type = type;
        this._path = new EditorPathImpl(0, 0, 0, 0);
    }

    public EditorPathImpl getPath() {
        return this._path;
    }

    @Override
    public boolean hasNext() {
        return this.hasNextEditor() || this.hasNextPane() || this.hasNextDocument();
    }

    private boolean hasNextDocument() {
        TabGroup tabGroup;
        boolean ret = false;
        if (BitField.isSet((int)this._type, (int)3) && (tabGroup = this._path.getTabGroup()) != null) {
            int documentCount = tabGroup.getTabGroupStateCount();
            ret = this._path._tabGroupStatePos < documentCount;
        }
        return ret;
    }

    private boolean hasNextPane() {
        TabGroupState tabGroupState;
        boolean ret = false;
        if (BitField.isSet((int)this._type, (int)7) && (tabGroupState = this._path.getTabGroupState()) != null) {
            int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
            ret = this._path._panePos < splitPaneStateCount;
        }
        return ret;
    }

    private boolean hasNextEditor() {
        SplitPaneState splitPaneState;
        boolean ret = false;
        if (BitField.isSet((int)this._type, (int)15) && (splitPaneState = this._path.getSplitPaneState()) != null) {
            int nbrEditorStates = splitPaneState.getEditorStateCount();
            ret = this._path._editorPos < nbrEditorStates;
        }
        return ret;
    }

    public Object next() {
        Object ret = null;
        switch (this._type) {
            case 1: {
                ret = this._path.getTabGroup();
                this.incrementTabGroup();
                break;
            }
            case 3: {
                ret = this._path.getTabGroupState();
                this.incrementDocumentPos();
                break;
            }
            case 7: {
                ret = this._path.getSplitPaneState();
                this.incrementSplitPaneState();
                break;
            }
            case 15: {
                ret = this._path.getEditorState();
                this.incrementEditorPos();
                break;
            }
        }
        return ret;
    }

    private boolean incrementTabGroup() {
        ++this._path._tabGroupPos;
        Desktop desktop = EditorManagerImpl.getInstance().getDesktop();
        boolean ret = this._path._tabGroupPos < desktop.getTabGroupCount();
        return ret;
    }

    private boolean incrementDocumentPos() {
        boolean ret = false;
        ++this._path._tabGroupStatePos;
        TabGroup tabGroup = this._path.getTabGroup();
        if (tabGroup != null) {
            if (this._path._tabGroupStatePos >= tabGroup.getTabGroupStateCount()) {
                if (this.incrementTabGroup()) {
                    this._path._tabGroupStatePos = 0;
                    ret = true;
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    private boolean incrementSplitPaneState() {
        boolean ret = false;
        ++this._path._panePos;
        TabGroupState tabGroupState = this._path.getTabGroupState();
        if (tabGroupState != null) {
            if (this._path._panePos >= tabGroupState.getSplitPaneStateCount()) {
                if (this.incrementDocumentPos()) {
                    this._path._panePos = 0;
                    ret = true;
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    private boolean incrementEditorPos() {
        boolean ret = false;
        ++this._path._editorPos;
        SplitPaneState splitPaneState = this._path.getSplitPaneState();
        if (splitPaneState != null) {
            if (this._path._editorPos >= splitPaneState.getEditorStateCount()) {
                if (this.incrementSplitPaneState()) {
                    this._path._editorPos = 0;
                    ret = true;
                }
            } else {
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }
}

