/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.util.MetaClass;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableFactory;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorConstants;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.LayoutSelector;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.TextNode;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.IdeMenus;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorAddinRegistry;
import oracle.ideimpl.editor.EditorCreation;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorCustomizationHook;
import oracle.ideimpl.editor.EditorCustomizationOptions;
import oracle.ideimpl.editor.EditorHook;
import oracle.ideimpl.editor.EditorHookRegistration;
import oracle.ideimpl.editor.EditorIterator;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorSelector;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.LastUsedFiles;
import oracle.ideimpl.editor.RecentFilesDockableFactory;
import oracle.ideimpl.editor.RecentFilesLRU;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FeedbackApi(value="editor_window")
public class EditorManagerImpl
extends EditorManager
implements LayoutListener,
ActiveViewListener,
ControllerProvider,
IdeListener {
    static final String FM_API_NAME = "editor_window";
    public static final int MAX_SHORTCUTS = 9;
    public static final int EDITOR_EVENT_OPENED = 1;
    public static final int EDITOR_EVENT_ACTIVATED = 2;
    public static final int EDITOR_EVENT_DEACTIVATED = 3;
    public static final int EDITOR_EVENT_CLOSED = 4;
    private static final EditorSelector EDITOR_SELECTOR;
    private static final int MAX_MENUS = 9;
    private static final int MAX_ACCELERATOR = 9;
    private static EditorManagerImpl INSTANCE;
    private final ArrayList _editorListeners;
    private final HashMap _layoutListener;
    protected final Desktop _desktop;
    private ContextMenu CONTEXT_MENU;
    public static final int CLOSE_OTHERS_CMD_ID;
    public static final int SYSTEM_MENU_CMD_ID;
    public static final int NEXT_PANE_CMD_ID;
    public static final int PREV_PANE_CMD_ID;
    public static final int SPLIT_DOCUMENT_CMD_ID;
    public static final int UNSPLIT_DOCUMENT_CMD_ID;
    public static final int DETACH_DOCUMENT_CMD_ID;
    public static final int REGROUP_DOCUMENTS_CMD_ID;
    public static final int NAVIGATE_LRU_FILES_CMD_ID;
    public static final int MAXIMIZE_TAB_GROUP_CMD_ID;
    public static final int RESTORE_TAB_GROUPS_CMD_ID;
    public static final int TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID;
    private static IdeAction nextPaneAction;
    private static IdeAction prevPaneAction;
    private static IdeAction nextEditorAction;
    private static IdeAction prevEditorAction;
    private static IdeAction splitDocument;
    private static IdeAction unsplitDocument;
    private static IdeAction detachDocument;
    private static IdeAction regroupDocuments;
    private static IdeAction navigateLruFiles;
    private static IdeAction maximizeTabGroup;
    private static IdeAction restoreTabGroup;
    private static IdeAction toggleMaximizeTabGroup;
    private final LinkedList _orderedDocumentList;
    private final int[] _windowListCmdID;
    private int[] _activateCmdId;
    private int[] _assignCmdId;
    private final oracle.ide.util.MultiMap _preferredLayouts;
    private final LinkedList _splitpanePool;
    private static final String EDITOR_FRAME_ID = "EditorFrame";
    protected final HashMap _idsToViews;
    protected final HashMap _viewsToIds;
    private static final boolean DEBUG_TRACE_VIEW_CHANGES;
    private EditorsOptions _editorsOptions;
    private TabGroup _lastActiveTabGroup;
    private SplitPane _lastActiveSplitPane;
    protected RecentFilesLRU _recentFilesLRU;
    protected EditorAddinRegistry _editorAddinRegistry;
    protected static final int EMO_TOP_EDITOR_TABS = 1;
    protected static final int EMO_HIDE_SINGLE_EDITOR_TABS = 2;
    protected static final int EMO_GRADIENT_EDITOR_TABS = 4;
    private static Integer _editorManagerOptions;
    private final Collection<TextBuffer> _openBuffers;
    private final NodeListener _closeListener;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Logger LOG;

    private void $init$() {
        this._editorListeners = new ArrayList(3);
        this._layoutListener = new HashMap();
        this._orderedDocumentList = new LinkedList();
        this._windowListCmdID = new int[9];
        this._preferredLayouts = new oracle.ide.util.MultiMap();
        this._splitpanePool = new LinkedList();
        this._openBuffers = new HashSet<TextBuffer>();
        this._closeListener = new NodeCloseListener(null);
    }

    public EditorManagerImpl() {
        this.$init$();
        this._idsToViews = new HashMap();
        this._viewsToIds = new HashMap();
        this._editorAddinRegistry = new EditorAddinRegistry();
        this._recentFilesLRU = new RecentFilesLRU();
        this._desktop = new Desktop();
    }

    protected static boolean getEditorManagerOption(int option) {
        if (_editorManagerOptions == null) {
            int values = 0;
            EditorCustomizationHook customization = (EditorCustomizationHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorCustomizationHook.ELEMENT);
            if (customization != null) {
                EditorCustomizationOptions options = customization.getCustomizationOptions();
                if (options.isTopTabMode()) {
                    values |= 1;
                }
                if (options.isTabsUseGradient()) {
                    values |= 4;
                }
                if (options.isHideTabsIfSingleEditor()) {
                    values |= 2;
                }
            }
            _editorManagerOptions = values;
        }
        return BitField.isSet((int)_editorManagerOptions, (int)option);
    }

    public void setActiveViewHandler(ActiveViewHandlerImpl activeViewHandler) {
        if (activeViewHandler != null) {
            activeViewHandler.addActiveViewListener(this);
            activeViewHandler.addControllerProvider(this._desktop, this);
        }
    }

    public List getWindowList() {
        ArrayList<JMenuItem> ret = new ArrayList<JMenuItem>();
        Iterator iterator = this._orderedDocumentList.iterator();
        int i = 1;
        while (i <= 9 && iterator.hasNext()) {
            TabGroupState tabGroupState = (TabGroupState)iterator.next();
            Context context = tabGroupState.getContext();
            Node node = context.getNode();
            Icon icon = node.getIcon();
            String label = Integer.toString(i) + " " + node.getShortLabel();
            1 abstractAction = new 1(this, label, icon, tabGroupState);
            JMenuItem menuItem = new JMenuItem(abstractAction);
            menuItem.setMnemonic(48 + i);
            ret.add(menuItem);
            ++i;
        }
        return ret;
    }

    public static EditorManagerImpl createInstance() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = new EditorManagerImpl();
        return INSTANCE;
    }

    public static EditorManagerImpl getInstance() {
        return INSTANCE;
    }

    public void initialize() {
        EditorManagerImpl.registerRecentFilesDockableFactory("System");
        EditorManagerImpl.registerRecentFilesDockableFactory("Application");
        Layouts.getLayouts().addStartupLayoutListener(EDITOR_FRAME_ID, (LayoutListener)this);
        this.createActions();
        KeyStrokeContextRegistry kcr = Ide.getKeyStrokeContextRegistry();
        kcr.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/ideimpl/editor/accelerators.xml");
        Ide.addIdeListener((IdeListener)this);
    }

    private void createActions() {
        Menubar menuMgr = Ide.getMenubar();
        String sWindow = IdeArb.getString((int)477) + " ";
        int i = 0;
        while (i < 9) {
            this._windowListCmdID[i] = Ide.findOrCreateCmdID((String)("WINDOW_" + i + "_CMD_ID"));
            IdeAction action = IdeAction.get((int)this._windowListCmdID[i], null, (String)(sWindow + i), (String)IdeArb.getString((int)421), (Integer)(49 + i), null, (Object)i, (boolean)true);
            action.addController((Controller)this);
            ++i;
        }
        this._activateCmdId = new int[9];
        this._assignCmdId = new int[9];
        String sActivate = IdeImplArb.getString(3);
        String sAssign = IdeImplArb.getString(38);
        int i2 = 0;
        while (i2 < 9) {
            this._activateCmdId[i2] = Ide.findOrCreateCmdID((String)("DOCUMENT_" + (i2 + 1) + "_CMD_ID"));
            Object[] formatStack = new Object[]{i2 + 1};
            IdeAction action = IdeAction.get((int)this._activateCmdId[i2], null, (String)MessageFormat.format(sActivate, formatStack), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)(49 + i2), null, (Object)i2, (boolean)true);
            action.addController((Controller)this);
            this._assignCmdId[i2] = Ide.findOrCreateCmdID((String)("DOCUMENT_ASSIGN_" + (i2 + 1) + "_CMD_ID"));
            action = IdeAction.get((int)this._assignCmdId[i2], null, (String)MessageFormat.format(sAssign, formatStack), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)(49 + i2), null, (Object)i2, (boolean)true);
            action.addController((Controller)this);
            ++i2;
        }
        String closeOthersLabel = IdeImplArb.getString(51);
        IdeAction action = IdeAction.get((int)CLOSE_OTHERS_CMD_ID, null, (String)StringUtils.stripMnemonic((String)closeOthersLabel), (String)IdeMainWindow.ACTION_CATEGORY_FILE, (Integer)StringUtils.getMnemonicKeyCode((String)closeOthersLabel), (ArrayResourceBundle)IdeImplArb.getInstance(), (int)80, null, (boolean)true);
        action.addController((Controller)this);
        String dropDownLabel = IdeImplArb.getString(52);
        IdeAction action2 = IdeAction.get((int)EditorManager.SHOW_DROPDOWN_CMD_ID, null, (String)StringUtils.stripMnemonic((String)dropDownLabel), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)StringUtils.getMnemonicKeyCode((String)dropDownLabel), (ArrayResourceBundle)IdeImplArb.getInstance(), (int)54, null, (boolean)true);
        action2.putValue("LongDescription", (Object)IdeImplArb.getString(57));
        action2.addController((Controller)this);
        String systemMenuLabel = IdeImplArb.getString(60);
        IdeAction action3 = IdeAction.get((int)SYSTEM_MENU_CMD_ID, null, (String)StringUtils.stripMnemonic((String)systemMenuLabel), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)StringUtils.getMnemonicKeyCode((String)systemMenuLabel), (ArrayResourceBundle)IdeImplArb.getInstance(), (int)26, null, (boolean)false);
        action3.addController((Controller)this);
        String text = IdeImplArb.getString(2);
        IdeAction.get((int)70, null, (String)StringUtils.stripMnemonic((String)text), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)StringUtils.getMnemonicKeyCode((String)text), (ArrayResourceBundle)IdeImplArb.getInstance(), (int)34, null, (boolean)true);
        String text2 = IdeImplArb.getString(53);
        IdeAction.get((int)71, null, (String)StringUtils.stripMnemonic((String)text2), (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)StringUtils.getMnemonicKeyCode((String)text2), (ArrayResourceBundle)IdeImplArb.getInstance(), (int)14, null, (boolean)true);
        String text3 = IdeImplArb.getString(29);
        String label = StringUtils.stripMnemonic((String)text3);
        int mnemonicKeyCode = StringUtils.getMnemonicKeyCode((String)text3);
        nextPaneAction = IdeAction.get((int)NEXT_PANE_CMD_ID, null, (String)label, (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)mnemonicKeyCode, (ArrayResourceBundle)IdeImplArb.getInstance(), (int)9, null, (boolean)true);
        nextPaneAction.addController((Controller)this);
        String text4 = IdeImplArb.getString(92);
        String label2 = StringUtils.stripMnemonic((String)text4);
        int mnemonicKeyCode2 = StringUtils.getMnemonicKeyCode((String)text4);
        prevPaneAction = IdeAction.get((int)PREV_PANE_CMD_ID, null, (String)label2, (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)mnemonicKeyCode2, (ArrayResourceBundle)IdeImplArb.getInstance(), (int)36, null, (boolean)true);
        prevPaneAction.addController((Controller)this);
        String text5 = IdeImplArb.getString(77);
        String label3 = StringUtils.stripMnemonic((String)text5);
        int mnemonicKeyCode3 = StringUtils.getMnemonicKeyCode((String)text5);
        nextEditorAction = IdeAction.get((int)40, null, (String)label3, (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)mnemonicKeyCode3, (ArrayResourceBundle)IdeImplArb.getInstance(), (int)41, null, (boolean)true);
        nextEditorAction.addController((Controller)this);
        String text6 = IdeImplArb.getString(58);
        String label4 = StringUtils.stripMnemonic((String)text6);
        int mnemonicKeyCode4 = StringUtils.getMnemonicKeyCode((String)text6);
        prevEditorAction = IdeAction.get((int)41, null, (String)label4, (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)mnemonicKeyCode4, (ArrayResourceBundle)IdeImplArb.getInstance(), (int)83, null, (boolean)true);
        prevEditorAction.addController((Controller)this);
        String text7 = IdeImplArb.getString(70);
        String label5 = StringUtils.stripMnemonic((String)text7);
        int mnemonicKeyCode5 = StringUtils.getMnemonicKeyCode((String)text7);
        splitDocument = IdeAction.get((int)SPLIT_DOCUMENT_CMD_ID, null, (String)label5, (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)mnemonicKeyCode5, (ResourceBundle)IdeImplArb.getInstance(), null, null, (boolean)false);
        splitDocument.addController((Controller)this);
        String text8 = IdeImplArb.getString(11);
        String label6 = StringUtils.stripMnemonic((String)text8);
        int mnemonicKeyCode6 = StringUtils.getMnemonicKeyCode((String)text8);
        unsplitDocument = IdeAction.get((int)UNSPLIT_DOCUMENT_CMD_ID, null, (String)label6, (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)mnemonicKeyCode6, (ResourceBundle)IdeImplArb.getInstance(), null, null, (boolean)false);
        unsplitDocument.addController((Controller)this);
        String text9 = IdeImplArb.getString(69);
        String label7 = StringUtils.stripMnemonic((String)text9);
        int mnemonicKeyCode7 = StringUtils.getMnemonicKeyCode((String)text9);
        detachDocument = IdeAction.get((int)DETACH_DOCUMENT_CMD_ID, null, (String)label7, (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)mnemonicKeyCode7, (ResourceBundle)IdeImplArb.getInstance(), null, null, (boolean)false);
        detachDocument.addController((Controller)this);
        String text10 = IdeImplArb.getString(62);
        String label8 = StringUtils.stripMnemonic((String)text10);
        int mnemonicKeyCode8 = StringUtils.getMnemonicKeyCode((String)text10);
        regroupDocuments = IdeAction.get((int)REGROUP_DOCUMENTS_CMD_ID, null, (String)label8, (String)IdeMainWindow.ACTION_CATEGORY_WINDOWS, (Integer)mnemonicKeyCode8, (ResourceBundle)IdeImplArb.getInstance(), null, null, (boolean)false);
        regroupDocuments.addController((Controller)this);
        String text11 = IdeImplArb.getString(0);
        String label9 = StringUtils.stripMnemonic((String)text11);
        int mnemonicKeyCode9 = StringUtils.getMnemonicKeyCode((String)text11);
        navigateLruFiles = IdeAction.get((int)NAVIGATE_LRU_FILES_CMD_ID, null, (String)label9, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)mnemonicKeyCode9, (ResourceBundle)IdeImplArb.getInstance(), null, null, (boolean)true);
        navigateLruFiles.addController((Controller)this);
        JMenuItem navigateLRUMenuItem = menuMgr.createMenuItem((ToggleAction)navigateLruFiles, MenuConstants.WEIGHT_NAVIGATE_GO_TO_RECENTFILE);
        JMenu navigateMenu = IdeMenus.findOrCreateJMenu("Navigate");
        menuMgr.add((Component)navigateLRUMenuItem, navigateMenu, MenuConstants.SECTION_NAVIGATE_GOTO_ELEMENT);
        String text12 = IdeImplArb.getString(78);
        String label10 = StringUtils.stripMnemonic((String)text12);
        int mnemonicKeyCode10 = StringUtils.getMnemonicKeyCode((String)text12);
        maximizeTabGroup = IdeAction.get((int)MAXIMIZE_TAB_GROUP_CMD_ID, null, (String)label10, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)mnemonicKeyCode10, (ResourceBundle)IdeImplArb.getInstance(), null, null, (boolean)true);
        maximizeTabGroup.addController((Controller)this);
        String text13 = IdeImplArb.getString(33);
        String label11 = StringUtils.stripMnemonic((String)text13);
        int mnemonicKeyCode11 = StringUtils.getMnemonicKeyCode((String)text13);
        restoreTabGroup = IdeAction.get((int)RESTORE_TAB_GROUPS_CMD_ID, null, (String)label11, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)mnemonicKeyCode11, (ResourceBundle)IdeImplArb.getInstance(), null, null, (boolean)true);
        restoreTabGroup.addController((Controller)this);
        String text14 = "Ma&ximize Toggle";
        String label12 = StringUtils.stripMnemonic((String)"Ma&ximize Toggle");
        int mnemonicKeyCode12 = StringUtils.getMnemonicKeyCode((String)"Ma&ximize Toggle");
        toggleMaximizeTabGroup = IdeAction.get((int)TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID, null, (String)label12, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)mnemonicKeyCode12, (ResourceBundle)IdeImplArb.getInstance(), null, null, (boolean)true);
        toggleMaximizeTabGroup.addController((Controller)this);
    }

    public void addinsLoaded(IdeEvent e) {
        this.registerDeclarativeEditors();
        EditorManagerImpl.registerRecentFilesAccordion(NavigatorManager.getApplicationNavigatorManager(), "Application");
    }

    private static void registerRecentFilesDockableFactory(String prefix) {
        String viewType = prefix + "oracle_ideimpl_editor_RecentFiles_VIEW_TYPE";
        String viewName = prefix + "oracle_ideimpl_editor_RecentFiles_VIEW_NAME";
        RecentFilesDockableFactory factory = new RecentFilesDockableFactory(viewName);
        DockStation.getDockStation().registerDockableFactory(viewType, (DockableFactory)factory);
    }

    private static void registerRecentFilesAccordion(NavigatorManager navMan, String prefix) {
        if (navMan != null) {
            String viewType = prefix + "oracle_ideimpl_editor_RecentFiles_VIEW_TYPE";
            String viewName = prefix + "oracle_ideimpl_editor_RecentFiles_VIEW_NAME";
            ViewId viewId = new ViewId(viewType, viewName);
            navMan.registerHostedDockable(viewId);
        }
    }

    public void mainWindowOpened(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
        Desktop desktop = this.getDesktop();
        int tabGroupCount = desktop.getTabGroupCount();
        int i = 0;
        while (i < tabGroupCount) {
            TabGroup tabGroup = desktop.getTabGroup(i);
            int tabGroupStateCount = tabGroup.getTabGroupStateCount();
            int j = 0;
            while (j < tabGroupStateCount) {
                TabGroupState tabGroupState = tabGroup.getTabGroupState(j);
                boolean restorableAtStartup = tabGroupState.isRestorableAtStartup();
                if (!restorableAtStartup) {
                    Context context = tabGroupState.getContext();
                    this.removeFromLRUList(context);
                }
                ++j;
            }
            ++i;
        }
    }

    Desktop getDesktop() {
        return this._desktop;
    }

    public void register(EditorAddin editorAddin, Class[] types) {
        this.extend(editorAddin, types);
    }

    public void unregister(EditorAddin editorAddin) {
        this._editorAddinRegistry.unregister(editorAddin);
    }

    public void extend(EditorAddin editorAddin, Class[] types) {
        this._editorAddinRegistry.extend(editorAddin, types);
    }

    public void registerDynamic(EditorAddin editorAddin) {
        this._editorAddinRegistry.registerDynamic(editorAddin);
    }

    public void unregisterDynamic(EditorAddin editorAddin) {
        this._editorAddinRegistry.unregisterDynamic(editorAddin);
    }

    public boolean isEditorRegistered(Class cls) {
        return this._editorAddinRegistry.isEditorRegistered(cls);
    }

    public EditorAddin getEditorAddin(Class cls) {
        return this._editorAddinRegistry.getEditorAddin(cls);
    }

    List getAddins(Element element) {
        return this._editorAddinRegistry.getAddins(element);
    }

    public boolean hasEditors(Element element) {
        return this._editorAddinRegistry.hasAddins(element);
    }

    private void dumpRegisteredEditors() {
        this._editorAddinRegistry.dumpRegisteredEditors();
    }

    private EditorAddin getBestEditorAddin(Context context) {
        Node node;
        EditorAddin ret = this.getMostRecentEditorAddin(context);
        if (ret == null && (node = context.getNode()) != null) {
            ret = this.getBestEditorAddin(node);
        }
        return ret;
    }

    private EditorAddin getMostRecentEditorAddin(Context context) {
        String editorAddinClass;
        EditorAddin ret = null;
        RecentFile recentFile = this._recentFilesLRU.getRecentFile(context);
        if (recentFile != null && (editorAddinClass = recentFile.getEditor()) != null) {
            ret = this._editorAddinRegistry.getRegisteredEditorAddin(editorAddinClass);
        }
        return ret;
    }

    public EditorAddin getBestEditorAddin(Node node) {
        EditorAddin ret = this.getDefaultAddinPreference(node);
        if (ret == null) {
            ret = this.getDefaultAddin((Element)node);
        }
        return ret;
    }

    private EditorAddin getDefaultAddinPreference(Node node) {
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExts = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        if (documentExts == null) {
            return null;
        }
        Map defaultEditorMap = documentExts.getDefaultEditorMap();
        if (defaultEditorMap == null) {
            return null;
        }
        Class registryDocClass = this._editorAddinRegistry.getRegisteredElementType(node.getClass());
        for (Map.Entry entry : defaultEditorMap.entrySet()) {
            try {
                EditorAddin editorAddin;
                Class<?> docClass = Class.forName((String)entry.getKey());
                if (!docClass.equals(registryDocClass) || (editorAddin = this._editorAddinRegistry.getRegisteredEditorAddin((String)entry.getValue())) == null || !this.getAddins((Element)node).contains(editorAddin)) continue;
                EditorAddin editorAddin2 = editorAddin;
                return editorAddin2;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        return null;
    }

    public EditorAddin getDefaultAddin(Element element) {
        EditorAddin ret = null;
        List addins = this.getAddins(element);
        if (!addins.isEmpty()) {
            ret = (EditorAddin)addins.get(0);
        }
        return ret;
    }

    public EditorAddin[] getStaticAddins(Class elementClass) {
        return this._editorAddinRegistry.getStaticAddins(elementClass).toArray(new EditorAddin[0]);
    }

    public Class[] getStaticElementTypes() {
        return this._editorAddinRegistry.getStaticElementTypes().toArray(new Class[0]);
    }

    public void addEditorListener(EditorListener listener) {
        this._editorListeners.add(listener);
    }

    public void removeEditorListener(EditorListener listener) {
        this._editorListeners.remove(listener);
    }

    private void fireEditorEvent(int eventID, Editor editor) {
        EditorManagerImpl.traceEditorEvent(eventID, editor);
        List dup = (List)this._editorListeners.clone();
        int i = 0;
        while (i < dup.size()) {
            EditorListener editorListener = (EditorListener)dup.get(i);
            try {
                switch (eventID) {
                    case 1: {
                        long startTime = System.nanoTime();
                        editorListener.editorOpened(editor);
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log("EditorListener.editorOpened", editorListener.getClass().getName(), endTime - startTime);
                        break;
                    }
                    case 2: {
                        long startTime = System.nanoTime();
                        editorListener.editorActivated(editor);
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log("EditorListener.editorActivated", editorListener.getClass().getName(), endTime - startTime);
                        break;
                    }
                    case 3: {
                        long startTime = System.nanoTime();
                        editorListener.editorDeactivated(editor);
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log("EditorListener.editorDeactivated", editorListener.getClass().getName(), endTime - startTime);
                        break;
                    }
                    case 4: {
                        long startTime = System.nanoTime();
                        editorListener.editorClosed(editor);
                        long endTime = System.nanoTime();
                        PerformanceLogger.get().log("EditorListener.editorClosed", editorListener.getClass().getName(), endTime - startTime);
                        break;
                    }
                }
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
            ++i;
        }
    }

    public void addLayoutListener(String editorId, BaseLayoutListener listener) {
        this._layoutListener.put(editorId, listener);
    }

    public void removeLayoutListener(String editorId) {
        this._layoutListener.remove(editorId);
    }

    public void registerPreferredLayoutListener(Class docClass, Class editorClass, String preferredLayoutBaseName, PreferredLayoutListener listener) {
        this._preferredLayouts.add((Object)editorClass, (Object)new Object[]{docClass, preferredLayoutBaseName, listener});
    }

    void initPreferredLayoutInfo(Editor editor, Context context) {
        Class editorClass = editor.getClass();
        Object[] bestLayoutListener = null;
        List list = this._preferredLayouts.get((Object)editorClass);
        if (list != null) {
            Class nodeClass;
            Node node = context.getNode();
            Class searchNodeClass = nodeClass = node.getClass();
            while (searchNodeClass != null) {
                int i = 0;
                while (i < list.size()) {
                    Object[] layoutListenerInfo = (Object[])list.get(i);
                    Class layoutListenerNodeClass = (Class)layoutListenerInfo[0];
                    if (searchNodeClass == layoutListenerNodeClass) {
                        bestLayoutListener = layoutListenerInfo;
                        break;
                    }
                    if (layoutListenerNodeClass.isAssignableFrom(searchNodeClass)) {
                        bestLayoutListener = layoutListenerInfo;
                    }
                    ++i;
                }
                searchNodeClass = searchNodeClass.getSuperclass();
            }
            if (bestLayoutListener != null) {
                PreferredLayoutListener listener = (PreferredLayoutListener)bestLayoutListener[2];
                editor.addPreferredLayoutListener(listener);
                String preferredLayoutBaseName = (String)bestLayoutListener[1];
                editor.setPreferredLayoutBaseName(preferredLayoutBaseName);
                String type = nodeClass.getName() + "-" + editorClass.getName();
                editor.setType(type);
            }
        }
    }

    public boolean searchEditor(EditorPathImpl editorPath, EditorCriteriaImpl editorCriteria) {
        boolean ret = false;
        int tabGroupCount = this._desktop.getTabGroupCount();
        int i = 0;
        while (!ret && i < tabGroupCount) {
            TabGroup tabGroup = this._desktop.getTabGroup(i);
            if (tabGroup.match(editorCriteria) || tabGroup.searchEditor(editorPath, editorCriteria)) {
                editorPath._tabGroupPos = i;
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public JComponent getDesktopComponent() {
        return this.getDesktop();
    }

    SplitPane createSplitPane() {
        SplitPane splitPane = this._splitpanePool.isEmpty() ? new SplitPane() : (SplitPane)this._splitpanePool.removeFirst();
        return splitPane;
    }

    void releaseSplitPane(SplitPane splitPane) {
        this._splitpanePool.addFirst(splitPane);
    }

    public Editor openDefaultEditorInFrame(Context context) {
        Editor editor = null;
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
            this.focusEditor(editorPath);
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            editor = tabGroupState.getCurrentEditor();
            EditorManagerImpl.updateContext(editor, context);
        } else {
            EditorAddin addin = this.getBestEditorAddin(context);
            if (addin != null) {
                Class editorClass = addin.getEditorClass();
                editor = this.openEditorInFrame(editorClass, context);
            }
        }
        return editor;
    }

    private static void updateContext(Editor editor, Context context) {
        Context editorContext = editor.getContext();
        if (ModelUtil.areDifferent((Object)editorContext.getProject(), (Object)context.getProject()) || ModelUtil.areDifferent((Object)editorContext.getWorkspace(), (Object)context.getWorkspace())) {
            editor.setContext(context);
        }
    }

    public Editor openEditorInFrame(Class editorClass, Context context) {
        Editor ret = null;
        WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        try {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.focusEditor(editorClass, context, editorPath)) {
                EditorState editorState = editorPath.getEditorState();
                ret = editorState.getEditor();
                EditorManagerImpl.updateContext(ret, context);
            } else {
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, editorClass);
                if (this.createEditor(openEditorOptions, editorPath)) {
                    EditorState editorState = editorPath.getEditorState();
                    ret = editorState.getEditor();
                }
            }
        }
        finally {
            wc.hide();
        }
        return ret;
    }

    public Editor openEditor(OpenEditorOptions openEditorOptions) {
        EditorState editorState;
        EditorCriteriaImpl editorCriteria;
        Editor editor = null;
        EditorPathImpl editorPath = new EditorPathImpl();
        Context context = openEditorOptions.getContext();
        Class editorClass = openEditorOptions.getEditorClass();
        if (editorClass == null) {
            editorCriteria = new EditorCriteriaImpl(context);
            EditorAddin editorAddin = this.getBestEditorAddin(context);
            if (editorAddin != null) {
                openEditorOptions.setEditorClass(editorAddin.getEditorClass());
            }
        } else {
            editorCriteria = new EditorCriteriaImpl(context, editorClass);
        }
        if (this.searchEditor(editorPath, editorCriteria)) {
            int openFlags = openEditorOptions.getFlags();
            if (BitField.isSet((int)openFlags, (int)1)) {
                if (BitField.isSet((int)openFlags, (int)5)) {
                    this.focusEditor(editorPath);
                } else {
                    this.activateEditor(editorPath);
                }
            }
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            editor = tabGroupState.getCurrentEditor();
            EditorManagerImpl.updateContext(editor, context);
        } else if (this.createEditor(openEditorOptions, editorPath) && (editorState = editorPath.getEditorState()) != null) {
            editor = editorState.getEditor();
        }
        return editor;
    }

    boolean focusEditor(EditorPathImpl editorPath) {
        boolean ret = false;
        if (this.activateEditor(editorPath)) {
            TabGroup tabGroup = editorPath.getTabGroup();
            tabGroup.focusCurrentEditor();
            ret = true;
        }
        return ret;
    }

    private void focusActiveEditor() {
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.getCurrentEditorPath(editorPath)) {
            this.focusEditor(editorPath);
        }
    }

    private boolean focusEditor(Class editorClass, Context context, EditorPathImpl editorPath) {
        boolean ret = false;
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(context, editorClass);
        if (this.searchEditor(editorPath, editorCriteria) && this.focusEditor(editorPath)) {
            ret = true;
        }
        return ret;
    }

    private void holdOnToBuffer(Node node) {
        if (!(node instanceof TextNode)) {
            return;
        }
        TextBuffer b = ((TextNode)node).acquireTextBuffer();
        this._openBuffers.add(b);
        node.addNodeListener(this._closeListener);
    }

    boolean createEditor(OpenEditorOptions openEditorOptions, EditorPathImpl editorPath) {
        List editorAddins;
        boolean ret = false;
        Context context = openEditorOptions.getContext();
        Node node = context.getNode();
        if (node != null && !(editorAddins = this.getAddins((Element)node)).isEmpty()) {
            EditorCreation editorCreation = new EditorCreation();
            editorCreation.setOpenEditorOptions(openEditorOptions);
            editorCreation.setEditorAddins(editorAddins);
            editorCreation.setEditorPath(editorPath);
            if (this.createEditor(editorCreation)) {
                this.holdOnToBuffer(node);
                ret = true;
            }
        }
        return ret;
    }

    private boolean createEditor(EditorCreation editorCreation) {
        boolean isNewTabGroup;
        TabGroup tabGroup;
        boolean ret = false;
        Desktop desktop = this.getDesktop();
        EditorPathImpl editorPath = editorCreation.getEditorPath();
        int refPosition = 0;
        TabGroup refTabGroup = null;
        OpenEditorOptions openEditorOptions = editorCreation.getOpenEditorOptions();
        EditorPath positionReference = openEditorOptions.getPositionReference();
        if (positionReference instanceof EditorPathImpl) {
            EditorPathImpl refEditorPath = (EditorPathImpl)positionReference;
            refTabGroup = refEditorPath.getTabGroup();
            refPosition = openEditorOptions.getPosition();
        }
        if (editorPath._tabGroupPos == -1) {
            int currentTabGroupPos = desktop.getCurrentTabGroupPos();
            if (currentTabGroupPos == -1) {
                tabGroup = new TabGroup();
                isNewTabGroup = true;
            } else if (refTabGroup != null) {
                if (refPosition == 4) {
                    tabGroup = refTabGroup;
                    isNewTabGroup = false;
                    this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroup));
                } else {
                    tabGroup = new TabGroup();
                    isNewTabGroup = true;
                }
            } else {
                editorPath._tabGroupPos = currentTabGroupPos;
                tabGroup = desktop.getTabGroup(currentTabGroupPos);
                isNewTabGroup = false;
            }
        } else {
            tabGroup = desktop.getTabGroup(editorPath._tabGroupPos);
            isNewTabGroup = false;
        }
        if (tabGroup.addTabGroupState(editorCreation)) {
            int creationFlags;
            if (isNewTabGroup) {
                DockLayoutConstraint constraint = new DockLayoutConstraint(refTabGroup, refPosition, 1, null);
                editorPath._tabGroupPos = desktop.addTabGroup(tabGroup, constraint);
            }
            if (BitField.isSet((int)(creationFlags = openEditorOptions.getFlags()), (int)1)) {
                ret = tabGroup.activateEditor(editorPath);
                if (ret) {
                    EditorState editorState = editorPath.getEditorState();
                    EditorAddin editorAddin = editorState.getEditorAddin();
                    Context context = openEditorOptions.getContext();
                    this.raiseContextInLRUList(context, editorAddin);
                } else if (editorPath._tabGroupStatePos != -1) {
                    tabGroup.closeTabGroupState(editorPath._tabGroupStatePos);
                }
            } else {
                ret = true;
            }
            if (ret) {
                if (BitField.isSet((int)creationFlags, (int)8)) {
                    Context context = openEditorOptions.getContext();
                    this._recentFilesLRU.setExplicit(context, true);
                }
                if (BitField.isSet((int)creationFlags, (int)2)) {
                    tabGroup.validate();
                }
                if (BitField.isSet((int)creationFlags, (int)5)) {
                    tabGroup.focusCurrentEditor();
                }
            }
        }
        return ret;
    }

    public boolean activateEditor(EditorPathImpl editorPath) {
        return this.getDesktop().activateEditor(editorPath);
    }

    public void activateCurrentEditorFrame() {
        int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
        if (currentTabGroupPos != -1) {
            TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
            tabGroup.focusCurrentEditor();
        }
    }

    public List findEditors(Context context) {
        ArrayList list = new ArrayList();
        int tabGroupCount = this._desktop.getTabGroupCount();
        int i = 0;
        while (i < tabGroupCount) {
            TabGroup tabGroup = this._desktop.getTabGroup(i);
            List subList = tabGroup.findEditors(context);
            list.addAll(subList);
            ++i;
        }
        return list;
    }

    public List getAllEditors() {
        ArrayList list = new ArrayList();
        int tabGroupCount = this._desktop.getTabGroupCount();
        int i = 0;
        while (i < tabGroupCount) {
            TabGroup tabGroup = this._desktop.getTabGroup(i);
            List subList = tabGroup.getAllEditors();
            list.addAll(subList);
            ++i;
        }
        return list;
    }

    public Editor getCurrentEditor() {
        Editor ret = null;
        int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
        if (currentTabGroupPos != -1) {
            TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
            ret = tabGroup.getCurrentEditor();
        }
        return ret;
    }

    public JComponent getDesktopBackground() {
        return this.getDesktop().getDesktopBackground();
    }

    private boolean getCurrentEditorPath(EditorPathImpl editorPath) {
        return this._desktop.getCurrentEditorPath(editorPath);
    }

    public final synchronized ContextMenu getContextMenu() {
        if (this.CONTEXT_MENU == null) {
            this.CONTEXT_MENU = new ContextMenu(new MnemonicSolver());
            this.CONTEXT_MENU.addContextMenuListener((ContextMenuListener)new 2());
            IdeAction action = IdeAction.find((int)57);
            EditorConstants.NAVIGATE_ITEM = this.CONTEXT_MENU.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_NAVIGATE_SELECT_IN_NAVIGATOR);
            action = IdeAction.find((int)5);
            EditorConstants.UNDO_ITEM = this.CONTEXT_MENU.createMenuItem((ToggleAction)action, 1.0f);
            action = IdeAction.find((int)6);
            EditorConstants.REDO_ITEM = this.CONTEXT_MENU.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_REDO);
            action = IdeAction.find((int)17);
            EditorConstants.CUT_ITEM = this.CONTEXT_MENU.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_CUT);
            action = IdeAction.find((int)18);
            EditorConstants.COPY_ITEM = this.CONTEXT_MENU.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_COPY);
            action = IdeAction.find((int)19);
            EditorConstants.PASTE_ITEM = this.CONTEXT_MENU.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_PASTE);
            action = IdeAction.find((int)78);
            EditorConstants.EXTENDED_PASTE_ITEM = this.CONTEXT_MENU.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_EXTENDED_PASTE);
            action = IdeAction.find((int)22);
            EditorConstants.ALL_ITEM = this.CONTEXT_MENU.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_SELECT_ALL);
            ContextMenuListenersHook hook = (ContextMenuListenersHook)javax.ide.extension.ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            if (hook != null) {
                this.CONTEXT_MENU.addContextMenuListener(hook.getListener("editor"));
            }
        }
        return this.CONTEXT_MENU;
    }

    public void replaceEditors(Context oldContext, Context newContext) {
        EditorPathImpl editorPath = new EditorPathImpl();
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(oldContext);
        if (this.searchEditor(editorPath, editorCriteria)) {
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            tabGroupState.setContext(newContext);
        }
    }

    public List getEditorsInfo() {
        ArrayList list = new ArrayList();
        EditorIterator toAdd = new EditorIterator(15);
        IdeUtil.addAll(list, (Iterator)toAdd);
        return list;
    }

    public void closeEditors(List listEditors) {
        EditorState[] editorStates = new EditorState[listEditors.size()];
        int i = 0;
        while (i < listEditors.size()) {
            Editor editor;
            EditorPathImpl editorPath;
            Object o = listEditors.get(i);
            if (o instanceof EditorState) {
                editorStates[i] = (EditorState)o;
            } else if (o instanceof Editor && this.searchEditor(editorPath = new EditorPathImpl(), new EditorCriteriaImpl(editor = (Editor)o))) {
                editorStates[i] = editorPath.getEditorState();
            }
            ++i;
        }
        this.closeEditors(editorStates);
    }

    private void closeEditors(EditorState[] editorStates) {
        HashSet<TabGroupState> tabGroupStateSet = new HashSet<TabGroupState>();
        int i = 0;
        while (i < editorStates.length) {
            EditorState editorState = editorStates[i];
            SplitPaneState parentSplitPaneState = editorState.getParentSplitPaneState();
            TabGroupState parentTabGroupState = parentSplitPaneState.getParentTabGroupState();
            tabGroupStateSet.add(parentTabGroupState);
            ++i;
        }
        TabGroupState[] tabGroupStates = tabGroupStateSet.toArray(new TabGroupState[tabGroupStateSet.size()]);
        this.closeEditors(tabGroupStates);
    }

    static {
        $assertionsDisabled = EditorManagerImpl.class.desiredAssertionStatus() ^ true;
        EDITOR_SELECTOR = EditorSelector.getInstance();
        CLOSE_OTHERS_CMD_ID = Ide.findOrCreateCmdID((String)"CLOSE_OTHERS_CMD_ID");
        SYSTEM_MENU_CMD_ID = Ide.findOrCreateCmdID((String)"SYSTEM_MENU_CMD_ID");
        NEXT_PANE_CMD_ID = Ide.findOrCreateCmdID((String)"NEXT_PANE_CMD_ID");
        PREV_PANE_CMD_ID = Ide.findOrCreateCmdID((String)"PREV_PANE_CMD_ID");
        SPLIT_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID((String)"SPLIT_DOCUMENT_CMD_ID");
        UNSPLIT_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID((String)"UNSPLIT_DOCUMENT_CMD_ID");
        DETACH_DOCUMENT_CMD_ID = Ide.findOrCreateCmdID((String)"DETACH_DOCUMENT_CMD_ID");
        REGROUP_DOCUMENTS_CMD_ID = Ide.findOrCreateCmdID((String)"REGROUP_DOCUMENTS_CMD_ID");
        NAVIGATE_LRU_FILES_CMD_ID = Ide.findOrCreateCmdID((String)"NAVIGATE_LRU_FILES_CMD_ID");
        MAXIMIZE_TAB_GROUP_CMD_ID = Ide.findOrCreateCmdID((String)"MAXIMIZE_TAB_GROUP_CMD_ID");
        RESTORE_TAB_GROUPS_CMD_ID = Ide.findOrCreateCmdID((String)"RESTORE_TAB_GROUPS_CMD_ID");
        TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID = Ide.findOrCreateCmdID((String)"TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID");
        DEBUG_TRACE_VIEW_CHANGES = Boolean.valueOf(Ide.getProperty((String)"DEBUG_TRACE_VIEW_CHANGES", (String)"false"));
        LOG = Logger.getLogger(EditorManagerImpl.class.getName());
    }

    public void closeEditors(TabGroupState[] tabGroupStates) {
        Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean refocusEditor = permanentFocusOwner == null ? false : SwingUtilities.isDescendingFrom(permanentFocusOwner, this.getDesktop());
        this.getDesktop().freezeFocusChanges(true);
        HashSet<TabGroupState> tabGroupStateSet = new HashSet<TabGroupState>(Arrays.asList(tabGroupStates));
        HashSet<Node> documentsToClose = new HashSet<Node>();
        HashSet<Node> docsThatStayOpen = new HashSet<Node>();
        MultiMap contextsAndDocs = new MultiMap();
        int tabGroupCount = this.getDesktop().getTabGroupCount();
        int i = 0;
        while (i < tabGroupCount) {
            TabGroup tabGroup = this.getDesktop().getTabGroup(i);
            int tabGroupStateCount = tabGroup.getTabGroupStateCount();
            int j = 0;
            while (j < tabGroupStateCount) {
                TabGroupState tabGroupState = tabGroup.getTabGroupState(j);
                boolean isClosing = tabGroupStateSet.contains(tabGroupState);
                Context context = new Context(tabGroupState.getContext());
                Node node = context.getNode();
                if (isClosing) {
                    documentsToClose.add(node);
                    contextsAndDocs.add((Object)context, (Object)node);
                } else {
                    docsThatStayOpen.add(node);
                }
                int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
                int k = 0;
                while (k < splitPaneStateCount) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(k);
                    int nbrEditorStates = splitPaneState.getEditorStateCount();
                    int l = 0;
                    while (l < nbrEditorStates) {
                        Node[] dependentNodes;
                        EditorState editorState = splitPaneState.getEditorState(l);
                        Editor editor = editorState.getEditor();
                        if (editor != null && (dependentNodes = editor.getDependentNodes()) != null) {
                            int m = 0;
                            while (m < dependentNodes.length) {
                                Node dependentNode = dependentNodes[m];
                                if (isClosing) {
                                    documentsToClose.add(dependentNode);
                                    contextsAndDocs.add((Object)context, (Object)dependentNode);
                                } else {
                                    docsThatStayOpen.add(dependentNode);
                                }
                                ++m;
                            }
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        for (Collection nodes : contextsAndDocs.values()) {
            nodes.removeAll(docsThatStayOpen);
        }
        documentsToClose.removeAll(docsThatStayOpen);
        IdeAction closeNodeAction = IdeActions.getFileCloseAction();
        String closeNodeCommand = closeNodeAction.getCommand();
        Command closeNodeCommandObject = CommandProcessor.createCommand((String)closeNodeCommand, (Context)new Context());
        CloseNodeCommand cmd = closeNodeCommandObject instanceof CloseNodeCommand ? (CloseNodeCommand)closeNodeCommandObject : new CloseNodeCommand();
        int status = cmd.checkSave(documentsToClose.iterator());
        if (status != 1) {
            int tabGroupCount2 = this._desktop.getTabGroupCount();
            int i2 = tabGroupCount2 - 1;
            while (i2 >= 0) {
                TabGroup tabGroup = this._desktop.getTabGroup(i2);
                tabGroup.close(tabGroupStates);
                --i2;
            }
            for (Map.Entry entry : contextsAndDocs.entrySet()) {
                Context context = (Context)entry.getKey();
                Collection lstDocs = (Collection)entry.getValue();
                cmd.setContext(context);
                cmd.clearAffectedNodes();
                if (!$assertionsDisabled && lstDocs == null) {
                    throw new AssertionError((Object)("Bug 6157300 occurred with context " + context));
                }
                status = cmd.close(lstDocs.iterator(), context, false, true);
                if (status == 1) break;
                this._recentFilesLRU.setExplicit(context, false);
            }
        }
        this.getDesktop().freezeFocusChanges(false);
        if (refocusEditor) {
            this.focusActiveEditor();
        }
    }

    public void activateEditor(EditorInfo editorInfo) {
        EditorPathImpl editorPath = new EditorPathImpl();
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(editorInfo);
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        if (editorManager.searchEditor(editorPath, editorCriteria)) {
            this.activateEditor(editorPath);
        }
    }

    public void setExplicit(Editor editor, boolean explicit) {
        Context context = editor.getContext();
        this._recentFilesLRU.setExplicit(context, explicit);
    }

    void raiseContextInLRUList(Context context, EditorAddin editorAddin) {
        String editorClassName = null;
        boolean canRaise = true;
        if (editorAddin != null) {
            canRaise = EditorManagerImpl.isRestorable(context, editorAddin);
            Class editorClass = editorAddin.getClass();
            editorClassName = editorClass.getName();
        }
        if (canRaise) {
            this._recentFilesLRU.raiseContextInLRUList(context, editorClassName);
        }
    }

    public static boolean isRestorable(Context context, EditorAddin editorAddin) {
        if (Boolean.FALSE.equals(editorAddin.getAttribute((Object)"no-recent-file"))) {
            return false;
        }
        if (context == null) {
            return false;
        }
        Node node = context.getNode();
        if (node == null) {
            return false;
        }
        URL url = node.getURL();
        if (url == null) {
            return false;
        }
        String protocol = url.getProtocol();
        if (protocol == null) {
            return false;
        }
        if (protocol.startsWith("ide.")) {
            return false;
        }
        Boolean restorable = (Boolean)editorAddin.getAttribute((Object)"restorable-from-url");
        return restorable == null ? true : restorable;
    }

    void removeFromLRUList(Context context) {
        this._recentFilesLRU.remove(context);
    }

    private static int getExplicitNumber() {
        EditorIterator editorIterator = new EditorIterator(3);
        ArrayList tabGroupStates = Collections.list(editorIterator);
        Collections.sort(tabGroupStates, new 3());
        int i = 0;
        while (i < tabGroupStates.size()) {
            TabGroupState tabGroupState = (TabGroupState)tabGroupStates.get(i);
            if (tabGroupState.isExplicit()) break;
            ++i;
        }
        int found = 0;
        while (i < tabGroupStates.size()) {
            TabGroupState tabGroupState = (TabGroupState)tabGroupStates.get(i);
            int assignedNumber = tabGroupState.getNodeNumber();
            if (found < assignedNumber) break;
            ++i;
            ++found;
        }
        if (found >= 9) {
            found = -1;
        }
        return found;
    }

    EditorsOptions getEditorsOptions() {
        if (this._editorsOptions == null) {
            ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.ide");
            this._editorsOptions = (EditorsOptions)settings.getData("editors-options");
            if (this._editorsOptions == null) {
                this._editorsOptions = new EditorsOptions();
                settings.putData("editors-options", (Copyable)this._editorsOptions);
            }
        }
        return this._editorsOptions;
    }

    public EditorPath searchEditor(Node node) {
        EditorPathImpl ret = null;
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(node))) {
            ret = editorPath;
        }
        return ret;
    }

    public void addView(ViewId id, View view) {
        this._idsToViews.put(id, view);
        this._viewsToIds.put(view, id);
    }

    public View getView(ViewId id) {
        return (View)this._idsToViews.get(id);
    }

    public void removeView(View view) {
        Object id = this._viewsToIds.get(view);
        if (id != null) {
            this._idsToViews.remove(id);
            this._viewsToIds.remove(view);
        }
    }

    public void addOpenedViews(Layout layout, List openedList) {
        Iterator iterator = this._viewsToIds.keySet().iterator();
        while (iterator.hasNext()) {
            openedList.add(iterator.next());
        }
    }

    public void save(Layout layout) {
        this.getDesktop().saveLayout();
        for (BaseLayoutListener listener : this._layoutListener.values()) {
            try {
                long startTime = System.nanoTime();
                listener.save(layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.save", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    public void init(Layout layout) {
        Assert.startTiming((String)(this.getClass().getName() + ".init"), (String)"Restoring opened editors...", (boolean)false);
        this.getDesktop().loadLayout();
        for (BaseLayoutListener listener : this._layoutListener.values()) {
            try {
                long startTime = System.nanoTime();
                listener.init(layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.init", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
        Assert.endTiming((String)(this.getClass().getName() + ".init"), (String)"Restored open editors", null, (boolean)false);
    }

    public void close(Layout layout) {
    }

    public void activeViewChanged(ActiveViewEvent e) {
        View newView;
        View oldView = e.getOldView();
        if (oldView instanceof Editor) {
            Editor editor = (Editor)oldView;
            this.fireEditorEvent(3, editor);
        }
        if ((newView = e.getNewView()) instanceof Editor) {
            Editor editor = (Editor)newView;
            this.fireEditorEvent(2, editor);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == 48 || commandId == 70 || commandId == 71 || commandId == NEXT_PANE_CMD_ID || commandId == PREV_PANE_CMD_ID || commandId == 40 || commandId == 41 || commandId == 42 || commandId == 43 || this.isGoto_n(action) || this.isWindow_n(action)) {
            this.handleWithoutFocus(action, context, false);
        } else if (commandId == SYSTEM_MENU_CMD_ID) {
            this.whenShowSystemMenu();
        } else if (commandId == NAVIGATE_LRU_FILES_CMD_ID) {
            this.whenNavigateLRUFiles();
        } else if (commandId == EditorManager.SHOW_DROPDOWN_CMD_ID) {
            Desktop desktop = this.getDesktop();
            int currentTabGroupPos = desktop.getCurrentTabGroupPos();
            if (currentTabGroupPos != -1) {
                TabGroup tabGroup = desktop.getTabGroup(currentTabGroupPos);
                tabGroup.showDropDownMenu();
            }
        } else if (commandId == CLOSE_OTHERS_CMD_ID) {
            this.whenCloseOthers(context);
        } else if (commandId == 39) {
            List editorsInfo = this.getEditorsInfo();
            this.closeEditors(editorsInfo);
        } else if (commandId == MAXIMIZE_TAB_GROUP_CMD_ID) {
            this.whenMaximizeTabGroup(context);
        } else if (commandId == RESTORE_TAB_GROUPS_CMD_ID) {
            this.whenRestoreTabGroups();
        } else if (commandId == TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID) {
            if (this.isTabGroupMaximized(context)) {
                this.whenRestoreTabGroups();
            } else {
                this.whenMaximizeTabGroup(context);
            }
        } else if (commandId == SPLIT_DOCUMENT_CMD_ID) {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                this.activateEditor(editorPath);
                TabGroupState tabGroupState = editorPath.getTabGroupState();
                int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
                boolean done = false;
                int splitPaneStatePos = 0;
                while (!done && splitPaneStatePos < splitPaneStateCount) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(splitPaneStatePos);
                    if (splitPaneState.isSplitable()) {
                        editorPath._panePos = splitPaneStatePos;
                        TabGroup tabGroup = editorPath.getTabGroup();
                        tabGroup.splitPane(editorPath);
                        done = true;
                    }
                    ++splitPaneStatePos;
                }
            }
        } else if (commandId == UNSPLIT_DOCUMENT_CMD_ID) {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                this.activateEditor(editorPath);
                TabGroup tabGroup = editorPath.getTabGroup();
                tabGroup.getCurrentEditorPath(editorPath);
                tabGroup.unsplitPane(editorPath);
                editorPath._panePos = 0;
                tabGroup.activateEditor(editorPath);
                this._desktop.revalidate();
            }
        } else if (commandId == DETACH_DOCUMENT_CMD_ID) {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                this._desktop.detachEditor(editorPath);
            }
        } else if (commandId == REGROUP_DOCUMENTS_CMD_ID) {
            this._desktop.reattachEditors();
        } else if (commandId == 51) {
            this.whenRefresh();
        } else if (!this.handleAssign_n(action)) {
            return false;
        }
        return true;
    }

    private void updateRefresh(IdeAction action) {
        boolean isEnabled = false;
        Editor currentEditor = this.getCurrentEditor();
        if (currentEditor != null) {
            Context context = currentEditor.getContext();
            Node node = context.getNode();
            if (node != null) {
                isEnabled = true;
            }
            action.setEnabled(isEnabled);
        }
    }

    private void whenRefresh() {
        Editor currentEditor = this.getCurrentEditor();
        Context context = currentEditor.getContext();
        Node node = context.getNode();
        if (node != null) {
            NodeUtil.reloadBuffers(Collections.singletonList(node), (boolean)true);
        }
    }

    private void whenNavigateLRUFiles() {
        RecentFile[] recentFiles = this._recentFilesLRU.getRecentFiles();
        IdeMainWindow mainWindow = Ide.getMainWindow();
        LastUsedFiles.runDialog((Frame)mainWindow, recentFiles);
    }

    private void handleWithoutFocus(IdeAction action, Context context, boolean focusEditor) {
        int commandId = action.getCommandId();
        if (commandId == 48) {
            this.whenCloseEditor(context);
        } else if (commandId == 70) {
            this.whenActivateLeftNode();
        } else if (commandId == 71) {
            this.whenActivateRightNode();
        } else if (commandId == NEXT_PANE_CMD_ID || commandId == PREV_PANE_CMD_ID) {
            Desktop desktop = this.getDesktop();
            int currentTabGroupPos = desktop.getCurrentTabGroupPos();
            TabGroup tabGroup = desktop.getTabGroup(currentTabGroupPos);
            TabGroupState currentTabGroupState = tabGroup.getCurrentTabGroupState();
            currentTabGroupState.handleEvent(commandId);
        } else if (commandId == 40 || commandId == 41) {
            Desktop desktop = this.getDesktop();
            int currentTabGroupPos = desktop.getCurrentTabGroupPos();
            TabGroup tabGroup = desktop.getTabGroup(currentTabGroupPos);
            TabGroupState currentTabGroupState = tabGroup.getCurrentTabGroupState();
            SplitPane currentSplitPane = currentTabGroupState.getCurrentSplitPane();
            currentSplitPane.handleEvent(commandId);
        } else if (commandId == 42) {
            this.whenNextEditorFrame(context);
        } else if (commandId == 43) {
            this.whenPrevEditorFrame(context);
        } else if (this.handleGoto_n(action) || this.handleWindow_n(action)) {
            // empty if block
        }
        if (focusEditor) {
            this.focusActiveEditor();
        }
    }

    private boolean isGoto_n(IdeAction action) {
        int commandId = action.getCommandId();
        int i = 0;
        while (i < this._activateCmdId.length) {
            int assignCmdId = this._activateCmdId[i];
            if (assignCmdId == commandId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean handleGoto_n(IdeAction action) {
        int commandId = action.getCommandId();
        int i = 0;
        while (i < this._activateCmdId.length) {
            int assignCmdId = this._activateCmdId[i];
            if (assignCmdId == commandId) {
                EditorPathImpl editorPath = new EditorPathImpl();
                if (this.searchEditor(editorPath, new EditorCriteriaImpl(i))) {
                    this.activateEditor(editorPath);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean handleAssign_n(IdeAction action) {
        int commandId = action.getCommandId();
        int i = 0;
        while (i < this._assignCmdId.length) {
            int assignCmdId = this._assignCmdId[i];
            if (assignCmdId == commandId) {
                EditorPathImpl currentEditorPath = new EditorPathImpl();
                if (this.getCurrentEditorPath(currentEditorPath)) {
                    TabGroupState currentTabGroupState = currentEditorPath.getTabGroupState();
                    TabGroupState reassignTabGroupState = null;
                    EditorPathImpl reassignEditorPath = new EditorPathImpl();
                    if (this.searchEditor(reassignEditorPath, new EditorCriteriaImpl(i))) {
                        reassignTabGroupState = reassignEditorPath.getTabGroupState();
                    }
                    if (reassignTabGroupState == null) {
                        currentTabGroupState.setNodeNumber(i);
                    } else if (reassignTabGroupState != currentTabGroupState) {
                        reassignTabGroupState.setNodeNumber(-1);
                        currentTabGroupState.setNodeNumber(i);
                        int newNumber = EditorManagerImpl.getExplicitNumber();
                        reassignTabGroupState.setNodeNumber(newNumber);
                    }
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isWindow_n(IdeAction action) {
        int commandId = action.getCommandId();
        TabGroupState tabGroupState = this.getTabGroupStateFromWindowMenu(commandId);
        return tabGroupState != null;
    }

    private boolean handleWindow_n(IdeAction action) {
        int commandId = action.getCommandId();
        TabGroupState tabGroupState = this.getTabGroupStateFromWindowMenu(commandId);
        if (tabGroupState != null) {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroupState))) {
                this.activateEditor(editorPath);
            }
            return true;
        }
        return false;
    }

    private void whenMaximizeTabGroup(Context context) {
        TabGroup tabGroup = this.getTabGroupFromContext(context);
        Desktop desktop = this.getDesktop();
        desktop.maximizeTabGroup(tabGroup);
    }

    private void whenRestoreTabGroups() {
        Desktop desktop = this.getDesktop();
        desktop.restoreTabGroups();
    }

    private boolean isTabGroupMaximized(Context context) {
        if (context == null) {
            return false;
        }
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        if (mainWindow.getMaximizedWindowType() != 2) {
            return false;
        }
        Desktop desktop = this.getDesktop();
        TabGroup tabGroup = this.getTabGroupFromContext(context);
        return desktop.isTabGroupMaximized(tabGroup);
    }

    private TabGroup getTabGroupFromContext(Context context) {
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
            return editorPath.getTabGroup();
        }
        Desktop desktop = this.getDesktop();
        int currentTabGroupPos = desktop.getCurrentTabGroupPos();
        if (currentTabGroupPos != -1) {
            return desktop.getTabGroup(currentTabGroupPos);
        }
        return null;
    }

    private void whenCloseOthers(Context context) {
        TabGroupState tabGroupStateToKeep = null;
        Desktop desktop = this.getDesktop();
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
            tabGroupStateToKeep = editorPath.getTabGroupState();
        } else {
            int currentTabGroupPos = desktop.getCurrentTabGroupPos();
            if (currentTabGroupPos != -1) {
                TabGroup tabGroup = desktop.getTabGroup(currentTabGroupPos);
                tabGroupStateToKeep = tabGroup.getCurrentTabGroupState();
            }
        }
        int tabGroupCount = desktop.getTabGroupCount();
        ArrayList<TabGroupState> tabGroupStateToClose = new ArrayList<TabGroupState>();
        int tabGroupPos = 0;
        while (tabGroupPos < tabGroupCount) {
            TabGroup tabGroup = desktop.getTabGroup(tabGroupPos);
            int tabGroupStateCount = tabGroup.getTabGroupStateCount();
            int i = 0;
            while (i < tabGroupStateCount) {
                TabGroupState tabGroupState = tabGroup.getTabGroupState(i);
                if (tabGroupState != tabGroupStateToKeep) {
                    tabGroupStateToClose.add(tabGroupState);
                }
                ++i;
            }
            ++tabGroupPos;
        }
        TabGroupState[] tabGroupStates = new TabGroupState[tabGroupStateToClose.size()];
        tabGroupStateToClose.toArray(tabGroupStates);
        this.closeEditors(tabGroupStates);
    }

    private void whenShowSystemMenu() {
        int currentTabGroupPos = this.getDesktop().getCurrentTabGroupPos();
        if (currentTabGroupPos != -1) {
            TabGroup tabGroup = this.getDesktop().getTabGroup(currentTabGroupPos);
            tabGroup.whenShowSystemMenu();
        }
    }

    private TabGroupState getTabGroupStateFromWindowMenu(int commandId) {
        int i = 0;
        while (i < this._windowListCmdID.length) {
            IdeAction act;
            WeakReference ref;
            if (this._windowListCmdID[i] == commandId && (ref = (WeakReference)(act = IdeAction.find((int)this._windowListCmdID[i])).getValue("UserData")) != null) {
                TabGroupState tabGroupState = (TabGroupState)ref.get();
                return tabGroupState;
            }
            ++i;
        }
        return null;
    }

    private void whenNextEditorFrame(Context context) {
        if (EditorManagerImpl.isMenuAction(context)) {
            TabGroupState tabGroupState = (TabGroupState)this._orderedDocumentList.get(1);
            this.activateEditor(tabGroupState);
        } else if (EDITOR_SELECTOR.sizeOfDisplayables() > 1) {
            EDITOR_SELECTOR.selectNext(this._orderedDocumentList);
        }
    }

    private void whenPrevEditorFrame(Context context) {
        if (EditorManagerImpl.isMenuAction(context)) {
            TabGroupState tabGroupState = (TabGroupState)this._orderedDocumentList.getLast();
            this.activateEditor(tabGroupState);
        } else if (EDITOR_SELECTOR.sizeOfDisplayables() > 1) {
            EDITOR_SELECTOR.selectPrevious(this._orderedDocumentList);
        }
    }

    void activateEditor(TabGroupState tabGroupState) {
        EditorPathImpl editorPath = new EditorPathImpl();
        this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroupState));
        this.activateEditor(editorPath);
    }

    private static boolean isMenuAction(Context context) {
        EventObject event = context.getEvent();
        if (event instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)event;
            Object actionEventSource = actionEvent.getSource();
            return actionEventSource instanceof MenuElement;
        }
        return false;
    }

    public void addToNodeList(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
        this._orderedDocumentList.addLast(tabGroupState);
    }

    public void removeFromNodeList(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
    }

    void moveTabGroupStateSwitchToTop(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
        this._orderedDocumentList.addFirst(tabGroupState);
    }

    private void whenWindowMenuActivates(TabGroupState tabGroupState) {
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroupState))) {
            this.activateEditor(editorPath);
        }
    }

    private void whenActivateRightNode() {
        int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
        TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
        tabGroup.whenActivateRightNode();
    }

    private void whenActivateLeftNode() {
        int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
        TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
        tabGroup.whenActivateLeftNode();
    }

    private void whenCloseEditor(Context context) {
        EditorPathImpl contextEditorPath = new EditorPathImpl();
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(context);
        if (this.searchEditor(contextEditorPath, editorCriteria)) {
            this.whenCloseEditor(contextEditorPath);
        }
    }

    private void whenCloseEditor(EditorPathImpl editorPath) {
        TabGroupState tabGroupState = editorPath.getTabGroupState();
        this.closeEditors(new TabGroupState[]{tabGroupState});
    }

    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == 39 || commandId == EditorManager.SHOW_DROPDOWN_CMD_ID || commandId == SYSTEM_MENU_CMD_ID) {
            action.setEnabled(this._desktop.getTabGroupCount() != 0);
        } else if (commandId == 42 || commandId == 43 || commandId == CLOSE_OTHERS_CMD_ID) {
            int tabGroupCount = this._desktop.getTabGroupCount();
            int nodeCount = 0;
            int i = 0;
            while (i < tabGroupCount) {
                TabGroup tabGroup = this._desktop.getTabGroup(i);
                if (tabGroup.isVisible()) {
                    nodeCount += tabGroup.getTabGroupStateCount();
                }
                ++i;
            }
            action.setEnabled(nodeCount > 0);
        } else if (commandId == MAXIMIZE_TAB_GROUP_CMD_ID) {
            boolean isMaximized = this.isTabGroupMaximized(context);
            action.setEnabled(isMaximized ^ true);
        } else if (commandId == RESTORE_TAB_GROUPS_CMD_ID) {
            boolean isMaximized = this.isTabGroupMaximized(context);
            action.setEnabled(isMaximized);
        } else if (commandId == REGROUP_DOCUMENTS_CMD_ID) {
            int tabGroupCount = this._desktop.getTabGroupCount();
            boolean canDo = tabGroupCount > 1;
            action.setEnabled(canDo);
        } else if (commandId == DETACH_DOCUMENT_CMD_ID) {
            boolean canDo = false;
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                TabGroup tabGroup = editorPath.getTabGroup();
                int tabGroupStateCount = tabGroup.getTabGroupStateCount();
                canDo = tabGroupStateCount > 1;
            }
            action.setEnabled(canDo);
        } else if (commandId == SPLIT_DOCUMENT_CMD_ID) {
            boolean canDo = false;
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                TabGroupState tabGroupState = editorPath.getTabGroupState();
                int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
                int splitPaneStatePos = 0;
                while (!canDo && splitPaneStatePos < splitPaneStateCount) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(splitPaneStatePos);
                    if (splitPaneState.isSplitable()) {
                        canDo = true;
                    }
                    ++splitPaneStatePos;
                }
            }
            action.setEnabled(canDo);
        } else if (commandId == UNSPLIT_DOCUMENT_CMD_ID) {
            boolean canDo = false;
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                int splitPaneStateCount = editorPath.getTabGroupState().getSplitPaneStateCount();
                canDo = splitPaneStateCount > 1;
            }
            action.setEnabled(canDo);
        } else if (commandId != NAVIGATE_LRU_FILES_CMD_ID) {
            if (commandId == 70) {
                boolean canDo = false;
                int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
                if (currentTabGroupPos != -1) {
                    TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
                    canDo = tabGroup.canActivateLeftNode();
                }
                action.setEnabled(canDo);
            } else if (commandId == 71) {
                boolean canDo = false;
                int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
                if (currentTabGroupPos != -1) {
                    TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
                    canDo = tabGroup.canActivateRightNode();
                }
                action.setEnabled(canDo);
            } else if (commandId == NEXT_PANE_CMD_ID || commandId == PREV_PANE_CMD_ID) {
                TabGroup tabGroup;
                TabGroupState currentTabGroupState;
                boolean canDo = false;
                Desktop desktop = this.getDesktop();
                int currentTabGroupPos = desktop.getCurrentTabGroupPos();
                if (currentTabGroupPos != -1 && (currentTabGroupState = (tabGroup = desktop.getTabGroup(currentTabGroupPos)).getCurrentTabGroupState()) != null) {
                    canDo = currentTabGroupState.canDo(action);
                }
                action.setEnabled(canDo);
            } else if (commandId == 40 || commandId == 41) {
                SplitPane currentSplitPane;
                TabGroup tabGroup;
                TabGroupState currentTabGroupState;
                boolean canDo = false;
                Desktop desktop = this.getDesktop();
                int currentTabGroupPos = desktop.getCurrentTabGroupPos();
                if (currentTabGroupPos != -1 && (currentTabGroupState = (tabGroup = desktop.getTabGroup(currentTabGroupPos)).getCurrentTabGroupState()) != null && (currentSplitPane = currentTabGroupState.getCurrentSplitPane()) != null) {
                    canDo = currentSplitPane.canDo(action);
                }
                action.setEnabled(canDo);
            } else if (commandId == 51) {
                this.updateRefresh(action);
            } else if (!this.updateAssign(action, commandId) && !this.updateActivate(action, commandId)) {
                return false;
            }
        }
        return true;
    }

    private boolean updateAssign(IdeAction action, int commandId) {
        boolean ret = false;
        int i = 0;
        while (i < this._assignCmdId.length) {
            int cmdId = this._assignCmdId[i];
            if (cmdId == commandId) {
                boolean hasOneEditor = this._desktop.getTabGroupCount() != 0;
                action.setEnabled(hasOneEditor);
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    private boolean updateActivate(IdeAction action, int commandId) {
        boolean ret = false;
        int i = 0;
        while (i < this._activateCmdId.length) {
            int cmdId = this._activateCmdId[i];
            if (cmdId == commandId) {
                boolean found = this.searchEditor(new EditorPathImpl(), new EditorCriteriaImpl(i));
                action.setEnabled(found);
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    int getActivateCmdId(int cmdId) {
        return this._activateCmdId[cmdId];
    }

    public int getAssignCmdId(int cmdId) {
        return this._assignCmdId[cmdId];
    }

    public String getActivateCmdTooltip(int nodeNumber) {
        int assignCmdId = this.getActivateCmdId(nodeNumber);
        String acceleratorTooltip = KeyUtil.getAcceleratorTooltip((int)assignCmdId);
        return acceleratorTooltip;
    }

    public void whenCurrentEditorChanges() {
        Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            SwingUtilities.invokeLater(new 4(this, layouts));
        }
    }

    void whenEditorOpened(Editor editor) {
        this.fireEditorEvent(1, editor);
    }

    void whenEditorClosed(Editor editor) {
        this.fireEditorEvent(4, editor);
        String editorId = editor.getId();
        BaseLayoutListener listener = (BaseLayoutListener)this._layoutListener.get(editorId);
        if (listener != null) {
            IdeProperties layout = Ide.getIdeProperties();
            try {
                long startTime = System.nanoTime();
                listener.close((Layout)layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.close", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException((Throwable)e);
            }
        }
    }

    private static void traceEditorEvent(int eventID, Editor editor) {
        if (DEBUG_TRACE_VIEW_CHANGES) {
            String eventText = eventID == 1 ? "EDITOR_EVENT_OPENED" : (eventID == 2 ? "EDITOR_EVENT_ACTIVATED" : (eventID == 3 ? "EDITOR_EVENT_DEACTIVATED" : (eventID == 4 ? "EDITOR_EVENT_CLOSED" : "???")));
            String editorId = editor == null ? "null" : editor.getId();
            System.out.println("fireEditorEvent( " + eventText + ", " + editorId + ")");
        }
    }

    public Controller getController() {
        return this;
    }

    private void registerDeclarativeEditors() {
        EditorHook editorHook = (EditorHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorHook.NAME);
        if (editorHook != null) {
            for (EditorHookRegistration reg : editorHook.getRegisteredEditors()) {
                DeclarativeEditorAddin ea = new DeclarativeEditorAddin(reg);
                EditorManager.getEditorManager().register((EditorAddin)ea, EditorManagerImpl.getClasses(reg.getId(), reg.getNodeClassNames()));
            }
        }
    }

    private static Class[] getClasses(String regId, Collection<String> classNames) {
        ArrayList classes = new ArrayList(classNames.size());
        for (String s : classNames) {
            try {
                Class<?> c = Class.forName(s);
                classes.add(c);
            }
            catch (Exception e) {
                LOG.warning("Node class '" + s + "' referenced by editor '" + regId + "' does not exist.");
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    static void checkThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            FeedbackManager.reportAPIException((String)"UI operations must happen on the event thread", (Throwable)new IllegalStateException(), (String)FM_API_NAME);
        }
    }

    static Logger ra$LOG() {
        return LOG;
    }

    static Collection ra$_openBuffers(EditorManagerImpl editorManagerImpl) {
        return editorManagerImpl._openBuffers;
    }

    static boolean mav$getCurrentEditorPath(EditorManagerImpl editorManagerImpl, EditorPathImpl editorPathImpl) {
        return editorManagerImpl.getCurrentEditorPath(editorPathImpl);
    }

    static TabGroup ra$_lastActiveTabGroup(EditorManagerImpl editorManagerImpl) {
        return editorManagerImpl._lastActiveTabGroup;
    }

    static void wa$_lastActiveTabGroup(EditorManagerImpl editorManagerImpl, TabGroup tabGroup) {
        editorManagerImpl._lastActiveTabGroup = tabGroup;
    }

    static SplitPane ra$_lastActiveSplitPane(EditorManagerImpl editorManagerImpl) {
        return editorManagerImpl._lastActiveSplitPane;
    }

    static void wa$_lastActiveSplitPane(EditorManagerImpl editorManagerImpl, SplitPane splitPane) {
        editorManagerImpl._lastActiveSplitPane = splitPane;
    }

    static void mav$whenWindowMenuActivates(EditorManagerImpl editorManagerImpl, TabGroupState tabGroupState) {
        editorManagerImpl.whenWindowMenuActivates(tabGroupState);
    }

    final class oracle.ideimpl.editor.EditorManagerImpl$1
    extends AbstractAction {
        private final /* synthetic */ TabGroupState v$tabGroupState;
        final /* synthetic */ EditorManagerImpl this$0;

        public void actionPerformed(ActionEvent e) {
            MenuSelectionManager.defaultManager().clearSelectedPath();
            SwingUtilities.invokeLater(new 1());
        }

        public oracle.ideimpl.editor.EditorManagerImpl$1(EditorManagerImpl editorManagerImpl, String string, Icon icon, TabGroupState tabGroupState) {
            this.v$tabGroupState = tabGroupState;
            this.this$0 = editorManagerImpl;
            super(string, icon);
        }

        static TabGroupState ra$v$tabGroupState(oracle.ideimpl.editor.EditorManagerImpl$1 var0) {
            return var0.v$tabGroupState;
        }

        final class 1
        implements Runnable {
            public void run() {
                EditorManagerImpl.mav$whenWindowMenuActivates(1.this.this$0, oracle.ideimpl.editor.EditorManagerImpl$1.ra$v$tabGroupState(1.this));
            }
        }
    }

    final class 2
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu popup) {
            popup.add((Component)EditorConstants.CUT_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
            popup.add((Component)EditorConstants.COPY_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
            popup.add((Component)EditorConstants.PASTE_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
            popup.add((Component)EditorConstants.ALL_ITEM, MenuConstants.SECTION_EDIT_CTXT_MENU, true);
            JMenuItem navigateItem = EditorConstants.NAVIGATE_ITEM;
            if (navigateItem != null) {
                IdeAction navigateAction = (IdeAction)navigateItem.getAction();
                navigateAction.updateAction(popup.getContext());
                popup.add((Component)navigateItem, MenuConstants.SECTION_NAVIGATE_CTXT_MENU, true);
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    static final class 3
    implements Comparator {
        public int compare(Object o1, Object o2) {
            TabGroupState ts1 = (TabGroupState)o1;
            TabGroupState ts2 = (TabGroupState)o2;
            return ts1.getNodeNumber() - ts2.getNodeNumber();
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ Layouts v$layouts;
        final /* synthetic */ EditorManagerImpl this$0;

        public void run() {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (EditorManagerImpl.mav$getCurrentEditorPath(this.this$0, editorPath)) {
                SplitPaneState splitPaneState;
                SplitPane splitPane;
                TabGroup tabGroup = editorPath.getTabGroup();
                if (tabGroup != EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0)) {
                    if (EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0) != null) {
                        EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0).highlight(false);
                    }
                    EditorManagerImpl.wa$_lastActiveTabGroup(this.this$0, tabGroup);
                    if (EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0) != null) {
                        EditorManagerImpl.ra$_lastActiveTabGroup(this.this$0).highlight(true);
                    }
                }
                if ((splitPane = (splitPaneState = editorPath.getSplitPaneState()).getSplitPane()) != EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0)) {
                    if (EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0) != null) {
                        EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0).highlight(false);
                    }
                    EditorManagerImpl.wa$_lastActiveSplitPane(this.this$0, splitPane);
                    if (EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0) != null) {
                        EditorManagerImpl.ra$_lastActiveSplitPane(this.this$0).highlight(true);
                    }
                }
                EditorState editorState = editorPath.getEditorState();
                Editor currentEditor = editorState.getEditor();
                this.v$layouts.activatePreferredLayout((LayoutSelector)currentEditor);
                Context context = currentEditor.getContext();
                EditorAddin editorAddin = editorState.getEditorAddin();
                this.this$0.raiseContextInLRUList(context, editorAddin);
            } else {
                int tabGroupCount = this.this$0.getDesktop().getTabGroupCount();
                if (tabGroupCount == 0) {
                    this.v$layouts.activateDefaultDesignLayout();
                }
            }
        }

        public 4(EditorManagerImpl editorManagerImpl, Layouts layouts) {
            this.v$layouts = layouts;
            this.this$0 = editorManagerImpl;
        }
    }

    private class DeclarativeEditorAddin
    extends EditorAddin {
        private final MetaClass<Editor> _editorClass;
        private final MenuSpec _menuSpec;
        private final boolean _isDefault;
        private final boolean _isDuplicable;
        private final boolean _isRestoreAtStartup;

        DeclarativeEditorAddin(EditorHookRegistration reg) {
            this._menuSpec = new MenuSpec(reg.getLabel(), null);
            this._editorClass = reg.getEditorClass();
            this._isDefault = reg.isDefault();
            this._isDuplicable = reg.isDuplicable();
            this._isRestoreAtStartup = reg.isRestoreAtStartup();
        }

        public Class getEditorClass() {
            try {
                Class clazz = this._editorClass.toClass();
                return clazz;
            }
            catch (Exception e) {
                EditorManagerImpl.ra$LOG().log(Level.SEVERE, "Failed to load editor class: " + this._editorClass.getClassName(), e);
                Class clazz = null;
                return clazz;
            }
        }

        public MenuSpec getMenuSpecification() {
            return this._menuSpec;
        }

        public boolean isDefault() {
            return this._isDefault;
        }

        public boolean isDuplicable() {
            return this._isDuplicable;
        }

        public boolean restoreAtStartup() {
            return this._isRestoreAtStartup;
        }
    }

    private class NodeCloseListener
    extends NodeListener {
        public void nodeWillClose(NodeEvent e) {
            TextNode node = (TextNode)e.getNode();
            node.removeNodeListener((NodeListener)this);
            EditorManagerImpl.ra$_openBuffers(EditorManagerImpl.this).remove(node.acquireTextBuffer());
        }

        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            TabGroup tabGroup;
            EditorPathImpl editorPath;
            Node newNode = NodeFactory.find((URL)newURL);
            Node oldNode = e.getNode();
            if (oldNode != null && (editorPath = (EditorPathImpl)EditorManagerImpl.this.searchEditor(oldNode)) != null && (tabGroup = editorPath.getTabGroup()) != null) {
                List editors = tabGroup.getAllEditors();
                for (Editor nextEditor : editors) {
                    if (!nextEditor.getContext().getNode().equals((Object)oldNode)) continue;
                    Context oldContext = nextEditor.getContext();
                    nextEditor.setContext(oldContext);
                }
            }
        }

        private NodeCloseListener() {
        }

        NodeCloseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

