/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.docking.Dockable;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ideimpl.docking.DockStationImpl;
import oracle.ideimpl.docking.DockablePath;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.TabGroupState;
import oracle.ideimpl.window.WindowSelector;

final class EditorSelector
extends WindowSelector {
    private static final EditorSelector INSTANCE;
    private List _nodeList;
    private List _dockableList;
    static final /* synthetic */ boolean $assertionsDisabled;

    private EditorSelector() {
    }

    public static EditorSelector getInstance() {
        return INSTANCE;
    }

    void selectNext(List nodeList) {
        this.initialize(nodeList);
        this.selectNextItem();
    }

    void selectPrevious(List nodeList) {
        this.initialize(nodeList);
        this.selectPreviousItem();
    }

    public int sizeOfDisplayables() {
        return EditorManager.getEditorManager().getAllEditors().size() + DockStationImpl.getInstance().getVisibleDockablePaths().size();
    }

    static {
        $assertionsDisabled = EditorSelector.class.desiredAssertionStatus() ^ true;
        INSTANCE = new EditorSelector();
    }

    protected Displayable[] getDisplayables() {
        if (!$assertionsDisabled && this._nodeList == null) {
            throw new AssertionError();
        }
        Displayable[] displayables = new Displayable[this._nodeList.size() + this._dockableList.size()];
        int index = 0;
        for (TabGroupState tabGroupState : this._nodeList) {
            displayables[index++] = tabGroupState.getContext().getNode();
        }
        for (DockablePath dockablePath : this._dockableList) {
            Dockable dockable = dockablePath.getDockable();
            1 displayable = new 1(this, dockable);
            displayables[index++] = displayable;
        }
        return displayables;
    }

    protected void activateSelectedWindow() {
        if (this._nodeList != null) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex < this._nodeList.size()) {
                EditorPathImpl editorPath;
                TabGroupState tabGroupState = (TabGroupState)this._nodeList.get(selectedIndex);
                EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
                if (editorManager.searchEditor(editorPath = new EditorPathImpl(), new EditorCriteriaImpl(tabGroupState))) {
                    editorManager.focusEditor(editorPath);
                    editorManager.moveTabGroupStateSwitchToTop(tabGroupState);
                }
            } else {
                DockablePath dockablePath = (DockablePath)this._dockableList.get(selectedIndex -= this._nodeList.size());
                Dockable dockable = dockablePath.getDockable();
                DockStationImpl.getInstance().activateDockable(dockable);
            }
            this.dispose();
        }
    }

    protected void dispose() {
        super.dispose();
        this._nodeList = null;
        this._dockableList = null;
    }

    private void initialize(List nodeList) {
        if (this._nodeList == null) {
            if (!($assertionsDisabled || nodeList != null && nodeList.size() > 0)) {
                throw new AssertionError();
            }
            this._nodeList = new ArrayList();
            for (TabGroupState tabGroupState : nodeList) {
                if (!tabGroupState.getParentTabGroup().isVisible()) continue;
                this._nodeList.add(tabGroupState);
            }
            this._dockableList = DockStationImpl.getInstance().getVisibleDockablePaths();
            if (!$assertionsDisabled && this._nodeList.size() <= 0) {
                throw new AssertionError();
            }
        }
    }

    final class 1
    extends DefaultDisplayable {
        private final /* synthetic */ Dockable v$dockable;
        final /* synthetic */ EditorSelector this$0;

        public String getShortLabel() {
            return this.v$dockable.getTitleName();
        }

        public Icon getIcon() {
            return this.v$dockable.getTabIcon();
        }

        public 1(EditorSelector editorSelector, Dockable dockable) {
            this.v$dockable = dockable;
            this.this$0 = editorSelector;
        }
    }
}

