/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.StructuredPropertyAccess;

abstract class EditorUtil {
    static boolean isSameNode(Context context1, Context context2) {
        Node node1 = context1.getNode();
        Node node2 = context2.getNode();
        return EditorUtil.isSameNode(node1, node2);
    }

    static boolean isSameNode(Node node1, Node node2) {
        URL url2;
        URL url1;
        boolean ret = false;
        if (node1 == node2) {
            ret = true;
        } else if (node1 != null && node2 != null && URLFileSystem.equals((URL)(url1 = node1.getURL()), (URL)(url2 = node2.getURL()))) {
            ret = true;
        }
        return ret;
    }

    static Context loadContext(StructuredPropertyAccess element) {
        Context ret = null;
        Node node = EditorUtil.getNode("document", element);
        if (node != null) {
            Node workspaceNode;
            Context ideContext = Context.newIdeContext((Node)node);
            Node projectNode = EditorUtil.getNode("project", element);
            if (projectNode instanceof Project) {
                ideContext.setProject((Project)projectNode);
            }
            if ((workspaceNode = EditorUtil.getNode("workspace", element)) instanceof Workspace) {
                ideContext.setWorkspace((Workspace)workspaceNode);
            }
            ret = ideContext;
        }
        return ret;
    }

    private static Node getNode(String urlProp, StructuredPropertyAccess element) {
        URL url = EditorUtil.getURL(urlProp, element);
        Node node = null;
        if (url != null && (URLFileSystem.exists((URL)url) || URLFileSystem.hasSuffix((URL)url, (String)".helpT") || URLFileSystem.hasSuffix((URL)url, (String)".help"))) {
            try {
                node = NodeFactory.findOrCreate((URL)url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return node;
    }

    private static URL getURL(String urlProp, StructuredPropertyAccess element) {
        String urlString = element.getProperty(urlProp, null);
        URL url = null;
        if (urlString != null && urlString.length() > 0) {
            url = URL2String.toURL((String)urlString);
        }
        return url;
    }

    static void saveContext(Context context, StructuredPropertyAccess element) {
        Node node;
        Workspace workspace;
        Project project = context.getProject();
        if (project != null) {
            URL projectURL = project.getURL();
            String projectString = URL2String.toString((URL)projectURL);
            element.setProperty("project", projectString);
        }
        if ((workspace = context.getWorkspace()) != null) {
            URL workspaceURL = workspace.getURL();
            String workspaceString = URL2String.toString((URL)workspaceURL);
            element.setProperty("workspace", workspaceString);
        }
        if ((node = context.getNode()) != null) {
            URL nodeURL = node.getURL();
            String nodeString = URL2String.toString((URL)nodeURL);
            element.setProperty("document", nodeString);
        }
    }

    static boolean isOldEditor(Editor editor) {
        Boolean oldEditor = (Boolean)editor.getEditorAttribute("old_editor");
        return Boolean.TRUE.equals(oldEditor);
    }

    EditorUtil() {
    }
}

