/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.editor.EditorManagerImpl;

final class LastUsedFiles
extends JPanel
implements KeyListener,
ActionListener,
ListSelectionListener {
    private Set _duplicates;
    private RecentFile[] _recentFiles;
    private KeyNavigationManager _keyNavigationManager;
    private JCheckBox _showAll;
    private JList _lFiles;
    private DismissableJEWTDialog _container;

    public static boolean runDialog(Frame frame, RecentFile[] recentFiles) {
        LastUsedFiles panel = new LastUsedFiles(recentFiles);
        HelpSystem hs = HelpSystem.getHelpSystem();
        DismissableJEWTDialog dlg = new DismissableJEWTDialog(frame);
        if (hs != null) {
            hs.registerTopic((JComponent)panel, "f1_idedrecentfiles_html");
        }
        panel.setContainer(dlg);
        dlg.setInitialFocus(panel._lFiles);
        dlg.setContent(panel);
        dlg.setResizable(true);
        boolean ret = WizardLauncher.runDialog((JDialog)((Object)dlg));
        if (ret) {
            JList windows = panel._lFiles;
            Object[] selectedValues = windows.getSelectedValues();
            int i = 0;
            while (i < selectedValues.length) {
                Object[] sel = windows.getSelectedValues();
                int selPos = 0;
                while (selPos < sel.length) {
                    MyModelElement myModelElement = (MyModelElement)sel[selPos];
                    Context context = myModelElement.getContext();
                    EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    openEditorOptions.setFlags(8, true);
                    editorManager.openEditor(openEditorOptions);
                    ++selPos;
                }
                ++i;
            }
        }
        return ret;
    }

    private LastUsedFiles(RecentFile[] recentFiles) {
        this._recentFiles = recentFiles;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        Dimension dimension = new Dimension(400, 400);
        this.setSize(dimension);
        JLabel lblWindows = new JLabel();
        DefaultListModel lm = new DefaultListModel();
        this._lFiles = new 1MyList(lm);
        this._lFiles.addListSelectionListener(this);
        this._lFiles.setCellRenderer(new 1());
        this._lFiles.addKeyListener(this);
        this._keyNavigationManager = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.ListKeyAdapter(this._lFiles));
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        EditorsOptions editorsOptions = editorManager.getEditorsOptions();
        boolean recentFilesShowAll = editorsOptions.isRecentFilesShowAll();
        this._showAll = new JCheckBox();
        this._showAll.getModel().setSelected(recentFilesShowAll);
        this._showAll.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this._showAll, (String)DialogsArb.getString((int)15));
        this.fillEditors();
        ResourceUtils.resLabel((JLabel)lblWindows, (Component)this._lFiles, (String)DialogsArb.getString((int)24));
        this._lFiles.addMouseListener(new 2());
        this._lFiles.setSelectionMode(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        this.add((Component)lblWindows, gbc);
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        gbc.fill = 1;
        this.add((Component)new JScrollPane(this._lFiles), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        this.add((Component)this._showAll, gbc);
        this.whenSelectionChanges();
    }

    private void fillEditors() {
        ButtonModel model = this._showAll.getModel();
        boolean showAll = model.isSelected();
        RecentFile[] recentFiles = LastUsedFiles.getValidRecentFiles(this._recentFiles);
        RecentFile[] shownFiles = showAll ? recentFiles : LastUsedFiles.filterExplicits(recentFiles);
        this._duplicates = LastUsedFiles.getDuplicates(shownFiles);
        DefaultListModel lm = (DefaultListModel)this._lFiles.getModel();
        ListSelectionModel lsm = this._lFiles.getSelectionModel();
        List<Object> oldSel = Arrays.asList(this._lFiles.getSelectedValues());
        lm.clear();
        int n = shownFiles.length;
        lm.ensureCapacity(n);
        int i = 0;
        while (i < n) {
            RecentFile recentFile = shownFiles[i];
            MyModelElement myModelElement = new MyModelElement(recentFile);
            lm.addElement(myModelElement);
            if (oldSel.contains(myModelElement)) {
                lsm.addSelectionInterval(i, i);
            }
            ++i;
        }
    }

    private static RecentFile[] getValidRecentFiles(RecentFile[] recentFiles) {
        ArrayList<RecentFile> list = new ArrayList<RecentFile>(recentFiles.length);
        int i = 0;
        while (i < recentFiles.length) {
            RecentFile recentFile = recentFiles[i];
            if (recentFile == null) {
                Assert.println((String)("recentFile[" + i + "] is null"));
            } else if (!URLFileSystem.isLocal((URL)recentFile.getNodeURL())) {
                Assert.println((String)("recentFile[" + i + "] skipped, non-local url (" + recentFile.getNodeURL() + ")"));
            } else {
                Context context = recentFile.getContext();
                if (context == null) {
                    Assert.println((String)("null context for " + recentFile.getNodeURL()));
                } else {
                    Node node = context.getNode();
                    if (node == null) {
                        Assert.println((String)("null node for " + recentFile.getNodeURL()));
                    } else {
                        URL url = node.getURL();
                        if (URLFileSystem.exists((URL)url)) {
                            String shortLabel = node.getShortLabel();
                            if (shortLabel != null) {
                                String longLabel = node.getLongLabel();
                                if (longLabel != null) {
                                    list.add(recentFile);
                                } else {
                                    Assert.println((String)("null loglabel for " + recentFile.getNodeURL()));
                                }
                            } else {
                                Assert.println((String)("null shortlabel for " + recentFile.getNodeURL()));
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return list.toArray(new RecentFile[list.size()]);
    }

    private static RecentFile[] filterExplicits(RecentFile[] recentFiles) {
        ArrayList<RecentFile> list = new ArrayList<RecentFile>(recentFiles.length);
        int i = 0;
        while (i < recentFiles.length) {
            RecentFile recentFile = recentFiles[i];
            if (recentFile.isExplicit()) {
                list.add(recentFile);
            }
            ++i;
        }
        return list.toArray(new RecentFile[list.size()]);
    }

    private static Set getDuplicates(RecentFile[] recentFiles) {
        int n = recentFiles.length;
        String[] shortLabels = new String[n];
        int i = 0;
        while (i < n) {
            Context context_i = recentFiles[i].getContext();
            Node node_i = context_i.getNode();
            shortLabels[i] = node_i.getShortLabel();
            ++i;
        }
        ArrayList<RecentFile> duplicateList = new ArrayList<RecentFile>();
        int i2 = 0;
        while (i2 < n) {
            boolean bDup = false;
            int j = i2 + 1;
            while (j < n) {
                if (shortLabels[i2].equals(shortLabels[j])) {
                    duplicateList.add(recentFiles[j]);
                    bDup = true;
                }
                ++j;
            }
            if (bDup) {
                duplicateList.add(recentFiles[i2]);
            }
            ++i2;
        }
        return new HashSet(duplicateList);
    }

    public void actionPerformed(ActionEvent e) {
        EditorsOptions editorsOptions = EditorManagerImpl.getInstance().getEditorsOptions();
        ButtonModel model = this._showAll.getModel();
        boolean showAll = model.isSelected();
        editorsOptions.setRecentFilesShowAll(showAll);
        this.fillEditors();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.whenSelectionChanges();
    }

    private void whenSelectionChanges() {
        DismissableJEWTDialog container = this.getContainer();
        if (container != null) {
            ListSelectionModel selectionModel = this._lFiles.getSelectionModel();
            boolean selectionEmpty = selectionModel.isSelectionEmpty();
            container.setOKButtonEnabled(!selectionEmpty);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!e.isConsumed() && e.getKeyCode() == 10) {
            DismissableJEWTDialog.mav$dismiss(this.getContainer());
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private DismissableJEWTDialog getContainer() {
        return this._container;
    }

    private void setContainer(DismissableJEWTDialog container) {
        this._container = container;
        this.whenSelectionChanges();
    }

    static KeyNavigationManager ra$_keyNavigationManager(LastUsedFiles lastUsedFiles) {
        return lastUsedFiles._keyNavigationManager;
    }

    static DismissableJEWTDialog mav$getContainer(LastUsedFiles lastUsedFiles) {
        return lastUsedFiles.getContainer();
    }

    static Set ra$_duplicates(LastUsedFiles lastUsedFiles) {
        return lastUsedFiles._duplicates;
    }

    static JList ra$_lFiles(LastUsedFiles lastUsedFiles) {
        return lastUsedFiles._lFiles;
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog(Frame owner) {
            super(owner, DialogsArb.getString((int)26), 7);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }

        static void mav$dismiss(DismissableJEWTDialog dismissableJEWTDialog) {
            dismissableJEWTDialog.dismiss();
        }
    }

    final class 1MyList
    extends JList {
        public 1MyList(ListModel dataModel) {
            super(dataModel);
            this.enableEvents(8);
        }

        protected void processKeyEvent(KeyEvent e) {
            if (LastUsedFiles.ra$_keyNavigationManager(LastUsedFiles.this) != null) {
                LastUsedFiles.ra$_keyNavigationManager(LastUsedFiles.this).preProcessKeyEvent(e);
            }
            super.processKeyEvent(e);
            if (LastUsedFiles.ra$_keyNavigationManager(LastUsedFiles.this) != null) {
                LastUsedFiles.ra$_keyNavigationManager(LastUsedFiles.this).postProcessKeyEvent(e);
            }
            if (e.getID() == 401 && e.getKeyCode() == 10) {
                DismissableJEWTDialog.mav$dismiss(LastUsedFiles.mav$getContainer(LastUsedFiles.this));
            }
        }
    }

    final class 1
    extends DefaultListCellRenderer {
        private MyModelElement _currentModelElement;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this._currentModelElement = (MyModelElement)value;
            String text = this._currentModelElement.getText();
            this.setText(text);
            Context context = this._currentModelElement.getContext();
            Node node = context.getNode();
            this.setIcon(node.getIcon());
            return this;
        }

        public String getToolTipText() {
            String ret;
            if (this._currentModelElement != null) {
                Context context = this._currentModelElement.getContext();
                Node node = context.getNode();
                ret = node.getLongLabel();
            } else {
                ret = super.getToolTipText();
            }
            return ret;
        }
    }

    final class 2
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            boolean clickOnAnItem;
            int index = LastUsedFiles.ra$_lFiles(LastUsedFiles.this).locationToIndex(e.getPoint());
            Rectangle r = LastUsedFiles.ra$_lFiles(LastUsedFiles.this).getCellBounds(index, index);
            boolean bl = clickOnAnItem = r != null ? r.contains(e.getPoint()) : false;
            if (e.getClickCount() == 2 && clickOnAnItem) {
                DismissableJEWTDialog.mav$dismiss(LastUsedFiles.mav$getContainer(LastUsedFiles.this));
            }
        }
    }

    private final class MyModelElement {
        private RecentFile _recentFile;

        public MyModelElement(RecentFile recentFile) {
            this._recentFile = recentFile;
        }

        public boolean equals(Object obj) {
            MyModelElement other = (MyModelElement)obj;
            return this._recentFile.equals((Object)other);
        }

        public int hashCode() {
            return this._recentFile.hashCode();
        }

        public String toString() {
            return this.getText();
        }

        public Context getContext() {
            return this._recentFile.getContext();
        }

        String getText() {
            Context context = this.getContext();
            Node node = context.getNode();
            String text = node.getShortLabel();
            if (LastUsedFiles.ra$_duplicates(LastUsedFiles.this).contains(this._recentFile)) {
                text = text + " (" + node.getLongLabel() + ")";
            }
            return text;
        }
    }
}

