/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.ApplicationChangeEvent;
import oracle.ide.navigator.ApplicationChangeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.javatools.dialogs.MessageDialog;

final class RecentFilesDockableWindow
extends DockableWindow
implements ApplicationChangeListener {
    static final String VIEW_TYPE = "oracle_ideimpl_editor_RecentFiles_VIEW_TYPE";
    static final String VIEW_NAME = "oracle_ideimpl_editor_RecentFiles_VIEW_NAME";
    private Workspace _currentApplication;
    private Component _gui;
    private JList _recentFilesList;
    private DefaultListModel _recentFilesListModel;
    private RecentFile[] _lastRecentFiles;

    RecentFilesDockableWindow(ViewId viewId) {
        super(viewId.getType() + "." + viewId.getName());
        EditorManagerImpl.getInstance()._recentFilesLRU.addWindow(this);
    }

    public String getTabName() {
        return "Recently Opened Files";
    }

    public String getTitleName() {
        return "Files in the current application that have been recently opened.";
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = this.createGUI();
        }
        return this._gui;
    }

    private Component createGUI() {
        JScrollPane sp = new JScrollPane();
        sp.setBorder(BorderFactory.createEmptyBorder());
        1RecentFilesJList list = new 1RecentFilesJList();
        list.setName("RecentlyOpenedFiles");
        this._recentFilesList = list;
        this._recentFilesListModel = new DefaultListModel();
        list.setModel(this._recentFilesListModel);
        list.setCellRenderer(new 1());
        list.addMouseListener(new 2());
        list.addKeyListener(new 3());
        sp.getViewport().add(list);
        return sp;
    }

    private void openCurrentRecentFile() {
        RecentFile recentFile = (RecentFile)this._recentFilesList.getSelectedValue();
        if (recentFile != null) {
            if (URLFileSystem.exists((URL)recentFile.getNodeURL())) {
                Context context = recentFile.getContext();
                EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                openEditorOptions.setFlags(8, true);
                editorManager.openEditor(openEditorOptions);
            } else {
                URL url = recentFile.getNodeURL();
                Node node = this.getErasedFileNode(url);
                if (node != null) {
                    EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
                    editorManager.removeFromLRUList(new Context(node));
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)(URLFileSystem.getPlatformPathName((URL)url) + " does not exist."), (String)"File not Found", null);
                }
                this.updateGUI();
            }
        }
    }

    private Node getErasedFileNode(URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            NodeFactory.uncache((URL)url, (boolean)false);
            Node node2 = node;
            return node2;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        return null;
    }

    final void updateGUI() {
        Object[] recentFiles = EditorManagerImpl.getInstance()._recentFilesLRU.getRecentFiles();
        if (!Arrays.equals(recentFiles, this._lastRecentFiles)) {
            this.updateGUIImpl((RecentFile[])recentFiles);
        } else {
            int i = 0;
            while (i < recentFiles.length) {
                if (recentFiles[i].isExplicit() != this._lastRecentFiles[i].isExplicit()) {
                    this.updateGUIImpl((RecentFile[])recentFiles);
                    break;
                }
                ++i;
            }
        }
    }

    private void updateGUIImpl(RecentFile[] recentFiles) {
        if (this._recentFilesListModel != null) {
            this._recentFilesListModel.clear();
            if (this._currentApplication != null) {
                URL currentApplicationURL = this._currentApplication.getURL();
                int n = recentFiles.length;
                int i = 0;
                while (i < n) {
                    RecentFile recentFile = recentFiles[i];
                    URL nodeURL = recentFile.getNodeURL();
                    if (nodeURL != null && URLFileSystem.equals((URL)currentApplicationURL, (URL)recentFile.getWorkspaceURL())) {
                        this._recentFilesListModel.addElement(recentFile);
                    }
                    ++i;
                }
                this._lastRecentFiles = recentFiles;
            }
        }
    }

    public int getDefaultVisibility(Layout layout) {
        return 1;
    }

    public void applicationChanged(ApplicationChangeEvent e) {
        Workspace application;
        if (e.getStateChange() == 2 && (application = e.getApplication()) != null) {
            this._currentApplication = application;
            if (this._gui != null) {
                RecentFile[] recentFiles = EditorManagerImpl.getInstance()._recentFilesLRU.getRecentFiles();
                this.updateGUIImpl(recentFiles);
            }
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_iderecentlyopenedfiles_html ");
    }

    static void mav$openCurrentRecentFile(RecentFilesDockableWindow recentFilesDockableWindow) {
        recentFilesDockableWindow.openCurrentRecentFile();
    }

    class 1RecentFilesJList
    extends JList {
        private final KeyNavigationManager _knm = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new 1(this));

        protected void processKeyEvent(KeyEvent e) {
            this._knm.preProcessKeyEvent(e);
            super.processKeyEvent(e);
            this._knm.postProcessKeyEvent(e);
        }

        final class 1
        extends KeyNavigationManager.ListKeyAdapter {
            public String toString(Object row) {
                int nRow = this.getRowPosition(row);
                ListModel listModel = 1RecentFilesJList.this.getModel();
                Object obj = listModel.getElementAt(nRow);
                RecentFile recentFile = (RecentFile)obj;
                return URLFileSystem.getFileName((URL)recentFile.getNodeURL());
            }

            public 1(JList jList) {
                super(jList);
            }
        }
    }

    final class 1
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            RecentFile recentFile = (RecentFile)value;
            URL nodeURL = recentFile.getNodeURL();
            try {
                Node node = NodeFactory.findOrCreate((URL)nodeURL);
                this.setText(node.getShortLabel());
                this.setToolTipText(node.getToolTipText());
                this.setIcon(node.getIcon());
            }
            catch (Exception e) {
                this.setText(URLFileSystem.getFileName((URL)nodeURL));
                this.setToolTipText(URLFileSystem.toDisplayString((URL)nodeURL));
                this.setIcon(null);
            }
            return this;
        }
    }

    final class 2
    implements MouseListener {
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                RecentFilesDockableWindow.mav$openCurrentRecentFile(RecentFilesDockableWindow.this);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    final class 3
    implements KeyListener {
        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (!e.isConsumed() && e.getKeyCode() == 10) {
                RecentFilesDockableWindow.mav$openCurrentRecentFile(RecentFilesDockableWindow.this);
            }
        }
    }
}

