/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.model.Node;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.RecentFilesDockableWindow;

final class RecentFilesLRU {
    private final int LRU_FILES_SIZE;
    private AtomicInteger explicitCount;
    private final ArrayList _windows;

    private void $init$() {
        this.explicitCount = new AtomicInteger();
        this._windows = new ArrayList();
    }

    RecentFilesLRU() {
        this.$init$();
        String property = Ide.getProperty((String)"Editors.RecentFilesSize", (String)"20");
        this.LRU_FILES_SIZE = Integer.parseInt(property);
    }

    public void setExplicit(Context context, boolean explicit) {
        RecentFile recentFile = this.getRecentFile(context);
        if (recentFile != null) {
            boolean wasExplicit = recentFile.isExplicit();
            if (wasExplicit) {
                this.explicitCount.decrementAndGet();
            }
            recentFile.setExplicit(explicit);
            if (explicit) {
                this.explicitCount.incrementAndGet();
            }
            this.adjustSize();
        }
    }

    private void adjustSize() {
        int expCount = this.explicitCount.get();
        if (expCount > this.LRU_FILES_SIZE) {
            this.removeOldest(true);
        } else {
            int lruSize = this.getLRUList().size();
            int implicitCount = lruSize - expCount;
            if (implicitCount > this.LRU_FILES_SIZE) {
                this.removeOldest(false);
            }
        }
    }

    private void removeOldest(boolean removeExplicit) {
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        EditorPathImpl editorPath = new EditorPathImpl();
        ArrayList lruFiles = this.getLRUList();
        int i = 0;
        while (i < lruFiles.size()) {
            EditorCriteriaImpl editorCriteria;
            boolean canRemove;
            RecentFile recentFile = (RecentFile)lruFiles.get(i);
            boolean isExplicit = recentFile.isExplicit();
            Context context = recentFile.getContext();
            if (isExplicit == removeExplicit && (canRemove = context != null ? false == editorManager.searchEditor(editorPath, editorCriteria = new EditorCriteriaImpl(context)) : true)) {
                RecentFile rf = (RecentFile)lruFiles.remove(i);
                if (!isExplicit) break;
                this.explicitCount.decrementAndGet();
                break;
            }
            ++i;
        }
        this.setLRUList(lruFiles);
    }

    RecentFile[] getRecentFiles() {
        ArrayList lruFiles = this.getLRUList();
        int lruSize = lruFiles.size();
        RecentFile[] recentFiles = new RecentFile[lruSize];
        int i = 0;
        while (i < lruSize) {
            RecentFile recentFile;
            recentFiles[lruSize - i - 1] = recentFile = (RecentFile)lruFiles.get(i);
            ++i;
        }
        return recentFiles;
    }

    void raiseContextInLRUList(Context context, String editorAddinClassName) {
        Node node;
        if (context != null && (node = context.getNode()) != null) {
            RecentFile recentFile = this.remove(context);
            if (recentFile == null) {
                recentFile = new RecentFile(context);
            }
            if (editorAddinClassName != null) {
                recentFile.setEditor(editorAddinClassName);
            }
            ArrayList lruFiles = this.getLRUList();
            lruFiles.add(recentFile);
            this.setLRUList(lruFiles);
            if (recentFile.isExplicit()) {
                this.explicitCount.incrementAndGet();
            }
            this.adjustSize();
        }
    }

    private ArrayList getLRUList() {
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        EditorsOptions editorsOptions = editorManager.getEditorsOptions();
        ArrayList lruFiles = editorsOptions.getLruFiles();
        this.explicitCount.set(0);
        int i = 0;
        while (i < lruFiles.size()) {
            RecentFile recentFile = (RecentFile)lruFiles.get(i);
            if (recentFile.isExplicit()) {
                this.explicitCount.incrementAndGet();
            }
            ++i;
        }
        return lruFiles;
    }

    final void addWindow(RecentFilesDockableWindow window) {
        this._windows.add(window);
    }

    private void setLRUList(ArrayList lruList) {
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        EditorsOptions editorsOptions = editorManager.getEditorsOptions();
        editorsOptions.setLruFiles(lruList);
        for (RecentFilesDockableWindow window : this._windows) {
            window.updateGUI();
        }
    }

    private int getPositionInLRUList(Context context) {
        if (context != null) {
            ArrayList lruFiles = this.getLRUList();
            int i = 0;
            while (i < lruFiles.size()) {
                RecentFile recentFile = (RecentFile)lruFiles.get(i);
                if (recentFile.isSameNode(context)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    RecentFile getRecentFile(Context context) {
        RecentFile ret = null;
        int positionInLRUList = this.getPositionInLRUList(context);
        if (positionInLRUList != -1) {
            ret = this.getRecentFile(positionInLRUList);
        }
        return ret;
    }

    private RecentFile getRecentFile(int positionInLRUList) {
        return (RecentFile)this.getLRUList().get(positionInLRUList);
    }

    RecentFile remove(Context context) {
        RecentFile ret = null;
        int positionInLRUList = this.getPositionInLRUList(context);
        if (positionInLRUList >= 0) {
            ArrayList lruList = this.getLRUList();
            ret = (RecentFile)lruList.remove(positionInLRUList);
            this.setLRUList(lruList);
            if (ret.isExplicit()) {
                this.explicitCount.decrementAndGet();
            }
        }
        return ret;
    }
}

