/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;
import oracle.ide.view.TitledContainer;
import oracle.ide.view.View;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.ScrollableCustomTab;
import oracle.ideimpl.editor.DelegatingBorder;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.EditorUtil;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.Splitter;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;
import oracle.javatools.ui.themes.Themes;

final class SplitPane
extends JPanel
implements TitledContainer,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
ComponentListener {
    private static final int MIN_HORZSB_WIDTH = 75;
    private static final int SPLIT_DRAG_BOUNDS_THRESHHOLD = 25;
    private static int _splitPaneID = 0;
    private final int _id;
    private SplitPaneState _splitPaneState;
    private final JScrollPane _scrollPane;
    private final JScrollBar _nativeVertScrollBar;
    private Component _installedVertScrollBar;
    private boolean _vertSplitterVisible;
    private final Splitter _vertSplitter;
    private final JScrollBar _nativeHorzScrollBar;
    private Component _installedHorzScrollBar;
    private boolean _horzSplitterVisible;
    private final Splitter _horzSplitter;
    private final CustomTab _editorTabs;
    private final ScrollableCustomTab _scrollableCustomTab;
    private final JPanel _bottomPanel;
    private int _currentEditorStatePos;
    private Component _leftMargin;
    private Component _rightMargin;
    private Component _topMargin;
    private Component _bottomMargin;
    private Component _editorComponent;
    private Component _editorButtons;
    private Point _ptDragSplitter;
    private DoubleClickTrigger _splitTrigger;
    private boolean _pendingEditorShown;
    private Component _bottomComponent;

    private void $init$() {
        this._id = _splitPaneID++;
        this._currentEditorStatePos = -1;
        this._splitTrigger = new DoubleClickTrigger();
    }

    public SplitPane() {
        this.$init$();
        this.setOpaque(false);
        this._scrollableCustomTab = EditorManagerImpl.getEditorManagerOption(1) ? new ScrollableCustomTab(1) : new ScrollableCustomTab(3);
        this._editorTabs = this._scrollableCustomTab.getCustomTab();
        this._editorTabs.setOffsetSelected(0);
        this._editorTabs.setMinTabWidth(30);
        this._editorTabs.setOpaque(false);
        this._editorTabs.setShowIcons(false);
        boolean gradientHighlight = EditorManagerImpl.getEditorManagerOption(4);
        this._editorTabs.setGradientHighlight(gradientHighlight);
        this._editorTabs.addSelectionListener((ListSelectionListener)new 1());
        this._editorTabs.addMouseListener((MouseListener)this);
        this.add(this._scrollableCustomTab);
        this._vertSplitter = new Splitter(0);
        this.add(this._vertSplitter);
        this._vertSplitter.addMouseListener(this);
        this._vertSplitter.addMouseMotionListener(this);
        this._horzSplitter = new Splitter(1);
        this.add(this._horzSplitter);
        this._horzSplitter.addMouseListener(this);
        this._horzSplitter.addMouseMotionListener(this);
        this._scrollPane = new JScrollPane();
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add(this._scrollPane);
        this._nativeVertScrollBar = this._scrollPane.getVerticalScrollBar();
        this.add(this._nativeVertScrollBar);
        this._nativeHorzScrollBar = this._scrollPane.getHorizontalScrollBar();
        this.add(this._nativeHorzScrollBar);
        this._scrollPane.addComponentListener(this);
        this._bottomPanel = new JPanel();
        this._bottomPanel.setOpaque(false);
        Border normalBottomBorder = BorderFactory.createLineBorder(IdeConstants.COLOR_IDE_LINES);
        this._bottomPanel.setBorder(new 2(this, normalBottomBorder));
        this.add(this._bottomPanel);
        if (JDK.HAS_BUG_4699831) {
            Dimension primaryScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
            JViewport viewport = this._scrollPane.getViewport();
            viewport.addComponentListener(new 3(this, viewport, primaryScreenSize));
        }
    }

    public String toString() {
        return "SplitPane[" + this._id + ";" + String.valueOf(this._splitPaneState) + "]";
    }

    SplitPaneState getSplitPaneState() {
        return this._splitPaneState;
    }

    void setSplitPaneState(SplitPaneState splitPaneState) {
        if (this._splitPaneState != null) {
            this.detachCurrentEditor();
            this._editorTabs.setModel(null);
            this._currentEditorStatePos = -1;
        }
        this._splitPaneState = splitPaneState;
        if (this._splitPaneState != null) {
            DefaultListModel editorsModel = this._splitPaneState.getEditorsModel();
            this._editorTabs.setModel((ListModel)editorsModel);
            int currentEditorStatePos = this._splitPaneState.getCurrentEditorStatePos();
            this.setCurrentEditorStatePos(currentEditorStatePos);
            int nbrEditorStates = this._splitPaneState.getEditorStateCount();
            int i = 0;
            while (i < nbrEditorStates) {
                EditorState editorState = this._splitPaneState.getEditorState(i);
                DefaultCustomTabPage page = (DefaultCustomTabPage)this._editorTabs.getPage(i);
                page.setEnabled(editorState.isEnabled());
                ++i;
            }
            boolean showEditorsTab = true;
            if (nbrEditorStates == 1 && EditorManagerImpl.getEditorManagerOption(2)) {
                showEditorsTab = false;
            }
            this._scrollableCustomTab.setVisible(showEditorsTab);
        }
    }

    private void setScrollableLeftMargin(Component margin) {
        if (margin == null) {
            this._scrollPane.setRowHeader(null);
        } else {
            this._scrollPane.setRowHeaderView(margin);
        }
    }

    private void setScrollableTopMargin(Component margin) {
        if (margin == null) {
            this._scrollPane.setColumnHeader(null);
        } else {
            this._scrollPane.setColumnHeaderView(margin);
        }
    }

    private void setFixedLeftMargin(Component margin) {
        if (this._leftMargin != null) {
            this.remove(this._leftMargin);
        }
        this._leftMargin = margin;
        if (this._leftMargin != null) {
            this.add(this._leftMargin);
        }
    }

    private void setFixedRightMargin(Component margin) {
        if (this._rightMargin != null) {
            this.remove(this._rightMargin);
        }
        this._rightMargin = margin;
        if (this._rightMargin != null) {
            this.add(this._rightMargin);
        }
    }

    private void setFixedTopMargin(Component margin) {
        if (this._topMargin != null) {
            this.remove(this._topMargin);
        }
        this._topMargin = margin;
        if (this._topMargin != null) {
            this.add(this._topMargin);
        }
    }

    private void setFixedBottomMargin(Component margin) {
        if (this._bottomMargin != null) {
            this.remove(this._bottomMargin);
        }
        this._bottomMargin = margin;
        if (this._bottomMargin != null) {
            this.add(this._bottomMargin);
        }
    }

    private void setEditorButtons(Component editorButtons) {
        if (this._editorButtons != null) {
            this.remove(this._editorButtons);
        }
        this._editorButtons = editorButtons;
        if (this._editorButtons != null) {
            this.add(this._editorButtons);
        }
    }

    private void setBottomComponent(Component bottomComponent) {
        if (this._bottomComponent != null) {
            this.remove(this._bottomComponent);
        }
        this._bottomComponent = bottomComponent;
        if (this._bottomComponent != null) {
            this.remove(this._bottomPanel);
            this.add(this._bottomComponent);
            this.add(this._bottomPanel);
        }
    }

    private void setEditorComponent(Component component, boolean inScrollPane, Component customHorzScrollbar, Component customVertScrollbar) {
        if (inScrollPane) {
            JViewport viewport = this._scrollPane.getViewport();
            Dimension componentSize = component.getSize();
            component.setSize(componentSize.width - 1, componentSize.height);
            viewport.setView(component);
            this._scrollPane.setVisible(true);
            this._editorComponent = this._scrollPane;
            if (customHorzScrollbar == null) {
                this._installedHorzScrollBar = this.getNativeHorzScrollBar();
                this._installedHorzScrollBar.setVisible(true);
            } else {
                this._installedHorzScrollBar = customHorzScrollbar;
                this.remove(this._bottomPanel);
                this.add(customHorzScrollbar);
                this.add(this._bottomPanel);
            }
            if (customVertScrollbar == null) {
                this._installedVertScrollBar = this.getNativeVertScrollBar();
                this._installedVertScrollBar.setVisible(true);
            } else {
                this._installedVertScrollBar = customVertScrollbar;
                this.add(customVertScrollbar);
            }
        } else {
            this._scrollPane.setVisible(false);
            this.getNativeHorzScrollBar().setVisible(false);
            if (customHorzScrollbar != null) {
                this.remove(this._bottomPanel);
                this._installedHorzScrollBar = customHorzScrollbar;
                this.add(customHorzScrollbar);
                this.add(this._bottomPanel);
            }
            this.getNativeVertScrollBar().setVisible(false);
            if (customVertScrollbar != null) {
                this._installedVertScrollBar = customVertScrollbar;
                this.add(this._installedVertScrollBar);
            }
            this._editorComponent = component;
            this.add(this._editorComponent);
        }
        this._horzSplitter.setVisible(this._installedHorzScrollBar != null && this._installedHorzScrollBar.isVisible());
        this._vertSplitter.setVisible(this._installedVertScrollBar != null && this._installedVertScrollBar.isVisible());
    }

    public void setVertSplitterVisible(boolean vertSplitterVisible) {
        this._vertSplitterVisible = vertSplitterVisible;
    }

    public void setHorzSplitterVisible(boolean horzSplitterVisible) {
        this._horzSplitterVisible = horzSplitterVisible;
    }

    public Editor getCurrentEditor() {
        Editor ret = null;
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState currentEditorState = splitPaneState.getCurrentEditorState();
        if (currentEditorState != null) {
            ret = currentEditorState.getEditor();
        }
        return ret;
    }

    private void setHorizontalScrollBarPolicy(int horizontalScrollBarPolicy) {
        switch (horizontalScrollBarPolicy) {
            case 31: {
                this._nativeHorzScrollBar.setVisible(false);
                break;
            }
            case 32: {
                this._nativeHorzScrollBar.setVisible(true);
                break;
            }
            case 30: {
                throw new UnsupportedOperationException("Not supported");
            }
        }
    }

    private void setVerticalScrollBarPolicy(int verticalScrollBarPolicy) {
        switch (verticalScrollBarPolicy) {
            case 21: {
                this._nativeVertScrollBar.setVisible(false);
                break;
            }
            case 22: {
                this._nativeVertScrollBar.setVisible(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported");
            }
        }
    }

    public Dimension getMinimumSize() {
        if (!this.isMinimumSizeSet()) {
            Insets insets = this.getInsets();
            int minHeight = this._horzSplitter.getPreferredSize().height;
            int tabPrefHeight = this._scrollableCustomTab.isVisible() ? this._scrollableCustomTab.getPreferredSize().height : 0;
            minHeight = Math.min(minHeight, tabPrefHeight);
            Dimension minimumSize = new Dimension(insets.left + insets.right, insets.top + minHeight + insets.bottom);
            super.setMinimumSize(minimumSize);
        }
        return super.getMinimumSize();
    }

    public void doLayout() {
        if (EditorManagerImpl.getEditorManagerOption(1)) {
            this.doLayoutTopTabs();
        } else {
            this.doLayoutBottomTabs();
        }
    }

    private void doLayoutBottomTabs() {
        Dimension size = this.getSize();
        int height = size.height;
        int width = size.width;
        Insets insets = this.getInsets();
        int leftMarginWidth = this._leftMargin != null && this._leftMargin.isVisible() ? this._leftMargin.getPreferredSize().width : 0;
        int rightMarginWidth = this._rightMargin != null && this._rightMargin.isVisible() ? this._rightMargin.getPreferredSize().width : 0;
        int topMarginHeight = this._topMargin != null && this._topMargin.isVisible() ? this._topMargin.getPreferredSize().height : 0;
        int bottomMarginHeight = this._bottomMargin != null && this._bottomMargin.isVisible() ? this._bottomMargin.getPreferredSize().height : 0;
        int bottomComponentHeight = this._bottomComponent != null && this._bottomComponent.isVisible() ? this._bottomComponent.getPreferredSize().height : 0;
        int vertScrollWidth = this._installedVertScrollBar != null && this._installedVertScrollBar.isVisible() ? this._installedVertScrollBar.getPreferredSize().width : 0;
        int vertSplitterHeight = this._vertSplitterVisible ? this._vertSplitter.getPreferredSize().height : 0;
        boolean isHorzScrollVisible = this._installedHorzScrollBar != null && this._installedHorzScrollBar.isVisible();
        int horzScrollHeight = isHorzScrollVisible ? this._installedHorzScrollBar.getPreferredSize().height : 0;
        Dimension editorTabPreferredSize = this._scrollableCustomTab.getPreferredSize();
        int bottomHeight = Math.max(bottomComponentHeight + 1, Math.max(horzScrollHeight + 1, editorTabPreferredSize.height));
        int xLeft = insets.left + 1;
        int xRight = width - insets.right - 1;
        int yTop = insets.top;
        if (!Themes.isThemed()) {
            ++yTop;
        }
        int yBottom = height - insets.bottom;
        int editorTop = yTop + topMarginHeight;
        int editorLeft = xLeft + leftMarginWidth;
        int editorWidth = xRight - rightMarginWidth - vertScrollWidth - editorLeft;
        int editorHeight = yBottom - (editorTop + bottomHeight + bottomMarginHeight);
        int editorBottom = editorTop + editorHeight;
        int editorTabLeft = insets.left;
        int vertScrollLeft = editorLeft + editorWidth;
        int vertScrollHeight = yBottom - yTop - bottomHeight;
        int editorButtonsMinWidth = vertScrollWidth + rightMarginWidth;
        int editorButtonsWidth = this._editorButtons == null || !this._editorButtons.isVisible() ? editorButtonsMinWidth : Math.max(this._editorButtons.getPreferredSize().width, editorButtonsMinWidth);
        int editorButtonsLeft = xRight - editorButtonsWidth;
        int horzSplitterWidth = this._horzSplitterVisible && this._horzSplitter != null && this._horzSplitter.isVisible() ? this._horzSplitter.getPreferredSize().width : 0;
        int horzSplitterLeft = editorButtonsLeft - horzSplitterWidth;
        int horzSpaceAvailable = horzSplitterLeft - editorTabLeft;
        int horzScrollWidth = Math.max(75, horzSpaceAvailable - editorTabPreferredSize.width);
        int horzScrollLeft = horzSplitterLeft - horzScrollWidth;
        int editorTabWidth = editorTabLeft + horzSpaceAvailable - horzScrollWidth;
        if (this._leftMargin != null && this._leftMargin.isVisible()) {
            this._leftMargin.setBounds(xLeft, yTop, leftMarginWidth, vertScrollHeight);
        }
        if (this._rightMargin != null && this._rightMargin.isVisible()) {
            this._rightMargin.setBounds(vertScrollLeft + vertScrollWidth, yTop, rightMarginWidth, vertScrollHeight);
        }
        if (this._topMargin != null && this._topMargin.isVisible()) {
            this._topMargin.setBounds(editorLeft, yTop, editorWidth, topMarginHeight);
        }
        if (this._bottomMargin != null && this._bottomMargin.isVisible()) {
            this._bottomMargin.setBounds(editorLeft, editorBottom, editorWidth, bottomMarginHeight);
        }
        if (this._editorComponent != null) {
            this._editorComponent.setBounds(editorLeft, editorTop, editorWidth, editorHeight);
        }
        this._vertSplitter.setBounds(vertScrollLeft, yTop, vertScrollWidth, vertSplitterHeight);
        if (this._installedVertScrollBar != null) {
            this._installedVertScrollBar.setBounds(vertScrollLeft, yTop + vertSplitterHeight, vertScrollWidth, vertScrollHeight - vertSplitterHeight);
        }
        this._scrollableCustomTab.setBounds(editorTabLeft, editorBottom + bottomMarginHeight, editorTabWidth, bottomHeight);
        this._bottomPanel.setBounds(editorTabLeft + editorTabWidth - 1, editorBottom + bottomMarginHeight, horzScrollWidth + horzSplitterWidth + vertScrollWidth + rightMarginWidth + 2, bottomHeight);
        if (isHorzScrollVisible) {
            this._installedHorzScrollBar.setBounds(horzScrollLeft, editorBottom + bottomMarginHeight, horzScrollWidth, horzScrollHeight);
        } else if (this._bottomComponent != null) {
            this._bottomComponent.setBounds(horzScrollLeft, editorBottom + bottomMarginHeight, horzScrollWidth, bottomComponentHeight);
        }
        this._horzSplitter.setBounds(horzSplitterLeft, editorBottom + bottomMarginHeight, horzSplitterWidth, horzScrollHeight);
        if (this._editorButtons != null) {
            this._editorButtons.setBounds(editorButtonsLeft, editorBottom + bottomMarginHeight, editorButtonsWidth, bottomHeight - 1);
        }
        if (this._pendingEditorShown) {
            this._pendingEditorShown = false;
            Editor currentEditor = this.getCurrentEditor();
            currentEditor.editorShown();
        }
    }

    private void doLayoutTopTabs() {
        int editorTabHeight;
        Dimension size = this.getSize();
        int height = size.height;
        int width = size.width;
        Insets insets = (Insets)this.getInsets().clone();
        ++insets.left;
        ++insets.right;
        Component vertScrollBar = this._installedVertScrollBar;
        Component horzScrollBar = this._installedHorzScrollBar;
        Component horzBar = horzScrollBar != null ? horzScrollBar : this._bottomComponent;
        if (this._scrollableCustomTab.isVisible()) {
            Dimension editorTabPreferredSize = this._scrollableCustomTab.getPreferredSize();
            editorTabHeight = editorTabPreferredSize.height;
        } else {
            editorTabHeight = 0;
        }
        boolean hasLeftMargin = this._leftMargin != null && this._leftMargin.isVisible();
        boolean hasRightMargin = this._rightMargin != null && this._rightMargin.isVisible();
        boolean hasTopMargin = this._topMargin != null && this._topMargin.isVisible();
        boolean hasBottomMargin = this._bottomMargin != null && this._bottomMargin.isVisible();
        boolean hasMiniToolbar = this._editorButtons != null && this._editorButtons.isVisible();
        boolean hasVertScrollbar = vertScrollBar != null && vertScrollBar.isVisible();
        boolean hasHorzScrollbar = horzBar != null && horzBar.isVisible();
        int leftMarginWidth = hasLeftMargin ? this._leftMargin.getPreferredSize().width : 0;
        int rightMarginWidth = hasRightMargin ? this._rightMargin.getPreferredSize().width : 0;
        int topMarginHeight = hasTopMargin ? this._topMargin.getPreferredSize().height : 0;
        int bottomMarginHeight = hasBottomMargin ? this._bottomMargin.getPreferredSize().height : 0;
        int miniToolbarHeight = hasMiniToolbar ? this._editorButtons.getPreferredSize().height : 0;
        int vertScrollWidth = hasVertScrollbar ? vertScrollBar.getPreferredSize().width : 0;
        int vertSplitterHeight = this._vertSplitterVisible ? this._vertSplitter.getPreferredSize().height : 0;
        int horzScrollHeight = hasHorzScrollbar ? horzBar.getPreferredSize().height : 0;
        int horzSplitterWidth = this._horzSplitterVisible ? this._horzSplitter.getPreferredSize().width : 0;
        int editorButtonsMinWidth = vertScrollWidth + rightMarginWidth;
        int bottomComponentWidth = hasMiniToolbar ? Math.max(this._editorButtons.getPreferredSize().width, editorButtonsMinWidth) : editorButtonsMinWidth;
        int bottomHeight = Math.max(miniToolbarHeight + 1, horzScrollHeight + 1);
        int myX = insets.left - 1;
        int myY = insets.top;
        int myWidth = width - insets.left - insets.right + 1;
        int myHeight = editorTabHeight;
        this._scrollableCustomTab.setBounds(new Rectangle(myX, myY, myWidth, myHeight));
        if (hasTopMargin) {
            int myX2 = insets.left;
            int myY2 = insets.top + editorTabHeight;
            int myWidth2 = width - insets.right - rightMarginWidth - vertScrollWidth;
            int myHeight2 = topMarginHeight;
            this._topMargin.setBounds(myX2, myY2, myWidth2, myHeight2);
        }
        if (vertSplitterHeight > 0) {
            int myX3 = width - insets.right - rightMarginWidth - vertScrollWidth;
            int myY3 = insets.top + editorTabHeight;
            int myWidth3 = vertScrollWidth;
            int myHeight3 = vertSplitterHeight;
            this._vertSplitter.setBounds(myX3, myY3, myWidth3, myHeight3);
        }
        if (vertScrollWidth > 0) {
            int myX4 = width - insets.right - rightMarginWidth - vertScrollWidth;
            int myY4 = insets.top + editorTabHeight + vertSplitterHeight;
            int myWidth4 = vertScrollWidth;
            int myHeight4 = height - myY4 - bottomHeight;
            vertScrollBar.setBounds(myX4, myY4, myWidth4, myHeight4);
        }
        if (hasRightMargin) {
            int myX5 = width - insets.right - rightMarginWidth;
            int myY5 = insets.top + editorTabHeight;
            int myWidth5 = rightMarginWidth;
            int myHeight5 = height - myY5 - bottomHeight;
            this._rightMargin.setBounds(myX5, myY5, myWidth5, myHeight5);
        }
        if (hasLeftMargin) {
            int myX6 = insets.left;
            int myY6 = insets.top + editorTabHeight + topMarginHeight;
            int myWidth6 = leftMarginWidth;
            int myHeight6 = height - insets.top - editorTabHeight - topMarginHeight - bottomMarginHeight - bottomHeight - insets.bottom;
            this._leftMargin.setBounds(myX6, myY6, myWidth6, myHeight6);
        }
        int myX7 = insets.left + leftMarginWidth;
        int myY7 = insets.top + editorTabHeight + topMarginHeight;
        int myWidth7 = width - insets.left - leftMarginWidth - vertScrollWidth - rightMarginWidth - insets.right;
        int myHeight7 = height - insets.top - editorTabHeight - topMarginHeight - bottomMarginHeight - bottomHeight - insets.bottom;
        this._editorComponent.setBounds(myX7, myY7, myWidth7, myHeight7);
        if (hasBottomMargin) {
            int myX8 = insets.left;
            int myY8 = height - insets.bottom - bottomHeight - bottomMarginHeight;
            int myWidth8 = width - insets.right - rightMarginWidth - vertScrollWidth;
            int myHeight8 = bottomMarginHeight;
            this._bottomMargin.setBounds(myX8, myY8, myWidth8, myHeight8);
        }
        if (hasHorzScrollbar) {
            int myX9 = insets.left - 1;
            int myY9 = height - insets.bottom - bottomHeight;
            int myWidth9 = width - insets.left + 1 - horzSplitterWidth - bottomComponentWidth - insets.right;
            int myHeight9 = bottomHeight;
            horzBar.setBounds(myX9, myY9, myWidth9, myHeight9);
        }
        if (horzSplitterWidth > 0) {
            int myX10 = width - insets.right - bottomComponentWidth - horzSplitterWidth;
            int myY10 = height - insets.bottom - bottomHeight;
            int myWidth10 = horzSplitterWidth;
            int myHeight10 = bottomHeight;
            this._horzSplitter.setBounds(myX10, myY10, myWidth10, myHeight10);
        }
        if (hasMiniToolbar) {
            int myX11 = width - insets.right - bottomComponentWidth;
            int myY11 = height - insets.bottom - miniToolbarHeight;
            int myWidth11 = bottomComponentWidth;
            int myHeight11 = bottomMarginHeight;
            this._editorButtons.setBounds(myX11, myY11, myWidth11, myHeight11);
        }
        if (this._pendingEditorShown) {
            this._pendingEditorShown = false;
            Editor currentEditor = this.getCurrentEditor();
            currentEditor.editorShown();
        }
    }

    protected void paintBorder(Graphics g) {
        int editorTabHeight = this._scrollableCustomTab.isVisible() ? this._scrollableCustomTab.getHeight() : 0;
        Dimension mySize = this.getSize();
        g.setColor(IdeConstants.COLOR_IDE_LINES);
        if (EditorManagerImpl.getEditorManagerOption(1)) {
            int[] xPoints = new int[]{0, 0, mySize.width - 1, mySize.width - 1};
            int[] yPoints = new int[]{editorTabHeight, mySize.height - 1, mySize.height - 1, 0};
            g.drawPolyline(xPoints, yPoints, xPoints.length);
        } else {
            if (!Themes.isThemed()) {
                g.drawLine(0, 0, mySize.width - 1, 0);
            }
            g.setColor(this.getBorderColor());
            g.drawLine(0, 0, 0, mySize.height - editorTabHeight - 1);
            g.drawLine(mySize.width - 1, 0, mySize.width - 1, mySize.height - editorTabHeight - 1);
        }
    }

    private Color getBorderColor() {
        if (Themes.isThemed()) {
            if (this.getTabGroup().isFocused()) {
                return Themes.getActiveTheme().getStateProperties("view", "active").getColor("bordercolor");
            }
            return Themes.getActiveTheme().getStateProperties("view", "inactive").getColor("bordercolor");
        }
        return IdeConstants.COLOR_IDE_LINES;
    }

    private void detachCurrentEditor() {
        if (this._editorComponent != null) {
            this.savePaneState();
            SplitPaneState splitPaneState = this.getSplitPaneState();
            Editor currentEditor = splitPaneState.getCurrentEditor();
            if (currentEditor != null) {
                if (!EditorUtil.isOldEditor(currentEditor)) {
                    currentEditor.removePropertyChangeListener((PropertyChangeListener)this);
                }
                currentEditor.editorHidden();
                Component editorGUI = currentEditor.getGUI();
                Component focusedChildComponent = GraphicsUtils.getFocusedChildComponent((Component)editorGUI);
                if (focusedChildComponent != null) {
                    EditorState currentEditorState = splitPaneState.getCurrentEditorState();
                    currentEditorState.setFocusedComponent(focusedChildComponent);
                }
            }
            if (this._editorComponent == this._scrollPane) {
                JViewport viewport = this._scrollPane.getViewport();
                viewport.setView(null);
            } else {
                this.remove(this._editorComponent);
            }
            this._editorComponent = null;
            if (this._installedHorzScrollBar != null) {
                if (this._installedHorzScrollBar != this.getNativeHorzScrollBar()) {
                    this.remove(this._installedHorzScrollBar);
                }
                this._installedHorzScrollBar = null;
            }
            if (this._installedVertScrollBar != null) {
                if (this._installedVertScrollBar != this.getNativeVertScrollBar()) {
                    this.remove(this._installedVertScrollBar);
                }
                this._installedVertScrollBar = null;
            }
            this.setScrollableLeftMargin(null);
            this.setScrollableTopMargin(null);
            this.setFixedLeftMargin(null);
            this.setFixedTopMargin(null);
            this.setFixedRightMargin(null);
            this.setFixedBottomMargin(null);
            this.setEditorButtons(null);
            MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
            mainWindow.unregisterView((View)currentEditor);
            this.revalidate();
            this.repaint();
        }
    }

    private void attachCurrentEditor() {
        int currentEditorStatePos;
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState currentEditorState = splitPaneState.getEditorState(currentEditorStatePos = splitPaneState.getCurrentEditorStatePos());
        Editor newEditor = currentEditorState.getEditor();
        if (newEditor == null) {
            TabGroupState parentTabGroupState = splitPaneState.getParentTabGroupState();
            Context context = parentTabGroupState.getContext();
            newEditor = currentEditorState.createEditor(context);
        }
        if (newEditor == null) {
            this.attachNullEditor();
        } else {
            MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
            mainWindow.registerView((View)newEditor, this);
            if (EditorUtil.isOldEditor(newEditor)) {
                this.attachOldEditor(newEditor);
            } else {
                this.attachEditor(newEditor);
            }
        }
        this._pendingEditorShown = true;
        this.revalidate();
        this.repaint();
    }

    private void attachEditor(Editor editor) {
        Component editorComponent = editor.getGUI();
        Component fixedLeftMargin = editor.getFixedLeftMargin();
        Component fixedRightMargin = editor.getFixedRightMargin();
        Component fixedTopMargin = editor.getFixedTopMargin();
        Component fixedBottomMargin = editor.getFixedBottomMargin();
        Component scrollableLeftMargin = editor.getScrollableLeftMargin();
        Component scrollableTopMargin = editor.getScrollableTopMargin();
        Component toolbar = editor.getMiniToolbar();
        Component bottomComponent = editor.getBottomComponent();
        Object scrollableAttribute = editor.getEditorAttribute("scrollable");
        boolean isScrollable = Boolean.FALSE.equals(scrollableAttribute) ^ true;
        Component customHorzScrollbar = (Component)editor.getEditorAttribute("custom_horizontal_scrollbar");
        Component customVertScrollbar = (Component)editor.getEditorAttribute("custom_vertical_scrollbar");
        this.setEditorComponent(editorComponent, isScrollable, customHorzScrollbar, customVertScrollbar);
        this.loadPaneState();
        this.whenHorizontalScrollbarPolicyChanges(isScrollable ? null : Integer.valueOf(31));
        this.whenHorizontalUnitChanges(null);
        this.whenHorizontalBlockIncrementChanges(null);
        this.whenVerticalScrollbarPolicyChanges(isScrollable ? null : Integer.valueOf(21));
        this.whenVerticalUnitChanges(null);
        this.whenVerticalBlockIncrementChanges(null);
        this.whenBackgroundColorChanges(null);
        editor.addPropertyChangeListener((PropertyChangeListener)this);
        this.setScrollableLeftMargin(scrollableLeftMargin);
        this.setScrollableTopMargin(scrollableTopMargin);
        this.setFixedLeftMargin(fixedLeftMargin);
        this.setFixedRightMargin(fixedRightMargin);
        this.setFixedTopMargin(fixedTopMargin);
        this.setFixedBottomMargin(fixedBottomMargin);
        this.setEditorButtons(toolbar);
        this.setBottomComponent(bottomComponent);
    }

    void savePaneState() {
        JScrollBar nativeVertScrollBar;
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState currentEditorState = splitPaneState.getCurrentEditorState();
        JScrollBar nativeHorzScrollBar = this.getNativeHorzScrollBar();
        if (this._installedHorzScrollBar == nativeHorzScrollBar) {
            BoundedRangeModel model = nativeHorzScrollBar.getModel();
            int minimum = model.getMinimum();
            int maximum = model.getMaximum();
            int extent = model.getExtent();
            int value = model.getValue();
            currentEditorState.setXScrollMin(minimum);
            currentEditorState.setXScrollMax(maximum);
            currentEditorState.setXScrollExtent(extent);
            currentEditorState.setXScrollPos(value);
        }
        if (this._installedVertScrollBar == (nativeVertScrollBar = this.getNativeVertScrollBar())) {
            BoundedRangeModel model = nativeVertScrollBar.getModel();
            int minimum = model.getMinimum();
            int maximum = model.getMaximum();
            int extent = model.getExtent();
            int value = model.getValue();
            currentEditorState.setYScrollMin(minimum);
            currentEditorState.setYScrollMax(maximum);
            currentEditorState.setYScrollExtent(extent);
            currentEditorState.setYScrollPos(value);
        }
    }

    void loadPaneState() {
        JScrollBar nativeVertScrollBar;
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState currentEditorState = splitPaneState.getCurrentEditorState();
        JScrollBar nativeHorzScrollBar = this.getNativeHorzScrollBar();
        if (this._installedHorzScrollBar == nativeHorzScrollBar) {
            BoundedRangeModel model = nativeHorzScrollBar.getModel();
            int xScrollMin = currentEditorState.getXScrollMin();
            int xScrollMax = currentEditorState.getXScrollMax();
            int xScrollExtent = currentEditorState.getXScrollExtent();
            int xScrollPos = currentEditorState.getXScrollPos();
            model.setMinimum(xScrollMin);
            model.setMaximum(xScrollMax);
            model.setExtent(xScrollExtent);
            model.setValue(xScrollPos);
        }
        if (this._installedVertScrollBar == (nativeVertScrollBar = this.getNativeVertScrollBar())) {
            BoundedRangeModel model = nativeVertScrollBar.getModel();
            int yScrollMin = currentEditorState.getYScrollMin();
            int yScrollMax = currentEditorState.getYScrollMax();
            int yScrollExtent = currentEditorState.getYScrollExtent();
            int yScrollPos = currentEditorState.getYScrollPos();
            model.setMinimum(yScrollMin);
            model.setMaximum(yScrollMax);
            model.setExtent(yScrollExtent);
            model.setValue(yScrollPos);
        }
    }

    private void attachOldEditor(Editor newEditor) {
        Component editorComponent = newEditor.getGUI();
        this.setEditorComponent(editorComponent, false, null, null);
    }

    private void attachNullEditor() {
        JPanel editorComponent = new JPanel();
        this.setEditorComponent(editorComponent, false, null, null);
    }

    void focusCurrentEditor() {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        EditorState currentEditorState = splitPaneState.getCurrentEditorState();
        if (currentEditorState != null) {
            Editor editor;
            Component focusedComponent = currentEditorState.getFocusedComponent();
            if (focusedComponent == null && (editor = currentEditorState.getEditor()) != null && (focusedComponent = editor.getDefaultFocusComponent()) != null && focusedComponent.getName() == null) {
                String mainComponentName = "Editor" + _splitPaneID + "_MAIN";
                focusedComponent.setName(mainComponentName);
            }
            if (focusedComponent != null && SwingUtilities.isDescendingFrom(focusedComponent, this._editorComponent)) {
                focusedComponent.requestFocus();
            } else {
                GraphicsUtils.focusComponentOrChild((Component)this._editorComponent);
            }
        }
    }

    private int searchEditorClassPos(Class editorClass) {
        int pageCount = this._editorTabs.getPageCount();
        int i = 0;
        while (i < pageCount) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)this._editorTabs.getPage(i);
            EditorState editorState = (EditorState)page.getUserObject();
            EditorAddin editorAddin = editorState.getEditorAddin();
            if (editorClass.equals(editorAddin.getEditorClass())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getCurrentEditorStatePos() {
        return this._currentEditorStatePos;
    }

    boolean setCurrentEditorStatePos(int editorStatePos) {
        boolean ret = false;
        if (editorStatePos != this._currentEditorStatePos) {
            SplitPaneState splitPaneState = this.getSplitPaneState();
            boolean canSetEditorState = splitPaneState.canSetEditorStatePos(editorStatePos);
            if (canSetEditorState) {
                boolean shouldRestoreFocus = GraphicsUtils.getFocusedChildComponent((Component)this) != null;
                Desktop desktop = EditorManagerImpl.getInstance().getDesktop();
                desktop.freezeFocusChanges(true);
                this.detachCurrentEditor();
                this._currentEditorStatePos = editorStatePos;
                splitPaneState.setCurrentEditorStatePos(this._currentEditorStatePos);
                this.attachCurrentEditor();
                if (shouldRestoreFocus) {
                    this.focusCurrentEditor();
                }
                desktop.freezeFocusChanges(false);
                this._editorTabs.setSelectedPage(editorStatePos);
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    private void setEditorEnabled(int editorPos, boolean enabled) {
        DefaultCustomTabPage page = (DefaultCustomTabPage)this._editorTabs.getPage(editorPos);
        if (page.isEnabled() != enabled) {
            page.setEnabled(enabled);
        }
        this._editorTabs.whenTabChanged();
    }

    public boolean activateEditor(Editor editor) {
        boolean ret = false;
        int editorClassPos = this.searchEditorClassPos(editor.getClass());
        if (this.getEditor(editorClassPos) == editor) {
            this.setCurrentEditorStatePos(editorClassPos);
            ret = true;
        }
        return ret;
    }

    private Editor getEditor(int index) {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        Editor editor = splitPaneState.getOrCreateEditor(index);
        return editor;
    }

    public void whenEditorStateChanges(EditorState editorState) {
        boolean enabled = editorState.isEnabled();
        int editorStatePos = this.searchEditorStatePos(editorState);
        this.setEditorEnabled(editorStatePos, enabled);
    }

    private int searchEditorStatePos(EditorState editorState) {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        int pageCount = splitPaneState.getEditorStateCount();
        int i = 0;
        while (i < pageCount) {
            EditorState editorState_i = splitPaneState.getEditorState(i);
            if (editorState == editorState_i) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void closeAll() {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        TabGroupState tabGroupState = splitPaneState.getParentTabGroupState();
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        editorManager.closeEditors(new TabGroupState[]{tabGroupState});
    }

    public void containerActivated(boolean isActive) {
        SplitPaneState splitPaneState = this.getSplitPaneState();
        if (splitPaneState != null) {
            if (isActive) {
                splitPaneState.whenEditorActivated();
            }
            this.getTabGroup().setFocused(isActive);
        }
    }

    public void mousePressed(MouseEvent e) {
        Component component = e.getComponent();
        if (component == this._vertSplitter) {
            Graphics g = this.getGraphics();
            g.setXORMode(this.getBackground());
            this._ptDragSplitter = SwingUtilities.convertPoint(this._vertSplitter, e.getPoint(), this);
            g.drawLine(0, this._ptDragSplitter.y, this.getWidth(), this._ptDragSplitter.y);
        } else if (component == this._horzSplitter) {
            Graphics g = this.getGraphics();
            g.setXORMode(this.getBackground());
            this._ptDragSplitter = SwingUtilities.convertPoint(this._horzSplitter, e.getPoint(), this);
            g.drawLine(this._ptDragSplitter.x, 0, this._ptDragSplitter.x, this.getHeight());
        } else if (component == this._editorTabs) {
            this.whenEditorTabMousePressed();
        }
    }

    private void whenEditorTabMousePressed() {
        SplitPaneState splitPaneState;
        Editor currentEditor;
        EditorPathImpl editorPath;
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        if (editorManager.searchEditor(editorPath = new EditorPathImpl(), new EditorCriteriaImpl(currentEditor = (splitPaneState = this.getSplitPaneState()).getCurrentEditor()))) {
            editorManager.focusEditor(editorPath);
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getComponent() == this._vertSplitter) {
            Graphics g = this.getGraphics();
            g.setXORMode(this.getBackground());
            g.drawLine(0, this._ptDragSplitter.y, this.getWidth(), this._ptDragSplitter.y);
            this._ptDragSplitter = SwingUtilities.convertPoint(this._vertSplitter, e.getPoint(), this);
            g.drawLine(0, this._ptDragSplitter.y, this.getWidth(), this._ptDragSplitter.y);
        } else if (e.getComponent() == this._horzSplitter) {
            Graphics g = this.getGraphics();
            g.setXORMode(this.getBackground());
            g.drawLine(this._ptDragSplitter.x, 0, this._ptDragSplitter.x, this.getHeight());
            this._ptDragSplitter = SwingUtilities.convertPoint(this._horzSplitter, e.getPoint(), this);
            g.drawLine(this._ptDragSplitter.x, 0, this._ptDragSplitter.x, this.getHeight());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getComponent() == this._vertSplitter) {
            Graphics g = this.getGraphics();
            int ySplitPos = this._ptDragSplitter.y;
            g.setXORMode(this.getBackground());
            g.drawLine(0, ySplitPos, this.getWidth(), ySplitPos);
            Rectangle editorBounds = this._editorComponent.getBounds();
            if (ySplitPos >= editorBounds.y + 25 && ySplitPos <= editorBounds.y + editorBounds.height - 25) {
                this.getTabGroup().split(this, ySplitPos, 1);
            }
        } else if (e.getComponent() == this._horzSplitter) {
            Graphics g = this.getGraphics();
            int xSplitPos = this._ptDragSplitter.x;
            g.setXORMode(this.getBackground());
            g.drawLine(xSplitPos, 0, xSplitPos, this.getHeight());
            Rectangle editorBounds = this._editorComponent.getBounds();
            if (xSplitPos >= editorBounds.x + 25 && xSplitPos <= editorBounds.x + editorBounds.width - 25) {
                this.getTabGroup().split(this, xSplitPos, 0);
            }
        }
    }

    private TabGroup getTabGroup() {
        return (TabGroup)this.getParent().getParent();
    }

    public void mouseClicked(MouseEvent e) {
        if (this._splitTrigger.isDoubleClick(e)) {
            Component component = e.getComponent();
            TabGroup tabGroup = this.getTabGroup();
            Rectangle editorBounds = this._editorComponent.getBounds();
            if (component == this._vertSplitter) {
                if (editorBounds.height >= 50) {
                    tabGroup.split(this, editorBounds.y + editorBounds.height / 2, 1);
                }
            } else if (component == this._horzSplitter && editorBounds.width >= 50) {
                tabGroup.split(this, editorBounds.x + editorBounds.width / 2, 0);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        block1: {
            String propertyName;
            block6: {
                block5: {
                    block4: {
                        block3: {
                            block2: {
                                block0: {
                                    propertyName = evt.getPropertyName();
                                    if (!propertyName.equals("horizontal_scrollbar_policy")) break block0;
                                    this.whenHorizontalScrollbarPolicyChanges((Integer)evt.getNewValue());
                                    break block1;
                                }
                                if (!propertyName.equals("horizontal_unit_increment")) break block2;
                                this.whenHorizontalUnitChanges((Integer)evt.getNewValue());
                                break block1;
                            }
                            if (!propertyName.equals("horizontal_block_increment")) break block3;
                            this.whenHorizontalBlockIncrementChanges((Integer)evt.getNewValue());
                            break block1;
                        }
                        if (!propertyName.equals("vertical_scrollbar_policy")) break block4;
                        this.whenVerticalScrollbarPolicyChanges((Integer)evt.getNewValue());
                        break block1;
                    }
                    if (!propertyName.equals("vertical_unit_increment")) break block5;
                    this.whenVerticalUnitChanges((Integer)evt.getNewValue());
                    break block1;
                }
                if (!propertyName.equals("vertical_block_increment")) break block6;
                this.whenVerticalBlockIncrementChanges((Integer)evt.getNewValue());
                break block1;
            }
            if (!propertyName.equals("background_color")) break block1;
            this.whenBackgroundColorChanges((Color)evt.getNewValue());
        }
    }

    private void whenHorizontalScrollbarPolicyChanges(Integer policy) {
        this.setHorizontalScrollBarPolicy((policy = this.getWhenPropertyChangeValue(policy, "horizontal_scrollbar_policy")) != null ? policy : 31);
    }

    private void whenHorizontalUnitChanges(Integer unit) {
        JScrollBar nativeHorzScrollBar = this.getNativeHorzScrollBar();
        if (this._installedHorzScrollBar == nativeHorzScrollBar) {
            nativeHorzScrollBar.setUnitIncrement((unit = this.getWhenPropertyChangeValue(unit, "horizontal_unit_increment")) != null ? unit : 1);
        }
    }

    private void whenHorizontalBlockIncrementChanges(Integer horizontalBlockIncrement) {
        JScrollBar nativeHorzScrollBar = this.getNativeHorzScrollBar();
        if (this._installedHorzScrollBar == nativeHorzScrollBar) {
            nativeHorzScrollBar.setBlockIncrement((horizontalBlockIncrement = this.getWhenPropertyChangeValue(horizontalBlockIncrement, "horizontal_block_increment")) != null ? horizontalBlockIncrement : 1);
        }
    }

    private void whenVerticalScrollbarPolicyChanges(Integer policy) {
        this.setVerticalScrollBarPolicy((policy = this.getWhenPropertyChangeValue(policy, "vertical_scrollbar_policy")) == null ? 21 : policy);
    }

    private void whenVerticalUnitChanges(Integer unit) {
        JScrollBar nativeVertScrollBar = this.getNativeVertScrollBar();
        if (nativeVertScrollBar == this._installedVertScrollBar) {
            nativeVertScrollBar.setUnitIncrement((unit = this.getWhenPropertyChangeValue(unit, "vertical_unit_increment")) != null ? unit : 1);
        }
    }

    private void whenVerticalBlockIncrementChanges(Integer verticallBlockIncrement) {
        JScrollBar nativeVertScrollBar = this.getNativeVertScrollBar();
        if (this._installedVertScrollBar == nativeVertScrollBar) {
            nativeVertScrollBar.setBlockIncrement((verticallBlockIncrement = this.getWhenPropertyChangeValue(verticallBlockIncrement, "vertical_block_increment")) != null ? verticallBlockIncrement : 1);
        }
    }

    private void whenBackgroundColorChanges(Color backgroundColor) {
        backgroundColor = this.getWhenPropertyChangeValue(backgroundColor, "background_color");
        JViewport viewport = this._scrollPane.getViewport();
        viewport.setBackground(backgroundColor);
    }

    private Integer getWhenPropertyChangeValue(Integer integerProperty, String propertyName) {
        if (integerProperty == null) {
            SplitPaneState splitPaneState = this.getSplitPaneState();
            Editor currentEditor = splitPaneState.getCurrentEditor();
            integerProperty = (Integer)currentEditor.getEditorAttribute(propertyName);
        }
        return integerProperty;
    }

    private Color getWhenPropertyChangeValue(Color colorProperty, String propertyName) {
        if (colorProperty == null) {
            Editor currentEditor = this.getSplitPaneState().getCurrentEditor();
            colorProperty = (Color)currentEditor.getEditorAttribute(propertyName);
        }
        return colorProperty;
    }

    public void handleEvent(int commandId) {
        block4: {
            block5: {
                if (commandId != 40) break block5;
                int currentEditorStatePos = this.getCurrentEditorStatePos();
                int pageCount = this._editorTabs.getPageCount();
                int editorPage = currentEditorStatePos + 1;
                while (editorPage < pageCount) {
                    DefaultCustomTabPage page = (DefaultCustomTabPage)this._editorTabs.getPage(editorPage);
                    boolean enabled = page.isEnabled();
                    if (enabled) {
                        this.setCurrentEditorStatePos(editorPage);
                        break block4;
                    }
                    ++editorPage;
                }
                break block4;
            }
            if (commandId != 41) break block4;
            int currentEditorStatePos = this.getCurrentEditorStatePos();
            int editorPage = currentEditorStatePos - 1;
            while (editorPage >= 0) {
                DefaultCustomTabPage page = (DefaultCustomTabPage)this._editorTabs.getPage(editorPage);
                boolean enabled = page.isEnabled();
                if (enabled) {
                    this.setCurrentEditorStatePos(editorPage);
                    break;
                }
                --editorPage;
            }
        }
    }

    boolean canDo(IdeAction action) {
        boolean ret;
        block4: {
            int commandId;
            block5: {
                ret = false;
                commandId = action.getCommandId();
                if (commandId != 40) break block5;
                int currentEditorStatePos = this.getCurrentEditorStatePos();
                int pageCount = this._editorTabs.getPageCount();
                int editorPage = currentEditorStatePos + 1;
                while (editorPage < pageCount) {
                    DefaultCustomTabPage page = (DefaultCustomTabPage)this._editorTabs.getPage(editorPage);
                    boolean enabled = page.isEnabled();
                    if (enabled) {
                        ret = true;
                        break block4;
                    }
                    ++editorPage;
                }
                break block4;
            }
            if (commandId != 41) break block4;
            int currentEditorStatePos = this.getCurrentEditorStatePos();
            int editorPage = currentEditorStatePos - 1;
            while (editorPage >= 0) {
                DefaultCustomTabPage page = (DefaultCustomTabPage)this._editorTabs.getPage(editorPage);
                boolean enabled = page.isEnabled();
                if (enabled) {
                    ret = true;
                    break;
                }
                --editorPage;
            }
        }
        return ret;
    }

    void highlight(boolean highlight) {
    }

    public void componentResized(ComponentEvent e) {
        this.whenHorizontalBlockIncrementChanges(null);
        this.whenVerticalBlockIncrementChanges(null);
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    private JScrollBar getNativeVertScrollBar() {
        return this._nativeVertScrollBar;
    }

    private JScrollBar getNativeHorzScrollBar() {
        return this._nativeHorzScrollBar;
    }

    static CustomTab ra$_editorTabs(SplitPane splitPane) {
        return splitPane._editorTabs;
    }

    static TabGroup mav$getTabGroup(SplitPane splitPane) {
        return splitPane.getTabGroup();
    }

    static Color mav$getBorderColor(SplitPane splitPane) {
        return splitPane.getBorderColor();
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            int selectedPage = SplitPane.ra$_editorTabs(SplitPane.this).getSelectedPage();
            SplitPane.this.setCurrentEditorStatePos(selectedPage);
        }
    }

    final class 2
    extends DelegatingBorder {
        private final /* synthetic */ Border v$normalBottomBorder;
        final /* synthetic */ SplitPane this$0;

        protected Border getDelegate() {
            if (!Themes.isThemed()) {
                return this.v$normalBottomBorder;
            }
            if (SplitPane.mav$getTabGroup(this.this$0).isFocused()) {
                return BorderFactory.createLineBorder(SplitPane.mav$getBorderColor(this.this$0));
            }
            return BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }

        public 2(SplitPane splitPane, Border border) {
            this.v$normalBottomBorder = border;
            this.this$0 = splitPane;
        }
    }

    final class 3
    extends ComponentAdapter {
        private final /* synthetic */ JViewport v$viewport;
        private final /* synthetic */ Dimension v$primaryScreenSize;
        final /* synthetic */ SplitPane this$0;

        public void componentResized(ComponentEvent e) {
            Dimension viewportSize = this.v$viewport.getSize();
            if (viewportSize.getWidth() > this.v$primaryScreenSize.getWidth() || viewportSize.getHeight() > this.v$primaryScreenSize.getHeight()) {
                this.v$viewport.removeComponentListener(this);
                this.v$viewport.setScrollMode(0);
            }
        }

        public 3(SplitPane splitPane, JViewport jViewport, Dimension dimension) {
            this.v$primaryScreenSize = dimension;
            this.v$viewport = jViewport;
            this.this$0 = splitPane;
        }
    }
}

