/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import oracle.ide.Context;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorCriteria;
import oracle.ide.model.Node;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.editor.EditorCreation;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.TabGroupState;

final class SplitPaneState {
    private TabGroupState _parentTabGroupState;
    private SplitPane _splitPane;
    private int _currentEditorStatePos;
    private DefaultListModel _editorsModel;

    private void $init$() {
        this._currentEditorStatePos = -1;
    }

    public SplitPaneState(EditorCreation editorCreation, TabGroupState tabGroupState) {
        this.$init$();
        this._parentTabGroupState = tabGroupState;
        this._editorsModel = this.createEditorsModel(editorCreation.getEditorAddins());
    }

    public SplitPaneState(TabGroupState tabGroupState) {
        this.$init$();
        this._parentTabGroupState = tabGroupState;
        this._editorsModel = this.createEditorsModel();
    }

    TabGroupState getParentTabGroupState() {
        return this._parentTabGroupState;
    }

    public String toString() {
        TabGroupState tabGroupState = this.getParentTabGroupState();
        Context context = tabGroupState.getContext();
        Node node = context.getNode();
        String shortLabel = node.getShortLabel();
        return shortLabel;
    }

    private DefaultListModel createEditorsModel() {
        List editorAddins = this.getParentTabGroupState().getEditorAddins();
        return this.createEditorsModel(editorAddins);
    }

    private DefaultListModel createEditorsModel(List editorAddins) {
        DefaultListModel<DefaultCustomTabPage> editorsModel = new DefaultListModel<DefaultCustomTabPage>();
        int nbrEditors = editorAddins.size();
        int i = 0;
        while (i < nbrEditors) {
            EditorAddin editorAddin = (EditorAddin)editorAddins.get(i);
            MenuSpec menuSpecification = editorAddin.getMenuSpecification();
            EditorState editorState = new EditorState(this, editorAddin);
            DefaultCustomTabPage page = new DefaultCustomTabPage(menuSpecification.getIcon(), menuSpecification.label, (Object)editorState);
            editorsModel.addElement(page);
            ++i;
        }
        return editorsModel;
    }

    public SplitPane getSplitPane() {
        return this._splitPane;
    }

    public void setSplitPane(SplitPane splitPane) {
        this._splitPane = splitPane;
    }

    public int getEditorStateCount() {
        return this._editorsModel.getSize();
    }

    public EditorState getEditorState(int i) {
        DefaultCustomTabPage page = (DefaultCustomTabPage)this._editorsModel.get(i);
        EditorState editorState = (EditorState)page.getUserObject();
        return editorState;
    }

    public int searchEditorPos(Class editorClass) {
        int n = this.getEditorStateCount();
        int i = 0;
        while (i < n) {
            EditorState editorState = this.getEditorState(i);
            EditorAddin editorAddin = editorState.getEditorAddin();
            if (editorClass.equals(editorAddin.getEditorClass())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int searchEditorPos(EditorAddin editorAddin) {
        int n = this.getEditorStateCount();
        int i = 0;
        while (i < n) {
            EditorState editorState = this.getEditorState(i);
            EditorAddin editorAddin_i = editorState.getEditorAddin();
            if (editorAddin_i == editorAddin) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int searchEditorPos(String editorAddinClassName) {
        int n = this.getEditorStateCount();
        int i = 0;
        while (i < n) {
            EditorState editorState = this.getEditorState(i);
            EditorAddin editorAddin_i = editorState.getEditorAddin();
            if (editorAddinClassName.equals(editorAddin_i.getClass().getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPath) {
        boolean ret = false;
        editorPath._editorPos = this.getCurrentEditorStatePos();
        if (editorPath._editorPos != -1) {
            ret = true;
        }
        return ret;
    }

    public Editor getCurrentEditor() {
        Editor ret = null;
        EditorState currentEditorState = this.getCurrentEditorState();
        if (currentEditorState != null) {
            ret = currentEditorState.getEditor();
        }
        return ret;
    }

    public int getCurrentEditorStatePos() {
        return this._currentEditorStatePos;
    }

    public EditorState getCurrentEditorState() {
        return this._currentEditorStatePos == -1 ? null : this.getEditorState(this._currentEditorStatePos);
    }

    public boolean setCurrentEditorStatePos(int currentEditorStatePos) {
        boolean canChange = true;
        if (this._currentEditorStatePos != currentEditorStatePos && (canChange = this.canSetEditorStatePos(currentEditorStatePos))) {
            TabGroupState parentTabGroupState = this.getParentTabGroupState();
            if (this._currentEditorStatePos != -1 && parentTabGroupState != null) {
                parentTabGroupState.reserveEditorStates(this, this._currentEditorStatePos, false);
            }
            this._currentEditorStatePos = currentEditorStatePos;
            if (this._currentEditorStatePos != -1 && parentTabGroupState != null) {
                parentTabGroupState.reserveEditorStates(this, currentEditorStatePos, true);
                parentTabGroupState.whenCurrentEditorChanges(this);
            }
        }
        return canChange;
    }

    boolean canSetEditorStatePos(int editorStatePos) {
        boolean canSetEditorState;
        if (editorStatePos == -1) {
            canSetEditorState = true;
        } else {
            EditorState editorState = this.getEditorState(editorStatePos);
            Editor newEditor = editorState.getEditor();
            if (newEditor == null) {
                TabGroupState parentTabGroupState = this.getParentTabGroupState();
                Context context = parentTabGroupState.getContext();
                newEditor = editorState.getOrCreateEditor(context);
            }
            canSetEditorState = newEditor != null;
        }
        return canSetEditorState;
    }

    public Editor getOrCreateEditor(int editorStatePos) {
        EditorState editorState = this.getEditorState(editorStatePos);
        Context context = this.getParentTabGroupState().getContext();
        return editorState.getOrCreateEditor(context);
    }

    public DefaultListModel getEditorsModel() {
        return this._editorsModel;
    }

    public static boolean match(EditorCriteria editorCriteria) {
        return false;
    }

    public boolean searchEditor(EditorPathImpl editorPath, EditorCriteriaImpl editorCriteria) {
        boolean ret = false;
        int n = this.getEditorStateCount();
        int i = 0;
        while (!ret && i < n) {
            EditorState editorState = this.getEditorState(i);
            if (editorState.match(editorCriteria)) {
                editorPath._editorPos = i;
                editorPath._editorStatus = 0;
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public void whenEditorActivated() {
        this.getParentTabGroupState().whenEditorActivated(this);
    }

    public void whenEditorStateChanges(EditorState editorState) {
        SplitPane splitPane = this.getSplitPane();
        if (splitPane != null) {
            splitPane.whenEditorStateChanges(editorState);
        }
    }

    void dump(String indent, boolean isActive) {
        System.out.println(indent + "SplitPaneState" + (isActive ? "*" : ""));
        int nbrEditorStates = this.getEditorStateCount();
        int i = 0;
        while (i < nbrEditorStates) {
            EditorState editorState = this.getEditorState(i);
            boolean active = i == this._currentEditorStatePos;
            editorState.dump(indent + "  ", active);
            ++i;
        }
    }

    public boolean activateEditor(EditorPathImpl editorPath) {
        boolean ret = false;
        if (editorPath._editorPos == -1) {
            editorPath._editorPos = this.getCurrentEditorStatePos();
            ret = true;
        } else {
            SplitPane splitPane = this.getSplitPane();
            if (splitPane != null && editorPath != null) {
                ret = splitPane.setCurrentEditorStatePos(editorPath._editorPos);
            }
        }
        return ret;
    }

    boolean saveStateInfo(StructuredPropertyAccess element) {
        boolean saveNode = this.isRestorableAtStartup();
        if (saveNode) {
            EditorState currentEditorState = this.getCurrentEditorState();
            EditorAddin editorAddin = currentEditorState.getEditorAddin();
            String currentEditorAddinClassName = editorAddin.getClass().getName();
            element.setProperty("currentEditor", currentEditorAddinClassName);
            int editorStateCount = this.getEditorStateCount();
            int i = 0;
            while (i < editorStateCount) {
                EditorState editorState = this.getEditorState(i);
                EditorAddin editorAddin_i = editorState.getEditorAddin();
                if (editorState.getEditor() != null) {
                    DefaultStructuredPropertyAccess editorStateElement = new DefaultStructuredPropertyAccess("editorState");
                    String addinName = editorAddin_i.getClass().getName();
                    editorStateElement.setProperty("addin", addinName);
                    editorState.saveStateInfo((StructuredPropertyAccess)editorStateElement);
                    element.appendChild((StructuredPropertyAccess)editorStateElement);
                } else {
                    StructuredPropertyAccess layoutInfo = editorState.getStateInfo();
                    if (layoutInfo != null) {
                        element.addAll(layoutInfo);
                    }
                }
                ++i;
            }
        }
        return saveNode;
    }

    boolean isRestorableAtStartup() {
        int editorStateCount = this.getEditorStateCount();
        int i = 0;
        while (i < editorStateCount) {
            EditorState editorState = this.getEditorState(i);
            EditorAddin editorAddin_i = editorState.getEditorAddin();
            if (!editorAddin_i.restoreAtStartup()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean loadStateInfo(StructuredPropertyAccess element) {
        Iterator childNodes = element.getChildNodes("editorState");
        while (childNodes.hasNext()) {
            int editorPos;
            StructuredPropertyAccess childNode = (StructuredPropertyAccess)childNodes.next();
            String addinName = childNode.getProperty("addin", null);
            if (addinName == null || (editorPos = this.searchEditorPos(addinName)) == -1) continue;
            EditorState editorState = this.getEditorState(editorPos);
            editorState.loadStateInfo(childNode);
        }
        String currentEditor = element.getProperty("currentEditor", null);
        int currentEditorStatePos = -1;
        if (currentEditor != null) {
            currentEditorStatePos = this.searchEditorPos(currentEditor);
        }
        if (currentEditorStatePos == -1) {
            currentEditorStatePos = 0;
        }
        boolean ret = this.setCurrentEditorStatePos(currentEditorStatePos);
        return ret;
    }

    boolean isSplitable() {
        int currentEditorStatePos = this.getCurrentEditorStatePos();
        EditorState currentEditorState = this.getEditorState(currentEditorStatePos);
        EditorAddin currentEditorAddin = currentEditorState.getEditorAddin();
        boolean canSplit = true;
        if (!currentEditorAddin.isDuplicable()) {
            canSplit = false;
            TabGroupState tabGroupState = this.getParentTabGroupState();
            int nbrEditorStates = this.getEditorStateCount();
            int editorStatePos = 0;
            while (editorStatePos < nbrEditorStates) {
                SplitPaneState reservedEditorState = tabGroupState.getReservedEditorState(editorStatePos);
                if (reservedEditorState == null) {
                    canSplit = true;
                }
                ++editorStatePos;
            }
        }
        return canSplit;
    }
}

