/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.MenuSelectionManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeUIManager;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.DropDownMenuButton;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.SmallSquareDropDownMenuButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.customtab.AutoRepeatButtonModel;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.datatransfer.TransferableContext;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.editor.DelegatingBorder;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.DocTabListener;
import oracle.ideimpl.editor.EditorCreation;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.SplitPaneStructPersistence;
import oracle.ideimpl.editor.TabGroupPanel;
import oracle.ideimpl.editor.TabGroupState;
import oracle.ideimpl.editor.TransferableEditorTab;
import oracle.ideimpl.util.DropFileUtil;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.themes.Themes;

final class TabGroup
extends JPanel
implements ComponentListener,
ActionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
ChangeListener,
ItemListener {
    private static final int HEADER_PANEL_HEIGHT = 2;
    private final CustomTab _docTabs;
    private final JPanel _headerPanel;
    private final TabGroupPanel _centerPanel;
    private TabGroupState _currentTabGroupState;
    private final JViewport _viewport;
    private final Box _buttonBox;
    private final JButton _scrollLeftButton;
    private final JButton _scrollRightButton;
    private final DropDownMenuButton _dropDownButton;
    private final DragSource _dragSource;
    private boolean _ensureTabVisibleAfterValidate;
    private boolean _headerPanelVisible;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._dragSource = new DragSource();
        this._headerPanelVisible = true;
    }

    public TabGroup() {
        this.$init$();
        if (Themes.isThemed()) {
            this._headerPanelVisible = false;
        }
        this.setOpaque(false);
        this._docTabs = new CustomTab(new DefaultListModel(), 1);
        this._docTabs.setGradientHighlight(true);
        this._docTabs.setOpaque(false);
        this._docTabs.setOffsetSelected(0);
        DocTabListener docTabListener = new DocTabListener(this, this._docTabs);
        this._docTabs.addSelectionListener((ListSelectionListener)docTabListener);
        this._docTabs.addListDataListener((ListDataListener)docTabListener);
        this._docTabs.addMouseListener((MouseListener)docTabListener);
        this._docTabs.setCtrlClickCloseEnabled(true);
        this._docTabs.setCloseAction((Action)new TabCloseAction());
        this._viewport = new JViewport();
        this._viewport.setView((Component)this._docTabs);
        this._viewport.addChangeListener(this);
        this._viewport.setOpaque(false);
        this._viewport.addComponentListener(this);
        String activateLeftTooltip = KeyUtil.buildTooltip((int)70);
        this._scrollLeftButton = new SmallSquareButton();
        this._scrollLeftButton.setAlignmentY(0.5f);
        this._scrollLeftButton.setModel((ButtonModel)new AutoRepeatButtonModel(400, 100));
        this._scrollLeftButton.addActionListener(this);
        this.initScrollButton(this._scrollLeftButton, activateLeftTooltip, 7);
        String activateRightTooltip = KeyUtil.buildTooltip((int)71);
        this._scrollRightButton = new SmallSquareButton();
        this._scrollRightButton.setModel((ButtonModel)new AutoRepeatButtonModel(400, 100));
        this._scrollRightButton.addActionListener(this);
        this.initScrollButton(this._scrollRightButton, activateRightTooltip, 3);
        String dropDownTooltip = KeyUtil.buildTooltip((int)EditorManager.SHOW_DROPDOWN_CMD_ID);
        this._dropDownButton = new SmallSquareDropDownMenuButton();
        this._dropDownButton.addItemListener((ItemListener)this);
        this.initScrollButton((AbstractButton)this._dropDownButton, dropDownTooltip, 5);
        Component buttonBoxFiller = Box.createHorizontalStrut(5);
        buttonBoxFiller.addMouseListener(docTabListener);
        this._buttonBox = new Box(0);
        this._buttonBox.setBorder(new ThemeBottomBorder(null));
        this._buttonBox.setOpaque(false);
        this._buttonBox.addMouseListener(docTabListener);
        this._buttonBox.add(buttonBoxFiller);
        this._buttonBox.add(this._scrollLeftButton);
        this._buttonBox.add(Box.createHorizontalStrut(1));
        this._buttonBox.add(this._scrollRightButton);
        this._buttonBox.add(Box.createHorizontalStrut(1));
        this._buttonBox.add((Component)this._dropDownButton);
        if (Themes.isThemed()) {
            this._buttonBox.add(Box.createHorizontalStrut(4));
        }
        Border headerBorder = JavatoolsBorderFactory.createLeftRightBorder((Color)IdeConstants.COLOR_IDE_LINES);
        this._headerPanel = new JPanel();
        this._headerPanel.setBackground(IdeUIManager.getInactiveTitleGradientDarkColor());
        this._headerPanel.setBorder(headerBorder);
        this._centerPanel = new TabGroupPanel();
        this._dragSource.createDefaultDragGestureRecognizer((Component)this._docTabs, 2, this);
        new DropTarget((Component)this._docTabs, this);
        new DropTarget(this._headerPanel, this);
        new DropTarget(this._buttonBox, this);
        this.add(this._buttonBox);
        this.add(this._viewport);
        if (this._headerPanelVisible) {
            this.add(this._headerPanel);
        }
        this.add(this._centerPanel);
    }

    protected void paintComponent(Graphics g) {
        if (Themes.isThemed()) {
            Themes.getActiveTheme().getStateProperties("onionskin", "normal").getPainter("bg").paint(g, 0, 0, this.getWidth(), this._docTabs.getHeight());
        }
        super.paintComponent(g);
    }

    private void initScrollButton(AbstractButton button, String toolTip, int arrowDir) {
        Icon icon = null;
        switch (arrowDir) {
            case 7: {
                icon = OracleIcons.getIcon((String)"extras/left.gif");
                break;
            }
            case 3: {
                icon = OracleIcons.getIcon((String)"extras/right.gif");
                break;
            }
            default: {
                icon = OracleIcons.getIcon((String)"extras/down.gif");
            }
        }
        button.setIcon(icon);
        button.setToolTipText(toolTip);
        button.setFocusable(false);
        button.setRolloverEnabled(false);
        Color col = button.getForeground();
        if (col == null) {
            col = Color.BLACK;
        }
        button.setForeground(new Color(col.getRed(), col.getGreen(), col.getBlue(), 144));
        button.setAlignmentY(0.0f);
    }

    private static EditorManagerImpl getEditorManager() {
        return EditorManagerImpl.getInstance();
    }

    private static Desktop getDesktop() {
        return TabGroup.getEditorManager().getDesktop();
    }

    public boolean isFocused() {
        return this._docTabs.isFocused();
    }

    public void setFocused(boolean focused) {
        this._docTabs.setFocused(focused);
        this._headerPanel.setBackground(focused ? IdeUIManager.getActiveTitleGradientDarkColor() : IdeUIManager.getInactiveTitleGradientDarkColor());
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        if (tabGroupState != null) {
            EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
            editorManager.moveTabGroupStateSwitchToTop(tabGroupState);
        }
    }

    public int getTabGroupStateCount() {
        return this._docTabs.getPageCount();
    }

    public TabGroupState getTabGroupState(int pos) {
        DefaultCustomTabPage page = (DefaultCustomTabPage)this._docTabs.getPage(pos);
        TabGroupState tabGroupState = (TabGroupState)page.getUserObject();
        return tabGroupState;
    }

    boolean addTabGroupState(EditorCreation editorCreation) {
        boolean ret = false;
        TabGroupState tabGroupState = new TabGroupState(this, editorCreation);
        SplitPaneState splitPaneState = tabGroupState.createSplitPaneState(editorCreation);
        if (splitPaneState != null) {
            tabGroupState.addSplitPaneState(splitPaneState);
            TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
            int currentTabGroupStatePos = this.indexOf(currentTabGroupState);
            EditorPathImpl editorPath = editorCreation.getEditorPath();
            editorPath._tabGroupStatePos = this.addTabGroupState(tabGroupState, currentTabGroupStatePos + 1);
            editorPath._panePos = 0;
            ret = true;
        }
        return ret;
    }

    int addTabGroupState(TabGroupState tabGroupState, int pos) {
        DefaultListModel model = (DefaultListModel)this._docTabs.getModel();
        if (pos < 0) {
            pos = model.getSize();
        }
        DefaultCustomTabPage tabPage = new DefaultCustomTabPage((Object)tabGroupState);
        model.add(pos, tabPage);
        tabGroupState.setParentTabGroup(this);
        this.whenTabGroupStateChanged(pos);
        TabGroup.getEditorManager().addToNodeList(tabGroupState);
        this._ensureTabVisibleAfterValidate = true;
        return pos;
    }

    void whenTabGroupStateChanged(TabGroupState tabGroupState) {
        block0: {
            int tabGroupStatePos = this.indexOf(tabGroupState);
            if (tabGroupStatePos == -1) break block0;
            this.whenTabGroupStateChanged(tabGroupStatePos);
        }
    }

    private void whenTabGroupStateChanged(int tabGroupStatePos) {
        DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._docTabs.getPage(tabGroupStatePos);
        TabGroupState tabGroupState = (TabGroupState)tabPage.getUserObject();
        Context context = tabGroupState.getContext();
        Node node = context.getNode();
        Icon icon = tabGroupState.getNodeIcon();
        String shortLabel = node.getShortLabel();
        String longLabel = tabGroupState.getLongLabel();
        Attributes attributes = node.getAttributes();
        boolean isDirty = attributes.isSet(ElementAttributes.COMPOSITE) ? attributes.isSet(ElementAttributes.DIRTY_COMPOSITE) : node.isDirty();
        tabPage.setIcon(icon);
        tabPage.setLabel(shortLabel);
        tabPage.setTooltip(longLabel);
        tabPage.setDirty(isDirty);
        this._docTabs.revalidate();
    }

    void closeTabGroupState(int pos) {
        DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._docTabs.getPage(pos);
        this.detachTabGroupState(pos);
        try {
            TabGroupState tabGroupState = (TabGroupState)tabPage.getUserObject();
            EditorManagerImpl editorManager = TabGroup.getEditorManager();
            editorManager.removeFromNodeList(tabGroupState);
            boolean restorableAtStartup = tabGroupState.isRestorableAtStartup();
            if (!restorableAtStartup) {
                Context context = tabGroupState.getContext();
                editorManager.removeFromLRUList(context);
            }
            int n = tabGroupState.getSplitPaneStateCount();
            int i = n - 1;
            while (i >= 0) {
                tabGroupState.closeSplitPaneState(i);
                --i;
            }
            tabGroupState.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this._docTabs.getPageCount() == 0) {
            Desktop desktop = TabGroup.getDesktop();
            desktop.removeTabGroup(this);
        }
    }

    void detachTabGroupState(int pos) {
        this._docTabs.removePage(pos);
    }

    private int indexOf(TabGroupState tabGroupState) {
        int n = this._docTabs.getPageCount();
        int i = 0;
        while (i < n) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)this._docTabs.getPage(i);
            if (page.getUserObject() == tabGroupState) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void whenTabSelectionChanges() {
        int tabGroupStatePos = this._docTabs.getSelectedPage();
        if (tabGroupStatePos == -1) {
            this.setCurrentTabGroupState(null);
        } else {
            this.safeSetCurrentTabGroupState(tabGroupStatePos);
        }
    }

    private static boolean canChangeSelection(TabGroupState newTabGroupState) {
        SplitPaneState newSplitPaneState;
        EditorState newEditorState;
        Editor newEditor;
        boolean ret = newTabGroupState != null ? (newEditor = (newEditorState = (newSplitPaneState = newTabGroupState.getCurrentSplitPaneState()).getCurrentEditorState()).getOrCreateEditor(newTabGroupState.getContext())) != null : true;
        return ret;
    }

    private void ensureTabVisible() {
        int selectedPage = this._docTabs.getSelectedPage();
        if (selectedPage != -1) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)this._docTabs.getPage(selectedPage);
            Dimension preferredSize = this._docTabs.getPreferredSize();
            if (preferredSize != null) {
                Rectangle pageBounds = page.getBounds();
                Rectangle viewRect = this._viewport.getViewRect();
                if (pageBounds.x < viewRect.x) {
                    this._viewport.setViewPosition(new Point(pageBounds.x, 0));
                } else if (pageBounds.x + pageBounds.width > viewRect.x + viewRect.width) {
                    this._viewport.setViewPosition(new Point(pageBounds.x + pageBounds.width - viewRect.width, 0));
                }
            }
        }
    }

    private void detachCurrentNode() {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != null) {
            this.updateCurrentLayoutState();
            int splitPaneStateCount = currentTabGroupState.getSplitPaneStateCount();
            int i = 0;
            while (i < splitPaneStateCount) {
                SplitPaneState splitPaneState = currentTabGroupState.getSplitPaneState(i);
                SplitPane splitPane = splitPaneState.getSplitPane();
                if (splitPane != null) {
                    this._centerPanel.remove(splitPane);
                    splitPane.setSplitPaneState(null);
                    splitPaneState.setSplitPane(null);
                    TabGroup.getEditorManager().releaseSplitPane(splitPane);
                }
                ++i;
            }
        }
    }

    private void updateCurrentLayoutState() {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        DockLayout layout = (DockLayout)this._centerPanel.getLayout();
        SplitPaneStructPersistence structPersistence = new SplitPaneStructPersistence(currentTabGroupState);
        DefaultStructuredPropertyAccess paneNode = new DefaultStructuredPropertyAccess("pane");
        layout.saveLayout(structPersistence, (StructuredPropertyAccess)paneNode);
        currentTabGroupState.setStructPersistence((StructuredPropertyAccess)paneNode);
    }

    private void attachCurrentNode() {
        DockLayout layout = (DockLayout)this._centerPanel.getLayout();
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        StructuredPropertyAccess structPersistence = currentTabGroupState.getStructPersistence();
        if (structPersistence != null) {
            SplitPaneStructPersistence layoutPersistence = new SplitPaneStructPersistence(currentTabGroupState);
            layout.loadLayout((Container)this._centerPanel, layoutPersistence, structPersistence);
        } else {
            SplitPaneState splitPaneState = currentTabGroupState.getSplitPaneState(0);
            SplitPane splitPane = TabGroup.getEditorManager().createSplitPane();
            splitPaneState.setSplitPane(splitPane);
            splitPane.setSplitPaneState(splitPaneState);
            this._centerPanel.add((Component)splitPane, new DockLayoutConstraint((Component)null, 2, 1, new Dimension(1000, 1000)));
        }
    }

    public void focusCurrentEditor() {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != null) {
            currentTabGroupState.focusCurrentEditor();
        }
    }

    void getDropArea(Rectangle dropArea) {
        this._centerPanel.getBounds(dropArea);
    }

    private static void printTree(Component top, String level) {
        System.out.println((top.isValid() ? " " : "I") + "  " + level + top.getClass().getName());
        if (top instanceof Container) {
            Container container = (Container)top;
            int i = 0;
            while (i < container.getComponentCount()) {
                Component component = container.getComponent(i);
                TabGroup.printTree(component, level + "  ");
                ++i;
            }
        }
    }

    static {
        $assertionsDisabled = TabGroup.class.desiredAssertionStatus() ^ true;
    }

    public void doLayout() {
        boolean hasTabs;
        boolean bl = hasTabs = this._docTabs.getPageCount() != 0;
        if (!$assertionsDisabled && !hasTabs) {
            throw new AssertionError();
        }
        if (hasTabs) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            Dimension tabSize = this._docTabs.getPreferredSize();
            Dimension buttonBoxSize = this._buttonBox.getPreferredSize();
            int buttonBoxGap = Themes.isThemed() ? 3 : 0;
            int tabHeight = Math.max(tabSize.height, this._buttonBox.getHeight());
            Rectangle rectangleViewport = new Rectangle(insets.left, insets.top + tabHeight - tabSize.height, size.width - (insets.left + buttonBoxSize.width + insets.right), tabSize.height);
            int buttonBoxY = insets.top + tabHeight - tabSize.height;
            Rectangle rectangleButtonBox = new Rectangle(rectangleViewport.x + rectangleViewport.width, buttonBoxY + buttonBoxGap, buttonBoxSize.width, tabSize.height - buttonBoxGap);
            this._viewport.setBounds(rectangleViewport);
            this._buttonBox.setBounds(rectangleButtonBox);
            if (this._headerPanelVisible) {
                this._headerPanel.setBounds(insets.left, insets.top + tabHeight, size.width - insets.left - insets.right, 2);
                tabHeight += 2;
            }
            this._centerPanel.setBounds(insets.left, insets.top + tabHeight, size.width - (insets.left + insets.right), size.height - (tabHeight + insets.top + insets.bottom));
        }
    }

    public void validate() {
        super.validate();
        if (this._ensureTabVisibleAfterValidate) {
            this._ensureTabVisibleAfterValidate = false;
            this.ensureTabVisible();
        }
    }

    public boolean searchEditor(EditorPathImpl editorPath, EditorCriteriaImpl editorCriteria) {
        boolean ret = false;
        int pageCount = this.getTabGroupStateCount();
        int i = 0;
        while (!ret && i < pageCount) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            if (tabGroupState.match(editorCriteria) || tabGroupState.searchEditor(editorPath, editorCriteria)) {
                editorPath._tabGroupStatePos = i;
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public boolean match(EditorCriteriaImpl editorCriteria) {
        return editorCriteria.getCriteria1() == this && editorCriteria.getType() == 13;
    }

    public boolean activateEditor(EditorPathImpl editorPath) {
        TabGroupState tabGroupState;
        boolean ret = true;
        int tabGroupStatePos = editorPath._tabGroupStatePos;
        if (tabGroupStatePos != -1 && this.setCurrentTabGroupState(tabGroupState = this.getTabGroupState(tabGroupStatePos)) && (ret = tabGroupState.activateEditor(editorPath))) {
            this.restoreIfMaximized();
            if (!this._ensureTabVisibleAfterValidate) {
                this.ensureTabVisible();
            }
        }
        return ret;
    }

    private void restoreIfMaximized() {
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        int maximizeType = mainWindow.getMaximizedWindowType();
        if (maximizeType == 1) {
            mainWindow.restore();
        } else if (maximizeType == 2 && !this.isShowing()) {
            mainWindow.restore();
        }
    }

    public List findEditors(Context context) {
        ArrayList<Editor> ret = null;
        Node node = context.getNode();
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        int nodeCount = this.getTabGroupStateCount();
        int i = 0;
        while (i < nodeCount) {
            boolean equal;
            TabGroupState tabGroupState = this.getTabGroupState(i);
            Context tabGroupStateContext = tabGroupState.getContext();
            boolean bl = equal = ModelUtil.areEqual((Object)node, (Object)tabGroupStateContext.getNode()) && ModelUtil.areEqual((Object)project, (Object)tabGroupStateContext.getProject()) && ModelUtil.areEqual((Object)workspace, (Object)tabGroupStateContext.getWorkspace());
            if (equal) {
                int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
                int j = 0;
                while (j < splitPaneStateCount) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(j);
                    int nbrEditorStates = splitPaneState.getEditorStateCount();
                    int k = 0;
                    while (k < nbrEditorStates) {
                        EditorState editorState = splitPaneState.getEditorState(k);
                        Editor editor = editorState.getEditor();
                        if (editor != null) {
                            if (ret == null) {
                                ret = new ArrayList<Editor>(1);
                            }
                            ret.add(editor);
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ret != null ? ret : Collections.EMPTY_LIST;
    }

    public List getAllEditors() {
        ArrayList<Editor> ret = new ArrayList<Editor>();
        int nodeCount = this.getTabGroupStateCount();
        int i = 0;
        while (i < nodeCount) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            int splitPaneCount = tabGroupState.getSplitPaneStateCount();
            int j = 0;
            while (j < splitPaneCount) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(j);
                int nbrEditorStates = splitPaneState.getEditorStateCount();
                int k = 0;
                while (k < nbrEditorStates) {
                    EditorState editorState = splitPaneState.getEditorState(k);
                    Editor editor = editorState.getEditor();
                    if (editor != null) {
                        ret.add(editor);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPath) {
        boolean ret = false;
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != null) {
            editorPath._tabGroupStatePos = this.indexOf(currentTabGroupState);
            ret = currentTabGroupState.getCurrentEditorPath(editorPath);
        }
        return ret;
    }

    TabGroupState getCurrentTabGroupState() {
        return this._currentTabGroupState;
    }

    public SplitPane getCurrentSplitPane() {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        return currentTabGroupState == null ? null : currentTabGroupState.getCurrentSplitPane();
    }

    public Editor getCurrentEditor() {
        Editor ret = null;
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != null) {
            ret = currentTabGroupState.getCurrentEditor();
        }
        return ret;
    }

    public SplitPane getSplitPane(Editor editor) {
        SplitPane ret = null;
        int nodeCount = this.getTabGroupStateCount();
        int i = 0;
        while (i < nodeCount) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            int splitPaneCount = tabGroupState.getSplitPaneStateCount();
            int j = 0;
            while (j < splitPaneCount) {
                SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(j);
                int nbrEditorStates = splitPaneState.getEditorStateCount();
                int k = 0;
                while (k < nbrEditorStates) {
                    EditorState editorState = splitPaneState.getEditorState(k);
                    if (editor == editorState.getEditor()) {
                        ret = splitPaneState.getSplitPane();
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    void close(TabGroupState[] tabGroupStates) {
        int currentPos;
        HashSet tabGroupStateSet = new HashSet();
        IdeUtil.addAll(tabGroupStateSet, (Object[])tabGroupStates);
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        int docToActivate = currentPos = this.indexOf(currentTabGroupState);
        while (docToActivate >= 0) {
            TabGroupState tabGroupState = this.getTabGroupState(docToActivate);
            if (!tabGroupStateSet.contains(tabGroupState)) break;
            --docToActivate;
        }
        if (docToActivate == -1) {
            int startPos;
            int nodeCount = this.getTabGroupStateCount();
            int i = startPos = currentPos >= 0 ? currentPos : 0;
            while (i < nodeCount) {
                TabGroupState tabGroupState = this.getTabGroupState(i);
                if (!tabGroupStateSet.contains(tabGroupState)) {
                    docToActivate = i;
                    break;
                }
                ++i;
            }
        }
        this._docTabs.setSelectedPage(docToActivate);
        int i = 0;
        while (i < tabGroupStates.length) {
            TabGroupState tabGroupState = tabGroupStates[i];
            int pageNo = this.indexOf(tabGroupState);
            if (pageNo != -1) {
                this.closeTabGroupState(pageNo);
            }
            ++i;
        }
    }

    private void updateButtonsEnabledStateActivate() {
        Point viewPosition = this._viewport.getViewPosition();
        Dimension viewSize = this._viewport.getViewSize();
        Dimension extentSize = this._viewport.getExtentSize();
        boolean scrollingRequired = viewPosition.x != 0 || viewPosition.x < viewSize.width - extentSize.width;
        this._scrollLeftButton.setVisible(scrollingRequired);
        this._scrollRightButton.setVisible(scrollingRequired);
    }

    public void stateChanged(ChangeEvent e) {
        this.updateButtonsEnabledStateActivate();
    }

    public void componentResized(ComponentEvent e) {
        this.ensureTabVisible();
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this._scrollLeftButton) {
            this.whenScrollTabsLeft();
        } else if (source == this._scrollRightButton) {
            this.whenScrollTabsRight();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this._dropDownButton) {
            if (e.getStateChange() == 1) {
                this.whenDropDownButtonPressed(true);
            } else if (e.getStateChange() == 2) {
                this.whenDropDownButtonPressed(false);
            }
        }
    }

    private void whenScrollTabsRight() {
        Point viewPosition = this._viewport.getViewPosition();
        Dimension viewSize = this._viewport.getViewSize();
        int pageAt = this._docTabs.getPageAfter(viewPosition.x);
        if (pageAt >= 0) {
            CustomTabPage page = this._docTabs.getPage(pageAt);
            Rectangle pageBounds = page.getBounds();
            Dimension extentSize = this._viewport.getExtentSize();
            int newViewPos = Math.min(pageBounds.x, viewSize.width - extentSize.width);
            this._viewport.setViewPosition(new Point(newViewPos, 0));
        }
    }

    private void whenScrollTabsLeft() {
        Point viewPosition = this._viewport.getViewPosition();
        int pageAt = this._docTabs.getPageBefore(viewPosition.x);
        if (pageAt >= 0) {
            CustomTabPage page = this._docTabs.getPage(pageAt);
            Rectangle pageBounds = page.getBounds();
            int xPos = pageBounds.x;
            this._viewport.setViewPosition(new Point(xPos, 0));
        }
    }

    private void whenDropDownButtonPressed(boolean isSelected) {
        this._dropDownButton.removeAllPopupItems();
        if (!isSelected) {
            return;
        }
        Dimension sizeScreen = this._dropDownButton.getToolkit().getScreenSize();
        List misc = TabGroup.getMiscPopupItems();
        List items = this.getEditorPopupItems();
        int n = misc.size();
        int nMiscMenuHeight = 0;
        int i = 0;
        while (i < n) {
            JMenuItem item = (JMenuItem)misc.get(i);
            int nHeight = item.getPreferredSize().height;
            nMiscMenuHeight += nHeight;
            ++i;
        }
        n = items.size();
        int nItemsMenuHeight = 0;
        int i2 = 0;
        while (i2 < n) {
            JMenuItem item = (JMenuItem)items.get(i2);
            int nHeight = item.getPreferredSize().height;
            nItemsMenuHeight += nHeight;
            ++i2;
        }
        if (nItemsMenuHeight + nMiscMenuHeight < sizeScreen.height * 9 / 10) {
            n = items.size();
            int i3 = 0;
            while (i3 < n) {
                JMenuItem item = (JMenuItem)items.get(i3);
                this._dropDownButton.addPopupItem(item);
                ++i3;
            }
        } else {
            n = items.size();
            int nAvailableHeight = sizeScreen.height * 9 / 10 - nMiscMenuHeight;
            int nNbrSubMenus = nItemsMenuHeight / nAvailableHeight + 1;
            int nNbrElementsPerMenu = items.size() / nNbrSubMenus + 1;
            int nElementsInThisMenu = nNbrElementsPerMenu + 1;
            JMenu subMenu = null;
            int i4 = 0;
            while (i4 < n) {
                JMenuItem item = (JMenuItem)items.get(i4);
                if (nElementsInThisMenu >= nNbrElementsPerMenu) {
                    String sFrom = item.getText();
                    int nTo = Math.min(i4 + nNbrElementsPerMenu, n) - 1;
                    JMenuItem itemTo = (JMenuItem)items.get(nTo);
                    String sTo = itemTo.getText();
                    subMenu = new JMenu(sFrom + " - " + sTo);
                    this._dropDownButton.addPopupItem((JMenuItem)subMenu);
                    nElementsInThisMenu = 0;
                }
                subMenu.add(item);
                ++nElementsInThisMenu;
                ++i4;
            }
        }
        this._dropDownButton.addPopupSeparator();
        n = misc.size();
        int i5 = 0;
        while (i5 < n) {
            JMenuItem item = (JMenuItem)misc.get(i5);
            this._dropDownButton.addPopupItem(item);
            ++i5;
        }
    }

    private List getEditorPopupItems() {
        ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
        int tabGroupStateCount = this.getTabGroupStateCount();
        int i = 0;
        while (i < tabGroupStateCount) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            Context context = tabGroupState.getContext();
            Node node = context.getNode();
            1 action = new 1(this, node.getShortLabel(), node.getIcon(), tabGroupState);
            JMenuItem item = new JMenuItem(action);
            list.add(item);
            ++i;
        }
        Collections.sort(list, new 2());
        return list;
    }

    private static List getMiscPopupItems() {
        ArrayList<JMenuItem> menus = new ArrayList<JMenuItem>(2);
        Menubar mb = Ide.getMenubar();
        IdeAction actionWindows = IdeAction.find((int)61);
        JMenuItem menuWindowDotDotDot = mb.createMenuItem((ToggleAction)actionWindows);
        menus.add(menuWindowDotDotDot);
        return menus;
    }

    public boolean canActivateLeftNode() {
        int selectedPage = this._docTabs.getSelectedPage();
        return selectedPage >= 1;
    }

    public void whenActivateLeftNode() {
        int selectedPage = this._docTabs.getSelectedPage();
        int newSelectedPage = selectedPage - 1;
        if (newSelectedPage >= 0) {
            this._docTabs.setSelectedPage(newSelectedPage);
            this.ensureTabVisible();
        }
    }

    public boolean canActivateRightNode() {
        int pageCount;
        int selectedPage = this._docTabs.getSelectedPage();
        return selectedPage + 1 < (pageCount = this._docTabs.getPageCount());
    }

    public void whenActivateRightNode() {
        int pageCount;
        int selectedPage = this._docTabs.getSelectedPage();
        int newSelectedPage = selectedPage + 1;
        if (newSelectedPage < (pageCount = this._docTabs.getPageCount())) {
            this._docTabs.setSelectedPage(newSelectedPage);
            this.ensureTabVisible();
        }
    }

    void splitPane(EditorPathImpl editorPath) {
        SplitPaneState splitPaneState = editorPath.getSplitPaneState();
        SplitPane splitPane = splitPaneState.getSplitPane();
        int splitAt = splitPane.getHeight() / 2;
        this.split(splitPane, splitAt, 1);
    }

    void unsplitPane(EditorPathImpl editorPath) {
        int keepPane = editorPath._panePos;
        TabGroupState tabGroupState = editorPath.getTabGroupState();
        editorPath._panePos = 0;
        int splitPaneStatePos = 0;
        while (splitPaneStatePos < keepPane) {
            this._centerPanel.closePanel(editorPath);
            ++splitPaneStatePos;
        }
        int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
        editorPath._panePos = 1;
        int splitPaneStatePos2 = 1;
        while (splitPaneStatePos2 < splitPaneStateCount) {
            this._centerPanel.closePanel(editorPath);
            ++splitPaneStatePos2;
        }
    }

    void split(SplitPane sourceSplitPane, int splitPos, int splitOrientation) {
        int editorStatePos;
        SplitPaneState sourceSplitPaneState;
        EditorState sourceEditorState;
        EditorAddin sourceEditorAddin;
        EditorAddin bestDuplicatedEditor;
        int newEditorStatePos;
        TabGroupState tabGroupState = this.getCurrentTabGroupState();
        SplitPaneState newSplitPaneState = new SplitPaneState(tabGroupState);
        boolean canCreateEditor = newSplitPaneState.setCurrentEditorStatePos(newEditorStatePos = newSplitPaneState.searchEditorPos(bestDuplicatedEditor = tabGroupState.findBestDuplicatedEditor(sourceEditorAddin = (sourceEditorState = (sourceSplitPaneState = sourceSplitPane.getSplitPaneState()).getEditorState(editorStatePos = sourceSplitPaneState.getCurrentEditorStatePos())).getEditorAddin())));
        if (canCreateEditor) {
            int orient;
            tabGroupState.addSplitPaneState(newSplitPaneState);
            SplitPane splitPane = EditorManagerImpl.getInstance().createSplitPane();
            newSplitPaneState.setSplitPane(splitPane);
            splitPane.setSplitPaneState(newSplitPaneState);
            DockLayoutInfoLeaf layoutInfo = this._centerPanel.getLayoutInfo(sourceSplitPane);
            Dimension sizePref = layoutInfo.getSize(2);
            Dimension sizeReal = sourceSplitPane.getSize();
            Dimension sizeNew = new Dimension(sizePref);
            if (splitOrientation == 1) {
                int heightToSplit = sizePref.height;
                sizePref.height = heightToSplit * splitPos / sizeReal.height;
                sizeNew.height = heightToSplit - sizePref.height;
                orient = 3;
            } else {
                int widthToSplit = sizePref.width;
                sizePref.width = widthToSplit * splitPos / sizeReal.width;
                sizeNew.width = widthToSplit - sizePref.width;
                orient = 1;
            }
            if (sourceEditorAddin == bestDuplicatedEditor) {
                DefaultStructuredPropertyAccess editorStateInfo = new DefaultStructuredPropertyAccess("DUPLICATON");
                sourceSplitPane.savePaneState();
                sourceEditorState.saveStateInfo((StructuredPropertyAccess)editorStateInfo);
                EditorState newEditorState = newSplitPaneState.getCurrentEditorState();
                newEditorState.loadStateInfo((StructuredPropertyAccess)editorStateInfo);
                splitPane.loadPaneState();
            }
            this._centerPanel.add((Component)splitPane, new DockLayoutConstraint(sourceSplitPane, orient, 1, sizeNew));
            this.revalidate();
        }
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        InputEvent event = dge.getTriggerEvent();
        if (event instanceof MouseEvent && ((MouseEvent)event).getButton() != 1) {
            return;
        }
        int pageAt = this._docTabs.getPageAt(dge.getDragOrigin());
        if (pageAt != -1) {
            TabGroupState tabGroupState = this.getTabGroupState(pageAt);
            Context context = tabGroupState.getContext();
            TransferableEditorTab transferableEditorTab = new TransferableEditorTab(context);
            TabGroup.getDesktop().setDropPanesVisible(true);
            this._dragSource.startDrag(dge, null, transferableEditorTab, this);
        }
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        TabGroup.getDesktop().setDropPanesVisible(false);
    }

    private boolean setCurrentTabGroupState(TabGroupState tabGroupState) {
        boolean ret = false;
        if (this._currentTabGroupState != tabGroupState) {
            if (TabGroup.canChangeSelection(tabGroupState)) {
                boolean shouldRestoreFocus = GraphicsUtils.getFocusedChildComponent((Component)this) != null;
                TabGroup.getDesktop().freezeFocusChanges(true);
                if (this._currentTabGroupState != null) {
                    this.detachCurrentNode();
                }
                this._currentTabGroupState = tabGroupState;
                int currentTabGroupStatePos = this._currentTabGroupState == null ? -1 : this.indexOf(this._currentTabGroupState);
                this._docTabs.setSelectedPage(currentTabGroupStatePos);
                if (this._currentTabGroupState != null) {
                    this.attachCurrentNode();
                    if (shouldRestoreFocus) {
                        this.focusCurrentEditor();
                    }
                }
                TabGroup.getDesktop().freezeFocusChanges(false);
                this.whenCurrentEditorChanges();
                if (tabGroupState != null) {
                    Context context = tabGroupState.getContext();
                    SplitPaneState currentSplitPaneState = tabGroupState.getCurrentSplitPaneState();
                    EditorState currentEditorState = currentSplitPaneState.getCurrentEditorState();
                    EditorAddin editorAddin = currentEditorState.getEditorAddin();
                    EditorManagerImpl editorManager = TabGroup.getEditorManager();
                    editorManager.raiseContextInLRUList(context, editorAddin);
                    editorManager.moveTabGroupStateSwitchToTop(tabGroupState);
                }
                this.revalidate();
                this.repaint();
                ret = true;
            }
        } else {
            ret = true;
        }
        return ret;
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        TabGroup.handleDragEvent(dtde);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        TabGroup.handleDragEvent(dtde);
    }

    private static void handleDragEvent(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(TransferableEditorTab.contextFlavor) || dtde.isDataFlavorSupported(TransferableContext.contextFlavor) || dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        DataFlavor[] transferDataFlavors = transferable.getTransferDataFlavors();
        int i = 0;
        while (i < transferDataFlavors.length) {
            DataFlavor transferDataFlavor = transferDataFlavors[i];
            try {
                if (TransferableEditorTab.contextFlavor.equals(transferDataFlavor)) {
                    this.dropTransferableEditorTab(dtde);
                } else if (TransferableContext.contextFlavor.equals(transferDataFlavor)) {
                    this.dropTransferableContext(dtde);
                } else if (DataFlavor.javaFileListFlavor.equals(transferDataFlavor)) {
                    this.dropJavaFileList(dtde);
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void dropTransferableContext(DropTargetDropEvent dtde) throws IOException, UnsupportedFlavorException {
        dtde.acceptDrop(3);
        Transferable transferable = dtde.getTransferable();
        TransferableContext transferableContext = (TransferableContext)transferable.getTransferData(TransferableContext.contextFlavor);
        Context context = transferableContext.getContext();
        this.dropContext(context);
    }

    private void dropTransferableEditorTab(DropTargetDropEvent dtde) throws UnsupportedFlavorException, IOException {
        dtde.acceptDrop(3);
        Transferable transferable = dtde.getTransferable();
        TransferableEditorTab transferableEditorTab = (TransferableEditorTab)transferable.getTransferData(TransferableEditorTab.contextFlavor);
        Context context = transferableEditorTab.getContext();
        this.dropContext(context);
    }

    private void dropContext(Context context) {
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(context);
        EditorPathImpl editorPath = new EditorPathImpl();
        EditorManagerImpl editorManager = TabGroup.getEditorManager();
        if (editorManager.searchEditor(editorPath, editorCriteria)) {
            TabGroup tabGroupSource = editorPath.getTabGroup();
            if (tabGroupSource != this) {
                TabGroupState tabGroupState = editorPath.getTabGroupState();
                tabGroupSource.detachTabGroupState(editorPath._tabGroupStatePos);
                editorPath._tabGroupStatePos = this.addTabGroupState(tabGroupState, -1);
                this.activateEditor(editorPath);
                int tabGroupStateCount = tabGroupSource.getTabGroupStateCount();
                if (tabGroupStateCount == 0) {
                    TabGroup.getDesktop().removeTabGroup(tabGroupSource);
                }
            }
        } else if (editorManager.searchEditor(editorPath, new EditorCriteriaImpl(this))) {
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            editorManager.createEditor(openEditorOptions, editorPath);
        }
    }

    private void dropJavaFileList(DropTargetDropEvent dtde) {
        EditorPathImpl editorPath;
        EditorManagerImpl editorManager = TabGroup.getEditorManager();
        if (editorManager.searchEditor(editorPath = new EditorPathImpl(), new EditorCriteriaImpl(this))) {
            editorManager.activateEditor(editorPath);
        }
        DropFileUtil.drop(dtde);
    }

    void showDropDownMenu() {
        this._dropDownButton.setSelected(true);
    }

    void whenCurrentEditorChanges(TabGroupState tabGroupState) {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState == tabGroupState) {
            this.whenCurrentEditorChanges();
        }
    }

    private void whenCurrentEditorChanges() {
        Desktop desktop = TabGroup.getDesktop();
        desktop.whenCurrentEditorChanges(this);
    }

    public void whenEditorActivated(TabGroupState tabGroupState) {
        TabGroupState currentTabGroupState = this.getCurrentTabGroupState();
        if (currentTabGroupState != tabGroupState) {
            this.setCurrentTabGroupState(tabGroupState);
        }
        TabGroup.getDesktop().whenEditorActivated(this);
    }

    void dump(String indent, boolean isActive) {
        System.out.println(indent + "TabGroupState" + (isActive ? "*" : ""));
        int tabGroupStateCount = this.getTabGroupStateCount();
        int i = 0;
        while (i < tabGroupStateCount) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            boolean active = tabGroupState == this._currentTabGroupState;
            tabGroupState.dump(indent + "  ", active);
            ++i;
        }
    }

    public void whenShowSystemMenu() {
        int selectedPage = this._docTabs.getSelectedPage();
        this.showSystemMenu(selectedPage, null);
    }

    void showSystemMenu(int pagePos, Point ptClick) {
        int yMenuPos;
        int xMenuPos;
        if (!this.isShowing()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        Menubar menuManager = Ide.getMenubar();
        EditorManagerImpl editorManager = TabGroup.getEditorManager();
        if (pagePos != -1) {
            IdeAction localAction;
            IdeAction localAction2;
            IdeAction localAction3;
            TabGroupState tabGroupState = this.getTabGroupState(pagePos);
            EditorPathImpl editorPath = new EditorPathImpl();
            editorManager.searchEditor(editorPath, new EditorCriteriaImpl(tabGroupState));
            tabGroupState.getCurrentEditorPath(editorPath);
            Editor currentEditor = editorPath.getSplitPaneState().getCurrentEditor();
            Context context = currentEditor.getContext();
            int[] conditionalCommandIDs = new int[]{EditorManagerImpl.MAXIMIZE_TAB_GROUP_CMD_ID, EditorManagerImpl.RESTORE_TAB_GROUPS_CMD_ID, EditorManagerImpl.SPLIT_DOCUMENT_CMD_ID, EditorManagerImpl.UNSPLIT_DOCUMENT_CMD_ID, EditorManagerImpl.DETACH_DOCUMENT_CMD_ID, EditorManagerImpl.REGROUP_DOCUMENTS_CMD_ID};
            int i = 0;
            while (i < conditionalCommandIDs.length) {
                int conditionalCommandID = conditionalCommandIDs[i];
                IdeAction localAction4 = TabGroup.createLocalAction(conditionalCommandID, currentEditor, context);
                if (localAction4 != null && localAction4.isEnabled()) {
                    JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)localAction4);
                    popupMenu.add(menuItem);
                }
                ++i;
            }
            IdeAction localAction5 = TabGroup.createLocalAction(WorkingSets.ADD_TO_WORKING_SET_CMD_ID, currentEditor, context);
            if (localAction5 != null && localAction5.isEnabled()) {
                JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)localAction5);
                popupMenu.addSeparator();
                popupMenu.add(menuItem);
            }
            if ((localAction3 = TabGroup.createLocalAction(AddContentCommand.ADD_URL_TO_PROJECT_CMD_ID, currentEditor, context)) != null && localAction3.isEnabled()) {
                JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)localAction3);
                String prName = context.getProject().getShortLabel();
                String menuText = ModelArb.format((int)67, (Object)prName);
                menuItem.setText(menuText);
                popupMenu.addSeparator();
                popupMenu.add(menuItem);
            }
            popupMenu.addSeparator();
            IdeAction localAction6 = TabGroup.createLocalAction(61, currentEditor, context);
            if (localAction6 != null) {
                JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)localAction6);
                popupMenu.add(menuItem);
            }
            popupMenu.addSeparator();
            IdeAction localAction7 = TabGroup.createLocalAction(48, currentEditor, context);
            if (localAction7 != null) {
                JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)localAction7);
                popupMenu.add(menuItem);
            }
            if ((localAction2 = TabGroup.createLocalAction(39, currentEditor, context)) != null) {
                JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)localAction2);
                popupMenu.add(menuItem);
            }
            if ((localAction = TabGroup.createLocalAction(EditorManagerImpl.CLOSE_OTHERS_CMD_ID, currentEditor, context)) != null) {
                JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)localAction);
                popupMenu.add(menuItem);
            }
        } else {
            Editor currentEditor = this.getCurrentEditor();
            Context context = currentEditor != null ? currentEditor.getContext() : null;
            int[] conditionalCommandIDs = new int[]{EditorManagerImpl.MAXIMIZE_TAB_GROUP_CMD_ID, EditorManagerImpl.RESTORE_TAB_GROUPS_CMD_ID, EditorManagerImpl.REGROUP_DOCUMENTS_CMD_ID};
            int i = 0;
            while (i < conditionalCommandIDs.length) {
                int conditionalCommandID = conditionalCommandIDs[i];
                IdeAction action = TabGroup.createLocalAction(conditionalCommandID, currentEditor, context);
                editorManager.update(action, context);
                if (action.isEnabled()) {
                    JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)action);
                    popupMenu.add(menuItem);
                }
                ++i;
            }
            popupMenu.addSeparator();
            IdeAction action = IdeAction.find((int)61);
            editorManager.update(action, null);
            JMenuItem menuItem = menuManager.createMenuItem((ToggleAction)action);
            popupMenu.add(menuItem);
            popupMenu.addSeparator();
            IdeAction action2 = IdeAction.find((int)39);
            editorManager.update(action2, null);
            JMenuItem menuItem2 = menuManager.createMenuItem((ToggleAction)action2);
            popupMenu.add(menuItem2);
        }
        if (ptClick == null) {
            CustomTabPage page = this._docTabs.getPage(pagePos);
            Rectangle bounds = page.getBounds();
            xMenuPos = bounds.x;
            yMenuPos = bounds.y + bounds.height;
        } else {
            xMenuPos = ptClick.x;
            yMenuPos = ptClick.y;
        }
        popupMenu.show((Component)this._docTabs, xMenuPos, yMenuPos);
    }

    private static IdeAction createLocalAction(int cmdID, Editor currentEditor, Context context) {
        IdeAction localAction = IdeAction.newLocalAction((int)cmdID, (View)currentEditor);
        if (localAction != null) {
            localAction.updateAction(context);
        }
        return localAction;
    }

    boolean saveLayout(StructuredPropertyAccess leafBox) {
        this.updateCurrentLayoutState();
        boolean leavesSaved = false;
        int nbrTabGroupState = this.getTabGroupStateCount();
        int i = 0;
        while (i < nbrTabGroupState) {
            TabGroupState tabGroupState = this.getTabGroupState(i);
            boolean restorableAtStartup = tabGroupState.isRestorableAtStartup();
            if (restorableAtStartup) {
                DefaultStructuredPropertyAccess stateNode = new DefaultStructuredPropertyAccess("state");
                tabGroupState.saveStateInfo((StructuredPropertyAccess)stateNode);
                leafBox.appendChild((StructuredPropertyAccess)stateNode);
                leavesSaved = true;
            }
            ++i;
        }
        if (leavesSaved) {
            int selectedPage = this._docTabs.getSelectedPage();
            leafBox.setProperty("selectedPage", Integer.toString(selectedPage));
        }
        return leavesSaved;
    }

    static TabGroup loadLayout(StructuredPropertyAccess leafBox) {
        TabGroup tabGroup = new TabGroup();
        String selectedPageString = leafBox.getProperty("selectedPage", "0");
        int selectedPage = Integer.parseInt(selectedPageString);
        Iterator childNodes = leafBox.getChildNodes("state");
        while (childNodes.hasNext()) {
            TabGroupState tabGroupState = new TabGroupState(tabGroup);
            StructuredPropertyAccess element = (StructuredPropertyAccess)childNodes.next();
            if (!tabGroupState.loadStateInfo(element)) continue;
            tabGroup.addTabGroupState(tabGroupState, -1);
        }
        boolean ret = tabGroup.safeSetCurrentTabGroupState(selectedPage);
        tabGroup.validate();
        return ret ? tabGroup : null;
    }

    private boolean safeSetCurrentTabGroupState(int selectedPage) {
        boolean ret = false;
        while (!ret && selectedPage >= 0) {
            int tabGroupStateCount = this.getTabGroupStateCount();
            if (selectedPage >= tabGroupStateCount) {
                --selectedPage;
                continue;
            }
            TabGroupState tabGroupState = this.getTabGroupState(selectedPage);
            if (this.setCurrentTabGroupState(tabGroupState)) {
                ret = true;
                continue;
            }
            this.closeTabGroupState(selectedPage);
        }
        return ret;
    }

    void highlight(boolean highlight) {
    }

    static EditorManagerImpl maS$getEditorManager() {
        return TabGroup.getEditorManager();
    }

    private class ThemeBottomBorder
    extends DelegatingBorder {
        private final Border _normalBorder;

        private void $init$() {
            this._normalBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, IdeConstants.COLOR_IDE_LINES);
        }

        protected Border getDelegate() {
            Color c = IdeConstants.COLOR_IDE_LINES;
            if (Themes.isThemed()) {
                c = TabGroup.this.isFocused() ? Themes.getActiveTheme().getStateProperties("view", "active").getColor("bordercolor") : Themes.getActiveTheme().getStateProperties("view", "inactive").getColor("bordercolor");
                return BorderFactory.createMatteBorder(0, 0, 1, 0, c);
            }
            return this._normalBorder;
        }

        private ThemeBottomBorder() {
            this.$init$();
        }

        ThemeBottomBorder(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 1
    extends AbstractAction {
        private final /* synthetic */ TabGroupState v$tabGroupState;
        final /* synthetic */ TabGroup this$0;

        public void actionPerformed(ActionEvent e) {
            EditorPathImpl editorPath;
            EditorManagerImpl editorManager = TabGroup.maS$getEditorManager();
            if (editorManager.searchEditor(editorPath = new EditorPathImpl(), new EditorCriteriaImpl(this.v$tabGroupState))) {
                editorManager.focusEditor(editorPath);
            }
        }

        public 1(TabGroup tabGroup, String string, Icon icon, TabGroupState tabGroupState) {
            this.v$tabGroupState = tabGroupState;
            this.this$0 = tabGroup;
            super(string, icon);
        }
    }

    final class 2
    implements Comparator {
        public int compare(Object o1, Object o2) {
            JMenuItem item1 = (JMenuItem)o1;
            JMenuItem item2 = (JMenuItem)o2;
            return String.CASE_INSENSITIVE_ORDER.compare(item1.getText(), item2.getText());
        }
    }

    private static final class TabCloseAction
    extends AbstractAction {
        public TabCloseAction() {
            this.putValue("ShortDescription", KeyUtil.buildTooltip((int)48));
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            DefaultCustomTabPage page = (DefaultCustomTabPage)source;
            TabGroupState tabGroupState = (TabGroupState)page.getUserObject();
            TabGroupState[] tabGroupStates = new TabGroupState[]{tabGroupState};
            EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
            editorManager.closeEditors(tabGroupStates);
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
    }
}

