/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Graphics;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import oracle.ide.editor.Editor;
import oracle.ideimpl.controls.dockLayout.AbstractDockLayoutInfoNode;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockLayout;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutPanel;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;
import oracle.javatools.ui.themes.Theme;
import oracle.javatools.ui.themes.Themes;

final class TabGroupPanel
extends DockLayoutPanel
implements ContainerListener {
    private static final int CLOSE_SENSIBILITY = 50;

    public TabGroupPanel() {
        this.addContainerListener(this);
        this.setPaintingDividers(false);
    }

    private TabGroup getTabGroup() {
        return (TabGroup)this.getParent();
    }

    protected void whenDividerMoved() {
        if (this._draggedIsHorz && this._draggedPtLast.x < 50) {
            this.whenDividerCloses(this._draggedDivider.getBefore());
        } else if (this._draggedIsHorz && this._draggedPtLast.x > this.getWidth() - 50) {
            this.whenDividerCloses(this._draggedDivider.getAfter());
        } else if (!this._draggedIsHorz && this._draggedPtLast.y < 50) {
            this.whenDividerCloses(this._draggedDivider.getBefore());
        } else if (!this._draggedIsHorz && this._draggedPtLast.y > this.getHeight() - 50) {
            this.whenDividerCloses(this._draggedDivider.getAfter());
        } else {
            super.whenDividerMoved();
        }
    }

    protected void paintComponent(Graphics g) {
        if (Themes.isThemed()) {
            Theme t = Themes.getActiveTheme();
            t.getStateProperties("onionskinbottom", "normal").getPainter("bg").paint(g, 0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
        this.paintDivider(g, this._layout.getVertDividers(this), true);
    }

    private void whenDividerCloses(DockLayoutInfo layoutInfo) {
        this.closePanels(layoutInfo);
        this._draggedDivider = null;
        this.setCursor(null);
    }

    protected void whenDividerDoubleClicked(DockDivider divider, int orientation) {
        DockLayoutInfo before;
        SplitPane currentSplitPane = this.getTabGroup().getCurrentSplitPane();
        DockLayoutInfo sideToClose = this.isSplitPaneInDockLayoutInfo(currentSplitPane, before = divider.getBefore()) ? divider.getAfter() : before;
        this.closePanels(sideToClose);
    }

    private boolean isSplitPaneInDockLayoutInfo(SplitPane splitPane, DockLayoutInfo dockLayoutInfo) {
        if (dockLayoutInfo.isLeaf()) {
            DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)dockLayoutInfo;
            return dockLayoutInfoLeaf.getComponent() == splitPane;
        }
        int n = dockLayoutInfo.getNodeCount();
        int i = n - 1;
        while (i >= 0) {
            DockLayoutInfo child = dockLayoutInfo.getNode(i);
            if (this.isSplitPaneInDockLayoutInfo(splitPane, child)) {
                return true;
            }
            --i;
        }
        return false;
    }

    private void closePanels(DockLayoutInfo sideToClose) {
        EditorPathImpl editorPathToFocus;
        ArrayList editors = new ArrayList(1);
        this.collectEditorsToClose(sideToClose, editors);
        TabGroup tabGroup = this.getTabGroup();
        SplitPane currentSplitPane = tabGroup.getCurrentSplitPane();
        Editor currentEditor = currentSplitPane.getCurrentEditor();
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        Editor splitPaneEditorToFocus = null;
        if (editors.contains(currentEditor)) {
            TabGroupState currentTabGroupState = tabGroup.getCurrentTabGroupState();
            int i = 0;
            while (splitPaneEditorToFocus == null && i < currentTabGroupState.getSplitPaneStateCount()) {
                SplitPane splitPane = currentTabGroupState.getSplitPane(i);
                Editor splitPaneEditor = splitPane.getCurrentEditor();
                if (!editors.contains(splitPaneEditor)) {
                    splitPaneEditorToFocus = splitPaneEditor;
                }
                ++i;
            }
        }
        if (splitPaneEditorToFocus != null && editorManager.searchEditor(editorPathToFocus = new EditorPathImpl(), new EditorCriteriaImpl(splitPaneEditorToFocus))) {
            editorManager.focusEditor(editorPathToFocus);
        }
        this.closePanels(editors);
    }

    private void collectEditorsToClose(DockLayoutInfo layoutInfo, ArrayList editors) {
        if (layoutInfo.isLeaf()) {
            DockLayoutInfoLeaf dockLayoutInfoLeaf = (DockLayoutInfoLeaf)layoutInfo;
            SplitPane splitPane = (SplitPane)dockLayoutInfoLeaf.getComponent();
            SplitPaneState splitPaneState = splitPane.getSplitPaneState();
            if (splitPaneState != null) {
                EditorState currentEditorState = splitPaneState.getCurrentEditorState();
                Editor editor = currentEditorState.getEditor();
                editors.add(editor);
            }
        } else {
            int n = layoutInfo.getNodeCount();
            int i = n - 1;
            while (i >= 0) {
                DockLayoutInfo child = layoutInfo.getNode(i);
                this.collectEditorsToClose(child, editors);
                --i;
            }
        }
    }

    private void closePanels(ArrayList editors) {
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        EditorPathImpl editorPath = new EditorPathImpl();
        int i = 0;
        while (i < editors.size()) {
            Editor editor = (Editor)editors.get(i);
            EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(editor);
            if (editorManager.searchEditor(editorPath, editorCriteria)) {
                this.closePanel(editorPath);
            }
            this.revalidate();
            ++i;
        }
    }

    void closePanel(EditorPathImpl editorPath) {
        TabGroupState tabGroupState = editorPath.getTabGroupState();
        SplitPaneState splitPaneState = editorPath.getSplitPaneState();
        SplitPane splitPane = splitPaneState.getSplitPane();
        tabGroupState.closeSplitPaneState(editorPath._panePos);
        this.remove(splitPane);
    }

    public void componentAdded(ContainerEvent e) {
        this.whenSplitPaneAddedOrRemoved();
    }

    public void componentRemoved(ContainerEvent e) {
        this.whenSplitPaneAddedOrRemoved();
    }

    private void whenSplitPaneAddedOrRemoved() {
        DockLayout layout = (DockLayout)this.getLayout();
        DockLayoutInfo constraints = layout.getConstraints();
        this.recWalkSplitPanes(constraints);
    }

    private void recWalkSplitPanes(DockLayoutInfo constraints) {
        AbstractDockLayoutInfoNode abstractDockLayoutInfoNode = (AbstractDockLayoutInfoNode)constraints;
        int nodeCount = constraints.getNodeCount();
        boolean isVertical = abstractDockLayoutInfoNode.isSameOrientation(2);
        int i = 0;
        while (i < nodeCount) {
            DockLayoutInfo node = constraints.getNode(i);
            if (node.isLeaf()) {
                DockLayoutInfoLeaf leaf = (DockLayoutInfoLeaf)node;
                SplitPane splitPane = (SplitPane)leaf.getComponent();
                SplitPaneState splitPaneState = splitPane.getSplitPaneState();
                boolean canSplit = splitPaneState.isSplitable();
                if (isVertical) {
                    splitPane.setVertSplitterVisible(canSplit && i == 0);
                    splitPane.setHorzSplitterVisible(canSplit);
                } else {
                    splitPane.setVertSplitterVisible(canSplit);
                    splitPane.setHorzSplitterVisible(canSplit && i == nodeCount - 1);
                }
            } else {
                this.recWalkSplitPanes(node);
            }
            ++i;
        }
    }
}

