/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ProductInformation;
import oracle.ideimpl.extension.AddinInfo;
import oracle.ideimpl.extension.ProductAddins;
import oracle.ideri.util.Product;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddinsHook
extends ExtensionHook {
    static final ElementName ELEMENT;
    private static final ElementName ADDIN;
    private static final String KEY_LOADSET = "loadset";
    private static final String KEY_HASUI = "hasUI";
    private ElementVisitor _addinVisitor;
    private Map<String, AddinInfo> _addinInfosByAddinClass;
    private boolean _processedProductAddins;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._addinVisitor = new AddinVisitor(null);
        this._addinInfosByAddinClass = new LinkedHashMap<String, AddinInfo>();
        this._processedProductAddins = false;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ADDIN, this._addinVisitor);
    }

    static {
        $assertionsDisabled = AddinsHook.class.desiredAssertionStatus() ^ true;
        ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "addins");
        ADDIN = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "addin");
    }

    public Collection<AddinInfo> getAddinInfos() {
        if (!this._processedProductAddins) {
            this._processedProductAddins = true;
            ProductInformation pi = ProductInformation.getProductInformation();
            Extension productExtension = javax.ide.extension.ExtensionRegistry.getExtensionRegistry().findExtension(Product.getProductID());
            if (!$assertionsDisabled && productExtension == null) {
                throw new AssertionError((Object)("Could not find product extension: " + Product.getProductID()));
            }
            ProductAddins productAddins = new ProductAddins(pi.getHashStructure(), productExtension, ExtensionRegistry.getOracleRegistry().getLogger());
            Collection<AddinInfo> addinInfos = productAddins.getAddins();
            for (AddinInfo info : addinInfos) {
                String className = info.getClassName();
                AddinInfo existing = this._addinInfosByAddinClass.get(className);
                if (existing != null) {
                    this.logDuplicateAddinError(null, productExtension, info);
                    continue;
                }
                this._addinInfosByAddinClass.put(className, info);
            }
        }
        return this._addinInfosByAddinClass.values();
    }

    private void logDuplicateAddinError(ElementContext context, Extension extension, AddinInfo info) {
        String className = info.getClassName();
        String otherExtensionId = info.getExtension().getID();
        String message = "Duplicate declaration of addin " + className + ". Previously defined in extension " + otherExtensionId;
        if (context != null) {
            this.log(context, Level.SEVERE, message);
        } else {
            ExtensionRegistry.getExtensionRegistry().getLogger().log((LogRecord)new ExtensionLogRecord(Level.SEVERE, message, extension, 0));
        }
    }

    public AddinsHook() {
        this.$init$();
    }

    static Map ra$_addinInfosByAddinClass(AddinsHook addinsHook) {
        return addinsHook._addinInfosByAddinClass;
    }

    static void mav$logDuplicateAddinError(AddinsHook addinsHook, ElementContext elementContext, Extension extension, AddinInfo addinInfo) {
        addinsHook.logDuplicateAddinError(elementContext, extension, addinInfo);
    }

    private class AddinVisitor
    extends ElementVisitor {
        public void start(ElementStartContext context) {
            String headless;
            String loadset = context.getAttributeValue(AddinsHook.KEY_LOADSET);
            if (loadset != null && loadset.trim().length() > 0) {
                context.getScopeData().put(AddinsHook.KEY_LOADSET, loadset);
            }
            Boolean bHasUI = (headless = context.getAttributeValue("headless")) == null ? Boolean.TRUE : Boolean.valueOf(Boolean.valueOf(headless) ^ true);
            String hasUI = context.getAttributeValue("requires-ui");
            if (hasUI != null) {
                if (headless != null) {
                    this.log((ElementContext)context, Level.WARNING, "Deprecated 'requires-ui' attribute ignored. Using the value of 'headless'");
                } else {
                    this.log((ElementContext)context, Level.WARNING, "The 'requires-ui' attribute is deprecated. Use 'headless' instead.");
                    bHasUI = Boolean.valueOf(hasUI);
                }
            }
            context.getScopeData().put(AddinsHook.KEY_HASUI, bHasUI);
        }

        public void end(ElementEndContext context) {
            String addinClassName = context.getText().trim();
            if (addinClassName.length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing addin class name.");
            } else {
                AddinInfo info = (AddinInfo)AddinsHook.ra$_addinInfosByAddinClass(AddinsHook.this).get(addinClassName);
                if (info == null) {
                    String loadset = (String)context.getScopeData().get(AddinsHook.KEY_LOADSET);
                    Locator locator = (Locator)context.getScopeData().get("xml.locator");
                    info = new AddinInfo(addinClassName, loadset, locator == null ? 0 : locator.getLineNumber());
                    info.setHasUI((Boolean)context.getScopeData().get(AddinsHook.KEY_HASUI));
                    Extension ext = context.getExtension();
                    info.setExtension(ext);
                    AddinsHook.ra$_addinInfosByAddinClass(AddinsHook.this).put(addinClassName, info);
                } else {
                    AddinsHook.mav$logDuplicateAddinError(AddinsHook.this, (ElementContext)context, null, info);
                }
            }
        }

        private AddinVisitor() {
        }

        AddinVisitor(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

