/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;

final class HotDeployExtensionSource
implements ExtensionSource {
    private URI _manifestURI;
    private URI _classesURI;
    private URI _deployURI;

    HotDeployExtensionSource(URI manifestURI, URI classesURI, URI deployURI) {
        this._manifestURI = manifestURI;
        this._classesURI = classesURI;
        this._deployURI = deployURI;
    }

    public URI getClasspathEntry() {
        return this._classesURI;
    }

    public URI resolvePath(Extension extension, String path) {
        File f = new File(path);
        if (f.isAbsolute() && f.exists()) {
            return URIFactory.newFileURI((File)f);
        }
        if (path.length() >= 2 && path.charAt(0) == '/') {
            return URIFactory.newURI((URI)this._classesURI, (String)path.substring(1));
        }
        return URIFactory.newURI((URI)this._deployURI, (String)path);
    }

    public InputStream getInputStream() throws IOException {
        return VirtualFileSystem.getVirtualFileSystem().openInputStream(this.getManifestURI());
    }

    public URI getManifestURI() {
        return this._manifestURI;
    }

    public String getName() {
        return "TODO: Hot deployed extension of questionable identitiy";
    }

    public URI getURI() {
        return this._manifestURI;
    }
}

