/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.DefaultElementContext;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.extension.ExtensionProcessorContext;
import oracle.ide.extension.ExtensionProcessorPlugin;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.TimedCache;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.javatools.icons.OracleIcons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IDEElementContext
extends DefaultElementContext {
    private static final TimedCache _macroMapsByExtension = new TimedCache(5);
    private static final String ENV = "env:";
    private static final String ORACLEICONS = "OracleIcons.";

    protected String getMacroValue(String macroName) {
        String result;
        Extension ext;
        String var;
        String value;
        if ("ide.install.dir".equals(macroName)) {
            return Ide.getOracleHomeDirectory();
        }
        if (macroName != null && macroName.startsWith(ENV) && macroName.length() > ENV.length() && (value = System.getenv(var = macroName.substring(ENV.length()))) != null) {
            return value;
        }
        if (macroName != null && macroName.startsWith(ORACLEICONS) && macroName.length() > ORACLEICONS.length()) {
            String fieldName = macroName.substring(ORACLEICONS.length());
            try {
                String basePath = "res:/" + OracleIcons.class.getPackage().getName().replace('.', '/') + '/';
                Field f = OracleIcons.class.getField(fieldName);
                if (f != null) {
                    String string = basePath + f.get(null);
                    return string;
                }
            }
            catch (NoSuchFieldException e) {
                this.getLogger().log((LogRecord)new ExtensionLogRecord((ElementContext)this, Level.WARNING, "No icon called '" + fieldName + "' exists in OracleIcons."));
                String string = null;
                return string;
            }
            catch (Exception e) {
                ExtensionLogRecord record = new ExtensionLogRecord((ElementContext)this, Level.SEVERE, "An exception occurred retrieving OracleIcons." + fieldName);
                record.setThrown(e);
                this.getLogger().log((LogRecord)record);
                String string = null;
                return string;
            }
        }
        if ((ext = (Extension)this.getScopeData().get("extension")) != null && (result = IDEElementContext.getMacroMap(ext).get(macroName)) != null) {
            return result;
        }
        String superValue = super.getMacroValue(macroName);
        if (superValue != null) {
            return superValue;
        }
        ExtensionManagerImpl emi = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
        if (ext != null && !emi.getProcessorPlugins().isEmpty()) {
            String baseMacro;
            int colon;
            ExtensionProcessorContext context = (ExtensionProcessorContext)this.getScopeData().get("processorContext");
            if (context == null) {
                context = new 1(this, ext);
                this.getScopeData().put("processorContext", context);
            }
            if ((colon = (baseMacro = macroName).indexOf(58)) > 0) {
                baseMacro = baseMacro.substring(0, colon);
            }
            for (ExtensionProcessorPlugin p : emi.getProcessorPlugins()) {
                try {
                    Set supported = p.getSupportedMacros(context);
                    if (!supported.contains(baseMacro)) continue;
                    emi.getLogger().log(Level.INFO, "Macro " + macroName + " was expanded by " + p.getClass());
                    String string = p.expandValue(context, macroName);
                    return string;
                }
                catch (Throwable t) {
                    ExtensionLogRecord r = new ExtensionLogRecord((ElementContext)this, Level.SEVERE, "Exception in " + p.getClass());
                    r.setThrown(t);
                    this.getLogger().log((LogRecord)r);
                }
            }
        }
        return null;
    }

    private static Map<String, String> getMacroMap(Extension ext) {
        HashMap<String, String> macros = (HashMap<String, String>)_macroMapsByExtension.get((Object)ext.getID());
        if (macros == null) {
            macros = new HashMap<String, String>();
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            macros.put("ide.extension.install.home", er.getInstallDirectory(ext).getAbsolutePath());
            macros.put("ide.extension.user.home", URLFileSystem.getPlatformPathName((URL)er.getSystemDirectory(ext.getID(), ext.getVersion())));
            _macroMapsByExtension.put((Object)ext.getID(), macros);
        }
        return macros;
    }

    IDEElementContext() {
    }

    final class 1
    extends ExtensionProcessorContext {
        private final /* synthetic */ Extension v$ext;
        final /* synthetic */ IDEElementContext this$0;

        public String getExtensionId() {
            return this.v$ext.getID();
        }

        public 1(IDEElementContext iDEElementContext, Extension extension) {
            this.v$ext = extension;
            this.this$0 = iDEElementContext;
        }
    }
}

