/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.editor.TextEditor;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MessagePresenter
extends Handler
implements IdeListener {
    private static final String UNKNOWN_SOURCE = "(Unknown Source)";
    private final MessageTreeModel model;

    private void $init$() {
        this.model = new MessageTreeModel(null);
    }

    public MessagePresenter() {
        this.$init$();
        if (Ide.isRunning()) {
            Ide.addIdeListener((IdeListener)this);
        }
        this.setLevel(Level.INFO);
    }

    private void createLogPage() {
        LogManager logManager = LogManager.getLogManager();
        if (logManager == null) {
            return;
        }
        logManager.addPage((LogPage)new ManifestExtensionLogPage());
        if (!logManager.isLogVisible()) {
            logManager.showLog();
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        SwingUtils.dispatch((Runnable)new 1(this, record));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        if (this.model.hasMessages()) {
            this.createLogPage();
        } else {
            this.model.addTreeModelListener(new 2());
        }
    }

    private Comparator<LogRecord> recordComparator() {
        Collator collator = Collator.getInstance();
        return new 3(this, collator);
    }

    static MessageTreeModel ra$model(MessagePresenter messagePresenter) {
        return messagePresenter.model;
    }

    static Comparator mav$recordComparator(MessagePresenter messagePresenter) {
        return messagePresenter.recordComparator();
    }

    static void mav$createLogPage(MessagePresenter messagePresenter) {
        messagePresenter.createLogPage();
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ LogRecord v$record;
        final /* synthetic */ MessagePresenter this$0;

        public void run() {
            MessagePresenter.ra$model(this.this$0).publish(this.v$record);
        }

        public 1(MessagePresenter messagePresenter, LogRecord logRecord) {
            this.v$record = logRecord;
            this.this$0 = messagePresenter;
        }
    }

    final class 2
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
            MessagePresenter.ra$model(MessagePresenter.this).removeTreeModelListener(this);
            MessagePresenter.mav$createLogPage(MessagePresenter.this);
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    private final class ManifestExtensionLogPage
    extends DefaultLogPage {
        public ManifestExtensionLogPage() {
            super(new ViewId("ManifestExtensionLogPage", ExtensionManagerArb.getString(15)), null, false, DefaultLogPage.HIDE_FIX_SOURCE_MENU);
            this.getTree().setModel(MessagePresenter.ra$model(MessagePresenter.this));
            this.getTree().setCellRenderer(new ManifestLogCellRender(null));
            this.getTree().setShowsRootHandles(true);
            IdeUtil.expandAllTreeRows((JTree)this.getTree());
            MessagePresenter.ra$model(MessagePresenter.this).addTreeModelListener(new 1());
        }

        public HelpInfo getHelpInfo() {
            return new HelpInfo("f1_idelogwindowgen_html");
        }

        protected String treeNodeToString(Object treeNode) {
            if (treeNode instanceof LogRecord) {
                return this.getRecordText((LogRecord)treeNode);
            }
            return super.treeNodeToString(treeNode);
        }

        private String getRecordText(LogRecord rec) {
            return this.getFormattedMessage(rec);
        }

        private String initCap(String str) {
            StringBuffer b = new StringBuffer(str);
            boolean upper = true;
            int i = 0;
            while (i < b.length()) {
                char c = b.charAt(i);
                if (Character.isWhitespace(c)) {
                    upper = true;
                } else {
                    b.setCharAt(i, upper ? Character.toUpperCase(c) : Character.toLowerCase(c));
                    upper = false;
                }
                ++i;
            }
            return b.toString();
        }

        private String getFormattedMessage(LogRecord record) {
            StringBuffer message = new StringBuffer();
            if (record.getLevel() == Level.SEVERE) {
                message.append("Error");
            } else {
                message.append(this.initCap(record.getLevel().toString()));
            }
            message.append(": ");
            Object[] parameters = record.getParameters();
            if (parameters == null || parameters.length == 0) {
                message.append(record.getMessage());
            } else {
                message.append(MessageFormat.format(record.getMessage(), parameters));
            }
            return message.toString();
        }

        protected void activateObject(Object obj) {
            if (!(obj instanceof ExtensionLogRecord)) {
                return;
            }
            ExtensionLogRecord record = (ExtensionLogRecord)obj;
            Locator locator = record.getLocator();
            String fileURI = locator.getSystemId();
            URL url = null;
            try {
                url = VirtualFileSystem.getVirtualFileSystem().toURL(URIFactory.newURI((String)fileURI));
            }
            catch (MalformedURLException mfe) {
                url = null;
            }
            if (url == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Unable to open manifest for " + fileURI), (String)"Unable to Open Manifest", null);
            } else {
                try {
                    Node manifestNode = NodeFactory.findOrCreate((URL)url);
                    Context context = Context.newIdeContext((Node)manifestNode);
                    Editor editor = EditorUtil.openExplicitEditorInFrame(Class.forName("oracle.ide.ceditor.CodeEditor"), (Context)context);
                    if (editor instanceof TextEditor) {
                        int row = locator.getLineNumber();
                        int col = locator.getColumnNumber();
                        ((TextEditor)editor).gotoLine(row, col, true);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        private boolean isWarning(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.WARNING;
        }

        private boolean isError(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.SEVERE;
        }

        private boolean isInformation(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.INFO;
        }

        static String mav$getRecordText(ManifestExtensionLogPage manifestExtensionLogPage, LogRecord logRecord) {
            return manifestExtensionLogPage.getRecordText(logRecord);
        }

        static boolean mav$isError(ManifestExtensionLogPage manifestExtensionLogPage, Object object) {
            return manifestExtensionLogPage.isError(object);
        }

        static boolean mav$isWarning(ManifestExtensionLogPage manifestExtensionLogPage, Object object) {
            return manifestExtensionLogPage.isWarning(object);
        }

        static boolean mav$isInformation(ManifestExtensionLogPage manifestExtensionLogPage, Object object) {
            return manifestExtensionLogPage.isInformation(object);
        }

        static JTree mav$getTree(ManifestExtensionLogPage manifestExtensionLogPage) {
            return manifestExtensionLogPage.getTree();
        }

        final class 1
        implements TreeModelListener {
            public void treeNodesChanged(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
                if (e.getTreePath().getPathCount() == 1) {
                    IdeUtil.expandAllTreeRows((JTree)ManifestExtensionLogPage.mav$getTree(ManifestExtensionLogPage.this));
                }
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeStructureChanged(TreeModelEvent e) {
            }
        }

        private class ManifestLogCellRender
        extends DefaultTreeCellRenderer {
            private Font _defaultFont;
            private Font _boldFont;

            private void $init$() {
                this._defaultFont = null;
                this._boldFont = null;
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (this._defaultFont == null) {
                    this._defaultFont = this.getFont();
                    this._boldFont = new Font(this._defaultFont.getName(), 1, this._defaultFont.getSize());
                }
                if (value instanceof LogRecord) {
                    LogRecord rec = (LogRecord)value;
                    this.setText(ManifestExtensionLogPage.mav$getRecordText(ManifestExtensionLogPage.this, rec));
                }
                if (leaf) {
                    if (ManifestExtensionLogPage.mav$isError(ManifestExtensionLogPage.this, value)) {
                        this.setIcon(OracleIcons.getIcon((String)"error.png"));
                    } else if (ManifestExtensionLogPage.mav$isWarning(ManifestExtensionLogPage.this, value)) {
                        this.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    } else if (ManifestExtensionLogPage.mav$isInformation(ManifestExtensionLogPage.this, value)) {
                        this.setIcon(OracleIcons.getIcon((String)"info.png"));
                    }
                } else {
                    this.setIcon(OracleIcons.getIcon((String)"extras/extension.png"));
                }
                this.setFont(leaf ? this._defaultFont : this._boldFont);
                return this;
            }

            private ManifestLogCellRender() {
                this.$init$();
            }

            ManifestLogCellRender(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }

    final class 3
    implements Comparator {
        private final /* synthetic */ Collator v$collator;
        final /* synthetic */ MessagePresenter this$0;

        public int compare(LogRecord o1, LogRecord o2) {
            int levelComp = this.compareLevels(o1, o2);
            if (levelComp != 0) {
                return levelComp;
            }
            int lineNumberComp = this.compareLineNumbers(o1, o2);
            if (lineNumberComp != 0) {
                return lineNumberComp;
            }
            return this.v$collator.compare(o1.getMessage(), o2.getMessage());
        }

        private int compareLineNumbers(LogRecord o1, LogRecord o2) {
            if (o1 instanceof ExtensionLogRecord && o2 instanceof ExtensionLogRecord) {
                int o1Line = ((ExtensionLogRecord)o1).getLocator().getLineNumber();
                int o2Line = ((ExtensionLogRecord)o2).getLocator().getLineNumber();
                return o1Line - o2Line;
            }
            return 0;
        }

        private int compareLevels(LogRecord o1, LogRecord o2) {
            return o1.getLevel().intValue() - o2.getLevel().intValue();
        }

        public 3(MessagePresenter messagePresenter, Collator collator) {
            this.v$collator = collator;
            this.this$0 = messagePresenter;
        }
    }

    private final class MessageTreeModel
    implements TreeModel {
        private final Object ROOT;
        private final List<TreeModelListener> listeners;
        private final Map<String, Collection<LogRecord>> recordsByLocation;

        private void $init$() {
            this.ROOT = new Object();
            this.listeners = new CopyOnWriteArrayList<TreeModelListener>();
            this.recordsByLocation = new TreeMap<String, Collection<LogRecord>>();
        }

        public boolean hasMessages() {
            return this.getChildCount(this.ROOT) != 0;
        }

        public void publish(LogRecord record) {
            String location = this.location(record);
            Collection<LogRecord> records = this.recordsByLocation.get(location);
            if (records == null) {
                records = new TreeSet<LogRecord>(MessagePresenter.mav$recordComparator(MessagePresenter.this));
                this.recordsByLocation.put(location, records);
                int index = this.getIndexOfChild(this.ROOT, location);
                this.fireNodesInserted(new Object[]{this.ROOT}, new int[]{index}, new Object[]{location});
            }
            if (records.add(record)) {
                int index = this.getIndexOfChild(location, record);
                this.fireNodesInserted(new Object[]{this.ROOT, location}, new int[]{index}, new Object[]{record});
            }
        }

        private void fireNodesInserted(Object[] path, int[] childIndices, Object[] children) {
            TreeModelEvent event = new TreeModelEvent((Object)this, path, childIndices, children);
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesInserted(event);
            }
        }

        private String location(LogRecord record) {
            if (record instanceof ExtensionLogRecord) {
                Locator locator = ((ExtensionLogRecord)record).getLocator();
                String displayString = locator.getSystemId();
                if (displayString == null) {
                    return MessagePresenter.UNKNOWN_SOURCE;
                }
                try {
                    URI uri = URIFactory.newURI((String)displayString);
                    if (uri != null && uri.getScheme() != null) {
                        URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                        if (url == null) {
                            String string = MessagePresenter.UNKNOWN_SOURCE;
                            return string;
                        }
                        if ("jar".equals(url.getProtocol())) {
                            url = JarUtil.getJarFileURL((URL)url);
                        }
                        String string = ExtensionManagerImpl.getExtensionIdFromFilename(URLFileSystem.getFileName((URL)url));
                        return string;
                    }
                }
                catch (MalformedURLException mfe) {
                    // empty catch block
                }
            }
            return MessagePresenter.UNKNOWN_SOURCE;
        }

        private Object get(Collection collection, int index) {
            int c = 0;
            for (Object t : collection) {
                if (c == index) {
                    return t;
                }
                ++c;
            }
            return null;
        }

        public Object getRoot() {
            return this.ROOT;
        }

        private Collection collectionForParent(Object parent) {
            Collection<LogRecord> result;
            if (parent == this.ROOT) {
                return this.recordsByLocation.keySet();
            }
            if (parent instanceof String && (result = this.recordsByLocation.get((String)parent)) != null) {
                return result;
            }
            return Collections.emptySet();
        }

        public Object getChild(Object parent, int index) {
            return this.get(this.collectionForParent(parent), index);
        }

        public int getChildCount(Object parent) {
            return this.collectionForParent(parent).size();
        }

        public boolean isLeaf(Object node) {
            return node instanceof LogRecord;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            int index = 0;
            for (Object o : this.collectionForParent(parent)) {
                if (o == child) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        private MessageTreeModel() {
            this.$init$();
        }

        MessageTreeModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

