/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.extension.HashStructureHook;
import oracle.ideimpl.extension.AddinInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProductAddins
extends HashStructureAdapter {
    private final Extension _productExtension;
    private final Logger _logger;

    ProductAddins(HashStructure hs, Extension productExtension, Logger extensionLogger) {
        super(hs);
        this._productExtension = productExtension;
        this._logger = extensionLogger;
    }

    Collection<AddinInfo> getAddins() {
        List addins;
        ArrayList<AddinInfo> infos = new ArrayList<AddinInfo>();
        HashStructure productAddins = this._hash.getHashStructure("product-addins");
        if (productAddins != null && (addins = productAddins.getAsList("addin")) != null) {
            for (HashStructure addin : addins) {
                String classname = HashStructureHook.getText((HashStructure)addin);
                if (classname == null || (classname = classname.trim()).length() == 0) {
                    this._logger.log((LogRecord)new ExtensionLogRecord(Level.SEVERE, "Missing addin class name in product-addins", this._productExtension, 0));
                    continue;
                }
                String loadset = addin.getString("loadset");
                boolean headless = addin.getBoolean("headless", false);
                AddinInfo info = new AddinInfo(classname, loadset, 0);
                info.setHasUI(headless ^ true);
                info.setExtension(this._productExtension);
                info.setProductSpecific(true);
                infos.add(info);
            }
        }
        return infos;
    }
}

