/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.spi.MacroExpander;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.extension.Role;
import oracle.ide.extension.RoleManager;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideimpl.extension.RolePreferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.xml.esax.ElementEndContext;
import oracle.javatools.xml.esax.ElementHandler;
import oracle.javatools.xml.esax.ElementStartContext;
import oracle.javatools.xml.esax.XMLLocator;
import oracle.javatools.xml.esax.spi.ExtensibleSAXParser;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RoleManagerImpl
extends RoleManager {
    private static final Logger LOG = Logger.getLogger(RoleManagerImpl.class.getName());
    private final List<RoleDefinition> _roles;
    private boolean _rolesLoaded;
    private static final String XMLNS = "http://xmlns.oracle.com/ide/roles";
    private RolePreferences _rolePreferences;
    private Role _activeRole;

    private void $init$() {
        this._roles = new ArrayList<RoleDefinition>();
        this._rolesLoaded = false;
        this._activeRole = RoleManager.NO_ROLE;
    }

    void setActiveRole(Role role) {
        this._activeRole = role;
        this._rolePreferences.setSelectedRoleId(role.getId());
        System.setProperty("ide.role", role.getId());
        PerformanceLogger.get().logConfigurationProperty("Role", role.getId());
    }

    private URL getRolePreferencesURL() {
        File rolePrefsFile = new File(Ide.getSystemDirectory() + "/_oracle.ide.rolemgr." + Version.VER_FULL + "/", "roleprefs.xml");
        return URLFactory.newURL((String)rolePrefsFile.getPath());
    }

    RolePreferences getRolePreferences() {
        if (this._rolePreferences == null) {
            URL rolePrefs = this.getRolePreferencesURL();
            if (URLFileSystem.exists((URL)rolePrefs)) {
                try {
                    HashStructure hs = (HashStructure)new HashStructureIO(XMLNS, "role-preferences").load(rolePrefs);
                    this._rolePreferences = RolePreferences.getInstance(hs);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            } else {
                this._rolePreferences = RolePreferences.getInstance();
            }
        }
        return this._rolePreferences;
    }

    void saveRolePreferences() {
        try {
            new HashStructureIO(XMLNS, "role-preferences").save(this.getRolePreferencesURL(), (Object)this._rolePreferences.getHash());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void loadRoles(Collection<File> rolesPath) {
        if (rolesPath == null) {
            throw new NullPointerException("rolesDirectory is null");
        }
        if (this._rolesLoaded) {
            throw new IllegalStateException("Roles already loaded");
        }
        this._rolesLoaded = true;
        for (File rolesDirectory : rolesPath) {
            File[] files;
            File[] fileArray = files = rolesDirectory.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                File file = fileArray[n];
                if (file.getName().toLowerCase().endsWith(".xml")) {
                    try {
                        RoleDefinition def = RoleManagerImpl.loadRole(file);
                        this._roles.add(def);
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.SEVERE, "Failed to load role file " + file);
                    }
                }
                ++n;
            }
        }
    }

    List<Role> getRoles() {
        if (!this._rolesLoaded) {
            throw new IllegalStateException("Must load roles first.");
        }
        ArrayList<Role> roles = new ArrayList<Role>(this._roles.size());
        for (RoleDefinition rd : this._roles) {
            roles.add(rd.getRole());
        }
        return Collections.unmodifiableList(roles);
    }

    List<String> getDisabledExtensions(Role role) {
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        for (RoleDefinition rd : this._roles) {
            if (rd.getRole() != role) continue;
            return rd.getDisabledExtensions();
        }
        throw new IllegalArgumentException("Unknown role; " + role);
    }

    File getRoleFile(Role role) {
        for (RoleDefinition rd : this._roles) {
            if (rd.getRole() != role) continue;
            return rd.getFile();
        }
        return null;
    }

    public Role getActiveRole() {
        return this._activeRole;
    }

    static RoleDefinition loadRole(File roleFile) throws IOException {
        try {
            ExtensibleSAXParser parser = new ExtensibleSAXParser();
            RoleVisitor rv = new RoleVisitor(null);
            parser.getContext().registerChildHandler(XMLNS, "role", (ElementHandler)rv);
            parser.parse((XMLLocator)new 1(null, roleFile));
            if (rv.getRole() == null) {
                throw new IOException(roleFile + ": role does not specify an id");
            }
            if (!"1.0".equals(rv.getVersion())) {
                throw new IOException(roleFile + ": role version '" + rv.getVersion() + "' not recognized.");
            }
            RoleDefinition roleDefinition = new RoleDefinition(rv.getRole(), roleFile, rv.getExtensions(), null);
            return roleDefinition;
        }
        catch (Exception e) {
            IOException ioe = new IOException("Failed to parse role " + roleFile);
            ioe.initCause(e);
            throw ioe;
        }
    }

    RoleManagerImpl() {
        this.$init$();
    }

    static final class 1
    extends XMLLocator {
        private final /* synthetic */ File v$roleFile;

        public InputSource createInputSource() throws IOException {
            return new InputSource(new FileInputStream(this.v$roleFile));
        }

        public 1(URI uRI, File file) {
            this.v$roleFile = file;
            super(uRI);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RoleVisitor
    extends ElementHandler {
        private String _id;
        private String _name;
        private String _description;
        private String _version;
        private final List<String> _extensions;
        private Role _role;
        private String _rsBundleClass;

        private void $init$() {
            this._extensions = new ArrayList<String>();
            this._role = null;
        }

        private String expandMacros(String text) {
            if (text == null) {
                return null;
            }
            return new 1().substituteMacros(text);
        }

        public void handleStart(ElementStartContext context) {
            this._id = context.getAttributeValue("id");
            this._version = context.getAttributeValue("version");
            this._rsBundleClass = context.getAttributeValue("rsbundle-class");
            context.registerChildHandler(RoleManagerImpl.XMLNS, "name", (ElementHandler)new 2());
            context.registerChildHandler(RoleManagerImpl.XMLNS, "description", (ElementHandler)new 3());
            4 extensionHandler = new 4();
            context.registerChildHandler(RoleManagerImpl.XMLNS, "disabled-extensions", (ElementHandler)new 5(this, extensionHandler));
        }

        public void handleEnd(ElementEndContext context) {
            if (this._id != null) {
                String name = this._name == null ? this._id : this._name;
                String description = this._description == null ? "" : this._description;
                this._role = new Role(this._id, name, description);
            }
        }

        public String getVersion() {
            return this._version;
        }

        public Role getRole() {
            return this._role;
        }

        public List<String> getExtensions() {
            return this._extensions;
        }

        private RoleVisitor() {
            this.$init$();
        }

        RoleVisitor(5 var1_1) {
            this();
        }

        static String mav$expandMacros(RoleVisitor roleVisitor, String string) {
            return roleVisitor.expandMacros(string);
        }

        static void wa$_name(RoleVisitor roleVisitor, String string) {
            roleVisitor._name = string;
        }

        static void wa$_description(RoleVisitor roleVisitor, String string) {
            roleVisitor._description = string;
        }

        static List ra$_extensions(RoleVisitor roleVisitor) {
            return roleVisitor._extensions;
        }

        static String ra$_rsBundleClass(RoleVisitor roleVisitor) {
            return roleVisitor._rsBundleClass;
        }

        final class 1
        extends MacroExpander {
            protected String getMacroValue(String macroText) {
                if (RoleVisitor.ra$_rsBundleClass(RoleVisitor.this) != null) {
                    try {
                        ResourceBundle rb = ResourceBundle.getBundle(RoleVisitor.ra$_rsBundleClass(RoleVisitor.this));
                        String string = rb.getString(macroText);
                        return string;
                    }
                    catch (MissingResourceException me) {
                        String string = null;
                        return string;
                    }
                }
                return null;
            }
        }

        final class 2
        extends ElementHandler {
            public void handleEnd(ElementEndContext context) {
                RoleVisitor.wa$_name(RoleVisitor.this, RoleVisitor.mav$expandMacros(RoleVisitor.this, context.getText().trim()));
            }
        }

        final class 3
        extends ElementHandler {
            public void handleEnd(ElementEndContext context) {
                RoleVisitor.wa$_description(RoleVisitor.this, RoleVisitor.mav$expandMacros(RoleVisitor.this, context.getText().trim()));
            }
        }

        final class 4
        extends ElementHandler {
            public void handleStart(ElementStartContext context) {
                String extensionId = context.getAttributeValue("refid");
                if (extensionId != null) {
                    RoleVisitor.ra$_extensions(RoleVisitor.this).add(extensionId);
                }
            }
        }

        final class 5
        extends ElementHandler {
            private final /* synthetic */ ElementHandler v$extensionHandler;
            final /* synthetic */ RoleVisitor this$0;

            public void handleStart(ElementStartContext context) {
                context.registerChildHandler(RoleManagerImpl.XMLNS, "extension", this.v$extensionHandler);
            }

            public 5(RoleVisitor roleVisitor, ElementHandler elementHandler) {
                this.v$extensionHandler = elementHandler;
                this.this$0 = roleVisitor;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RoleDefinition {
        private final Role _role;
        private final File _roleFile;
        private final List<String> _disabledExtensions;

        private RoleDefinition(Role role, File file, List<String> disabledExtensions) {
            this._role = role;
            this._roleFile = file;
            this._disabledExtensions = disabledExtensions;
        }

        public Role getRole() {
            return this._role;
        }

        public File getFile() {
            return this._roleFile;
        }

        public List<String> getDisabledExtensions() {
            return this._disabledExtensions;
        }

        RoleDefinition(Role role, File file, List list, 1 var4_4) {
            this(role, file, list);
        }

        public final class 1 {
        }
    }
}

