/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.extension.Role;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoleSelectionPanel
extends JPanel {
    private final JLabel _label;
    private final NiceList _niceList;
    private final JCheckBox _roleSelectOnStartup;
    private final SimpleListModel<RoleItem> _listModel;

    private void $init$() {
        this._label = new JLabel();
        this._niceList = new NiceList();
        this._roleSelectOnStartup = new JCheckBox();
        this._listModel = new SimpleListModel();
    }

    public RoleSelectionPanel() {
        this.$init$();
        HelpUtils.setHelpID((JComponent)this, (String)"f1_rol_selectrole_html");
        this.layoutComponents();
        this.resComponents();
        RoleItemRenderer renderer = new RoleItemRenderer(null);
        renderer.setRadioButtonStyle(true);
        this._niceList.setCellRenderer((ListCellRenderer)((Object)renderer));
        this._niceList.setFireCheckboxActionOnSelectionChanged(true);
        this._niceList.setModel(this._listModel);
        this._niceList.setSelectionMode(0);
        this._niceList.setVisibleRowCount(5);
        this._niceList.addListActionListener((NiceListActionListener)new 1());
    }

    public void addDoubleClickActionListener(ActionListener l) {
        this._niceList.addDoubleClickActionListener(l);
    }

    public void removeDoubleClickActionListener(ActionListener l) {
        this._niceList.removeDoubleClickActionListener(l);
    }

    private void resComponents() {
        ResourceUtils.resLabel((JLabel)this._label, (Component)this._niceList, (String)ExtensionManagerArb.getString(41));
        ResourceUtils.resButton((AbstractButton)this._roleSelectOnStartup, (String)ExtensionManagerArb.getString(42));
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.anchor = 17;
        this.add((Component)this._label, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JScrollPane((Component)this._niceList), gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this._roleSelectOnStartup, gbc);
    }

    public void setRoles(Collection<Role> roles) {
        ArrayList<Role> rolesSorted = new ArrayList<Role>(roles);
        Collections.sort(rolesSorted);
        this._listModel.removeAll();
        for (Role role : rolesSorted) {
            this._listModel.addElement((Object)new RoleItem(role));
        }
        this._niceList.setSelectedIndex(0);
        ((RoleItem)this._listModel.getElementAt((int)0)).isSelected = true;
    }

    public Role getSelectedRole() {
        return ((RoleItem)this._niceList.getSelectedValue()).role;
    }

    public boolean isSelectOnStartupChecked() {
        return this._roleSelectOnStartup.isSelected();
    }

    public void setSelectOnStartupChecked(boolean checked) {
        this._roleSelectOnStartup.setSelected(checked);
    }

    public void setSelectedRole(String roleId) {
        if (roleId == null) {
            return;
        }
        for (RoleItem item : this._listModel) {
            if (roleId.equals(item.role.getId())) {
                item.isSelected = true;
                this._niceList.setSelectedValue((Object)item, true);
                continue;
            }
            item.isSelected = false;
        }
    }

    static SimpleListModel ra$_listModel(RoleSelectionPanel roleSelectionPanel) {
        return roleSelectionPanel._listModel;
    }

    final class 1
    implements NiceListActionListener {
        public void listActionPerformed(NiceListActionEvent lae) {
            if (lae.getRow() < 0) {
                return;
            }
            if (lae.getType() == NiceListActionEvent.Type.CHECKBOX) {
                RoleItem checkedItem = (RoleItem)RoleSelectionPanel.ra$_listModel(RoleSelectionPanel.this).getElementAt(lae.getRow());
                checkedItem.isSelected = true;
                RoleSelectionPanel.ra$_listModel(RoleSelectionPanel.this).changed(lae.getRow());
                int i = 0;
                while (i < RoleSelectionPanel.ra$_listModel(RoleSelectionPanel.this).getSize()) {
                    RoleItem item = (RoleItem)RoleSelectionPanel.ra$_listModel(RoleSelectionPanel.this).getElementAt(i);
                    if (item.isSelected && i != lae.getRow()) {
                        item.isSelected = false;
                        RoleSelectionPanel.ra$_listModel(RoleSelectionPanel.this).changed(i);
                    }
                    ++i;
                }
            }
        }
    }

    private class RoleItem {
        Role role;
        boolean isSelected;

        RoleItem(Role role) {
            this.role = role;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RoleItemRenderer
    extends NiceListRenderer<RoleItem> {
        protected String getTitle(RoleItem listItem) {
            return listItem.role.getName();
        }

        protected String getDescription(RoleItem listItem) {
            return listItem.role.getDescription();
        }

        protected boolean isItemSelected(RoleItem listItem) {
            return listItem.isSelected;
        }

        private RoleItemRenderer() {
        }

        RoleItemRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

