/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.Feature;
import oracle.ide.ExtensionRegistry;
import oracle.ideimpl.extension.ExtensionManagerImpl;

final class CachedExtensionInfo {
    private final Map _dependees;
    private final Map _containees;
    private static final Object STATE_VISITING = "visiting";
    private static final Object STATE_VISITED_SAFE = "visited_safe";
    private static final Object STATE_VISITED_UNSAFE = "visited_unsafe";

    private void $init$() {
        this._dependees = new HashMap();
        this._containees = new HashMap();
    }

    Collection getExtensionsWhichDependOn(Extension ext) {
        Collection result = (Collection)this._dependees.get(ext.getID());
        if (result == null) {
            result = this.getExtensionsWhichDependOnImpl(ext);
            this._dependees.put(ext.getID(), result);
        }
        return result;
    }

    private Collection getExtensionsWhichDependOnImpl(Extension ext) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        HashMap<Extension, Object> state = new HashMap<Extension, Object>();
        ArrayList unsafe = new ArrayList();
        Collection allExtensions = er.getAllExtensions();
        state.put(ext, STATE_VISITED_UNSAFE);
        for (Extension thisExtension : allExtensions) {
            if (state.get(thisExtension) != null) continue;
            this.dependeeVisit(thisExtension, state, unsafe);
        }
        return unsafe;
    }

    private void dependeeVisit(Extension extension, Map state, Collection unsafe) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        state.put(extension, STATE_VISITING);
        for (ExtensionDependency dep : extension.getDependencies()) {
            Extension depExt;
            if (dep == null || dep.getID() == null || (depExt = er.findExtensionEvenIfNotLoaded(dep.getID())) == null) continue;
            Object theState = state.get(depExt);
            if (theState == null) {
                this.dependeeVisit(depExt, state, unsafe);
                continue;
            }
            if (theState != STATE_VISITED_UNSAFE) continue;
            state.put(extension, STATE_VISITED_UNSAFE);
            unsafe.add(extension);
            break;
        }
        if (state.get(extension) != STATE_VISITED_UNSAFE) {
            state.put(extension, STATE_VISITED_SAFE);
        }
    }

    Collection getContainedExtensions(Extension ext) {
        Collection result = (Collection)this._containees.get(ext.getID());
        if (result == null) {
            result = this.getContainedExtensionsImpl(ext);
            this._containees.put(ext.getID(), result);
        }
        return result;
    }

    private Collection getContainedExtensionsImpl(Extension e) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        HashSet<Extension> extensions = new HashSet<Extension>();
        for (Extension ext : er.getAllExtensions()) {
            Feature feature;
            if (ext.getID().equals(e.getID()) || (feature = ((ExtensionManagerImpl)er).getFeature(ext)) == null || !e.getID().equals(feature.getPartOf()) || !feature.isOptional()) continue;
            extensions.add(ext);
        }
        return extensions;
    }

    CachedExtensionInfo() {
        this.$init$();
    }
}

