/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.spi.Feature;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.ExtensionRegistry;
import oracle.ide.IdeUIManager;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.extension.DisabledReason;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.preference.CachedExtensionInfo;
import oracle.ideimpl.extension.preference.ExtensionFilter;
import oracle.ideimpl.resource.ExtensionManagerOptionsArb;
import oracle.ideri.util.Product;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.controls.nicelist.NiceList;
import oracle.javatools.controls.nicelist.NiceListActionEvent;
import oracle.javatools.controls.nicelist.NiceListActionListener;
import oracle.javatools.controls.nicelist.NiceListRenderer;
import oracle.javatools.icons.OracleIcons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExtensionListPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(ExtensionListPanel.class.getName());
    private final JLabel _extensions;
    private final NiceList _listControl;
    private final SimpleListModel _model;
    private Set _disabledIds;
    private ExtensionFilter _filter;
    private CachedExtensionInfo _info;
    private Set<String> _productExtensionIds;

    private void $init$() {
        this._extensions = new JLabel();
        this._listControl = new NiceList();
        this._model = new SimpleListModel();
        this._disabledIds = Collections.EMPTY_SET;
        this._filter = null;
        this._info = null;
        this._productExtensionIds = null;
    }

    ExtensionListPanel() {
        this.$init$();
        this.resControls();
        this.layoutControls();
        this.installListeners();
        TheRenderer r = new TheRenderer(null);
        r.setGradientColor(IdeUIManager.getActiveTitleGradientLightColor(), IdeUIManager.getActiveTitleGradientDarkColor());
        r.setTwoLineDescription(false);
        this._listControl.setCellRenderer((ListCellRenderer)((Object)r));
        this._listControl.setModel((ListModel)this._model);
        this._listControl.setSelectionMode(0);
        HelpUtils.setHelpID((JComponent)this, (String)"f1_idedidesetextensionmanager_html");
    }

    private Set<String> getProductExtensionIds() {
        if (this._productExtensionIds == null) {
            this._productExtensionIds = new HashSet<String>();
            String productId = Product.getProductID();
            this._productExtensionIds.add(productId);
            this.addExtensionDependencies(this._productExtensionIds, productId);
        }
        return this._productExtensionIds;
    }

    private void addExtensionDependencies(Set<String> ids, String id) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        Extension extension = er.findExtensionEvenIfNotLoaded(id);
        for (ExtensionDependency dep : extension.getDependencies()) {
            if (dep == null || dep.getID() == null || ids.contains(dep.getID())) continue;
            ids.add(dep.getID());
            this.addExtensionDependencies(ids, dep.getID());
        }
    }

    void setCachedExtensionInfo(CachedExtensionInfo info) {
        this._info = info;
    }

    void setDisabledIds(Set set) {
        this._disabledIds = set;
    }

    void populate() {
        this.populate(new 1());
    }

    void populate(ExtensionFilter filter) {
        this._filter = filter;
        Collection items = this.getVisibleExtensions();
        this._model.asList().addAll(items);
    }

    private Collection getVisibleExtensions() {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        for (Extension extension : er.getAllExtensions()) {
            if (!this.isVisibleExtension(extension)) continue;
            extensions.add(extension);
        }
        Collections.sort(extensions);
        return extensions;
    }

    private void layoutControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this._extensions, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        JScrollPane sp = new JScrollPane((Component)this._listControl);
        this.add((Component)sp, gbc);
    }

    private void installListeners() {
        TheListener l = new TheListener(null);
        this._listControl.addListActionListener((NiceListActionListener)l);
    }

    private void resControls() {
        ResourceUtils.resLabel((JLabel)this._extensions, (Component)this._listControl, (String)ExtensionManagerOptionsArb.getString(2));
    }

    private boolean isCurrentlyEnabled(Extension ext) {
        return this._disabledIds.contains(ext.getID()) ^ true;
    }

    private void setCurrentlyEnabled(Extension ext, boolean enabled) {
        if (enabled) {
            this._disabledIds.remove(ext.getID());
        } else {
            this._disabledIds.add(ext.getID());
        }
    }

    private void updateDependencies(Extension extension, boolean selected) {
        this.updateDependencies(extension, selected, new LinkedHashSet<Extension>());
    }

    private void updateDependencies(Extension extension, boolean selected, Set<Extension> visited) {
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        if (selected) {
            if (visited.contains(extension)) {
                StringBuffer cycleText = new StringBuffer();
                for (Extension e : visited) {
                    cycleText.append(e.getID());
                    cycleText.append("->");
                }
                cycleText.append(extension.getID());
                LOG.log(Level.WARNING, cycleText.toString());
                return;
            }
            visited.add(extension);
            for (ExtensionDependency dep : extension.getDependencies()) {
                String id = dep.getID();
                Extension ext = er.findExtensionEvenIfNotLoaded(id);
                if (ext == null) continue;
                if (this.isVisibleExtension(ext)) {
                    this.setCurrentlyEnabled(ext, selected);
                }
                this.updateDependencies(ext, selected, visited);
            }
            visited.remove(extension);
        } else {
            Collection dependees = this.getExtensionsWhichDependOn(extension);
            for (Extension ext : dependees) {
                if (ext == null || !this.isVisibleExtension(ext)) continue;
                this.setCurrentlyEnabled(ext, false);
            }
        }
    }

    private Collection getExtensionsWhichDependOn(Extension extension) {
        return this._info.getExtensionsWhichDependOn(extension);
    }

    private Collection getContainedExtensions(Extension extension) {
        return this._info.getContainedExtensions(extension);
    }

    private Feature getFeature(Extension extension) {
        if (this.getProductExtensionIds().contains(extension.getID())) {
            return null;
        }
        return ((ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry()).getFeature(extension);
    }

    private boolean isVisibleExtension(Extension ext) {
        return this._filter.accept(ext);
    }

    private void showConfigureDialog(Extension owningExtension) {
        JEWTDialog jd = JEWTDialog.createDialog((Component)IdeUtil.findActiveModalWindow(), (String)ExtensionManagerOptionsArb.getString(3), (int)7);
        ExtensionListPanel p = new ExtensionListPanel();
        HelpUtils.setHelpID((JComponent)p, (String)"f1_idedidesetextensionversion_html");
        jd.setContent((Component)p);
        jd.setResizable(true);
        DialogHeader header = new DialogHeader();
        header.setHeaderImage(OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/person.png")));
        header.setHeaderDescription(ExtensionManagerOptionsArb.format(1, owningExtension.getName()));
        jd.setDialogHeader((Component)header);
        HashSet copy = new HashSet(this._disabledIds);
        p.setDisabledIds(copy);
        p.setCachedExtensionInfo(this._info);
        p.populate(new 2(this, owningExtension));
        if (jd.runDialog()) {
            this._disabledIds.clear();
            this._disabledIds.addAll(copy);
        }
    }

    static SimpleListModel ra$_model(ExtensionListPanel extensionListPanel) {
        return extensionListPanel._model;
    }

    static boolean mav$isCurrentlyEnabled(ExtensionListPanel extensionListPanel, Extension extension) {
        return extensionListPanel.isCurrentlyEnabled(extension);
    }

    static void mav$setCurrentlyEnabled(ExtensionListPanel extensionListPanel, Extension extension, boolean bl) {
        extensionListPanel.setCurrentlyEnabled(extension, bl);
    }

    static void mav$updateDependencies(ExtensionListPanel extensionListPanel, Extension extension, boolean bl) {
        extensionListPanel.updateDependencies(extension, bl);
    }

    static void mav$showConfigureDialog(ExtensionListPanel extensionListPanel, Extension extension) {
        extensionListPanel.showConfigureDialog(extension);
    }

    static Collection mav$getContainedExtensions(ExtensionListPanel extensionListPanel, Extension extension) {
        return extensionListPanel.getContainedExtensions(extension);
    }

    static Feature mav$getFeature(ExtensionListPanel extensionListPanel, Extension extension) {
        return extensionListPanel.getFeature(extension);
    }

    final class 1
    implements ExtensionFilter {
        public boolean accept(Extension extension) {
            ExtensionManagerImpl mgr = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
            if (!mgr.isLoaded(extension.getID()) && mgr.getDisabledReason(extension.getID()) == DisabledReason.ROLE_DISABLED) {
                return false;
            }
            Feature feature = ExtensionListPanel.mav$getFeature(ExtensionListPanel.this, extension);
            return feature != null && feature.isOptional() && (feature.getPartOf() == null || feature.getPartOf().trim().length() == 0);
        }
    }

    final class 2
    implements ExtensionFilter {
        private final /* synthetic */ Extension v$owningExtension;
        final /* synthetic */ ExtensionListPanel this$0;

        public boolean accept(Extension extension) {
            Feature feature = ExtensionListPanel.mav$getFeature(this.this$0, extension);
            return feature != null && feature.isOptional() && this.v$owningExtension.getID().equals(feature.getPartOf());
        }

        public 2(ExtensionListPanel extensionListPanel, Extension extension) {
            this.v$owningExtension = extension;
            this.this$0 = extensionListPanel;
        }
    }

    private class TheListener
    implements NiceListActionListener {
        public void listActionPerformed(NiceListActionEvent lae) {
            int row = lae.getRow();
            if (row >= 0) {
                Extension extension = (Extension)ExtensionListPanel.ra$_model(ExtensionListPanel.this).getElementAt(row);
                if (lae.getType() == NiceListActionEvent.Type.CHECKBOX) {
                    boolean enabled = ExtensionListPanel.mav$isCurrentlyEnabled(ExtensionListPanel.this, extension) ^ true;
                    ExtensionListPanel.mav$setCurrentlyEnabled(ExtensionListPanel.this, extension, enabled);
                    ExtensionListPanel.mav$updateDependencies(ExtensionListPanel.this, extension, enabled);
                    ExtensionListPanel.ra$_model(ExtensionListPanel.this).changed(row);
                } else if (lae.getType() == NiceListActionEvent.Type.HYPERLINK) {
                    ExtensionListPanel.mav$showConfigureDialog(ExtensionListPanel.this, extension);
                }
            }
        }

        private TheListener() {
        }

        TheListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TheRenderer
    extends NiceListRenderer {
        public String getTitle(Object item) {
            Extension ext = (Extension)item;
            String name = ext.getName();
            String ver = ext.getVersion().toString();
            if (name == null) {
                name = ext.getID();
            }
            return name + " " + ver;
        }

        public String getDescription(Object item) {
            Extension ext = (Extension)item;
            Feature feature = ExtensionListPanel.mav$getFeature(ExtensionListPanel.this, ext);
            String description = "";
            if (feature != null) {
                description = feature.getDescription();
            }
            return description;
        }

        public boolean isItemSelected(Object item) {
            return ExtensionListPanel.mav$isCurrentlyEnabled(ExtensionListPanel.this, (Extension)item);
        }

        public String getHyperLinkText(Object item) {
            if (!ExtensionListPanel.mav$getContainedExtensions(ExtensionListPanel.this, (Extension)item).isEmpty()) {
                return ExtensionManagerOptionsArb.getString(5);
            }
            return "";
        }

        private TheRenderer() {
        }

        TheRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

