/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import oracle.ide.Ide;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionPreferences
extends HashStructureAdapter {
    @GuardedBy(value="ExtensionPreferences.class")
    private static ExtensionPreferences _prefs;
    private final URL _url;

    private ExtensionPreferences(HashStructure hs) {
        this(hs, null);
    }

    private ExtensionPreferences(HashStructure hs, URL url) {
        super(hs);
        this._url = url;
    }

    public Set<String> getDisabledIds() {
        ListStructure ls = this._hash.getListStructure("disabledExtensions");
        if (ls == null) {
            return Collections.emptySet();
        }
        HashSet s = new HashSet();
        s.addAll(ls);
        return Collections.unmodifiableSet(s);
    }

    public void setDisabledIds(Set<String> disabledIds) {
        ListStructure ls = this._hash.getOrCreateListStructure("disabledExtensions");
        ls.clear();
        ls.addAll(disabledIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExtensionPreferences getInstance() {
        Class<ExtensionPreferences> clazz = ExtensionPreferences.class;
        synchronized (ExtensionPreferences.class) {
            if (_prefs == null) {
                URL dir = URLFactory.newDirURL((String)Ide.getSystemDirectory());
                URL file = URLFactory.newURL((URL)dir, (String)"ide-extension-prefs.xml");
                HashStructure hash = HashStructure.newInstance();
                _prefs = new ExtensionPreferences(hash, file);
                try {
                    _prefs.open();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ExtensionPreferences extensionPreferences = _prefs;
            // ** MonitorExit[var4] (shouldn't be in output)
            return extensionPreferences;
        }
    }

    private void open() throws IOException {
        HashStructureIO io = ExtensionPreferences.getIO();
        if (URLFileSystem.exists((URL)this._url)) {
            io.open(this._url, (Object)this._hash);
        }
    }

    public void save() throws IOException {
        ExtensionPreferences.getIO().save(this._url, (Object)this._hash);
    }

    private static HashStructureIO getIO() {
        return new HashStructureIO("http://xmlns.oracle.com/ide/hash", "ide:extension-preferences");
    }
}

