/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.help;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.help.AboutBoxPage;
import oracle.javatools.controls.nicetable.NiceTable;

public abstract class AboutTablePage
extends AboutBoxPage {
    private static final Border PANEL_BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private NiceTable _table;
    private JScrollPane _scrollPane;
    private Component _component;

    protected abstract TableModel buildTableModel();

    public final Component getComponent() {
        if (this._component == null) {
            Box component = new Box(1);
            component.setBorder(PANEL_BORDER);
            this._table = new KeyNavigableNiceTable();
            this._table.setAutoResizeMode(0);
            this._scrollPane = this._table.getScrollPaneForTable();
            component.add(this._scrollPane);
            this.setInitialFocus((Component)this._table);
            this._component = component;
        }
        return this._component;
    }

    protected void configureTable(NiceTable table) {
    }

    public final void populate() {
        TableModel model = this.buildTableModel();
        this._table.setModel(model);
        this._table.setSortColumn(0, true);
        this.configureTable(this._table);
        this._table.autoSizeColumnsToFit();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        TableModel model = this._table.getModel();
        StringBuilder headers = new StringBuilder();
        StringBuilder underlines = new StringBuilder();
        int c = 0;
        while (c < model.getColumnCount()) {
            String colName = model.getColumnName(c);
            String title = colName == null ? "" : colName;
            headers.append(String.valueOf(title));
            if (c < model.getColumnCount() - 1) {
                headers.append('\t');
            }
            int titleLength = Math.max(1, title.length());
            int i = 0;
            while (i < titleLength) {
                underlines.append('=');
                ++i;
            }
            if (c < model.getColumnCount() - 1) {
                underlines.append('\t');
            }
            ++c;
        }
        sb.append((CharSequence)headers);
        sb.append('\n');
        sb.append((CharSequence)underlines);
        sb.append('\n');
        int r = 0;
        while (r < model.getRowCount()) {
            int c2 = 0;
            while (c2 < model.getColumnCount()) {
                Object modelValue;
                TableCellRenderer renderer = this._table.getCellRenderer(r, c2);
                Component rc = renderer.getTableCellRendererComponent((JTable)this._table, modelValue = model.getValueAt(r, c2), false, false, r, c2);
                if (rc instanceof JLabel) {
                    sb.append(((JLabel)rc).getText());
                } else if (modelValue == null) {
                    sb.append("");
                } else {
                    sb.append(String.valueOf(modelValue));
                }
                if (c2 < model.getColumnCount() - 1) {
                    sb.append('\t');
                }
                ++c2;
            }
            sb.append('\n');
            ++r;
        }
        return sb.toString();
    }

    private static final class KeyNavigableNiceTable
    extends NiceTable {
        private final KeyNavigationManager _knm;

        private void $init$() {
            this._knm = new KeyNavigationManager();
        }

        public KeyNavigableNiceTable() {
            this.$init$();
            this._knm.setKeyComponentAdapter((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TableKeyAdapter((JTable)((Object)this)));
        }

        protected void processKeyEvent(KeyEvent e) {
            if (this._knm != null) {
                this._knm.preProcessKeyEvent(e);
            }
            super.processKeyEvent(e);
            if (this._knm != null) {
                this._knm.postProcessKeyEvent(e);
            }
        }
    }
}

