/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.help.AboutTablePage;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.controls.nicetable.DefaultNiceTableModel;
import oracle.javatools.util.Pair;

public final class AboutVersionPage
extends AboutTablePage {
    private static final String DEPINFO = "oracle/ide/depinfo.txt";
    private static final String PRODUCT_SCHEMA = "product_schema";
    private static final String LABEL = "label";
    private Map _scratchMap;

    public AboutVersionPage() {
        this.setName(IdeImplArb.getString(8));
    }

    protected TableModel buildTableModel() {
        Vector data = new Vector(10);
        Vector<String> colNames = new Vector<String>(2);
        colNames.add(IdeImplArb.getString(50));
        colNames.add(IdeImplArb.getString(44));
        this.addVersionInfo(data);
        if (Version.DEBUG_BUILD != 0 || Boolean.valueOf(System.getProperty("ide.about.version.showAll")).booleanValue()) {
            this.addDepencencyVersionInfo(data);
        }
        return new DefaultNiceTableModel(data, colNames);
    }

    private void addVersionInfo(Vector data) {
        Vector<Object> row = new Vector<Object>(2);
        row.add(IdeImplArb.getString(49));
        row.add(Version.VER_FULL);
        data.add(row);
        row = new Vector(2);
        row.add(IdeImplArb.getString(88));
        row.add(System.getProperty("java.version"));
        data.add(row);
        Iterator iter = Ide.getVersionInfo().getVersionPairs();
        while (iter.hasNext()) {
            Pair cv = (Pair)iter.next();
            row = new Vector(2);
            row.add(cv.first);
            row.add(cv.second);
            data.add(row);
        }
    }

    private void addDepencencyVersionInfo(Vector data) {
        URL parentOfJewt;
        URL jewtRes;
        this._scratchMap = new HashMap();
        BufferedReader br = null;
        try {
            try {
                InputStream depStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEPINFO);
                if (depStream != null) {
                    HashMap<String, String> labelsBySchema = new HashMap<String, String>();
                    br = new BufferedReader(new InputStreamReader(depStream));
                    String line = br.readLine();
                    while (line != null) {
                        Map lineMap = this.getLineMap(line);
                        String schema = (String)lineMap.get(PRODUCT_SCHEMA);
                        String label = (String)lineMap.get(LABEL);
                        String labels = (String)labelsBySchema.get(schema);
                        if (labels == null) {
                            labelsBySchema.put(schema, label);
                        } else {
                            labelsBySchema.put(schema, labels + ", " + label);
                        }
                        line = br.readLine();
                    }
                    for (Map.Entry entry : labelsBySchema.entrySet()) {
                        String schema = (String)entry.getKey();
                        String labels = (String)entry.getValue();
                        if (schema == null || schema.trim().length() <= 0) continue;
                        Vector<String> v = new Vector<String>(2);
                        v.add("Build: " + schema);
                        v.add(labels);
                        data.add(v);
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this._scratchMap = null;
        }
        if ((jewtRes = Thread.currentThread().getContextClassLoader().getResource("oracle/bali/ewt/LookAndFeel.class")) != null && (parentOfJewt = URLFileSystem.getParent((URL)jewtRes)) != null) {
            URL[] urls = URLFileSystem.list((URL)parentOfJewt);
            int i = 0;
            while (i < urls.length) {
                URL thisUrl = urls[i];
                String name = URLFileSystem.getName((URL)thisUrl);
                if (name != null && name.indexOf(95) > 0) {
                    Vector<String> v = new Vector<String>();
                    v.add("Build: (JEWT)");
                    v.add(name.replace('_', '.'));
                    data.add(v);
                    break;
                }
                ++i;
            }
        }
    }

    private Map getLineMap(String line) {
        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
            return Collections.EMPTY_MAP;
        }
        this._scratchMap.clear();
        StringTokenizer tokSemi = new StringTokenizer(line, ";");
        while (tokSemi.hasMoreTokens()) {
            String token = tokSemi.nextToken();
            int eqPos = token.indexOf(61);
            if (eqPos <= 0) continue;
            this._scratchMap.put(token.substring(0, eqPos), token.substring(eqPos + 1));
        }
        return this._scratchMap;
    }
}

