/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.history.Historian;
import oracle.ide.history.HistoryContext;
import oracle.ide.history.HistoryManager;
import oracle.ide.history.LocalState;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.model.TextNodeHistorian;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.persistence.NameSpace;
import oracle.ide.util.Assert;
import oracle.ideimpl.history.HistoryOptions;
import oracle.ideimpl.history.LocalStateImpl;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Copyable;

public final class HistoryManagerImpl
extends HistoryManager
implements Observer,
Addin {
    public static final String RESTORE_HISTORY_RENAME_CMD = "oracle.ide.cmd.RestoreHistoryRenameCommand";
    public static final int RESTORE_HISTORY_RENAME_CMD_ID = Ide.createCmdID((String)"oracle.ide.cmd.RestoreHistoryRenameCommand");
    private static final String FIELD_SEPARATOR = "|";
    private static final String HISTORY_DIRNAME = ".history";
    private static final String HISTORY_DIR = Ide.getSystemDirectory() + ".history" + File.separator;
    private static final String NS_STATES = "LocalHistory:States";
    private static final String NS_URLS = "LocalHistory:Urls";
    private static final String NS_NODES = "LocalHistory:Documents";
    private static final String NS_COMMENTS = "LocalHistory:Comments";
    private static final String NS_IDS = "LocalHistory:IdData";
    private static final NameSpace STATES = NameSpace.getNameSpace((String)"LocalHistory:States");
    private static final NameSpace URLS = NameSpace.getNameSpace((String)"LocalHistory:Urls");
    private static final NameSpace NODES = NameSpace.getNameSpace((String)"LocalHistory:Documents");
    private static final NameSpace COMMENTS = NameSpace.getNameSpace((String)"LocalHistory:Comments");
    private static final NameSpace IDS = NameSpace.getNameSpace((String)"LocalHistory:IdData");
    private static final int DELETION_URL_ID = -1;
    private static boolean PRUNED;
    private static HashMap URLID_TO_NODEID;
    private static HashMap URL_TO_URLID;
    private static List DELETED_NODE_IDS;
    private static final HashMap LOCTYPE_TO_HISTORIANTYPE;
    private static final HashMap HISTORIANTYPE_TO_HISTORIAN;
    private boolean active;
    private static URL _tmpDir;

    private void $init$() {
        this.active = true;
    }

    static {
        LOCTYPE_TO_HISTORIANTYPE = new HashMap();
        HISTORIANTYPE_TO_HISTORIAN = new HashMap();
        if (STATES != null && URLS != null && NODES != null && COMMENTS != null) {
            STATES.setAutoFlush(1500L);
            URLS.setAutoFlush(1500L);
            NODES.setAutoFlush(1500L);
            COMMENTS.setAutoFlush(1500L);
            IDS.setAutoFlush(1500L);
            if (Boolean.valueOf(System.getProperty("ide.localhistory.dump")).booleanValue()) {
                System.out.println("======================================================");
                System.out.println("======================================================");
                NameSpace[] namespaces = new NameSpace[]{STATES, URLS, NODES, COMMENTS};
                int j = 0;
                while (j < namespaces.length) {
                    NameSpace s = namespaces[j];
                    System.out.println("---------" + s.getName() + "---------");
                    Iterator i = s.getKeyIterator();
                    while (i.hasNext()) {
                        System.out.println(i.next());
                    }
                    System.out.println("-------------------------------------");
                    ++j;
                }
                HistoryManagerImpl.dumpIdData("url");
                HistoryManagerImpl.dumpIdData("node");
                System.out.println("======================================================");
                System.out.println("======================================================");
            }
        }
        _tmpDir = null;
        String tmpdir = System.getProperty("java.io.tmpdir");
        _tmpDir = tmpdir != null ? URLFileSystem.canonicalize((URL)URLFactory.newFileURL((String)tmpdir)) : null;
    }

    public HistoryManagerImpl() {
        this.$init$();
    }

    public void initialize() {
        if (STATES == null || URLS == null || NODES == null || COMMENTS == null) {
            Assert.println((String)"HistoryManager disabled - persistent storage not available.");
            return;
        }
        HistoryManager.setHistoryManager((HistoryManager)this);
        try {
            this.registerHistorian(TextNodeHistorian.class, TextNode.class);
            this.registerHistorian(TextNodeHistorian.class, DeployableTextNode.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Preferences prefs = Preferences.getPreferences();
        HistoryOptions options = HistoryOptions.getInstance((PropertyStorage)prefs);
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("HistoryOptions", (Copyable)options);
        prefs.getProperties().getOrCreateHashStructure("HistoryOptions").addStructureChangeListener((StructureChangeListener)new 1(this, options));
        this.optionsChanged(options);
        Ide.addIdeListener((IdeListener)new 2());
    }

    private boolean isSupported(URL[] urls) {
        URL[] uRLArray = urls;
        int n = 0;
        while (n < uRLArray.length) {
            URL url = uRLArray[n];
            if (this.isSupported(url)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isSupported(URL url) {
        return _tmpDir == null || !URLFileSystem.isBaseURLFor((URL)_tmpDir, (URL)url);
    }

    public synchronized boolean hasLocalHistory(URL url) {
        if (!this.isSupported(url)) {
            return false;
        }
        if (!this.active) {
            return false;
        }
        HistoryManagerImpl.pruneHistory();
        try {
            this.persistInitialState(new URL[]{url});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object nodeId = HistoryManagerImpl.getNodeId(url, false);
        if (nodeId != null) {
            Iterator i = STATES.getKeyIterator(nodeId.toString() + FIELD_SEPARATOR);
            return i != null && i.hasNext();
        }
        return false;
    }

    public synchronized LocalState[] getLocalHistory(URL url) {
        if (!this.active) {
            return null;
        }
        HistoryManagerImpl.pruneHistory();
        try {
            this.persistInitialState(new URL[]{url});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object nodeId = HistoryManagerImpl.getNodeId(url, false);
        return this.getLocalHistory(nodeId);
    }

    public synchronized LocalState[] getLocalHistory(Object nodeId) {
        return this.getLocalHistory(nodeId, false);
    }

    public synchronized LocalState getLastState(Object nodeId) {
        LocalState[] result = this.getLocalHistory(nodeId, true);
        return result != null && result.length > 0 ? result[0] : null;
    }

    /*
     * Unable to fully structure code
     */
    private LocalState[] getLocalHistory(Object nodeId, boolean lastOnly) {
        block7: {
            if (!this.active) {
                return null;
            }
            HistoryManagerImpl.pruneHistory();
            list = null;
            if (nodeId == null) break block7;
            prefix = nodeId.toString() + "|";
            v0 = i = lastOnly != false ? HistoryManagerImpl.STATES.getReverseKeyIterator(prefix) : HistoryManagerImpl.STATES.getKeyIterator(prefix);
            if (i == null || !i.hasNext()) break block7;
            list = new ArrayList<LocalStateImpl>();
            if (!lastOnly) ** GOTO lbl24
            try {
                list.add(LocalStateImpl.decode((String)i.next()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                try {
                    list.add(LocalStateImpl.decode((String)i.next()));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
lbl24:
                // 3 sources

                ** while (i.hasNext())
            }
        }
        v1 = states = list != null ? new LocalState[list.size()] : null;
        if (states != null) {
            list.toArray(states);
        }
        return states;
    }

    public Object[] getDeletions(URL url) {
        Iterator i;
        if (!this.active) {
            return null;
        }
        HistoryManagerImpl.pruneHistory();
        ArrayList list = new ArrayList();
        List deletions = HistoryManagerImpl.loadDeletedNodeIds();
        Iterator iterator = i = deletions != null ? deletions.iterator() : null;
        if (i != null) {
            while (i.hasNext()) {
                try {
                    Object nodeId = i.next();
                    Iterator j = STATES.getReverseKeyIterator(nodeId.toString() + FIELD_SEPARATOR);
                    if (j == null) continue;
                    String key = (String)j.next();
                    LocalStateImpl state = LocalStateImpl.decode(key);
                    if (url != null && !URLFileSystem.isBaseURLFor((URL)url, (URL)state.getStateURL())) continue;
                    list.add(nodeId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Object[] result = new Object[list.size()];
        list.toArray(result);
        return result;
    }

    public synchronized void persistInitialState(URL[] sources) throws Exception {
        if (!this.isSupported(sources)) {
            return;
        }
        if (!this.active) {
            return;
        }
        HistoryManagerImpl.pruneHistory();
        if (sources != null) {
            Date timestamp = null;
            int i = 0;
            while (i < sources.length) {
                URL url = sources[i];
                Historian historian = null;
                Node node = null;
                if (!URLFileSystem.isDirectory((URL)url)) {
                    node = NodeFactory.findOrCreate((URL)url);
                    Historian historian2 = historian = node != null ? HistoryManagerImpl.getHistorian(node.getClass()) : null;
                }
                if (historian != null) {
                    Object nodeId = HistoryManagerImpl.getNodeId(url, true);
                    boolean needState = false;
                    Iterator iter = STATES.getReverseKeyIterator(nodeId.toString() + FIELD_SEPARATOR);
                    if (iter == null || !iter.hasNext()) {
                        needState = true;
                    } else {
                        Object key = iter.next();
                        try {
                            LocalStateImpl state = LocalStateImpl.decode((String)key);
                            needState = URLFileSystem.lastModified((URL)url) > state.getDate().getTime();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (needState && URLFileSystem.exists((URL)url)) {
                        timestamp = timestamp == null ? new Date(System.currentTimeMillis()) : timestamp;
                        URL dataUrl = HistoryManagerImpl.createDataUrl(nodeId, timestamp);
                        try {
                            historian.copy(url, dataUrl);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (dataUrl != null && URLFileSystem.exists((URL)dataUrl)) {
                            URLFileSystem.setLastModified((URL)dataUrl, (long)timestamp.getTime());
                            this.safePutStates(timestamp, (Integer)nodeId, (Integer)HistoryManagerImpl.getUrlId(url, true), (Integer)HistoryManagerImpl.getUrlId(dataUrl, true));
                            if (node != null) {
                                node.attach((Observer)this);
                            }
                        }
                    }
                }
                ++i;
            }
            if (timestamp != null) {
                HistoryManagerImpl.persistComments(timestamp, IdeImplArb.getString(76));
            }
        }
    }

    private void safePutStates(Date timestamp, Integer nodeId, Integer stateUrlId, Integer dataUrlId) {
        STATES.putRecord(new LocalStateImpl(timestamp, nodeId, stateUrlId, dataUrlId).toString(), null);
    }

    public synchronized void persist(URL[] sources, String description) throws Exception {
        if (!this.isSupported(sources)) {
            return;
        }
        if (!this.active) {
            return;
        }
        HistoryManagerImpl.pruneHistory();
        if (sources != null) {
            Date timestamp = new Date(System.currentTimeMillis());
            boolean needComment = false;
            int i = 0;
            while (i < sources.length) {
                URL url = sources[i];
                Historian historian = null;
                Node node = null;
                if (!URLFileSystem.isDirectory((URL)url)) {
                    node = NodeFactory.findOrCreate((URL)url);
                    Historian historian2 = historian = node != null ? HistoryManagerImpl.getHistorian(node.getClass()) : null;
                }
                if (historian != null) {
                    Object nodeId = HistoryManagerImpl.getNodeId(url, true);
                    URL dataUrl = HistoryManagerImpl.createDataUrl(nodeId, timestamp);
                    try {
                        historian.recordContents(url, dataUrl);
                        URLFileSystem.setLastModified((URL)dataUrl, (long)timestamp.getTime());
                        this.safePutStates(timestamp, (Integer)nodeId, (Integer)HistoryManagerImpl.getUrlId(url, true), (Integer)HistoryManagerImpl.getUrlId(dataUrl, true));
                        if (node != null) {
                            node.attach((Observer)this);
                        }
                        needComment = true;
                    }
                    catch (Exception e) {
                        Assert.printStackTrace((Throwable)e);
                        throw e;
                    }
                }
                ++i;
            }
            if (needComment) {
                HistoryManagerImpl.persistComments(timestamp, description);
            }
        }
    }

    public void restore(LocalState[] states, Context context) throws Exception {
        int i = 0;
        while (i < states.length) {
            LocalState state = states[i];
            URL nodeURL = state.getNodeURL();
            URL stateURL = state.getStateURL();
            try {
                Node node = NodeFactory.find((URL)stateURL);
                if (nodeURL == null) {
                    if (node != null) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)IdeImplArb.format(48, URLFileSystem.getPlatformPathName((URL)stateURL)), (String)IdeImplArb.getString(31), null);
                    } else if (!URLFileSystem.exists((URL)stateURL) || MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)IdeImplArb.format(40, URLFileSystem.getPlatformPathName((URL)stateURL)), (String)IdeImplArb.getString(31), null)) {
                        URLFileSystem.copy((URL)state.getDataURL(), (URL)stateURL);
                        HistoryManagerImpl.restoreUrlId(state.getNodeId(), stateURL);
                        node = NodeFactory.findOrCreate((URL)stateURL);
                    }
                } else if (!URLFileSystem.equals((URL)nodeURL, (URL)stateURL)) {
                    Context ctx = new Context(context);
                    node = NodeFactory.findOrCreate((URL)nodeURL);
                    ctx.setNode(node);
                    HistoryContext.setLocalState((Context)ctx, (LocalState)state);
                    Command cmd = CommandProcessor.createCommand((String)RESTORE_HISTORY_RENAME_CMD, (Context)ctx);
                    if (cmd != null) {
                        CommandProcessor.getInstance().invoke(cmd);
                    }
                } else {
                    Context ctx = new Context(context);
                    node = node != null ? node : NodeFactory.findOrCreate((URL)stateURL);
                    ctx.setNode(node);
                    HistoryContext.setLocalState((Context)ctx, (LocalState)state);
                    Command cmd = CommandProcessor.createCommand((String)"oracle.ide.cmd.RestoreHistoryCommand", (Context)ctx);
                    if (cmd != null) {
                        CommandProcessor.getInstance().invoke(cmd);
                    }
                }
            }
            catch (Exception e) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)IdeImplArb.format(64, new String[]{URLFileSystem.getPlatformPathName((URL)stateURL)}), (String)IdeImplArb.getString(31), null);
            }
            ++i;
        }
    }

    public void registerHistorian(Class historianCls, Class nodeCls) {
        if (Historian.class.isAssignableFrom(historianCls) && Node.class.isAssignableFrom(nodeCls)) {
            if (LOCTYPE_TO_HISTORIANTYPE.put(nodeCls, historianCls) == null) {
                NodeFactory.attach((Observer)this, (Class)nodeCls);
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    public Class getRegisteredHistorian(Class nodeCls) throws Exception {
        if (Node.class.isAssignableFrom(nodeCls)) {
            return (Class)LOCTYPE_TO_HISTORIANTYPE.get(nodeCls);
        }
        throw new Exception();
    }

    public void update(Object observed, UpdateMessage msg) {
        int id;
        int n = id = msg != null ? msg.getMessageID() : -1;
        if (id == NodeFactory.NODE_CACHED) {
            Node node = (Node)observed;
            if (HistoryManagerImpl.getNodeId(node.getURL(), false) != null) {
                node.attach((Observer)this);
            }
        } else if (id == NodeFactory.NODE_UNCACHED) {
            Node node = (Node)observed;
            URL oldUrl = node.getURL();
            node.detach((Observer)this);
            HistoryManagerImpl.updateNodeId(oldUrl, null);
        } else if (id == UpdateMessage.OBJECT_RENAMED) {
            List list = msg.getAddObjects();
            URL oldUrl = null;
            URL newUrl = null;
            if (!list.isEmpty()) {
                newUrl = ((Node)list.get(0)).getURL();
                oldUrl = ((Node)observed).getURL();
            } else {
                Node node = RenameMessage.getRenamedNode((UpdateMessage)msg);
                if (node != null) {
                    list = msg.getModifyObjects();
                    if (!list.isEmpty()) {
                        newUrl = node.getURL();
                        oldUrl = (URL)list.get(0);
                    }
                } else {
                    list = msg.getModifyObjects();
                    if (!list.isEmpty()) {
                        newUrl = ((Node)observed).getURL();
                        oldUrl = (URL)list.get(0);
                    }
                }
            }
            if (newUrl != null && oldUrl != null) {
                HistoryManagerImpl.updateNodeId(oldUrl, newUrl);
            }
        }
    }

    public void clear(URL[] sources) {
        HistoryManagerImpl._clear(sources);
    }

    private synchronized void optionsChanged(HistoryOptions options) {
        this.active = options != null ? options.isEnabled() : this.active;
    }

    static URL createDataUrl(Object nodeId, Date timestamp) {
        URL url = URLFactory.newDirURL((String)(HISTORY_DIR + nodeId));
        URLFileSystem.mkdirs((URL)url);
        return URLFactory.newFileURL((String)(url.getPath() + timestamp.getTime()));
    }

    static synchronized String getDescription(LocalState state) {
        Iterator i;
        if (state != null && (i = COMMENTS.getKeyIterator("" + state.getDate().getTime())) != null && i.hasNext()) {
            String key = (String)i.next();
            int index = key.indexOf(FIELD_SEPARATOR);
            return key.substring(++index);
        }
        return null;
    }

    static synchronized Object getNodeId(URL url, boolean create) {
        if (url == null) {
            return null;
        }
        Object urlId = HistoryManagerImpl.getUrlId(url, create);
        return HistoryManagerImpl.getNodeId(urlId, create);
    }

    static synchronized Object getNodeId(Object urlId, boolean create) {
        HashMap ids;
        Object nodeId = null;
        if (urlId != null && (nodeId = (Object)(ids = HistoryManagerImpl.loadNodeIds()).get(urlId)) == null && create) {
            nodeId = HistoryManagerImpl.nextNodeId(urlId);
        }
        return nodeId;
    }

    private static synchronized HashMap loadNodeIds() {
        if (URLID_TO_NODEID != null) {
            return URLID_TO_NODEID;
        }
        URLID_TO_NODEID = new HashMap();
        DELETED_NODE_IDS = new ArrayList();
        int count = 0;
        Iterator i = NODES.getKeyIterator();
        if (i != null) {
            while (i.hasNext()) {
                String key = (String)i.next();
                int index = key.indexOf(FIELD_SEPARATOR);
                try {
                    ++count;
                    Integer urlId = Integer.decode(key.substring(0, index));
                    Integer nodeId = Integer.decode(key.substring(++index));
                    if (urlId != -1) {
                        URLID_TO_NODEID.put(urlId, nodeId);
                        continue;
                    }
                    DELETED_NODE_IDS.add(nodeId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return URLID_TO_NODEID;
    }

    private static List loadDeletedNodeIds() {
        HistoryManagerImpl.loadNodeIds();
        return DELETED_NODE_IDS;
    }

    private static synchronized HashMap loadUrlIds() {
        if (URL_TO_URLID != null) {
            return URL_TO_URLID;
        }
        URL_TO_URLID = new HashMap();
        int count = 0;
        Iterator i = URLS.getKeyIterator();
        if (i != null) {
            while (i.hasNext()) {
                String key = (String)i.next();
                int index = key.lastIndexOf(FIELD_SEPARATOR);
                try {
                    ++count;
                    URL url = URLFactory.newURL((String)key.substring(0, index));
                    Integer urlId = Integer.decode(key.substring(++index));
                    URL_TO_URLID.put(url, urlId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return URL_TO_URLID;
    }

    private static synchronized void updateNodeId(URL oldUrl, URL newUrl) {
        Object urlId = HistoryManagerImpl.getUrlId(oldUrl, false);
        if (urlId != null) {
            HashMap ids = HistoryManagerImpl.loadNodeIds();
            Object nodeId = ids.get(urlId);
            if (nodeId == null) {
                return;
            }
            ids.remove(urlId);
            String prefix = urlId.toString() + FIELD_SEPARATOR;
            if (newUrl != null) {
                urlId = HistoryManagerImpl.getUrlId(newUrl, false);
                if (urlId != null) {
                    Object victim = ids.get(urlId);
                    if (victim != null) {
                        HistoryManagerImpl.updateNodeId(newUrl, null);
                    }
                } else {
                    urlId = HistoryManagerImpl.getUrlId(newUrl, true);
                }
                ids.put(urlId, nodeId);
            } else {
                List list = HistoryManagerImpl.loadDeletedNodeIds();
                urlId = -1;
                list.add(nodeId);
            }
            try {
                NODES.delRecord(prefix + nodeId.toString());
                prefix = urlId.toString() + FIELD_SEPARATOR;
                NODES.putRecord(prefix + nodeId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static synchronized void restoreUrlId(Object nodeId, URL newUrl) {
        Object urlId = HistoryManagerImpl.getUrlId(newUrl, true);
        if (urlId != null) {
            HashMap ids = HistoryManagerImpl.loadNodeIds();
            Object conflictingId = ids.get(urlId);
            if (conflictingId != null && !conflictingId.equals(nodeId)) {
                HistoryManagerImpl.updateNodeId(newUrl, null);
            }
            List list = HistoryManagerImpl.loadDeletedNodeIds();
            list.remove(nodeId);
            ids.put(urlId, nodeId);
            try {
                String prefix = String.valueOf(-1) + FIELD_SEPARATOR;
                NODES.delRecord(prefix + nodeId.toString());
                prefix = urlId.toString() + FIELD_SEPARATOR;
                NODES.putRecord(prefix + nodeId, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static synchronized Node getNode(Object nodeId) {
        URL url = HistoryManagerImpl.getCurrentUrl(nodeId);
        if (url != null) {
            try {
                if (!URLFileSystem.isDirectory((URL)url)) {
                    Node node = NodeFactory.findOrCreate((URL)url);
                    return node;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static synchronized Object getUrlId(URL url, boolean create) {
        if (url == null) {
            return null;
        }
        HashMap ids = HistoryManagerImpl.loadUrlIds();
        Object urlId = ids.get(url);
        if (urlId == null && create) {
            urlId = HistoryManagerImpl.nextUrlId(url);
        }
        return urlId;
    }

    static synchronized URL getUrl(Object urlId) {
        Iterator i;
        if (urlId == null) {
            return null;
        }
        HashMap ids = HistoryManagerImpl.loadUrlIds();
        Set keys = ids.keySet();
        Iterator iterator = i = keys != null ? keys.iterator() : null;
        if (i != null) {
            while (i.hasNext()) {
                Object key = i.next();
                Object value = ids.get(key);
                if (value == null || !urlId.equals(value)) continue;
                return (URL)key;
            }
        }
        return null;
    }

    static synchronized URL getCurrentUrl(Object nodeId) {
        if (nodeId != null) {
            Iterator i;
            HashMap ids = HistoryManagerImpl.loadNodeIds();
            Set keys = ids.keySet();
            Iterator iterator = i = keys != null ? keys.iterator() : null;
            if (i != null) {
                while (i.hasNext()) {
                    Object key = i.next();
                    Object value = ids.get(key);
                    if (value == null || !nodeId.equals(value)) continue;
                    return HistoryManagerImpl.getUrl(key);
                }
            }
        }
        return null;
    }

    static synchronized Object nextNodeId(Object urlId) {
        if (urlId == null) {
            return null;
        }
        HashMap ids = HistoryManagerImpl.loadNodeIds();
        Integer nodeId = HistoryManagerImpl.nextFreeId("node");
        String key = urlId.toString() + FIELD_SEPARATOR + nodeId.toString();
        ids.put(urlId, nodeId);
        NODES.putRecord(key, null);
        return nodeId;
    }

    static synchronized Object nextUrlId(URL url) {
        if (url == null) {
            return null;
        }
        HashMap ids = HistoryManagerImpl.loadUrlIds();
        Integer urlId = HistoryManagerImpl.nextFreeId("url");
        String prefix = url.toString() + FIELD_SEPARATOR;
        String key = prefix + urlId.toString();
        ids.put(url, urlId);
        URLS.putRecord(key, null);
        return urlId;
    }

    private static Historian getHistorian(Class nodeCls) {
        Class historianCls;
        Historian historian = null;
        if (nodeCls != null && (historianCls = (Class)LOCTYPE_TO_HISTORIANTYPE.get(nodeCls)) != null && (historian = (Historian)HISTORIANTYPE_TO_HISTORIAN.get(historianCls)) == null) {
            try {
                historian = (Historian)historianCls.newInstance();
                HISTORIANTYPE_TO_HISTORIAN.put(historianCls, historian);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return historian;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistComments(Date timestamp, String comments) {
        if (timestamp != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(timestamp.getTime());
            buffer.append(FIELD_SEPARATOR);
            buffer.append(comments);
            NameSpace nameSpace = COMMENTS;
            synchronized (nameSpace) {
                COMMENTS.putRecord(buffer.toString(), null);
            }
        }
    }

    private static boolean checkURLBeforeDeletion(URL url) {
        if (url.getPath().indexOf(HISTORY_DIRNAME) < 0) {
            Exception e = new Exception("FATAL ERROR: History Manager should not be deleting " + url.getPath());
            e.printStackTrace();
            FeedbackManager.reportException((Throwable)e);
            return false;
        }
        return true;
    }

    private static synchronized void _clear(URL[] sources) {
        HashMap<Object, Integer> liveNodes = new HashMap<Object, Integer>();
        HashMap<Object, LocalStateImpl> liveUrls = new HashMap<Object, LocalStateImpl>();
        Iterator i = STATES.getReverseKeyIterator();
        if (i != null) {
            while (i.hasNext()) {
                boolean delete = false;
                try {
                    String key = (String)i.next();
                    LocalStateImpl state = LocalStateImpl.decode(key);
                    int j = 0;
                    while (j < sources.length) {
                        if (URLFileSystem.equals((URL)state.getNodeURL(), (URL)sources[j])) {
                            delete = true;
                            break;
                        }
                        ++j;
                    }
                    if (delete) {
                        STATES.delRecord(key);
                        URL url = state.getDataURL();
                        if (!HistoryManagerImpl.checkURLBeforeDeletion(url) || URLFileSystem.delete((URL)url)) continue;
                        Exception e = new Exception("ERROR: History Manager couldn't successfully delete " + url.getPath());
                        e.printStackTrace();
                        continue;
                    }
                    liveNodes.put(state.getNodeId(), 0);
                    liveUrls.put(state.getStateUrlId(), state);
                    liveUrls.put(state.getDataUrlId(), state);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        HistoryManagerImpl._pruneHistory(liveNodes, liveUrls);
    }

    private static synchronized void pruneHistory() {
        if (PRUNED) {
            return;
        }
        PRUNED = true;
        IdeSettings settings = Ide.getSettings();
        HistoryOptions options = (HistoryOptions)((Object)settings.getData("HistoryOptions"));
        long time = System.currentTimeMillis();
        int maxRevisions = Integer.MAX_VALUE;
        if (options != null) {
            int days = options.getLifespan();
            if (days >= 0) {
                long milliseconds = (long)days * (long)24 * (long)60 * (long)60 * 1000L;
                time -= milliseconds;
            } else {
                time = Long.MIN_VALUE;
            }
            maxRevisions = options.getRevisions();
        } else {
            time = Long.MIN_VALUE;
        }
        HashMap<Object, Integer> liveNodes = new HashMap<Object, Integer>();
        HashMap<Object, LocalStateImpl> liveUrls = new HashMap<Object, LocalStateImpl>();
        Date cutOff = new Date(time);
        Iterator i = STATES.getReverseKeyIterator();
        if (i != null) {
            while (i.hasNext()) {
                boolean delete = false;
                try {
                    String key = (String)i.next();
                    LocalStateImpl state = LocalStateImpl.decode(key);
                    int count = 0;
                    if (cutOff.after(state.getDate())) {
                        delete = true;
                    } else {
                        Object value = liveNodes.get(state.getNodeId());
                        int n = count = value != null ? (Integer)value : 0;
                        if (++count > maxRevisions) {
                            delete = true;
                        }
                    }
                    if (delete) {
                        STATES.delRecord(key);
                        URL url = state.getDataURL();
                        if (!HistoryManagerImpl.checkURLBeforeDeletion(url) || URLFileSystem.delete((URL)url)) continue;
                        Exception e = new Exception("ERROR: History Manager couldn't successfully delete " + url.getPath());
                        e.printStackTrace();
                        continue;
                    }
                    liveNodes.put(state.getNodeId(), count);
                    liveUrls.put(state.getStateUrlId(), state);
                    liveUrls.put(state.getDataUrlId(), state);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        HistoryManagerImpl._pruneHistory(liveNodes, liveUrls);
    }

    private static synchronized void _pruneHistory(HashMap liveNodes, HashMap liveUrls) {
        List deletions;
        HashMap map = HistoryManagerImpl.loadNodeIds();
        Set keySet = map != null ? map.keySet() : null;
        Object[] keys = null;
        if (keySet != null) {
            keys = new Object[keySet.size()];
            keySet.toArray(keys);
        }
        if (keys != null) {
            int j = 0;
            while (j < keys.length) {
                try {
                    Object urlId = keys[j];
                    Object nodeId = map.get(urlId);
                    if (liveNodes.get(nodeId) == null) {
                        StringBuffer str = new StringBuffer();
                        str.append(urlId.toString());
                        str.append(FIELD_SEPARATOR);
                        str.append(nodeId.toString());
                        NODES.delRecord(str.toString());
                        HistoryManagerImpl.releaseId("node", (Integer)nodeId);
                        map.remove(urlId);
                        URL url = URLFactory.newDirURL((String)(HISTORY_DIR + nodeId));
                        URLFileSystem.delete((URL)url);
                    } else {
                        liveUrls.put(urlId, nodeId);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
        }
        if ((deletions = HistoryManagerImpl.loadDeletedNodeIds()) != null) {
            int j = deletions.size() - 1;
            while (j >= 0) {
                try {
                    Object nodeId = deletions.get(j);
                    if (liveNodes.get(nodeId) == null) {
                        StringBuffer str = new StringBuffer();
                        str.append(String.valueOf(-1));
                        str.append(FIELD_SEPARATOR);
                        str.append(nodeId.toString());
                        NODES.delRecord(str.toString());
                        HistoryManagerImpl.releaseId("node", (Integer)nodeId);
                        deletions.remove(nodeId);
                        URL url = URLFactory.newDirURL((String)(HISTORY_DIR + nodeId));
                        URLFileSystem.delete((URL)url);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                --j;
            }
        }
        keySet = (map = HistoryManagerImpl.loadUrlIds()) != null ? map.keySet() : null;
        keys = null;
        if (keySet != null) {
            keys = new Object[keySet.size()];
            keySet.toArray(keys);
        }
        if (keys != null) {
            int j = 0;
            while (j < keys.length) {
                try {
                    Object url = keys[j];
                    Object urlId = map.get(url);
                    if (liveUrls.get(urlId) == null) {
                        StringBuffer str = new StringBuffer();
                        str.append(((URL)url).toString());
                        str.append(FIELD_SEPARATOR);
                        str.append(urlId.toString());
                        URLS.delRecord(str.toString());
                        HistoryManagerImpl.releaseId("url", (Integer)urlId);
                        map.remove(url);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
        }
        liveNodes.clear();
        liveUrls.clear();
    }

    private static final int bytesToInt(byte[] b, int start) {
        return b[start] << 24 | (b[start + 1] & 0xFF) << 16 | (b[start + 2] & 0xFF) << 8 | b[start + 3] & 0xFF;
    }

    private static final byte[] intToBytes(int val, byte[] b, int start) {
        if (b == null) {
            b = new byte[4];
        }
        b[start] = (byte)(val >> 24);
        b[start + 1] = (byte)(val >> 16);
        b[start + 2] = (byte)(val >> 8);
        b[start + 3] = (byte)val;
        return b;
    }

    private static void dumpIdData(String type) {
        System.out.println("---- ID data for " + type);
        byte[] max = IDS.getRecord(type + ".max");
        System.out.println("max: " + (max == null ? "null" : String.valueOf(HistoryManagerImpl.bytesToInt(max, 0))));
        System.out.print("free: [");
        byte[] free = IDS.getRecord(type + ".free");
        if (free != null) {
            int i = 0;
            while (i < free.length) {
                System.out.print(String.valueOf(HistoryManagerImpl.bytesToInt(free, i)));
                System.out.print(", ");
                i += 4;
            }
        }
        System.out.println("]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseId(String type, int id) {
        NameSpace nameSpace = IDS;
        synchronized (nameSpace) {
            byte[] free = IDS.getRecord(type + ".free");
            if (free == null) {
                free = new byte[]{};
            }
            byte[] newFree = new byte[free.length + 4];
            HistoryManagerImpl.intToBytes(id, newFree, 0);
            System.arraycopy(free, 0, newFree, 4, free.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int nextFreeId(String type) {
        NameSpace nameSpace = IDS;
        synchronized (nameSpace) {
            int id;
            byte[] freeIds = IDS.getRecord(type + ".free");
            if (freeIds != null && freeIds.length >= 4) {
                int id2 = HistoryManagerImpl.bytesToInt(freeIds, freeIds.length - 4);
                byte[] newIds = new byte[freeIds.length - 4];
                System.arraycopy(freeIds, 0, newIds, 0, newIds.length);
                IDS.putRecord(type + ".free", newIds);
                int n = id2;
                return n;
            }
            byte[] maxId = IDS.getRecord(type + ".max");
            int n = id = maxId == null || maxId.length == 0 ? 0 : HistoryManagerImpl.bytesToInt(maxId, 0);
            if (id == Integer.MAX_VALUE) {
                throw new IllegalStateException("id pool for local history is exhausted. Please purge.");
            }
            int newMax = id + 1;
            IDS.putRecord(type + ".max", HistoryManagerImpl.intToBytes(newMax, null, 0));
            int n2 = id;
            return n2;
        }
    }

    static void mav$optionsChanged(HistoryManagerImpl historyManagerImpl, HistoryOptions historyOptions) {
        historyManagerImpl.optionsChanged(historyOptions);
    }

    final class 1
    extends StructureChangeListener {
        private final /* synthetic */ HistoryOptions v$options;
        final /* synthetic */ HistoryManagerImpl this$0;

        public void structureValuesChanged(StructureChangeEvent e) {
            HistoryManagerImpl.mav$optionsChanged(this.this$0, this.v$options);
        }

        public 1(HistoryManagerImpl historyManagerImpl, HistoryOptions historyOptions) {
            this.v$options = historyOptions;
            this.this$0 = historyManagerImpl;
        }
    }

    final class 2
    extends IdeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addinsLoaded(IdeEvent idee) {
            Map m;
            Map map = m = Recognizer.getExtensionToClassMap();
            synchronized (map) {
                try {
                    for (Class nodeCls : m.values()) {
                        if (!TextNode.class.isAssignableFrom(nodeCls)) continue;
                        HistoryManagerImpl.this.registerHistorian(TextNodeHistorian.class, nodeCls);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Ide.removeIdeListener((IdeListener)this);
        }
    }
}

